/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api;

import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LdapApiServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LdapApiServiceFactory.class);
    private static LdapApiService ldapCodecService;
    private static boolean usingStandaloneImplementation;

    private LdapApiServiceFactory() {
    }

    public static boolean isInitialized() {
        return ldapCodecService != null;
    }

    public static boolean isUsingStandaloneImplementation() {
        if (!LdapApiServiceFactory.isInitialized()) {
            String msg = I18n.err(I18n.ERR_05200_NOT_INITIALIZED_YET, new Object[0]);
            LOG.error(msg);
            throw new IllegalStateException(msg);
        }
        return usingStandaloneImplementation;
    }

    public static LdapApiService getSingleton() {
        if (ldapCodecService == null) {
            LdapApiServiceFactory.initialize(null);
        }
        return ldapCodecService;
    }

    public static void initialize(LdapApiService ldapCodecService) {
        if (LdapApiServiceFactory.ldapCodecService != null) {
            String msg = I18n.err(I18n.ERR_05201_INSTANCE_ALREADY_SET, LdapApiServiceFactory.class.getName());
            LOG.error(msg);
            throw new IllegalStateException(msg);
        }
        if (ldapCodecService == null) {
            try {
                Class<?> serviceClass = Class.forName("org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.standalone.StandaloneLdapApiService");
                LdapApiServiceFactory.ldapCodecService = (LdapApiService)serviceClass.newInstance();
                usingStandaloneImplementation = true;
            }
            catch (Exception e) {
                LOG.error(I18n.err(I18n.ERR_05202_FAILED_TO_INSTANCIATE, e.getMessage()));
            }
        } else {
            usingStandaloneImplementation = false;
            LdapApiServiceFactory.ldapCodecService = ldapCodecService;
        }
    }
}

