/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.actions.request.search.filter;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.search.SubstringFilter;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreAny
extends GrammarAction<LdapMessageContainer<SearchRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreAny.class);

    public StoreAny() {
        super("Store a any value");
    }

    @Override
    public void action(LdapMessageContainer<SearchRequest> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        SubstringFilter substringFilter = (SubstringFilter)container.getTerminalFilter();
        if (tlv.getLength() == 0) {
            String msg = I18n.err(I18n.ERR_05139_EMPTY_SUBSTRING_ANY_FILTER_PDU, new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        String any = Strings.utf8ToString(tlv.getValue().getData());
        substringFilter.addAnySubstrings(any);
        container.unstackFilters();
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05153_STORED_ANY_SUBSTRING, any));
        }
    }
}

