/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.actions.request.modifydn;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.BooleanDecoder;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.BooleanDecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreModifyDnRequestDeleteOldRdn
extends GrammarAction<LdapMessageContainer<ModifyDnRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreModifyDnRequestDeleteOldRdn.class);

    public StoreModifyDnRequestDeleteOldRdn() {
        super("Store ModifyDN request deleteOldRdn flag");
    }

    @Override
    public void action(LdapMessageContainer<ModifyDnRequest> container) throws DecoderException {
        ModifyDnRequest modifyDnRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        BerValue value = tlv.getValue();
        try {
            modifyDnRequest.setDeleteOldRdn(BooleanDecoder.parse(value));
        }
        catch (BooleanDecoderException bde) {
            LOG.error(I18n.err(I18n.ERR_05125_INVALID_OLD_RDN, Strings.dumpBytes(value.getData()), bde.getMessage()));
            throw new DecoderException(bde.getMessage(), bde);
        }
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            if (modifyDnRequest.getDeleteOldRdn()) {
                LOG.debug(I18n.msg(I18n.MSG_05135_OID_RDN_ATT_WILL_BE_DELETED, new Object[0]));
            } else {
                LOG.debug(I18n.msg(I18n.MSG_05136_OID_RDN_ATT_WILL_BE_RETAINED, new Object[0]));
            }
        }
    }
}

