/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.actions.ldapResult;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.Message;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.name.Dn;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreMatchedDN
extends GrammarAction<LdapMessageContainer<Message>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreMatchedDN.class);

    public StoreMatchedDN() {
        super("Store matched Dn");
    }

    @Override
    public void action(LdapMessageContainer<Message> container) throws DecoderException {
        Dn matchedDn;
        TLV tlv = container.getCurrentTLV();
        LdapResult ldapResult = container.getLdapResult();
        ResultCodeEnum resultCode = ldapResult.getResultCode();
        if (tlv.getLength() == 0) {
            matchedDn = Dn.EMPTY_DN;
        } else {
            switch (resultCode) {
                case NO_SUCH_OBJECT: 
                case ALIAS_PROBLEM: 
                case INVALID_DN_SYNTAX: 
                case ALIAS_DEREFERENCING_PROBLEM: {
                    byte[] dnBytes = tlv.getValue().getData();
                    String dnStr = Strings.utf8ToString(dnBytes);
                    try {
                        matchedDn = new Dn(dnStr);
                        break;
                    }
                    catch (LdapInvalidDnException ine) {
                        String msg = I18n.err(I18n.ERR_05106_INCORRECT_DN_GIVEN_INVALID, dnStr, Strings.dumpBytes(dnBytes), ine.getLocalizedMessage());
                        LOG.error(msg);
                        throw new DecoderException(I18n.err(I18n.ERR_05107_INCORRECT_DN_GIVEN, ine.getLocalizedMessage()), ine);
                    }
                }
                default: {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn(I18n.msg(I18n.MSG_05107_NO_SUCH_OBJECT_MATCHED_DN_NOT_SET, new Object[0]));
                    }
                    matchedDn = Dn.EMPTY_DN;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05108_MATCHED_DN_IS, matchedDn));
        }
        ldapResult.setMatchedDn(matchedDn);
    }
}

