/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.util.Asn1StringUtils;

public class GrammarTransition<C extends Asn1Container> {
    private Action<C> action;
    private Enum<?> previousState;
    private Enum<?> currentState;
    private int currentTag;

    public GrammarTransition(Enum<?> previousState, Enum<?> currentState, int currentTag, Action<C> action) {
        this.previousState = previousState;
        this.currentState = currentState;
        this.action = action;
        this.currentTag = currentTag;
    }

    public GrammarTransition(Enum<?> previousState, Enum<?> currentState, int currentTag) {
        this.previousState = previousState;
        this.currentState = currentState;
        this.currentTag = currentTag;
    }

    public GrammarTransition(Enum<?> previousState, Enum<?> currentState, UniversalTag currentTag, Action<C> action) {
        this.previousState = previousState;
        this.currentState = currentState;
        this.action = action;
        this.currentTag = currentTag.getValue();
    }

    public GrammarTransition(Enum<?> previousState, Enum<?> currentState, UniversalTag currentTag) {
        this.previousState = previousState;
        this.currentState = currentState;
        this.currentTag = currentTag.getValue();
    }

    public boolean hasAction() {
        return this.action != null;
    }

    public Action<C> getAction() {
        return this.action;
    }

    public Enum<?> getCurrentState() {
        return this.currentState;
    }

    public Enum<?> getPreviousState() {
        return this.previousState;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Transition from state <").append(this.previousState).append("> ");
        sb.append("to state <").append(this.currentState).append(">, ");
        sb.append("tag <").append(Asn1StringUtils.dumpByte((byte)this.currentTag)).append(">, ");
        sb.append("action : ");
        if (this.action == null) {
            sb.append("no action");
        } else {
            sb.append(this.action);
        }
        return sb.toString();
    }
}

