/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.util;

import com.google.common.net.InetAddresses;
import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import io.netty.channel.unix.Errors;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.math.MathContext;
import java.math.RoundingMode;
import java.net.BindException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.CelebornException;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.DiskStatus;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.network.util.JavaUtils;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PartitionSplitMode;
import org.apache.celeborn.common.protocol.PartitionType;
import org.apache.celeborn.common.protocol.message.ControlMessages$;
import org.apache.celeborn.common.protocol.message.Message;
import org.apache.celeborn.common.protocol.message.StatusCode;
import org.apache.commons.lang3.SystemUtils;
import org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;
import scala.util.control.ControlThrowable;
import scala.util.control.NonFatal$;

public final class Utils$
implements Logging {
    public static Utils$ MODULE$;
    private InetAddress localIpAddress;
    private final boolean isWindows;
    private final boolean isMac;
    private final boolean isMacOnAppleSilicon;
    private Option<String> customHostname;
    private final ConcurrentHashMap<String, Tuple2<String, Object>> hostPortParseResults;
    private final int MAX_DEFAULT_NETTY_THREADS;
    private final String SORTED_SUFFIX;
    private final String INDEX_SUFFIX;
    private final String SUFFIX_HDFS_WRITE_SUCCESS;
    private transient Logger log;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    static {
        new Utils$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public SimpleDateFormat createDateFormat() {
        return new SimpleDateFormat("yyyyMMddHHmmss", Locale.US);
    }

    public Seq<String> stringToSeq(String str) {
        return Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])str.split(","))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$stringToSeq$2(x$2))));
    }

    public scala.collection.immutable.Map<String, String> getSystemProperties() {
        return ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(System.getProperties().stringPropertyNames()).asScala()).map((Function1 & Serializable & scala.Serializable)key -> new Tuple2(key, (Object)System.getProperty(key)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public long timeStringAsMs(String str) {
        return JavaUtils.timeStringAsMs(str);
    }

    public long timeStringAsSeconds(String str) {
        return JavaUtils.timeStringAsSec(str);
    }

    public long byteStringAsBytes(String str) {
        return JavaUtils.byteStringAsBytes(str);
    }

    public long byteStringAsKb(String str) {
        return JavaUtils.byteStringAsKb(str);
    }

    public long byteStringAsMb(String str) {
        return JavaUtils.byteStringAsMb(str);
    }

    public long byteStringAsGb(String str) {
        return JavaUtils.byteStringAsGb(str);
    }

    public int memoryStringToMb(String str) {
        return (int)(JavaUtils.byteStringAsBytes(str) / 1024L / 1024L);
    }

    public String bytesToString(long size) {
        return this.bytesToString(scala.package$.MODULE$.BigInt().apply(size));
    }

    public String bytesToString(BigInt size) {
        String string;
        long EB = 0x1000000000000000L;
        long PB = 0x4000000000000L;
        long TB = 0x10000000000L;
        long GB = 0x40000000L;
        long MB = 0x100000L;
        long KB = 1024L;
        if (size.$greater$eq((Object)scala.package$.MODULE$.BigInt().apply(2048L).$times(BigInt$.MODULE$.long2bigInt(EB)))) {
            string = new java.lang.StringBuilder(2).append(scala.package$.MODULE$.BigDecimal().apply(size, new MathContext(3, RoundingMode.HALF_UP)).toString()).append(" B").toString();
        } else {
            Tuple2 tuple2;
            Tuple2 tuple22 = size.$greater$eq((Object)BigInt$.MODULE$.long2bigInt(2L * EB)) ? new Tuple2((Object)scala.package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(EB)), (Object)"EB") : (size.$greater$eq((Object)BigInt$.MODULE$.long2bigInt(2L * PB)) ? new Tuple2((Object)scala.package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(PB)), (Object)"PB") : (size.$greater$eq((Object)BigInt$.MODULE$.long2bigInt(2L * TB)) ? new Tuple2((Object)scala.package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(TB)), (Object)"TB") : (size.$greater$eq((Object)BigInt$.MODULE$.long2bigInt(2L * GB)) ? new Tuple2((Object)scala.package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(GB)), (Object)"GB") : (size.$greater$eq((Object)BigInt$.MODULE$.long2bigInt(2L * MB)) ? new Tuple2((Object)scala.package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(MB)), (Object)"MB") : (tuple2 = size.$greater$eq((Object)BigInt$.MODULE$.long2bigInt(2L * KB)) ? new Tuple2((Object)scala.package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(KB)), (Object)"KB") : new Tuple2((Object)scala.package$.MODULE$.BigDecimal().apply(size), (Object)"B"))))));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BigDecimal value = (BigDecimal)tuple2._1();
            String unit = (String)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)value, (Object)unit);
            Tuple2 tuple24 = tuple23;
            BigDecimal value2 = (BigDecimal)tuple24._1();
            String unit2 = (String)tuple24._2();
            string = new StringOps(Predef$.MODULE$.augmentString("%.1f %s")).formatLocal(Locale.US, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value2, unit2}));
        }
        return string;
    }

    public String megabytesToString(long megabytes) {
        return this.bytesToString(megabytes * 1024L * 1024L);
    }

    public String msDurationToString(long ms) {
        int second = 1000;
        int minute = 60 * second;
        int hour = 60 * minute;
        Locale locale = Locale.US;
        long l = ms;
        String string = l < (long)second ? new StringOps(Predef$.MODULE$.augmentString("%d ms")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l)})) : (l < (long)minute ? new StringOps(Predef$.MODULE$.augmentString("%.1f s")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)second))})) : (l < (long)hour ? new StringOps(Predef$.MODULE$.augmentString("%.1f m")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)minute))})) : new StringOps(Predef$.MODULE$.augmentString("%.2f h")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)hour))}))));
        return string;
    }

    public Tuple2<String, Object> extractHostPortFromRssUrl(String essUrl) throws CelebornException {
        Tuple2 tuple2;
        try {
            int port;
            String host;
            block5: {
                block4: {
                    URI uri = new URI(essUrl);
                    host = uri.getHost();
                    port = uri.getPort();
                    String string = uri.getScheme();
                    String string2 = "rss";
                    if (string != null ? !string.equals(string2) : string2 != null) break block4;
                    if (host != null && port >= 0 && (uri.getPath() == null || uri.getPath().isEmpty()) && uri.getFragment() == null && uri.getQuery() == null && uri.getUserInfo() == null) break block5;
                }
                throw new CelebornException(new java.lang.StringBuilder(20).append("Invalid master URL: ").append(essUrl).toString());
            }
            tuple2 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
        }
        catch (URISyntaxException e) {
            throw new CelebornException(new java.lang.StringBuilder(20).append("Invalid master URL: ").append(essUrl).toString(), e);
        }
        return tuple2;
    }

    public <T> T tryOrIOException(Function0<T> block) {
        Object object;
        try {
            object = block.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IOException) {
                IOException iOException = (IOException)throwable2;
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception encountered", iOException);
                throw iOException;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception encountered", e);
                throw new IOException(e);
            }
            throw throwable;
        }
        return (T)object;
    }

    public void tryLogNonFatalError(Function0<BoxedUnit> block) {
        try {
            block.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(29).append("Uncaught exception in thread ").append(Thread.currentThread().getName()).toString(), t);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public void tryOrExit(Function0<BoxedUnit> block) {
        try {
            block.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ControlThrowable) {
                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                throw (Throwable)controlThrowable;
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                throw throwable3;
            }
            throw throwable;
        }
    }

    public <T> T tryWithSafeFinallyAndFailureCallbacks(Function0<T> block, Function0<BoxedUnit> catchBlock, Function0<BoxedUnit> finallyBlock) {
        Object object;
        Throwable originalThrowable = null;
        try {
            try {
                object = block.apply();
            }
            catch (Throwable cause) {
                block17: {
                    originalThrowable = cause;
                    try {
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Aborting task", originalThrowable);
                        catchBlock.apply$mcV$sp();
                    }
                    catch (Throwable t) {
                        Throwable throwable = originalThrowable;
                        Throwable throwable2 = t;
                        if (!(throwable == null ? throwable2 != null : !throwable.equals(throwable2))) break block17;
                        originalThrowable.addSuppressed(t);
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(32).append("Suppressing exception in catch: ").append(t.getMessage()).toString(), t);
                    }
                }
                throw originalThrowable;
            }
        }
        catch (Throwable throwable) {
            try {
                finallyBlock.apply$mcV$sp();
            }
            catch (Throwable throwable3) {
                Throwable throwable4 = throwable3;
                if (throwable4 != null) {
                    Throwable throwable5 = throwable4;
                    if (originalThrowable != null) {
                        Throwable throwable6 = originalThrowable;
                        Throwable throwable7 = throwable5;
                        if (throwable6 == null ? throwable7 != null : !throwable6.equals(throwable7)) {
                            originalThrowable.addSuppressed(throwable5);
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(34).append("Suppressing exception in finally: ").append(throwable5.getMessage()).toString(), throwable5);
                            throw originalThrowable;
                        }
                    }
                }
                throw throwable3;
            }
            throw throwable;
        }
        Object object2 = object;
        try {
            finallyBlock.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (throwable8 != null) {
                Throwable throwable9 = throwable8;
                if (originalThrowable != null) {
                    Throwable throwable10 = originalThrowable;
                    Throwable throwable11 = throwable9;
                    if (throwable10 == null ? throwable11 != null : !throwable10.equals(throwable11)) {
                        originalThrowable.addSuppressed(throwable9);
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(34).append("Suppressing exception in finally: ").append(throwable5.getMessage()).toString(), throwable9);
                        throw originalThrowable;
                    }
                }
            }
            throw throwable;
        }
        return (T)object2;
    }

    public <T> void tryWithSafeFinallyAndFailureCallbacks$default$2(Function0<T> block) {
    }

    public <T> void tryWithSafeFinallyAndFailureCallbacks$default$3(Function0<T> block) {
    }

    public <T> Tuple2<T, Object> startServiceOnPort(int startPort, Function1<Object, Tuple2<T, Object>> startService, CelebornConf conf, String serviceName) {
        Object object = new Object();
        try {
            Predef$.MODULE$.require(startPort == 0 || 1024 <= startPort && startPort < 65536, (Function0 & Serializable & scala.Serializable)() -> "startPort should be between 1024 and 65535 (inclusive), or 0 for a random free port.");
            String serviceString = serviceName.isEmpty() ? "" : new java.lang.StringBuilder(3).append(" '").append(serviceName).append("'").toString();
            int maxRetries = conf.portMaxRetries();
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), maxRetries).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)offset -> {
                int tryPort = startPort == 0 ? startPort : MODULE$.userPort(startPort, offset);
                try {
                    Tuple2 tuple2 = (Tuple2)startService.apply((Object)BoxesRunTime.boxToInteger((int)tryPort));
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Object service = tuple2._1();
                    int port = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = new Tuple2(service, (Object)BoxesRunTime.boxToInteger((int)port));
                    Tuple2 tuple23 = tuple22;
                    Object service2 = tuple23._1();
                    int port2 = tuple23._2$mcI$sp();
                    MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(38).append("Successfully started service").append(serviceString).append(" on port ").append(port2).append(".").toString());
                    throw new NonLocalReturnControl(object, (Object)new Tuple2(service2, (Object)BoxesRunTime.boxToInteger((int)port2)));
                }
                catch (Throwable throwable) {
                    BoxedUnit boxedUnit;
                    Exception exception;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof Exception && MODULE$.isBindCollision(exception = (Exception)throwable2)) {
                        if (offset >= maxRetries) {
                            String exceptionMessage = startPort == 0 ? new java.lang.StringBuilder(219).append(exception.getMessage()).append(": Service").append(serviceString).append(" failed after ").append(maxRetries).append(" retries (on a random free port)! ").append("Consider explicitly setting the appropriate binding address for ").append("the service").append(serviceString).append(" (for example spark.driver.bindAddress ").append("for SparkDriver) to the correct binding address.").toString() : new java.lang.StringBuilder(212).append(exception.getMessage()).append(": Service").append(serviceString).append(" failed after ").append(maxRetries).append(" retries (starting from ").append(startPort).append(")! Consider explicitly setting ").append("the appropriate port for the service").append(serviceString).append(" (for example spark.ui.port ").append("for SparkUI) to an available port or increasing spark.port.maxRetries.").toString();
                            BindException exception2 = new BindException(exceptionMessage);
                            exception2.setStackTrace(exception.getStackTrace());
                            throw exception2;
                        }
                        if (startPort == 0) {
                            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(111).append("Service").append(serviceString).append(" could not bind on a random free port. ").append("You may check whether configuring an appropriate binding address.").toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(50).append("Service").append(serviceString).append(" could not bind on port ").append(tryPort).append(". ").append("Attempting port ").append(tryPort + 1).append(".").toString());
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        throw throwable;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
            });
            throw new CelebornException(new java.lang.StringBuilder(32).append("Failed to start service").append(serviceString).append(" on port ").append(startPort).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (Tuple2)ex.value();
        }
    }

    public <T> String startServiceOnPort$default$4() {
        return "";
    }

    public int userPort(int base, int offset) {
        return (base + offset - 1024) % 64512 + 1024;
    }

    public boolean isBindCollision(Throwable exception) {
        boolean bl;
        block5: {
            while (true) {
                Throwable throwable;
                if ((throwable = exception) instanceof BindException) {
                    BindException bindException = (BindException)throwable;
                    if (bindException.getMessage() != null) {
                        return true;
                    }
                    exception = bindException.getCause();
                    continue;
                }
                if (throwable instanceof Errors.NativeIoException) {
                    Errors.NativeIoException nativeIoException = (Errors.NativeIoException)throwable;
                    if (nativeIoException.getMessage() == null || !nativeIoException.getMessage().startsWith("bind() failed: ")) {
                        exception = nativeIoException.getCause();
                        continue;
                    }
                    bl = true;
                    break block5;
                }
                if (!(throwable instanceof Exception)) break;
                Exception exception2 = (Exception)throwable;
                exception = exception2.getCause();
            }
            bl = false;
        }
        return bl;
    }

    public String encodeFileNameToURIRawPath(String fileName) {
        Predef$.MODULE$.require(!fileName.contains("/") && !fileName.contains("\\"));
        return new URI("file", null, "localhost", -1, new java.lang.StringBuilder(1).append("/").append(fileName).toString(), null, null).getRawPath().substring(1);
    }

    public <T> Seq<T> randomize(TraversableOnce<T> seq, ClassTag<T> evidence$1) {
        return Predef$.MODULE$.genericWrapArray(this.randomizeInPlace(seq.toArray(evidence$1), this.randomizeInPlace$default$2()));
    }

    public <T> Object randomizeInPlace(Object arr, Random rand) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(ScalaRunTime$.MODULE$.array_length(arr) - 1), 1).by(-1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int j = rand.nextInt(i + 1);
            Object tmp = ScalaRunTime$.MODULE$.array_apply(arr, j);
            ScalaRunTime$.MODULE$.array_update(arr, j, ScalaRunTime$.MODULE$.array_apply(arr, i));
            ScalaRunTime$.MODULE$.array_update(arr, i, tmp);
        });
        return arr;
    }

    public <T> Random randomizeInPlace$default$2() {
        return new Random();
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public boolean isMac() {
        return this.isMac;
    }

    public boolean isMacOnAppleSilicon() {
        return this.isMacOnAppleSilicon;
    }

    private InetAddress localIpAddress$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if (!this.bitmap$0) {
                this.localIpAddress = this.findLocalInetAddress();
                this.bitmap$0 = true;
            }
        }
        return this.localIpAddress;
    }

    private InetAddress localIpAddress() {
        return !this.bitmap$0 ? this.localIpAddress$lzycompute() : this.localIpAddress;
    }

    /*
     * WARNING - void declaration
     */
    private InetAddress findLocalInetAddress() {
        InetAddress inetAddress;
        Object object = new Object();
        try {
            String defaultIpOverride = System.getenv("CELEBORN_LOCAL_IP");
            if (defaultIpOverride != null) {
                inetAddress = InetAddress.getByName(defaultIpOverride);
            } else {
                void var3_3;
                InetAddress address = InetAddress.getLocalHost();
                if (address.isLoopbackAddress()) {
                    Seq activeNetworkIFs = ((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(NetworkInterface.getNetworkInterfaces()).asScala()).toSeq();
                    Seq reOrderedNetworkIFs = this.isWindows() ? activeNetworkIFs : (Seq)activeNetworkIFs.reverse();
                    reOrderedNetworkIFs.foreach((Function1 & Serializable & scala.Serializable)ni -> {
                        Utils$.$anonfun$findLocalInetAddress$1(address, object, ni);
                        return BoxedUnit.UNIT;
                    });
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(95).append("Your hostname, ").append(InetAddress.getLocalHost().getHostName()).append(" resolves to").append(" a loopback address: ").append(address.getHostAddress()).append(", but we couldn't find any").append(" external IP address!").toString());
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Set CELEBORN_LOCAL_IP if you need to bind to another address");
                }
                inetAddress = var3_3;
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                inetAddress = (InetAddress)ex.value();
            }
            throw ex;
        }
        return inetAddress;
    }

    private Option<String> customHostname() {
        return this.customHostname;
    }

    private void customHostname_$eq(Option<String> x$1) {
        this.customHostname = x$1;
    }

    public void setCustomHostname(String hostname) {
        this.checkHost(hostname);
        this.customHostname_$eq((Option<String>)new Some((Object)hostname));
    }

    public String localCanonicalHostName() {
        return (String)this.customHostname().getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.localIpAddress().getCanonicalHostName());
    }

    public String localHostName() {
        return (String)this.customHostname().getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.localIpAddress().getHostAddress());
    }

    public String localHostNameForURI() {
        return (String)this.customHostname().getOrElse((Function0 & Serializable & scala.Serializable)() -> InetAddresses.toUriString((InetAddress)MODULE$.localIpAddress()));
    }

    public void checkHost(String host) {
        if (host != null && host.split(":").length > 2) {
            Predef$.MODULE$.assert(host.startsWith("[") && host.endsWith("]"), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(52).append("Expected hostname or IPv6 IP enclosed in [] but got ").append(host).toString());
        } else {
            Predef$.MODULE$.assert(host != null && host.indexOf(58) == -1, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(32).append("Expected hostname or IP but got ").append(host).toString());
        }
    }

    public void checkHostPort(String hostPort) {
        if (hostPort != null && hostPort.split(":").length > 2) {
            Predef$.MODULE$.assert(hostPort != null && hostPort.indexOf("]:") != -1, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(31).append("Expected host and port but got ").append(hostPort).toString());
        } else {
            Predef$.MODULE$.assert(hostPort != null && hostPort.indexOf(58) != -1, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(31).append("Expected host and port but got ").append(hostPort).toString());
        }
    }

    private ConcurrentHashMap<String, Tuple2<String, Object>> hostPortParseResults() {
        return this.hostPortParseResults;
    }

    public Tuple2<String, Object> parseHostPort(String hostPort) {
        Tuple2<String, Object> tuple2;
        Tuple2<String, Object> cached = this.hostPortParseResults().get(hostPort);
        if (cached != null) {
            return cached;
        }
        if (hostPort != null && hostPort.split(":").length > 2) {
            int index = hostPort.lastIndexOf("]:");
            if (-1 == index) {
                return this.setDefaultPortValue$1(hostPort);
            }
            String port = hostPort.substring(index + 2).trim();
            Tuple2 retVal = new Tuple2((Object)hostPort.substring(0, index + 1).trim(), (Object)(port.isEmpty() ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(port)).toInt())));
            tuple2 = this.hostPortParseResults().putIfAbsent(hostPort, (Tuple2<String, Object>)retVal);
        } else {
            int index = hostPort.lastIndexOf(58);
            if (-1 == index) {
                return this.setDefaultPortValue$1(hostPort);
            }
            String port = hostPort.substring(index + 1).trim();
            Tuple2 retVal = new Tuple2((Object)hostPort.substring(0, index).trim(), (Object)(port.isEmpty() ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(port)).toInt())));
            tuple2 = this.hostPortParseResults().putIfAbsent(hostPort, (Tuple2<String, Object>)retVal);
        }
        return this.hostPortParseResults().get(hostPort);
    }

    private int MAX_DEFAULT_NETTY_THREADS() {
        return this.MAX_DEFAULT_NETTY_THREADS;
    }

    public TransportConf fromCelebornConf(CelebornConf _conf, String module, int numUsableCores) {
        CelebornConf conf = _conf.clone();
        int numThreads = this.defaultNumThreads(numUsableCores);
        conf.setIfMissing(new java.lang.StringBuilder(26).append("celeborn.").append(module).append(".io.serverThreads").toString(), Integer.toString(numThreads));
        conf.setIfMissing(new java.lang.StringBuilder(26).append("celeborn.").append(module).append(".io.clientThreads").toString(), Integer.toString(numThreads));
        conf.setIfMissing(new java.lang.StringBuilder(21).append("rss.").append(module).append(".io.serverThreads").toString(), Integer.toString(numThreads));
        conf.setIfMissing(new java.lang.StringBuilder(21).append("rss.").append(module).append(".io.clientThreads").toString(), Integer.toString(numThreads));
        return new TransportConf(module, conf);
    }

    public int fromCelebornConf$default$3() {
        return 0;
    }

    private int defaultNumThreads(int numUsableCores) {
        int availableCores = numUsableCores > 0 ? numUsableCores : Runtime.getRuntime().availableProcessors();
        return package$.MODULE$.min(availableCores, this.MAX_DEFAULT_NETTY_THREADS());
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public ClassLoader getContextOrClassLoader() {
        return (ClassLoader)Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader()).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getClassLoader());
    }

    public boolean classIsLoadable(String clazz) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Class.forName(clazz, false, MODULE$.getContextOrClassLoader())).isSuccess();
    }

    public Class<?> classForName(String className) {
        return Class.forName(className, true, this.getContextOrClassLoader());
    }

    public String getCodeSourceLocation(Class<?> clazz) {
        return new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
    }

    /*
     * WARNING - void declaration
     */
    public String loadDefaultRssProperties(CelebornConf conf, String filePath) {
        void var3_3;
        String path = (String)Option$.MODULE$.apply((Object)filePath).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getDefaultPropertiesFile(MODULE$.getDefaultPropertiesFile$default$1()));
        Option$.MODULE$.apply((Object)path).foreach((Function1 & Serializable & scala.Serializable)confFile -> {
            Utils$.$anonfun$loadDefaultRssProperties$2(conf, confFile);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    public String loadDefaultRssProperties$default$2() {
        return null;
    }

    public String getDefaultPropertiesFile(scala.collection.immutable.Map<String, String> env) {
        return (String)env.get((Object)"CELEBORN_CONF_DIR").orElse((Function0 & Serializable & scala.Serializable)() -> env.get((Object)"CELEBORN_HOME").map((Function1 & Serializable & scala.Serializable)t -> new java.lang.StringBuilder(4).append((String)t).append(File.separator).append("conf").toString())).map((Function1 & Serializable & scala.Serializable)t -> new File(new java.lang.StringBuilder(22).append((String)t).append(File.separator).append("celeborn-defaults.conf").toString())).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isFile())).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getAbsolutePath()).orNull(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<String, String> getDefaultPropertiesFile$default$1() {
        return scala.sys.package$.MODULE$.env();
    }

    public String getDefaultQuotaConfigurationFile(scala.collection.immutable.Map<String, String> env) {
        return (String)env.get((Object)"CELEBORN_CONF_DIR").orElse((Function0 & Serializable & scala.Serializable)() -> env.get((Object)"CELEBORN_HOME").map((Function1 & Serializable & scala.Serializable)t -> new java.lang.StringBuilder(4).append((String)t).append(File.separator).append("conf").toString())).map((Function1 & Serializable & scala.Serializable)t -> new File(new java.lang.StringBuilder(10).append((String)t).append(File.separator).append("quota.yaml").toString())).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isFile())).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.getAbsolutePath()).orNull(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<String, String> getDefaultQuotaConfigurationFile$default$1() {
        return scala.sys.package$.MODULE$.env();
    }

    public String trimExceptCRLF(String str) {
        Function1 & Serializable & scala.Serializable nonSpaceOrNaturalLineDelimiter = (Function1 & Serializable & scala.Serializable)ch -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$trimExceptCRLF$1(BoxesRunTime.unboxToChar((Object)ch)));
        int firstPos = new StringOps(Predef$.MODULE$.augmentString(str)).indexWhere((Function1)nonSpaceOrNaturalLineDelimiter);
        int lastPos = new StringOps(Predef$.MODULE$.augmentString(str)).lastIndexWhere((Function1)nonSpaceOrNaturalLineDelimiter);
        return firstPos >= 0 && lastPos >= 0 ? str.substring(firstPos, lastPos + 1) : "";
    }

    public scala.collection.immutable.Map<String, String> getPropertiesFromFile(String filename) {
        scala.collection.immutable.Map map;
        File file = new File(filename);
        Predef$.MODULE$.require(file.exists(), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(31).append("Properties file ").append(file).append(" does not exist").toString());
        Predef$.MODULE$.require(file.isFile(), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(37).append("Properties file ").append(file).append(" is not a normal file").toString());
        try (InputStreamReader inReader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            try {
                Properties properties = new Properties();
                properties.load(inReader);
                map = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(properties.stringPropertyNames()).asScala()).map((Function1 & Serializable & scala.Serializable)k -> new Tuple2(k, (Object)MODULE$.trimExceptCRLF(properties.getProperty((String)k))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }
            catch (IOException e) {
                throw new CelebornException(new java.lang.StringBuilder(40).append("Failed when loading RSS properties from ").append(filename).toString(), e);
            }
        }
        return map;
    }

    public String makeShuffleKey(String applicationId, int shuffleId) {
        return new java.lang.StringBuilder(1).append(applicationId).append("-").append(shuffleId).toString();
    }

    public Tuple2<String, Object> splitShuffleKey(String shuffleKey) {
        String[] splits = shuffleKey.split("-");
        String appId = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splits)).dropRight(1))).mkString("-");
        int shuffleId = new StringOps(Predef$.MODULE$.augmentString((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splits)).last())).toInt();
        return new Tuple2((Object)appId, (Object)BoxesRunTime.boxToInteger((int)shuffleId));
    }

    public Tuple2<Object, Object> splitPartitionLocationUniqueId(String uniqueId) {
        String[] splits = uniqueId.split("-");
        int partitionId = new StringOps(Predef$.MODULE$.augmentString(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splits)).dropRight(1))).mkString("-"))).toInt();
        int epoch = new StringOps(Predef$.MODULE$.augmentString((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splits)).last())).toInt();
        return new Tuple2.mcII.sp(partitionId, epoch);
    }

    public String makeReducerKey(String applicationId, int shuffleId, int partitionId) {
        return new java.lang.StringBuilder(2).append(applicationId).append("-").append(shuffleId).append("-").append(partitionId).toString();
    }

    public String makeMapKey(String applicationId, int shuffleId, int mapId, int attemptId) {
        return new java.lang.StringBuilder(3).append(applicationId).append("-").append(shuffleId).append("-").append(mapId).append("-").append(attemptId).toString();
    }

    public String makeMapKey(int shuffleId, int mapId, int attemptId) {
        return new java.lang.StringBuilder(2).append(shuffleId).append("-").append(mapId).append("-").append(attemptId).toString();
    }

    public String shuffleKeyPrefix(String shuffleKey) {
        return new java.lang.StringBuilder(1).append(shuffleKey).append("-").toString();
    }

    public int bytesToInt(byte[] bytes, boolean bigEndian) {
        return bigEndian ? bytes[0] << 24 | bytes[1] << 16 | bytes[2] << 8 | bytes[3] : bytes[3] << 24 | bytes[2] << 16 | bytes[1] << 8 | bytes[0];
    }

    public boolean bytesToInt$default$2() {
        return true;
    }

    public long timeIt(Function0<BoxedUnit> f) {
        long start = System.currentTimeMillis();
        f.apply$mcV$sp();
        return System.currentTimeMillis() - start;
    }

    public String getThreadDump() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        String pid = runtimeMXBean.getName().split("@")[0];
        return this.runCommand(new java.lang.StringBuilder(10).append("jstack -l ").append(pid).toString());
    }

    private String readProcessStdout(Process process) {
        InputStream stream = process.getInputStream();
        StringBuilder sb = new StringBuilder();
        int res = stream.read();
        while (res != -1) {
            sb.append((char)res);
            res = stream.read();
        }
        return sb.toString();
    }

    public String runCommand(String cmd) {
        Process process = Runtime.getRuntime().exec(cmd);
        return this.readProcessStdout(process);
    }

    public String runCommandComplex(String cmd) {
        String[] cmds = (String[])((Object[])new String[]{"/bin/sh", "-c", cmd});
        Process process = Runtime.getRuntime().exec(cmds);
        return this.readProcessStdout(process);
    }

    public File createDirectory(String root, String namePrefix) {
        int attempts = 0;
        int maxAttempts = 10;
        File dir = null;
        while (dir == null) {
            if (++attempts > maxAttempts) {
                throw new IOException(new java.lang.StringBuilder(59).append("Failed to create a temp directory (under ").append(root).append(") after ").append(maxAttempts).append(" attempts!").toString());
            }
            try {
                dir = new File(root, new java.lang.StringBuilder(1).append(namePrefix).append("-").append(UUID.randomUUID().toString()).toString());
                if (!dir.exists() && dir.mkdirs()) continue;
                dir = null;
            }
            catch (SecurityException securityException) {
                dir = null;
            }
        }
        return dir.getCanonicalFile();
    }

    public String createDirectory$default$2() {
        return "rss";
    }

    /*
     * WARNING - void declaration
     */
    public File createTempDir(String root, String namePrefix) {
        void var3_3;
        File dir = this.createDirectory(root, namePrefix);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(dir){
            private final File dir$1;

            public void run() {
                block0: {
                    if (this.dir$1 == null) break block0;
                    JavaUtils.deleteRecursively(this.dir$1);
                }
            }
            {
                this.dir$1 = dir$1;
            }
        }));
        return var3_3;
    }

    public String createTempDir$default$1() {
        return System.getProperty("java.io.tmpdir");
    }

    public String createTempDir$default$2() {
        return "celeborn";
    }

    public String mkString(Seq<String> args, String sep) {
        return args.mkString(sep);
    }

    public String mkString$default$2() {
        return ",";
    }

    /*
     * WARNING - void declaration
     */
    public Map<WorkerInfo, Map<String, Integer>> getSlotsPerDisk(HashMap<WorkerInfo, Tuple2<List<PartitionLocation>, List<PartitionLocation>>> slots) {
        void var2_2;
        HashMap workerSlotsDistribution = new HashMap();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(slots).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            WorkerInfo workerInfo;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    workerInfo = (WorkerInfo)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            List masterPartitionLoc = (List)tuple2._1();
            List slavePartitionLoc = (List)tuple2._2();
            HashMap diskSlotsMap = new HashMap();
            Utils$.countSlotsByDisk$1(masterPartitionLoc, diskSlotsMap);
            Utils$.countSlotsByDisk$1(slavePartitionLoc, diskSlotsMap);
            Map map = workerSlotsDistribution.put(workerInfo, diskSlotsMap);
            return map;
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Integer> getSlotsPerDisk(List<PartitionLocation> masterLocations, List<PartitionLocation> workerLocations) {
        void var3_3;
        HashMap slotDistributions = new HashMap();
        ((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(masterLocations).asScala()).$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(workerLocations).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            PartitionLocation partitionLocation = x0$1;
            String mountPoint = partitionLocation.getStorageInfo().getMountPoint();
            Integer n = slotDistributions.containsKey(mountPoint) ? slotDistributions.put(mountPoint, Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int((Integer)slotDistributions.get(mountPoint)) + 1)) : slotDistributions.put(mountPoint, Predef$.MODULE$.int2Integer(1));
            return n;
        });
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(34).append("locations to distribution ,").append(" ").append(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(masterLocations).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.toString(), Buffer$.MODULE$.canBuildFrom())).mkString(",")).append(" ").append(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(workerLocations).asScala()).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.toString(), Buffer$.MODULE$.canBuildFrom())).mkString(",")).append(" ").append("to ").append(slotDistributions).append(" ").toString());
        return var3_3;
    }

    public <T> T tryWithTimeoutAndCallback(Function0<T> block, Function0<T> callback, ThreadPoolExecutor threadPool, long timeoutInSeconds, String errorMessage) {
        Object object;
        Callable futureTask = new Callable<T>(block){
            private final Function0 block$1;

            public T call() {
                return (T)this.block$1.apply();
            }
            {
                this.block$1 = block$1;
            }
        };
        Future future = null;
        try {
            try {
                future = threadPool.submit(futureTask);
                object = future.get(timeoutInSeconds, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(44).append("TimeoutException in thread ").append(Thread.currentThread().getName()).append(",").append(" error message: ").append(errorMessage).toString());
                object = callback.apply();
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        finally {
            if (future != null && !future.isCancelled()) {
                future.cancel(true);
            }
        }
        return object;
    }

    public <T> long tryWithTimeoutAndCallback$default$4(Function0<T> block, Function0<T> callback) {
        return 10L;
    }

    public <T> String tryWithTimeoutAndCallback$default$5(Function0<T> block, Function0<T> callback) {
        return "none";
    }

    public Object toTransportMessage(Object message) {
        Object object;
        Object object2 = message;
        if (object2 instanceof Message) {
            Message message2 = (Message)object2;
            object = ControlMessages$.MODULE$.toTransportMessage(message2);
        } else if (object2 instanceof GeneratedMessageV3) {
            GeneratedMessageV3 generatedMessageV3 = (GeneratedMessageV3)object2;
            object = ControlMessages$.MODULE$.toTransportMessage(generatedMessageV3);
        } else {
            object = message;
        }
        return object;
    }

    public Object fromTransportMessage(Object message) {
        Object object;
        Object object2 = message;
        if (object2 instanceof TransportMessage) {
            TransportMessage transportMessage = (TransportMessage)object2;
            object = ControlMessages$.MODULE$.fromTransportMessage(transportMessage);
        } else {
            object = message;
        }
        return object;
    }

    public StatusCode toStatusCode(int status) {
        StatusCode statusCode;
        int n = status;
        switch (n) {
            case 0: {
                statusCode = StatusCode.SUCCESS;
                break;
            }
            case 1: {
                statusCode = StatusCode.PARTIAL_SUCCESS;
                break;
            }
            case 2: {
                statusCode = StatusCode.REQUEST_FAILED;
                break;
            }
            case 3: {
                statusCode = StatusCode.SHUFFLE_ALREADY_REGISTERED;
                break;
            }
            case 4: {
                statusCode = StatusCode.SHUFFLE_NOT_REGISTERED;
                break;
            }
            case 5: {
                statusCode = StatusCode.RESERVE_SLOTS_FAILED;
                break;
            }
            case 6: {
                statusCode = StatusCode.SLOT_NOT_AVAILABLE;
                break;
            }
            case 7: {
                statusCode = StatusCode.WORKER_NOT_FOUND;
                break;
            }
            case 8: {
                statusCode = StatusCode.PARTITION_NOT_FOUND;
                break;
            }
            case 9: {
                statusCode = StatusCode.SLAVE_PARTITION_NOT_FOUND;
                break;
            }
            case 10: {
                statusCode = StatusCode.DELETE_FILES_FAILED;
                break;
            }
            case 11: {
                statusCode = StatusCode.PARTITION_EXISTS;
                break;
            }
            case 12: {
                statusCode = StatusCode.REVIVE_FAILED;
                break;
            }
            case 13: {
                statusCode = StatusCode.PUSH_DATA_FAILED;
                break;
            }
            case 14: {
                statusCode = StatusCode.NUM_MAPPER_ZERO;
                break;
            }
            case 15: {
                statusCode = StatusCode.MAP_ENDED;
                break;
            }
            case 16: {
                statusCode = StatusCode.STAGE_ENDED;
                break;
            }
            case 17: {
                statusCode = StatusCode.PUSH_DATA_FAIL_NON_CRITICAL_CAUSE;
                break;
            }
            case 18: {
                statusCode = StatusCode.PUSH_DATA_FAIL_SLAVE;
                break;
            }
            case 19: {
                statusCode = StatusCode.PUSH_DATA_FAIL_MASTER;
                break;
            }
            case 20: {
                statusCode = StatusCode.PUSH_DATA_FAIL_PARTITION_NOT_FOUND;
                break;
            }
            case 21: {
                statusCode = StatusCode.HARD_SPLIT;
                break;
            }
            case 22: {
                statusCode = StatusCode.SOFT_SPLIT;
                break;
            }
            case 23: {
                statusCode = StatusCode.STAGE_END_TIME_OUT;
                break;
            }
            case 24: {
                statusCode = StatusCode.SHUFFLE_DATA_LOST;
                break;
            }
            case 25: {
                statusCode = StatusCode.WORKER_SHUTDOWN;
                break;
            }
            case 26: {
                statusCode = StatusCode.NO_AVAILABLE_WORKING_DIR;
                break;
            }
            case 27: {
                statusCode = StatusCode.WORKER_IN_BLACKLIST;
                break;
            }
            case 28: {
                statusCode = StatusCode.UNKNOWN_WORKER;
                break;
            }
            case 30: {
                statusCode = StatusCode.PUSH_DATA_SUCCESS_MASTER_CONGESTED;
                break;
            }
            case 31: {
                statusCode = StatusCode.PUSH_DATA_SUCCESS_SLAVE_CONGESTED;
                break;
            }
            default: {
                statusCode = null;
                break;
            }
        }
        return statusCode;
    }

    public PartitionSplitMode toShuffleSplitMode(int mode) {
        PartitionSplitMode partitionSplitMode;
        int n = mode;
        switch (n) {
            case 0: {
                partitionSplitMode = PartitionSplitMode.SOFT;
                break;
            }
            case 1: {
                partitionSplitMode = PartitionSplitMode.HARD;
                break;
            }
            default: {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(39).append("invalid shuffle mode ").append(mode).append(", fallback to soft").toString());
                partitionSplitMode = PartitionSplitMode.SOFT;
                break;
            }
        }
        return partitionSplitMode;
    }

    public PartitionType toPartitionType(int value) {
        PartitionType partitionType;
        int n = value;
        switch (n) {
            case 0: {
                partitionType = PartitionType.REDUCE;
                break;
            }
            case 1: {
                partitionType = PartitionType.MAP;
                break;
            }
            case 2: {
                partitionType = PartitionType.MAPGROUP;
                break;
            }
            default: {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(51).append("invalid partitionType ").append(value).append(", fallback to ReducePartition").toString());
                partitionType = PartitionType.REDUCE;
                break;
            }
        }
        return partitionType;
    }

    public DiskStatus toDiskStatus(int value) {
        DiskStatus diskStatus;
        int n = value;
        switch (n) {
            case 0: {
                diskStatus = DiskStatus.HEALTHY;
                break;
            }
            case 1: {
                diskStatus = DiskStatus.READ_OR_WRITE_FAILURE;
                break;
            }
            case 2: {
                diskStatus = DiskStatus.IO_HANG;
                break;
            }
            case 3: {
                diskStatus = DiskStatus.HIGH_DISK_USAGE;
                break;
            }
            default: {
                diskStatus = null;
                break;
            }
        }
        return diskStatus;
    }

    public String getPeerPath(String path) {
        return path.endsWith("0") ? new java.lang.StringBuilder(1).append(path.substring(0, path.length() - 1)).append("1").toString() : new java.lang.StringBuilder(1).append(path.substring(0, path.length() - 1)).append("0").toString();
    }

    public String SORTED_SUFFIX() {
        return this.SORTED_SUFFIX;
    }

    public String INDEX_SUFFIX() {
        return this.INDEX_SUFFIX;
    }

    public String SUFFIX_HDFS_WRITE_SUCCESS() {
        return this.SUFFIX_HDFS_WRITE_SUCCESS;
    }

    public boolean isHdfsPath(String path) {
        return path.startsWith("hdfs://");
    }

    public String getSortedFilePath(String path) {
        return new java.lang.StringBuilder(0).append(path).append(this.SORTED_SUFFIX()).toString();
    }

    public String getIndexFilePath(String path) {
        return new java.lang.StringBuilder(0).append(path).append(this.INDEX_SUFFIX()).toString();
    }

    public String getWriteSuccessFilePath(String path) {
        return new java.lang.StringBuilder(0).append(path).append(this.SUFFIX_HDFS_WRITE_SUCCESS()).toString();
    }

    public ByteString roaringBitmapToByteString(RoaringBitmap roaringBitMap) {
        ByteString byteString;
        if (roaringBitMap != null && !roaringBitMap.isEmpty()) {
            ByteBuffer buf = ByteBuffer.allocate(roaringBitMap.serializedSizeInBytes());
            roaringBitMap.serialize(buf);
            buf.rewind();
            byteString = ByteString.copyFrom((ByteBuffer)buf);
        } else {
            byteString = ByteString.EMPTY;
        }
        return byteString;
    }

    /*
     * WARNING - void declaration
     */
    public RoaringBitmap byteStringToRoaringBitmap(ByteString bytes) {
        RoaringBitmap roaringBitmap;
        if (!bytes.isEmpty()) {
            void var2_2;
            RoaringBitmap roaringBitmap2 = new RoaringBitmap();
            ByteBuffer buf = bytes.asReadOnlyByteBuffer();
            buf.rewind();
            roaringBitmap2.deserialize(buf);
            roaringBitmap = var2_2;
        } else {
            roaringBitmap = null;
        }
        return roaringBitmap;
    }

    public static final /* synthetic */ boolean $anonfun$stringToSeq$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$findLocalInetAddress$2(InetAddress addr) {
        return addr.isLinkLocalAddress() || addr.isLoopbackAddress();
    }

    public static final /* synthetic */ boolean $anonfun$findLocalInetAddress$3(InetAddress x$5) {
        return x$5 instanceof Inet4Address;
    }

    public static final /* synthetic */ void $anonfun$findLocalInetAddress$1(InetAddress address$1, Object nonLocalReturnKey2$1, NetworkInterface ni) {
        Seq addresses = ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(ni.getInetAddresses()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)addr -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$findLocalInetAddress$2(addr))).toSeq();
        if (addresses.nonEmpty()) {
            InetAddress addr2 = (InetAddress)addresses.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$findLocalInetAddress$3(x$5))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (InetAddress)addresses.head());
            InetAddress strippedAddress = InetAddress.getByAddress(addr2.getAddress());
            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(80).append("Your hostname, ").append(InetAddress.getLocalHost().getHostName()).append(" resolves to").append(" a loopback address: ").append(address$1.getHostAddress()).append("; using ").append(strippedAddress.getHostAddress()).append(" instead (on interface ").append(ni.getName()).append(")").toString());
            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Set CELEBORN_LOCAL_IP if you need to bind to another address");
            throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)strippedAddress);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Tuple2 setDefaultPortValue$1(String hostPort$2) {
        void var2_2;
        Tuple2 retval = new Tuple2((Object)hostPort$2, (Object)BoxesRunTime.boxToInteger((int)0));
        this.hostPortParseResults().put(hostPort$2, (Tuple2<String, Object>)retval);
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$loadDefaultRssProperties$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        boolean bl = k.startsWith("celeborn.") || k.startsWith("rss.");
        return bl;
    }

    public static final /* synthetic */ void $anonfun$loadDefaultRssProperties$2(CelebornConf conf$1, String confFile) {
        ((IterableLike)MODULE$.getPropertiesFromFile(confFile).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$loadDefaultRssProperties$3(x0$1)))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            conf$1.setIfMissing(k, v);
            String string = (String)scala.sys.package$.MODULE$.props().getOrElseUpdate((Object)k, (Function0 & Serializable & scala.Serializable)() -> v);
            return string;
        });
    }

    public static final /* synthetic */ boolean $anonfun$trimExceptCRLF$1(char ch) {
        return ch > ' ' || ch == '\r' || ch == '\n';
    }

    private static final void countSlotsByDisk$1(List location, HashMap diskSlotsMap$1) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(location).asScala()).foreach((Function1 & Serializable & scala.Serializable)item -> {
            String mountPoint = item.getStorageInfo().getMountPoint();
            return diskSlotsMap$1.containsKey(mountPoint) ? diskSlotsMap$1.put(mountPoint, Predef$.MODULE$.int2Integer(1 + Predef$.MODULE$.Integer2int((Integer)diskSlotsMap$1.get(mountPoint)))) : diskSlotsMap$1.put(mountPoint, Predef$.MODULE$.int2Integer(1));
        });
    }

    private Utils$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.isWindows = SystemUtils.IS_OS_WINDOWS;
        this.isMac = SystemUtils.IS_OS_MAC_OSX;
        this.isMacOnAppleSilicon = SystemUtils.IS_OS_MAC_OSX && SystemUtils.OS_ARCH.equals("aarch64");
        this.customHostname = scala.sys.package$.MODULE$.env().get((Object)"CELEBORN_LOCAL_HOSTNAME");
        this.hostPortParseResults = new ConcurrentHashMap();
        this.MAX_DEFAULT_NETTY_THREADS = 64;
        this.SORTED_SUFFIX = ".sorted";
        this.INDEX_SUFFIX = ".index";
        this.SUFFIX_HDFS_WRITE_SUCCESS = ".success";
    }
}

