/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.protocol.message;

import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.protocol.MessageType;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PartitionSplitMode;
import org.apache.celeborn.common.protocol.PartitionType;
import org.apache.celeborn.common.protocol.PbApplicationLost;
import org.apache.celeborn.common.protocol.PbApplicationLostResponse;
import org.apache.celeborn.common.protocol.PbChangeLocationResponse;
import org.apache.celeborn.common.protocol.PbCheckForWorkerTimeout;
import org.apache.celeborn.common.protocol.PbCheckForWorkerTimeoutOrBuilder;
import org.apache.celeborn.common.protocol.PbCheckQuota;
import org.apache.celeborn.common.protocol.PbCheckQuotaResponse;
import org.apache.celeborn.common.protocol.PbCommitFiles;
import org.apache.celeborn.common.protocol.PbCommitFilesResponse;
import org.apache.celeborn.common.protocol.PbDestroy;
import org.apache.celeborn.common.protocol.PbDestroyResponse;
import org.apache.celeborn.common.protocol.PbDiskInfo;
import org.apache.celeborn.common.protocol.PbFileGroup;
import org.apache.celeborn.common.protocol.PbGetBlacklist;
import org.apache.celeborn.common.protocol.PbGetBlacklistResponse;
import org.apache.celeborn.common.protocol.PbGetReducerFileGroup;
import org.apache.celeborn.common.protocol.PbGetReducerFileGroupResponse;
import org.apache.celeborn.common.protocol.PbGetWorkerInfosResponse;
import org.apache.celeborn.common.protocol.PbHeartbeatFromApplication;
import org.apache.celeborn.common.protocol.PbHeartbeatFromWorker;
import org.apache.celeborn.common.protocol.PbHeartbeatResponse;
import org.apache.celeborn.common.protocol.PbMapperEnd;
import org.apache.celeborn.common.protocol.PbMapperEndResponse;
import org.apache.celeborn.common.protocol.PbPartitionLocation;
import org.apache.celeborn.common.protocol.PbPartitionSplit;
import org.apache.celeborn.common.protocol.PbRegisterShuffle;
import org.apache.celeborn.common.protocol.PbRegisterShuffleResponse;
import org.apache.celeborn.common.protocol.PbRegisterWorker;
import org.apache.celeborn.common.protocol.PbRegisterWorkerResponse;
import org.apache.celeborn.common.protocol.PbReleaseSlots;
import org.apache.celeborn.common.protocol.PbReleaseSlotsResponse;
import org.apache.celeborn.common.protocol.PbReportWorkerUnavailable;
import org.apache.celeborn.common.protocol.PbRequestSlots;
import org.apache.celeborn.common.protocol.PbRequestSlotsResponse;
import org.apache.celeborn.common.protocol.PbReregisterWorkerResponse;
import org.apache.celeborn.common.protocol.PbReserveSlots;
import org.apache.celeborn.common.protocol.PbReserveSlotsResponse;
import org.apache.celeborn.common.protocol.PbResourceConsumption;
import org.apache.celeborn.common.protocol.PbRevive;
import org.apache.celeborn.common.protocol.PbSlaveLostResponse;
import org.apache.celeborn.common.protocol.PbSlotInfo;
import org.apache.celeborn.common.protocol.PbStageEnd;
import org.apache.celeborn.common.protocol.PbStageEndResponse;
import org.apache.celeborn.common.protocol.PbStorageInfo;
import org.apache.celeborn.common.protocol.PbThreadDumpResponse;
import org.apache.celeborn.common.protocol.PbUnregisterShuffle;
import org.apache.celeborn.common.protocol.PbUnregisterShuffleResponse;
import org.apache.celeborn.common.protocol.PbWorkerInfo;
import org.apache.celeborn.common.protocol.PbWorkerLost;
import org.apache.celeborn.common.protocol.PbWorkerLostResponse;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.protocol.message.ControlMessages;
import org.apache.celeborn.common.protocol.message.ControlMessages$CheckForApplicationTimeOut$;
import org.apache.celeborn.common.protocol.message.ControlMessages$GetWorkerInfos$;
import org.apache.celeborn.common.protocol.message.ControlMessages$OneWayMessageResponse$;
import org.apache.celeborn.common.protocol.message.ControlMessages$RemoveExpiredShuffle$;
import org.apache.celeborn.common.protocol.message.ControlMessages$ThreadDump$;
import org.apache.celeborn.common.protocol.message.StatusCode;
import org.apache.celeborn.common.quota.ResourceConsumption;
import org.apache.celeborn.common.util.PbSerDeUtils$;
import org.apache.celeborn.common.util.Utils$;
import org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ControlMessages$
implements Logging {
    public static ControlMessages$ MODULE$;
    private final String ZERO_UUID;
    private final PbCheckForWorkerTimeout pbCheckForWorkerTimeout;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ControlMessages$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        ControlMessages$ controlMessages$ = this;
        synchronized (controlMessages$) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public String ZERO_UUID() {
        return this.ZERO_UUID;
    }

    public PbCheckForWorkerTimeout pbCheckForWorkerTimeout() {
        return this.pbCheckForWorkerTimeout;
    }

    public TransportMessage toTransportMessage(Object message) {
        TransportMessage transportMessage;
        Object object = message;
        if (object instanceof PbCheckForWorkerTimeoutOrBuilder) {
            transportMessage = new TransportMessage(MessageType.CHECK_FOR_WORKER_TIMEOUT, null);
        } else if (ControlMessages$CheckForApplicationTimeOut$.MODULE$.equals(object)) {
            transportMessage = new TransportMessage(MessageType.CHECK_FOR_APPLICATION_TIMEOUT, null);
        } else if (ControlMessages$RemoveExpiredShuffle$.MODULE$.equals(object)) {
            transportMessage = new TransportMessage(MessageType.REMOVE_EXPIRED_SHUFFLE, null);
        } else if (object instanceof PbRegisterWorker) {
            PbRegisterWorker pbRegisterWorker = (PbRegisterWorker)object;
            transportMessage = new TransportMessage(MessageType.REGISTER_WORKER, pbRegisterWorker.toByteArray());
        } else if (object instanceof ControlMessages.HeartbeatFromWorker) {
            ControlMessages.HeartbeatFromWorker heartbeatFromWorker = (ControlMessages.HeartbeatFromWorker)object;
            String host = heartbeatFromWorker.host();
            int rpcPort = heartbeatFromWorker.rpcPort();
            int pushPort = heartbeatFromWorker.pushPort();
            int fetchPort = heartbeatFromWorker.fetchPort();
            int replicatePort = heartbeatFromWorker.replicatePort();
            Seq<DiskInfo> disks = heartbeatFromWorker.disks();
            Map<UserIdentifier, ResourceConsumption> userResourceConsumption = heartbeatFromWorker.userResourceConsumption();
            Set<String> activeShuffleKeys = heartbeatFromWorker.activeShuffleKeys();
            HashMap<String, Long> estimatedAppDiskUsage = heartbeatFromWorker.estimatedAppDiskUsage();
            String requestId = heartbeatFromWorker.requestId();
            java.util.List pbDisks = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)disks.map((Function1 & Serializable & scala.Serializable)diskInfo -> PbSerDeUtils$.MODULE$.toPbDiskInfo((DiskInfo)diskInfo), Seq$.MODULE$.canBuildFrom())).asJava();
            Map<String, PbResourceConsumption> pbUserResourceConsumption = PbSerDeUtils$.MODULE$.toPbUserResourceConsumption(userResourceConsumption);
            byte[] payload = PbHeartbeatFromWorker.newBuilder().setHost(host).setRpcPort(rpcPort).setPushPort(pushPort).setFetchPort(fetchPort).addAllDisks(pbDisks).putAllUserResourceConsumption(pbUserResourceConsumption).setReplicatePort(replicatePort).addAllActiveShuffleKeys(activeShuffleKeys).putAllEstimatedAppDiskUsage(estimatedAppDiskUsage).setRequestId(requestId).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.HEARTBEAT_FROM_WORKER, payload);
        } else if (object instanceof ControlMessages.HeartbeatResponse) {
            ControlMessages.HeartbeatResponse heartbeatResponse = (ControlMessages.HeartbeatResponse)object;
            HashSet<String> expiredShuffleKeys = heartbeatResponse.expiredShuffleKeys();
            boolean registered = heartbeatResponse.registered();
            byte[] payload = PbHeartbeatResponse.newBuilder().addAllExpiredShuffleKeys(expiredShuffleKeys).setRegistered(registered).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.HEARTBEAT_RESPONSE, payload);
        } else if (object instanceof PbRegisterShuffle) {
            PbRegisterShuffle pbRegisterShuffle = (PbRegisterShuffle)object;
            transportMessage = new TransportMessage(MessageType.REGISTER_SHUFFLE, pbRegisterShuffle.toByteArray());
        } else if (object instanceof PbRegisterShuffleResponse) {
            PbRegisterShuffleResponse pbRegisterShuffleResponse = (PbRegisterShuffleResponse)object;
            transportMessage = new TransportMessage(MessageType.REGISTER_SHUFFLE_RESPONSE, pbRegisterShuffleResponse.toByteArray());
        } else if (object instanceof ControlMessages.RequestSlots) {
            ControlMessages.RequestSlots requestSlots = (ControlMessages.RequestSlots)object;
            String applicationId = requestSlots.applicationId();
            int shuffleId = requestSlots.shuffleId();
            ArrayList<Integer> partitionIdList = requestSlots.partitionIdList();
            String hostname = requestSlots.hostname();
            boolean shouldReplicate = requestSlots.shouldReplicate();
            UserIdentifier userIdentifier = requestSlots.userIdentifier();
            String requestId = requestSlots.requestId();
            byte[] payload = PbRequestSlots.newBuilder().setApplicationId(applicationId).setShuffleId(shuffleId).addAllPartitionIdList(partitionIdList).setHostname(hostname).setShouldReplicate(shouldReplicate).setRequestId(requestId).setUserIdentifier(PbSerDeUtils$.MODULE$.toPbUserIdentifier(userIdentifier)).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.REQUEST_SLOTS, payload);
        } else if (object instanceof ControlMessages.ReleaseSlots) {
            ControlMessages.ReleaseSlots releaseSlots = (ControlMessages.ReleaseSlots)object;
            String applicationId = releaseSlots.applicationId();
            int shuffleId = releaseSlots.shuffleId();
            java.util.List<String> workerIds = releaseSlots.workerIds();
            java.util.List<Map<String, Integer>> slots = releaseSlots.slots();
            String requestId = releaseSlots.requestId();
            List pbSlots = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(slots).asScala()).map((Function1 & Serializable & scala.Serializable)slot -> PbSlotInfo.newBuilder().putAllSlot((Map<String, Integer>)slot).build(), Buffer$.MODULE$.canBuildFrom())).toList();
            byte[] payload = PbReleaseSlots.newBuilder().setApplicationId(applicationId).setShuffleId(shuffleId).setRequestId(requestId).addAllWorkerIds(workerIds).addAllSlots((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pbSlots).asJava()).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.RELEASE_SLOTS, payload);
        } else if (object instanceof ControlMessages.ReleaseSlotsResponse) {
            ControlMessages.ReleaseSlotsResponse releaseSlotsResponse = (ControlMessages.ReleaseSlotsResponse)object;
            StatusCode status = releaseSlotsResponse.status();
            byte[] payload = PbReleaseSlotsResponse.newBuilder().setStatus(status.getValue()).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.RELEASE_SLOTS_RESPONSE, payload);
        } else if (object instanceof ControlMessages.RequestSlotsResponse) {
            ControlMessages.RequestSlotsResponse requestSlotsResponse = (ControlMessages.RequestSlotsResponse)object;
            StatusCode status = requestSlotsResponse.status();
            HashMap<WorkerInfo, Tuple2<java.util.List<PartitionLocation>, java.util.List<PartitionLocation>>> workerResource = requestSlotsResponse.workerResource();
            PbRequestSlotsResponse.Builder builder = PbRequestSlotsResponse.newBuilder().setStatus(status.getValue());
            Object object2 = !workerResource.isEmpty() ? builder.putAllWorkerResource(PbSerDeUtils$.MODULE$.toPbWorkerResource(workerResource)) : BoxedUnit.UNIT;
            byte[] payload = builder.build().toByteArray();
            transportMessage = new TransportMessage(MessageType.REQUEST_SLOTS_RESPONSE, payload);
        } else if (object instanceof PbRevive) {
            PbRevive pbRevive = (PbRevive)object;
            transportMessage = new TransportMessage(MessageType.REVIVE, pbRevive.toByteArray());
        } else if (object instanceof PbChangeLocationResponse) {
            PbChangeLocationResponse pbChangeLocationResponse = (PbChangeLocationResponse)object;
            transportMessage = new TransportMessage(MessageType.CHANGE_LOCATION_RESPONSE, pbChangeLocationResponse.toByteArray());
        } else if (object instanceof ControlMessages.MapperEnd) {
            ControlMessages.MapperEnd mapperEnd = (ControlMessages.MapperEnd)object;
            String applicationId = mapperEnd.applicationId();
            int shuffleId = mapperEnd.shuffleId();
            int mapId = mapperEnd.mapId();
            int attemptId = mapperEnd.attemptId();
            int numMappers = mapperEnd.numMappers();
            byte[] payload = PbMapperEnd.newBuilder().setApplicationId(applicationId).setShuffleId(shuffleId).setMapId(mapId).setAttemptId(attemptId).setNumMappers(numMappers).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.MAPPER_END, payload);
        } else if (object instanceof ControlMessages.MapperEndResponse) {
            ControlMessages.MapperEndResponse mapperEndResponse = (ControlMessages.MapperEndResponse)object;
            StatusCode status = mapperEndResponse.status();
            byte[] payload = PbMapperEndResponse.newBuilder().setStatus(status.getValue()).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.MAPPER_END_RESPONSE, payload);
        } else if (object instanceof ControlMessages.GetReducerFileGroup) {
            ControlMessages.GetReducerFileGroup getReducerFileGroup = (ControlMessages.GetReducerFileGroup)object;
            String applicationId = getReducerFileGroup.applicationId();
            int shuffleId = getReducerFileGroup.shuffleId();
            byte[] payload = PbGetReducerFileGroup.newBuilder().setApplicationId(applicationId).setShuffleId(shuffleId).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.GET_REDUCER_FILE_GROUP, payload);
        } else if (object instanceof ControlMessages.GetReducerFileGroupResponse) {
            ControlMessages.GetReducerFileGroupResponse getReducerFileGroupResponse = (ControlMessages.GetReducerFileGroupResponse)object;
            StatusCode status = getReducerFileGroupResponse.status();
            PartitionLocation[][] fileGroup = getReducerFileGroupResponse.fileGroup();
            int[] attempts = getReducerFileGroupResponse.attempts();
            PbGetReducerFileGroupResponse.Builder builder = PbGetReducerFileGroupResponse.newBuilder().setStatus(status.getValue());
            builder.addAllFileGroup((Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileGroup)).map((Function1 & Serializable & scala.Serializable)arr -> PbFileGroup.newBuilder().addAllLocations((Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arr)).map((Function1 & Serializable & scala.Serializable)location -> PbSerDeUtils$.MODULE$.toPbPartitionLocation((PartitionLocation)location), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(PbPartitionLocation.class))))).toIterable()).asJava()).build(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(PbFileGroup.class))))).toIterable()).asJava());
            builder.addAllAttempts((Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(attempts)).map((Function1 & Serializable & scala.Serializable)x$1 -> ControlMessages$.$anonfun$toTransportMessage$5(BoxesRunTime.unboxToInt((Object)x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.class))))).toIterable()).asJava());
            byte[] payload = builder.build().toByteArray();
            transportMessage = new TransportMessage(MessageType.GET_REDUCER_FILE_GROUP_RESPONSE, payload);
        } else if (object instanceof PbWorkerLost) {
            PbWorkerLost pbWorkerLost = (PbWorkerLost)object;
            transportMessage = new TransportMessage(MessageType.WORKER_LOST, pbWorkerLost.toByteArray());
        } else if (object instanceof PbWorkerLostResponse) {
            PbWorkerLostResponse pbWorkerLostResponse = (PbWorkerLostResponse)object;
            transportMessage = new TransportMessage(MessageType.WORKER_LOST_RESPONSE, pbWorkerLostResponse.toByteArray());
        } else if (object instanceof ControlMessages.StageEnd) {
            ControlMessages.StageEnd stageEnd = (ControlMessages.StageEnd)object;
            String applicationId = stageEnd.applicationId();
            int shuffleId = stageEnd.shuffleId();
            byte[] payload = PbStageEnd.newBuilder().setApplicationId(applicationId).setShuffleId(shuffleId).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.STAGE_END, payload);
        } else if (object instanceof ControlMessages.StageEndResponse) {
            ControlMessages.StageEndResponse stageEndResponse = (ControlMessages.StageEndResponse)object;
            StatusCode status = stageEndResponse.status();
            byte[] payload = PbStageEndResponse.newBuilder().setStatus(status.getValue()).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.STAGE_END_RESPONSE, payload);
        } else if (object instanceof PbUnregisterShuffle) {
            PbUnregisterShuffle pbUnregisterShuffle = (PbUnregisterShuffle)object;
            transportMessage = new TransportMessage(MessageType.UNREGISTER_SHUFFLE, pbUnregisterShuffle.toByteArray());
        } else if (object instanceof PbUnregisterShuffleResponse) {
            PbUnregisterShuffleResponse pbUnregisterShuffleResponse = (PbUnregisterShuffleResponse)object;
            transportMessage = new TransportMessage(MessageType.UNREGISTER_SHUFFLE_RESPONSE, pbUnregisterShuffleResponse.toByteArray());
        } else if (object instanceof ControlMessages.ApplicationLost) {
            ControlMessages.ApplicationLost applicationLost = (ControlMessages.ApplicationLost)object;
            String appId = applicationLost.appId();
            String requestId = applicationLost.requestId();
            byte[] payload = PbApplicationLost.newBuilder().setAppId(appId).setRequestId(requestId).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.APPLICATION_LOST, payload);
        } else if (object instanceof ControlMessages.ApplicationLostResponse) {
            ControlMessages.ApplicationLostResponse applicationLostResponse = (ControlMessages.ApplicationLostResponse)object;
            StatusCode status = applicationLostResponse.status();
            byte[] payload = PbApplicationLostResponse.newBuilder().setStatus(status.getValue()).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.APPLICATION_LOST_RESPONSE, payload);
        } else if (object instanceof ControlMessages.HeartbeatFromApplication) {
            ControlMessages.HeartbeatFromApplication heartbeatFromApplication = (ControlMessages.HeartbeatFromApplication)object;
            String appId = heartbeatFromApplication.appId();
            long totalWritten = heartbeatFromApplication.totalWritten();
            long fileCount = heartbeatFromApplication.fileCount();
            String requestId = heartbeatFromApplication.requestId();
            byte[] payload = PbHeartbeatFromApplication.newBuilder().setAppId(appId).setRequestId(requestId).setTotalWritten(totalWritten).setFileCount(fileCount).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.HEARTBEAT_FROM_APPLICATION, payload);
        } else if (object instanceof ControlMessages.GetBlacklist) {
            ControlMessages.GetBlacklist getBlacklist = (ControlMessages.GetBlacklist)object;
            java.util.List<WorkerInfo> localBlacklist = getBlacklist.localBlacklist();
            byte[] payload = PbGetBlacklist.newBuilder().addAllLocalBlackList((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(localBlacklist).asScala()).map((Function1 & Serializable & scala.Serializable)workerInfo -> PbSerDeUtils$.MODULE$.toPbWorkerInfo((WorkerInfo)workerInfo, true), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.GET_BLACKLIST, payload);
        } else if (object instanceof ControlMessages.GetBlacklistResponse) {
            ControlMessages.GetBlacklistResponse getBlacklistResponse = (ControlMessages.GetBlacklistResponse)object;
            StatusCode statusCode = getBlacklistResponse.statusCode();
            java.util.List<WorkerInfo> blacklist = getBlacklistResponse.blacklist();
            java.util.List<WorkerInfo> unknownWorkers = getBlacklistResponse.unknownWorkers();
            PbGetBlacklistResponse.Builder builder = PbGetBlacklistResponse.newBuilder().setStatus(statusCode.getValue());
            builder.addAllBlacklist((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(blacklist).asScala()).map((Function1 & Serializable & scala.Serializable)workerInfo -> PbSerDeUtils$.MODULE$.toPbWorkerInfo((WorkerInfo)workerInfo, true), Buffer$.MODULE$.canBuildFrom())).toList()).asJava());
            builder.addAllUnknownWorkers((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(unknownWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)workerInfo -> PbSerDeUtils$.MODULE$.toPbWorkerInfo((WorkerInfo)workerInfo, true), Buffer$.MODULE$.canBuildFrom())).toList()).asJava());
            byte[] payload = builder.build().toByteArray();
            transportMessage = new TransportMessage(MessageType.GET_BLACKLIST_RESPONSE, payload);
        } else if (object instanceof ControlMessages.CheckQuota) {
            ControlMessages.CheckQuota checkQuota = (ControlMessages.CheckQuota)object;
            UserIdentifier userIdentifier = checkQuota.userIdentifier();
            PbCheckQuota.Builder builder = PbCheckQuota.newBuilder().setUserIdentifier(PbSerDeUtils$.MODULE$.toPbUserIdentifier(userIdentifier));
            transportMessage = new TransportMessage(MessageType.CHECK_QUOTA, builder.build().toByteArray());
        } else if (object instanceof ControlMessages.CheckQuotaResponse) {
            ControlMessages.CheckQuotaResponse checkQuotaResponse = (ControlMessages.CheckQuotaResponse)object;
            boolean available = checkQuotaResponse.isAvailable();
            byte[] payload = PbCheckQuotaResponse.newBuilder().setAvailable(available).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.CHECK_QUOTA_RESPONSE, payload);
        } else if (object instanceof ControlMessages.ReportWorkerUnavailable) {
            ControlMessages.ReportWorkerUnavailable reportWorkerUnavailable = (ControlMessages.ReportWorkerUnavailable)object;
            java.util.List<WorkerInfo> failed = reportWorkerUnavailable.unavailable();
            String requestId = reportWorkerUnavailable.requestId();
            byte[] payload = PbReportWorkerUnavailable.newBuilder().addAllUnavailable((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(failed).asScala()).map((Function1 & Serializable & scala.Serializable)workerInfo -> PbSerDeUtils$.MODULE$.toPbWorkerInfo((WorkerInfo)workerInfo, true), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()).setRequestId(requestId).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.REPORT_WORKER_FAILURE, payload);
        } else if (object instanceof PbRegisterWorkerResponse) {
            PbRegisterWorkerResponse pbRegisterWorkerResponse = (PbRegisterWorkerResponse)object;
            transportMessage = new TransportMessage(MessageType.REGISTER_WORKER_RESPONSE, pbRegisterWorkerResponse.toByteArray());
        } else if (object instanceof ControlMessages.ReregisterWorkerResponse) {
            ControlMessages.ReregisterWorkerResponse reregisterWorkerResponse = (ControlMessages.ReregisterWorkerResponse)object;
            boolean success = reregisterWorkerResponse.success();
            byte[] payload = PbReregisterWorkerResponse.newBuilder().setSuccess(success).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.REREGISTER_WORKER_RESPONSE, payload);
        } else if (object instanceof ControlMessages.ReserveSlots) {
            ControlMessages.ReserveSlots reserveSlots = (ControlMessages.ReserveSlots)object;
            String applicationId = reserveSlots.applicationId();
            int shuffleId = reserveSlots.shuffleId();
            java.util.List<PartitionLocation> masterLocations = reserveSlots.masterLocations();
            java.util.List<PartitionLocation> slaveLocations = reserveSlots.slaveLocations();
            long splitThreshold = reserveSlots.splitThreshold();
            PartitionSplitMode splitMode = reserveSlots.splitMode();
            PartitionType partType = reserveSlots.partitionType();
            boolean rangeReadFilter = reserveSlots.rangeReadFilter();
            UserIdentifier userIdentifier = reserveSlots.userIdentifier();
            byte[] payload = PbReserveSlots.newBuilder().setApplicationId(applicationId).setShuffleId(shuffleId).addAllMasterLocations((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(masterLocations).asScala()).map((Function1 & Serializable & scala.Serializable)location -> PbSerDeUtils$.MODULE$.toPbPartitionLocation((PartitionLocation)location), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()).addAllSlaveLocations((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(slaveLocations).asScala()).map((Function1 & Serializable & scala.Serializable)location -> PbSerDeUtils$.MODULE$.toPbPartitionLocation((PartitionLocation)location), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()).setSplitThreshold(splitThreshold).setSplitMode(splitMode.getValue()).setPartitionType(partType.getValue()).setRangeReadFilter(rangeReadFilter).setUserIdentifier(PbSerDeUtils$.MODULE$.toPbUserIdentifier(userIdentifier)).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.RESERVE_SLOTS, payload);
        } else if (object instanceof ControlMessages.ReserveSlotsResponse) {
            ControlMessages.ReserveSlotsResponse reserveSlotsResponse = (ControlMessages.ReserveSlotsResponse)object;
            StatusCode status = reserveSlotsResponse.status();
            String reason = reserveSlotsResponse.reason();
            byte[] payload = PbReserveSlotsResponse.newBuilder().setStatus(status.getValue()).setReason(reason).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.RESERVE_SLOTS_RESPONSE, payload);
        } else if (object instanceof ControlMessages.CommitFiles) {
            ControlMessages.CommitFiles commitFiles = (ControlMessages.CommitFiles)object;
            String applicationId = commitFiles.applicationId();
            int shuffleId = commitFiles.shuffleId();
            java.util.List<String> masterIds = commitFiles.masterIds();
            java.util.List<String> slaveIds = commitFiles.slaveIds();
            int[] mapAttempts = commitFiles.mapAttempts();
            long epoch = commitFiles.epoch();
            byte[] payload = PbCommitFiles.newBuilder().setApplicationId(applicationId).setShuffleId(shuffleId).addAllMasterIds(masterIds).addAllSlaveIds(slaveIds).addAllMapAttempts((Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(mapAttempts)).map((Function1 & Serializable & scala.Serializable)x$2 -> ControlMessages$.$anonfun$toTransportMessage$12(BoxesRunTime.unboxToInt((Object)x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.class))))).toIterable()).asJava()).setEpoch(epoch).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.COMMIT_FILES, payload);
        } else if (object instanceof ControlMessages.CommitFilesResponse) {
            ControlMessages.CommitFilesResponse commitFilesResponse = (ControlMessages.CommitFilesResponse)object;
            StatusCode status = commitFilesResponse.status();
            java.util.List<String> committedMasterIds = commitFilesResponse.committedMasterIds();
            java.util.List<String> committedSlaveIds = commitFilesResponse.committedSlaveIds();
            java.util.List<String> failedMasterIds = commitFilesResponse.failedMasterIds();
            java.util.List<String> failedSlaveIds = commitFilesResponse.failedSlaveIds();
            Map<String, StorageInfo> committedMasterStorageInfos = commitFilesResponse.committedMasterStorageInfos();
            Map<String, StorageInfo> committedSlaveStorageInfos = commitFilesResponse.committedSlaveStorageInfos();
            Map<String, RoaringBitmap> committedMapIdBitMap = commitFilesResponse.committedMapIdBitMap();
            long totalWritten = commitFilesResponse.totalWritten();
            int fileCount = commitFilesResponse.fileCount();
            PbCommitFilesResponse.Builder builder = PbCommitFilesResponse.newBuilder().setStatus(status.getValue());
            builder.addAllCommittedMasterIds(committedMasterIds);
            builder.addAllCommittedSlaveIds(committedSlaveIds);
            builder.addAllFailedMasterIds(failedMasterIds);
            builder.addAllFailedSlaveIds(failedSlaveIds);
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(committedMasterStorageInfos).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> builder.putCommittedMasterStorageInfos((String)entry._1(), StorageInfo.toPb((StorageInfo)entry._2())));
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(committedSlaveStorageInfos).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> builder.putCommittedSlaveStorageInfos((String)entry._1(), StorageInfo.toPb((StorageInfo)entry._2())));
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(committedMapIdBitMap).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> builder.putMapIdBitmap((String)entry._1(), Utils$.MODULE$.roaringBitmapToByteString((RoaringBitmap)entry._2())));
            builder.setTotalWritten(totalWritten);
            builder.setFileCount(fileCount);
            byte[] payload = builder.build().toByteArray();
            transportMessage = new TransportMessage(MessageType.COMMIT_FILES_RESPONSE, payload);
        } else if (object instanceof ControlMessages.Destroy) {
            ControlMessages.Destroy destroy = (ControlMessages.Destroy)object;
            String shuffleKey = destroy.shuffleKey();
            java.util.List<String> masterLocations = destroy.masterLocations();
            java.util.List<String> slaveLocations = destroy.slaveLocations();
            byte[] payload = PbDestroy.newBuilder().setShuffleKey(shuffleKey).addAllMasterLocations(masterLocations).addAllSlaveLocation(slaveLocations).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.DESTROY, payload);
        } else if (object instanceof ControlMessages.DestroyResponse) {
            ControlMessages.DestroyResponse destroyResponse = (ControlMessages.DestroyResponse)object;
            StatusCode status = destroyResponse.status();
            java.util.List<String> failedMasters = destroyResponse.failedMasters();
            java.util.List<String> failedSlaves = destroyResponse.failedSlaves();
            PbDestroyResponse.Builder builder = PbDestroyResponse.newBuilder().setStatus(status.getValue());
            builder.addAllFailedMasters(failedMasters);
            builder.addAllFailedSlaves(failedSlaves);
            byte[] payload = builder.build().toByteArray();
            transportMessage = new TransportMessage(MessageType.DESTROY_RESPONSE, payload);
        } else if (object instanceof ControlMessages.SlaveLostResponse) {
            ControlMessages.SlaveLostResponse slaveLostResponse = (ControlMessages.SlaveLostResponse)object;
            StatusCode status = slaveLostResponse.status();
            PartitionLocation slaveLocation = slaveLostResponse.slaveLocation();
            byte[] payload = PbSlaveLostResponse.newBuilder().setStatus(status.getValue()).setSlaveLocation(PbSerDeUtils$.MODULE$.toPbPartitionLocation(slaveLocation)).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.SLAVE_LOST_RESPONSE, payload);
        } else if (ControlMessages$GetWorkerInfos$.MODULE$.equals(object)) {
            transportMessage = new TransportMessage(MessageType.GET_WORKER_INFO, null);
        } else if (object instanceof ControlMessages.GetWorkerInfosResponse) {
            ControlMessages.GetWorkerInfosResponse getWorkerInfosResponse = (ControlMessages.GetWorkerInfosResponse)object;
            StatusCode status = getWorkerInfosResponse.status();
            Seq<WorkerInfo> workerInfos = getWorkerInfosResponse.workerInfos();
            byte[] payload = PbGetWorkerInfosResponse.newBuilder().setStatus(status.getValue()).addAllWorkerInfos((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)workerInfos.map((Function1 & Serializable & scala.Serializable)workerInfo -> PbSerDeUtils$.MODULE$.toPbWorkerInfo((WorkerInfo)workerInfo, false), Seq$.MODULE$.canBuildFrom())).toList()).asJava()).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.GET_WORKER_INFO_RESPONSE, payload);
        } else if (ControlMessages$ThreadDump$.MODULE$.equals(object)) {
            transportMessage = new TransportMessage(MessageType.THREAD_DUMP, null);
        } else if (object instanceof ControlMessages.ThreadDumpResponse) {
            ControlMessages.ThreadDumpResponse threadDumpResponse = (ControlMessages.ThreadDumpResponse)object;
            String threadDump = threadDumpResponse.threadDump();
            byte[] payload = PbThreadDumpResponse.newBuilder().setThreadDump(threadDump).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.THREAD_DUMP_RESPONSE, payload);
        } else if (object instanceof PbPartitionSplit) {
            PbPartitionSplit pbPartitionSplit = (PbPartitionSplit)object;
            transportMessage = new TransportMessage(MessageType.PARTITION_SPLIT, pbPartitionSplit.toByteArray());
        } else if (ControlMessages$OneWayMessageResponse$.MODULE$.equals(object)) {
            transportMessage = new TransportMessage(MessageType.ONE_WAY_MESSAGE_RESPONSE, null);
        } else {
            throw new MatchError(object);
        }
        return transportMessage;
    }

    public Object fromTransportMessage(TransportMessage message) {
        Object object;
        MessageType messageType = message.getType();
        boolean bl = ((Object)((Object)MessageType.UNKNOWN_MESSAGE)).equals((Object)messageType) ? true : ((Object)((Object)MessageType.UNRECOGNIZED)).equals((Object)messageType);
        if (bl) {
            String msg = new StringBuilder(25).append("received unknown message ").append(message).toString();
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
            throw new UnsupportedOperationException(msg);
        }
        if (((Object)((Object)MessageType.REGISTER_WORKER)).equals((Object)messageType)) {
            object = PbRegisterWorker.parseFrom(message.getPayload());
        } else if (((Object)((Object)MessageType.HEARTBEAT_FROM_WORKER)).equals((Object)messageType)) {
            PbHeartbeatFromWorker pbHeartbeatFromWorker = PbHeartbeatFromWorker.parseFrom(message.getPayload());
            HashMap<String, Long> estimatedAppDiskUsage = new HashMap<String, Long>();
            Map<UserIdentifier, ResourceConsumption> userResourceConsumption = PbSerDeUtils$.MODULE$.fromPbUserResourceConsumption(pbHeartbeatFromWorker.getUserResourceConsumptionMap());
            Buffer pbDisks = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbHeartbeatFromWorker.getDisksList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbDiskInfo -> PbSerDeUtils$.MODULE$.fromPbDiskInfo((PbDiskInfo)pbDiskInfo), Buffer$.MODULE$.canBuildFrom());
            if (!pbHeartbeatFromWorker.getEstimatedAppDiskUsageMap().isEmpty()) {
                estimatedAppDiskUsage.putAll(pbHeartbeatFromWorker.getEstimatedAppDiskUsageMap());
            }
            HashSet<String> activeShuffleKeys = new HashSet<String>();
            Object object2 = !pbHeartbeatFromWorker.getActiveShuffleKeysList().isEmpty() ? BoxesRunTime.boxToBoolean((boolean)activeShuffleKeys.addAll((Collection<String>)pbHeartbeatFromWorker.getActiveShuffleKeysList())) : BoxedUnit.UNIT;
            object = new ControlMessages.HeartbeatFromWorker(pbHeartbeatFromWorker.getHost(), pbHeartbeatFromWorker.getRpcPort(), pbHeartbeatFromWorker.getPushPort(), pbHeartbeatFromWorker.getFetchPort(), pbHeartbeatFromWorker.getReplicatePort(), (Seq<DiskInfo>)pbDisks, userResourceConsumption, activeShuffleKeys, estimatedAppDiskUsage, pbHeartbeatFromWorker.getRequestId());
        } else if (((Object)((Object)MessageType.HEARTBEAT_RESPONSE)).equals((Object)messageType)) {
            PbHeartbeatResponse pbHeartbeatResponse = PbHeartbeatResponse.parseFrom(message.getPayload());
            HashSet<String> expiredShuffleKeys = new HashSet<String>();
            Object object3 = pbHeartbeatResponse.getExpiredShuffleKeysCount() > 0 ? BoxesRunTime.boxToBoolean((boolean)expiredShuffleKeys.addAll((Collection<String>)pbHeartbeatResponse.getExpiredShuffleKeysList())) : BoxedUnit.UNIT;
            object = new ControlMessages.HeartbeatResponse(expiredShuffleKeys, pbHeartbeatResponse.getRegistered());
        } else if (((Object)((Object)MessageType.REGISTER_SHUFFLE)).equals((Object)messageType)) {
            object = PbRegisterShuffle.parseFrom(message.getPayload());
        } else if (((Object)((Object)MessageType.REGISTER_SHUFFLE_RESPONSE)).equals((Object)messageType)) {
            object = PbRegisterShuffleResponse.parseFrom(message.getPayload());
        } else if (((Object)((Object)MessageType.REQUEST_SLOTS)).equals((Object)messageType)) {
            PbRequestSlots pbRequestSlots = PbRequestSlots.parseFrom(message.getPayload());
            UserIdentifier userIdentifier = PbSerDeUtils$.MODULE$.fromPbUserIdentifier(pbRequestSlots.getUserIdentifier());
            object = new ControlMessages.RequestSlots(pbRequestSlots.getApplicationId(), pbRequestSlots.getShuffleId(), new ArrayList<Integer>(pbRequestSlots.getPartitionIdListList()), pbRequestSlots.getHostname(), pbRequestSlots.getShouldReplicate(), userIdentifier, pbRequestSlots.getRequestId());
        } else if (((Object)((Object)MessageType.RELEASE_SLOTS)).equals((Object)messageType)) {
            PbReleaseSlots pbReleaseSlots = PbReleaseSlots.parseFrom(message.getPayload());
            java.util.List slotsList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbReleaseSlots.getSlotsList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbSlot -> new HashMap<String, Integer>(pbSlot.getSlotMap()), Buffer$.MODULE$.canBuildFrom())).toList()).asJava();
            object = new ControlMessages.ReleaseSlots(pbReleaseSlots.getApplicationId(), pbReleaseSlots.getShuffleId(), new ArrayList<String>((Collection<String>)pbReleaseSlots.getWorkerIdsList()), new ArrayList<Map<String, Integer>>(slotsList), pbReleaseSlots.getRequestId());
        } else if (((Object)((Object)MessageType.RELEASE_SLOTS_RESPONSE)).equals((Object)messageType)) {
            PbReleaseSlotsResponse pbReleaseSlotsResponse = PbReleaseSlotsResponse.parseFrom(message.getPayload());
            object = new ControlMessages.ReleaseSlotsResponse(Utils$.MODULE$.toStatusCode(pbReleaseSlotsResponse.getStatus()));
        } else if (((Object)((Object)MessageType.REQUEST_SLOTS_RESPONSE)).equals((Object)messageType)) {
            PbRequestSlotsResponse pbRequestSlotsResponse = PbRequestSlotsResponse.parseFrom(message.getPayload());
            object = new ControlMessages.RequestSlotsResponse(Utils$.MODULE$.toStatusCode(pbRequestSlotsResponse.getStatus()), PbSerDeUtils$.MODULE$.fromPbWorkerResource(pbRequestSlotsResponse.getWorkerResourceMap()));
        } else if (((Object)((Object)MessageType.REVIVE)).equals((Object)messageType)) {
            object = PbRevive.parseFrom(message.getPayload());
        } else if (((Object)((Object)MessageType.CHANGE_LOCATION_RESPONSE)).equals((Object)messageType)) {
            object = PbChangeLocationResponse.parseFrom(message.getPayload());
        } else if (((Object)((Object)MessageType.MAPPER_END)).equals((Object)messageType)) {
            PbMapperEnd pbMapperEnd = PbMapperEnd.parseFrom(message.getPayload());
            object = new ControlMessages.MapperEnd(pbMapperEnd.getApplicationId(), pbMapperEnd.getShuffleId(), pbMapperEnd.getMapId(), pbMapperEnd.getAttemptId(), pbMapperEnd.getNumMappers());
        } else if (((Object)((Object)MessageType.MAPPER_END_RESPONSE)).equals((Object)messageType)) {
            PbMapperEndResponse pbMapperEndResponse = PbMapperEndResponse.parseFrom(message.getPayload());
            object = new ControlMessages.MapperEndResponse(Utils$.MODULE$.toStatusCode(pbMapperEndResponse.getStatus()));
        } else if (((Object)((Object)MessageType.GET_REDUCER_FILE_GROUP)).equals((Object)messageType)) {
            PbGetReducerFileGroup pbGetReducerFileGroup = PbGetReducerFileGroup.parseFrom(message.getPayload());
            object = new ControlMessages.GetReducerFileGroup(pbGetReducerFileGroup.getApplicationId(), pbGetReducerFileGroup.getShuffleId());
        } else if (((Object)((Object)MessageType.GET_REDUCER_FILE_GROUP_RESPONSE)).equals((Object)messageType)) {
            PbGetReducerFileGroupResponse pbGetReducerFileGroupResponse = PbGetReducerFileGroupResponse.parseFrom(message.getPayload());
            PartitionLocation[][] fileGroup = (PartitionLocation[][])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbGetReducerFileGroupResponse.getFileGroupList()).asScala()).map((Function1 & Serializable & scala.Serializable)fg -> (PartitionLocation[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fg.getLocationsList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbLoc -> PbSerDeUtils$.MODULE$.fromPbPartitionLocation((PbPartitionLocation)pbLoc), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(PartitionLocation.class)), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(PartitionLocation.class)));
            int[] attempts = (int[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbGetReducerFileGroupResponse.getAttemptsList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$3)), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
            object = new ControlMessages.GetReducerFileGroupResponse(Utils$.MODULE$.toStatusCode(pbGetReducerFileGroupResponse.getStatus()), fileGroup, attempts);
        } else if (((Object)((Object)MessageType.UNREGISTER_SHUFFLE)).equals((Object)messageType)) {
            object = PbUnregisterShuffle.parseFrom(message.getPayload());
        } else if (((Object)((Object)MessageType.UNREGISTER_SHUFFLE_RESPONSE)).equals((Object)messageType)) {
            object = PbUnregisterShuffleResponse.parseFrom(message.getPayload());
        } else if (((Object)((Object)MessageType.APPLICATION_LOST)).equals((Object)messageType)) {
            PbApplicationLost pbApplicationLost = PbApplicationLost.parseFrom(message.getPayload());
            object = new ControlMessages.ApplicationLost(pbApplicationLost.getAppId(), pbApplicationLost.getRequestId());
        } else if (((Object)((Object)MessageType.APPLICATION_LOST_RESPONSE)).equals((Object)messageType)) {
            PbApplicationLostResponse pbApplicationLostResponse = PbApplicationLostResponse.parseFrom(message.getPayload());
            object = new ControlMessages.ApplicationLostResponse(Utils$.MODULE$.toStatusCode(pbApplicationLostResponse.getStatus()));
        } else if (((Object)((Object)MessageType.HEARTBEAT_FROM_APPLICATION)).equals((Object)messageType)) {
            PbHeartbeatFromApplication pbHeartbeatFromApplication = PbHeartbeatFromApplication.parseFrom(message.getPayload());
            object = new ControlMessages.HeartbeatFromApplication(pbHeartbeatFromApplication.getAppId(), pbHeartbeatFromApplication.getTotalWritten(), pbHeartbeatFromApplication.getFileCount(), pbHeartbeatFromApplication.getRequestId());
        } else if (((Object)((Object)MessageType.GET_BLACKLIST)).equals((Object)messageType)) {
            PbGetBlacklist pbGetBlacklist = PbGetBlacklist.parseFrom(message.getPayload());
            object = new ControlMessages.GetBlacklist(new ArrayList<WorkerInfo>((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbGetBlacklist.getLocalBlackListList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbWorkerInfo -> PbSerDeUtils$.MODULE$.fromPbWorkerInfo((PbWorkerInfo)pbWorkerInfo), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()));
        } else if (((Object)((Object)MessageType.GET_BLACKLIST_RESPONSE)).equals((Object)messageType)) {
            PbGetBlacklistResponse pbGetBlacklistResponse = PbGetBlacklistResponse.parseFrom(message.getPayload());
            object = new ControlMessages.GetBlacklistResponse(Utils$.MODULE$.toStatusCode(pbGetBlacklistResponse.getStatus()), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbGetBlacklistResponse.getBlacklistList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbWorkerInfo -> PbSerDeUtils$.MODULE$.fromPbWorkerInfo((PbWorkerInfo)pbWorkerInfo), Buffer$.MODULE$.canBuildFrom())).toList()).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbGetBlacklistResponse.getUnknownWorkersList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbWorkerInfo -> PbSerDeUtils$.MODULE$.fromPbWorkerInfo((PbWorkerInfo)pbWorkerInfo), Buffer$.MODULE$.canBuildFrom())).toList()).asJava());
        } else if (((Object)((Object)MessageType.CHECK_QUOTA)).equals((Object)messageType)) {
            PbCheckQuota pbCheckAvailable = PbCheckQuota.parseFrom(message.getPayload());
            object = new ControlMessages.CheckQuota(PbSerDeUtils$.MODULE$.fromPbUserIdentifier(pbCheckAvailable.getUserIdentifier()));
        } else if (((Object)((Object)MessageType.CHECK_QUOTA_RESPONSE)).equals((Object)messageType)) {
            PbCheckQuotaResponse pbCheckAvailableResponse = PbCheckQuotaResponse.parseFrom(message.getPayload());
            object = new ControlMessages.CheckQuotaResponse(pbCheckAvailableResponse.getAvailable());
        } else if (((Object)((Object)MessageType.REPORT_WORKER_FAILURE)).equals((Object)messageType)) {
            PbReportWorkerUnavailable pbReportWorkerUnavailable = PbReportWorkerUnavailable.parseFrom(message.getPayload());
            object = new ControlMessages.ReportWorkerUnavailable(new ArrayList<WorkerInfo>((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbReportWorkerUnavailable.getUnavailableList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbWorkerInfo -> PbSerDeUtils$.MODULE$.fromPbWorkerInfo((PbWorkerInfo)pbWorkerInfo), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()), pbReportWorkerUnavailable.getRequestId());
        } else if (((Object)((Object)MessageType.REGISTER_WORKER_RESPONSE)).equals((Object)messageType)) {
            object = PbRegisterWorkerResponse.parseFrom(message.getPayload());
        } else if (((Object)((Object)MessageType.REREGISTER_WORKER_RESPONSE)).equals((Object)messageType)) {
            PbReregisterWorkerResponse pbReregisterWorkerResponse = PbReregisterWorkerResponse.parseFrom(message.getPayload());
            object = new ControlMessages.ReregisterWorkerResponse(pbReregisterWorkerResponse.getSuccess());
        } else if (((Object)((Object)MessageType.RESERVE_SLOTS)).equals((Object)messageType)) {
            PbReserveSlots pbReserveSlots = PbReserveSlots.parseFrom(message.getPayload());
            UserIdentifier userIdentifier = PbSerDeUtils$.MODULE$.fromPbUserIdentifier(pbReserveSlots.getUserIdentifier());
            object = new ControlMessages.ReserveSlots(pbReserveSlots.getApplicationId(), pbReserveSlots.getShuffleId(), new ArrayList<PartitionLocation>((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbReserveSlots.getMasterLocationsList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbLoc -> PbSerDeUtils$.MODULE$.fromPbPartitionLocation((PbPartitionLocation)pbLoc), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()), new ArrayList<PartitionLocation>((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbReserveSlots.getSlaveLocationsList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbLoc -> PbSerDeUtils$.MODULE$.fromPbPartitionLocation((PbPartitionLocation)pbLoc), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()), pbReserveSlots.getSplitThreshold(), Utils$.MODULE$.toShuffleSplitMode(pbReserveSlots.getSplitMode()), Utils$.MODULE$.toPartitionType(pbReserveSlots.getPartitionType()), pbReserveSlots.getRangeReadFilter(), userIdentifier);
        } else if (((Object)((Object)MessageType.RESERVE_SLOTS_RESPONSE)).equals((Object)messageType)) {
            PbReserveSlotsResponse pbReserveSlotsResponse = PbReserveSlotsResponse.parseFrom(message.getPayload());
            object = new ControlMessages.ReserveSlotsResponse(Utils$.MODULE$.toStatusCode(pbReserveSlotsResponse.getStatus()), pbReserveSlotsResponse.getReason());
        } else if (((Object)((Object)MessageType.COMMIT_FILES)).equals((Object)messageType)) {
            PbCommitFiles pbCommitFiles = PbCommitFiles.parseFrom(message.getPayload());
            object = new ControlMessages.CommitFiles(pbCommitFiles.getApplicationId(), pbCommitFiles.getShuffleId(), (java.util.List<String>)pbCommitFiles.getMasterIdsList(), (java.util.List<String>)pbCommitFiles.getSlaveIdsList(), (int[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbCommitFiles.getMapAttemptsList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$4)), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int()), pbCommitFiles.getEpoch());
        } else if (((Object)((Object)MessageType.COMMIT_FILES_RESPONSE)).equals((Object)messageType)) {
            PbCommitFilesResponse pbCommitFilesResponse = PbCommitFilesResponse.parseFrom(message.getPayload());
            HashMap<String, StorageInfo> committedMasterStorageInfos = new HashMap<String, StorageInfo>();
            HashMap<String, StorageInfo> committedSlaveStorageInfos = new HashMap<String, StorageInfo>();
            HashMap<String, RoaringBitmap> committedBitMap = new HashMap<String, RoaringBitmap>();
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pbCommitFilesResponse.getCommittedMasterStorageInfosMap()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> committedMasterStorageInfos.put((String)entry._1(), StorageInfo.fromPb((PbStorageInfo)entry._2())));
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pbCommitFilesResponse.getCommittedSlaveStorageInfosMap()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> committedSlaveStorageInfos.put((String)entry._1(), StorageInfo.fromPb((PbStorageInfo)entry._2())));
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pbCommitFilesResponse.getMapIdBitmapMap()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> committedBitMap.put((String)entry._1(), Utils$.MODULE$.byteStringToRoaringBitmap((ByteString)entry._2())));
            object = new ControlMessages.CommitFilesResponse(Utils$.MODULE$.toStatusCode(pbCommitFilesResponse.getStatus()), (java.util.List<String>)pbCommitFilesResponse.getCommittedMasterIdsList(), (java.util.List<String>)pbCommitFilesResponse.getCommittedSlaveIdsList(), (java.util.List<String>)pbCommitFilesResponse.getFailedMasterIdsList(), (java.util.List<String>)pbCommitFilesResponse.getFailedSlaveIdsList(), committedMasterStorageInfos, committedSlaveStorageInfos, committedBitMap, pbCommitFilesResponse.getTotalWritten(), pbCommitFilesResponse.getFileCount());
        } else if (((Object)((Object)MessageType.DESTROY)).equals((Object)messageType)) {
            PbDestroy pbDestroy = PbDestroy.parseFrom(message.getPayload());
            object = new ControlMessages.Destroy(pbDestroy.getShuffleKey(), (java.util.List<String>)pbDestroy.getMasterLocationsList(), (java.util.List<String>)pbDestroy.getSlaveLocationList());
        } else if (((Object)((Object)MessageType.DESTROY_RESPONSE)).equals((Object)messageType)) {
            PbDestroyResponse pbDestroyResponse = PbDestroyResponse.parseFrom(message.getPayload());
            object = new ControlMessages.DestroyResponse(Utils$.MODULE$.toStatusCode(pbDestroyResponse.getStatus()), (java.util.List<String>)pbDestroyResponse.getFailedMastersList(), (java.util.List<String>)pbDestroyResponse.getFailedSlavesList());
        } else if (((Object)((Object)MessageType.SLAVE_LOST_RESPONSE)).equals((Object)messageType)) {
            PbSlaveLostResponse pbSlaveLostResponse = PbSlaveLostResponse.parseFrom(message.getPayload());
            object = new ControlMessages.SlaveLostResponse(Utils$.MODULE$.toStatusCode(pbSlaveLostResponse.getStatus()), PbSerDeUtils$.MODULE$.fromPbPartitionLocation(pbSlaveLostResponse.getSlaveLocation()));
        } else if (((Object)((Object)MessageType.GET_WORKER_INFO)).equals((Object)messageType)) {
            object = ControlMessages$GetWorkerInfos$.MODULE$;
        } else if (((Object)((Object)MessageType.GET_WORKER_INFO_RESPONSE)).equals((Object)messageType)) {
            PbGetWorkerInfosResponse pbGetWorkerInfoResponse = PbGetWorkerInfosResponse.parseFrom(message.getPayload());
            object = new ControlMessages.GetWorkerInfosResponse(Utils$.MODULE$.toStatusCode(pbGetWorkerInfoResponse.getStatus()), (Seq<WorkerInfo>)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbGetWorkerInfoResponse.getWorkerInfosList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbWorkerInfo -> PbSerDeUtils$.MODULE$.fromPbWorkerInfo((PbWorkerInfo)pbWorkerInfo), Buffer$.MODULE$.canBuildFrom())).toList());
        } else if (((Object)((Object)MessageType.THREAD_DUMP)).equals((Object)messageType)) {
            object = ControlMessages$ThreadDump$.MODULE$;
        } else if (((Object)((Object)MessageType.THREAD_DUMP_RESPONSE)).equals((Object)messageType)) {
            PbThreadDumpResponse pbThreadDumpResponse = PbThreadDumpResponse.parseFrom(message.getPayload());
            object = new ControlMessages.ThreadDumpResponse(pbThreadDumpResponse.getThreadDump());
        } else if (((Object)((Object)MessageType.REMOVE_EXPIRED_SHUFFLE)).equals((Object)messageType)) {
            object = ControlMessages$RemoveExpiredShuffle$.MODULE$;
        } else if (((Object)((Object)MessageType.ONE_WAY_MESSAGE_RESPONSE)).equals((Object)messageType)) {
            object = ControlMessages$OneWayMessageResponse$.MODULE$;
        } else if (((Object)((Object)MessageType.CHECK_FOR_WORKER_TIMEOUT)).equals((Object)messageType)) {
            object = this.pbCheckForWorkerTimeout();
        } else if (((Object)((Object)MessageType.CHECK_FOR_APPLICATION_TIMEOUT)).equals((Object)messageType)) {
            object = ControlMessages$CheckForApplicationTimeOut$.MODULE$;
        } else if (((Object)((Object)MessageType.WORKER_LOST)).equals((Object)messageType)) {
            object = PbWorkerLost.parseFrom(message.getPayload());
        } else if (((Object)((Object)MessageType.WORKER_LOST_RESPONSE)).equals((Object)messageType)) {
            object = PbWorkerLostResponse.parseFrom(message.getPayload());
        } else if (((Object)((Object)MessageType.STAGE_END)).equals((Object)messageType)) {
            PbStageEnd pbStageEnd = PbStageEnd.parseFrom(message.getPayload());
            object = new ControlMessages.StageEnd(pbStageEnd.getApplicationId(), pbStageEnd.getShuffleId());
        } else if (((Object)((Object)MessageType.PARTITION_SPLIT)).equals((Object)messageType)) {
            object = PbPartitionSplit.parseFrom(message.getPayload());
        } else if (((Object)((Object)MessageType.STAGE_END_RESPONSE)).equals((Object)messageType)) {
            PbStageEndResponse pbStageEndResponse = PbStageEndResponse.parseFrom(message.getPayload());
            object = new ControlMessages.StageEndResponse(Utils$.MODULE$.toStatusCode(pbStageEndResponse.getStatus()));
        } else {
            throw new MatchError((Object)messageType);
        }
        return object;
    }

    public static final /* synthetic */ Integer $anonfun$toTransportMessage$5(int x$1) {
        return new Integer(x$1);
    }

    public static final /* synthetic */ Integer $anonfun$toTransportMessage$12(int x$2) {
        return new Integer(x$2);
    }

    private ControlMessages$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.ZERO_UUID = new UUID(0L, 0L).toString();
        this.pbCheckForWorkerTimeout = PbCheckForWorkerTimeout.newBuilder().build();
    }
}

