/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.server.memory;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.celeborn.common.network.server.memory.ReadBufferDispatcher;
import org.apache.celeborn.common.network.server.memory.ReadBufferListener;
import org.apache.celeborn.common.network.server.memory.ReadBufferRequest;
import org.apache.celeborn.common.util.ThreadUtils;
import org.apache.celeborn.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryManager {
    private static final Logger logger = LoggerFactory.getLogger(MemoryManager.class);
    private static volatile MemoryManager _INSTANCE = null;
    private long maxDirectorMemory = 0L;
    private final long pausePushDataThreshold;
    private final long pauseReplicateThreshold;
    private final long resumeThreshold;
    private final long maxSortMemory;
    private final List<MemoryPressureListener> memoryPressureListeners = new ArrayList<MemoryPressureListener>();
    private final ScheduledExecutorService checkService = ThreadUtils.newDaemonSingleThreadScheduledExecutor("memory-manager-checker");
    private final ScheduledExecutorService reportService = ThreadUtils.newDaemonSingleThreadScheduledExecutor("memory-manager-reporter");
    private final ExecutorService actionService = ThreadUtils.newDaemonSingleThreadExecutor("memory-manager-actor");
    private AtomicLong nettyMemoryCounter = null;
    private final AtomicLong sortMemoryCounter = new AtomicLong(0L);
    private final AtomicLong diskBufferCounter = new AtomicLong(0L);
    private final LongAdder pausePushDataCounter = new LongAdder();
    private final LongAdder pausePushDataAndReplicateCounter = new LongAdder();
    private MemoryManagerStat memoryManagerStat = MemoryManagerStat.resumeAll;
    private boolean underPressure;
    private final AtomicBoolean trimInProcess = new AtomicBoolean(false);
    private final AtomicLong readBufferCounter = new AtomicLong(0L);
    private long readBufferThreshold = 0L;
    private final ReadBufferDispatcher readBufferDispatcher;
    private final AtomicLong memoryShuffleStorageCounter = new AtomicLong(0L);
    private long memoryShuffleStorageThreshold = 0L;

    public static MemoryManager initialize(double pausePushDataRatio, double pauseReplicateRatio, double resumeRatio, double maxSortRatio, double readBufferRatio, double shuffleStorageRatio, long checkInterval, long reportInterval) {
        if (_INSTANCE == null) {
            _INSTANCE = new MemoryManager(pausePushDataRatio, pauseReplicateRatio, resumeRatio, maxSortRatio, readBufferRatio, shuffleStorageRatio, checkInterval, reportInterval);
        }
        return _INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMemoryListener(MemoryPressureListener listener) {
        List<MemoryPressureListener> list = this.memoryPressureListeners;
        synchronized (list) {
            this.memoryPressureListeners.add(listener);
        }
    }

    public static MemoryManager instance() {
        return _INSTANCE;
    }

    private MemoryManager(double pausePushDataRatio, double pauseReplicateRatio, double resumeRatio, double maxSortMemRatio, double readBufferRatio, double shuffleStorageRatio, long checkInterval, long reportInterval) {
        String[][] providers = new String[][]{{"sun.misc.VM", "maxDirectMemory"}, {"jdk.internal.misc.VM", "maxDirectMemory"}};
        Method maxMemMethod = null;
        for (String[] provider : providers) {
            String clazz = provider[0];
            String method = provider[1];
            try {
                Class<?> vmClass = Class.forName(clazz);
                maxMemMethod = vmClass.getDeclaredMethod(method, new Class[0]);
                maxMemMethod.setAccessible(true);
                this.maxDirectorMemory = (Long)maxMemMethod.invoke(null, new Object[0]);
                break;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            }
        }
        Preconditions.checkArgument((this.maxDirectorMemory > 0L ? 1 : 0) != 0);
        this.maxSortMemory = (long)((double)this.maxDirectorMemory * maxSortMemRatio);
        this.pausePushDataThreshold = (long)((double)this.maxDirectorMemory * pausePushDataRatio);
        this.pauseReplicateThreshold = (long)((double)this.maxDirectorMemory * pauseReplicateRatio);
        this.resumeThreshold = (long)((double)this.maxDirectorMemory * resumeRatio);
        this.readBufferThreshold = (long)((double)this.maxDirectorMemory * readBufferRatio);
        this.memoryShuffleStorageThreshold = (long)((double)this.maxDirectorMemory * shuffleStorageRatio);
        this.initDirectMemoryIndicator();
        this.checkService.scheduleWithFixedDelay(() -> {
            try {
                MemoryManagerStat lastAction = this.memoryManagerStat;
                this.memoryManagerStat = this.currentMemoryAction();
                if (lastAction != this.memoryManagerStat) {
                    if (this.memoryManagerStat == MemoryManagerStat.pausePushDataAndResumeReplicate) {
                        this.pausePushDataCounter.increment();
                        this.actionService.submit(() -> {
                            logger.info("Trigger pausePushDataAndResumeReplicate action");
                            this.memoryPressureListeners.forEach(memoryPressureListener -> memoryPressureListener.onPause("push"));
                            this.memoryPressureListeners.forEach(MemoryPressureListener::onTrim);
                            this.memoryPressureListeners.forEach(memoryPressureListener -> memoryPressureListener.onResume("replicate"));
                        });
                    } else if (this.memoryManagerStat == MemoryManagerStat.pausePushDataAndReplicate) {
                        this.pausePushDataAndReplicateCounter.increment();
                        this.actionService.submit(() -> {
                            logger.info("Trigger pausePushDataAndReplicate action");
                            this.memoryPressureListeners.forEach(memoryPressureListener -> memoryPressureListener.onPause("push"));
                            this.memoryPressureListeners.forEach(memoryPressureListener -> memoryPressureListener.onPause("replicate"));
                            this.memoryPressureListeners.forEach(MemoryPressureListener::onTrim);
                        });
                    } else {
                        this.actionService.submit(() -> {
                            logger.info("Trigger resume action");
                            this.memoryPressureListeners.forEach(memoryPressureListener -> memoryPressureListener.onResume("all"));
                        });
                    }
                } else if (this.memoryManagerStat != MemoryManagerStat.resumeAll && !this.trimInProcess.get()) {
                    this.trimInProcess.set(true);
                    this.actionService.submit(() -> {
                        try {
                            logger.info("Trigger trim action");
                            this.memoryPressureListeners.forEach(MemoryPressureListener::onTrim);
                        }
                        finally {
                            this.trimInProcess.set(false);
                        }
                    });
                }
            }
            catch (Exception e) {
                logger.error("Memory tracker check error", (Throwable)e);
            }
        }, checkInterval, checkInterval, TimeUnit.MILLISECONDS);
        this.reportService.scheduleWithFixedDelay(() -> logger.info("Direct memory usage: {}/{}, disk buffer size: {}, sort memory size: {}", new Object[]{Utils.bytesToString(this.nettyMemoryCounter.get()), Utils.bytesToString(this.maxDirectorMemory), Utils.bytesToString(this.diskBufferCounter.get()), Utils.bytesToString(this.sortMemoryCounter.get())}), reportInterval, reportInterval, TimeUnit.SECONDS);
        this.readBufferDispatcher = new ReadBufferDispatcher(this);
        logger.info("Memory tracker initialized with: max direct memory: {}, pause pushdata memory: {}, pause replication memory: {}, resume memory: {}", new Object[]{Utils.bytesToString(this.maxDirectorMemory), Utils.bytesToString(this.pausePushDataThreshold), Utils.bytesToString(this.pauseReplicateThreshold), Utils.bytesToString(this.resumeThreshold)});
    }

    private void initDirectMemoryIndicator() {
        try {
            Field[] result;
            Field field = null;
            for (Field tf : result = PlatformDependent.class.getDeclaredFields()) {
                if (!"DIRECT_MEMORY_COUNTER".equals(tf.getName())) continue;
                field = tf;
            }
            field.setAccessible(true);
            this.nettyMemoryCounter = (AtomicLong)field.get(PlatformDependent.class);
        }
        catch (Exception e) {
            logger.error("Fatal error, get netty_direct_memory failed, worker should stop", (Throwable)e);
            System.exit(-1);
        }
    }

    public MemoryManagerStat currentMemoryAction() {
        boolean resume;
        boolean pauseReplication;
        long memoryUsage = this.nettyMemoryCounter.get() + this.sortMemoryCounter.get();
        boolean pausePushData = memoryUsage > this.pausePushDataThreshold;
        boolean bl = pauseReplication = memoryUsage > this.pauseReplicateThreshold;
        if (pausePushData) {
            this.underPressure = true;
            if (pauseReplication) {
                return MemoryManagerStat.pausePushDataAndReplicate;
            }
            return MemoryManagerStat.pausePushDataAndResumeReplicate;
        }
        boolean bl2 = resume = memoryUsage < this.resumeThreshold;
        if (resume) {
            this.underPressure = false;
            return MemoryManagerStat.resumeAll;
        }
        if (this.underPressure) {
            return MemoryManagerStat.pausePushDataAndResumeReplicate;
        }
        return MemoryManagerStat.resumeAll;
    }

    public void reserveSortMemory(long fileLen) {
        this.sortMemoryCounter.addAndGet(fileLen);
    }

    public boolean sortMemoryReady() {
        return this.currentMemoryAction().equals((Object)MemoryManagerStat.resumeAll) && this.sortMemoryCounter.get() < this.maxSortMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSortMemory(long size) {
        MemoryManager memoryManager = this;
        synchronized (memoryManager) {
            if (this.sortMemoryCounter.get() - size < 0L) {
                this.sortMemoryCounter.set(0L);
            } else {
                this.sortMemoryCounter.addAndGet(-1L * size);
            }
        }
    }

    public void incrementDiskBuffer(int size) {
        this.diskBufferCounter.addAndGet(size);
    }

    public void releaseDiskBuffer(int size) {
        this.diskBufferCounter.addAndGet(size * -1);
    }

    public AtomicLong getNettyMemoryCounter() {
        return this.nettyMemoryCounter;
    }

    public AtomicLong getSortMemoryCounter() {
        return this.sortMemoryCounter;
    }

    public AtomicLong getDiskBufferCounter() {
        return this.diskBufferCounter;
    }

    public long getPausePushDataCounter() {
        return this.pausePushDataCounter.sum();
    }

    public void requestReadBuffers(int min, int max, int bufferSize, ReadBufferListener listener) {
        this.readBufferDispatcher.addBufferRequest(new ReadBufferRequest(min, max, bufferSize, listener));
    }

    public void recycleReadBuffer(ByteBuf readBuf) {
        this.readBufferDispatcher.recycle(readBuf);
    }

    protected void changeReadBufferCounter(int delta) {
        this.readBufferCounter.addAndGet(delta);
    }

    protected boolean readBufferAvailable(int requiredBytes) {
        return this.readBufferCounter.get() + (long)requiredBytes < this.readBufferThreshold;
    }

    public long getPausePushDataAndReplicateCounter() {
        return this.pausePushDataAndReplicateCounter.sum();
    }

    static enum MemoryManagerStat {
        resumeAll,
        pausePushDataAndReplicate,
        pausePushDataAndResumeReplicate;

    }

    public static interface MemoryPressureListener {
        public void onPause(String var1);

        public void onResume(String var1);

        public void onTrim();
    }
}

