/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.meta;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.meta.WorkerInfo$;
import org.apache.celeborn.common.quota.ResourceConsumption;
import org.apache.celeborn.common.rpc.RpcEndpointRef;
import org.apache.celeborn.common.rpc.netty.NettyRpcEndpointRef;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t5d\u0001B A\u0001-C\u0001b\u0017\u0001\u0003\u0006\u0004%\t\u0001\u0018\u0005\tQ\u0002\u0011\t\u0011)A\u0005;\"A\u0011\u000e\u0001BC\u0002\u0013\u0005!\u000e\u0003\u0005o\u0001\t\u0005\t\u0015!\u0003l\u0011!y\u0007A!b\u0001\n\u0003Q\u0007\u0002\u00039\u0001\u0005\u0003\u0005\u000b\u0011B6\t\u0011E\u0004!Q1A\u0005\u0002)D\u0001B\u001d\u0001\u0003\u0002\u0003\u0006Ia\u001b\u0005\tg\u0002\u0011)\u0019!C\u0001U\"AA\u000f\u0001B\u0001B\u0003%1\u000e\u0003\u0005v\u0001\t\u0015\r\u0011\"\u0001w\u0011%\t9\u0001\u0001B\u0001B\u0003%q\u000f\u0003\u0006\u0002\n\u0001\u0011)\u0019!C\u0001\u0003\u0017A!\"a\n\u0001\u0005\u0003\u0005\u000b\u0011BA\u0007\u0011)\tI\u0003\u0001BA\u0002\u0013\u0005\u00111\u0006\u0005\u000b\u0003s\u0001!\u00111A\u0005\u0002\u0005m\u0002BCA$\u0001\t\u0005\t\u0015)\u0003\u0002.!9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0003\"CA0\u0001\u0001\u0007I\u0011AA1\u0011%\t)\b\u0001a\u0001\n\u0003\t9\b\u0003\u0005\u0002|\u0001\u0001\u000b\u0015BA2\u0011%\ti\b\u0001a\u0001\n\u0003\ty\bC\u0005\u0002\b\u0002\u0001\r\u0011\"\u0001\u0002\n\"A\u0011Q\u0012\u0001!B\u0013\t\t\tC\u0004\u0002J\u0001!\t!a$\t\u000f\u0005%\u0003\u0001\"\u0001\u0002\u001c\"I\u0011\u0011\u0016\u0001C\u0002\u0013\u0005\u00111\u0016\u0005\t\u0003g\u0003\u0001\u0015!\u0003\u0002.\"A\u0011Q\u0017\u0001A\u0002\u0013\u0005!\u000eC\u0005\u00028\u0002\u0001\r\u0011\"\u0001\u0002:\"9\u0011Q\u0018\u0001!B\u0013Y\u0007\"CA`\u0001\u0001\u0007I\u0011AA@\u0011%\t\t\r\u0001a\u0001\n\u0003\t\u0019\r\u0003\u0005\u0002H\u0002\u0001\u000b\u0015BAA\u0011!\tI\r\u0001a\u0001\n\u0003Q\u0007\"CAf\u0001\u0001\u0007I\u0011AAg\u0011\u001d\t\t\u000e\u0001Q!\n-Dq!a5\u0001\t\u0003\t)\u000eC\u0004\u0002^\u0002!\t!a8\t\u000f\u0005\u0005\b\u0001\"\u0001\u0002d\"9\u0011q\u001e\u0001\u0005\u0002\u0005E\bbBAx\u0001\u0011\u0005\u0011\u0011 \u0005\b\u0003{\u0004A\u0011AA\u0000\u0011\u001d\u00119\u0001\u0001C\u0001\u0005\u0013AqAa\u0003\u0001\t\u0003\u0011i\u0001C\u0004\u0003\u0014\u0001!\tA!\u0006\t\u000f\tm\u0001\u0001\"\u0001\u0003\u001e!9!q\u0004\u0001\u0005\u0002\tu\u0001b\u0002B\u0011\u0001\u0011\u0005!1\u0005\u0005\b\u0005K\u0001A\u0011AAp\u0011\u001d\u00119\u0003\u0001C\u0001\u0005SAqAa\f\u0001\t\u0003\ty\u000eC\u0004\u00032\u0001!\tAa\r\t\u000f\tm\u0002\u0001\"\u0001\u0003>!9!1\t\u0001\u0005B\tu\u0001b\u0002B#\u0001\u0011\u0005#q\t\u0005\b\u0005#\u0002A\u0011\tB\u0005\u000f\u001d\u0011\u0019\u0006\u0011E\u0001\u0005+2aa\u0010!\t\u0002\t]\u0003bBA%w\u0011\u0005!\u0011\f\u0005\b\u00057ZD\u0011\u0001B/\u0011%\u0011\u0019gOA\u0001\n\u0013\u0011)G\u0001\u0006X_J\\WM]%oM>T!!\u0011\"\u0002\t5,G/\u0019\u0006\u0003\u0007\u0012\u000baaY8n[>t'BA#G\u0003!\u0019W\r\\3c_Jt'BA$I\u0003\u0019\t\u0007/Y2iK*\t\u0011*A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u0019J+\u0006CA'Q\u001b\u0005q%\"A(\u0002\u000bM\u001c\u0017\r\\1\n\u0005Es%AB!osJ+g\r\u0005\u0002N'&\u0011AK\u0014\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u0003-fk\u0011a\u0016\u0006\u00031\n\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u00035^\u0013q\u0001T8hO&tw-\u0001\u0003i_N$X#A/\u0011\u0005y+gBA0d!\t\u0001g*D\u0001b\u0015\t\u0011'*\u0001\u0004=e>|GOP\u0005\u0003I:\u000ba\u0001\u0015:fI\u00164\u0017B\u00014h\u0005\u0019\u0019FO]5oO*\u0011AMT\u0001\u0006Q>\u001cH\u000fI\u0001\beB\u001c\u0007k\u001c:u+\u0005Y\u0007CA'm\u0013\tigJA\u0002J]R\f\u0001B\u001d9d!>\u0014H\u000fI\u0001\taV\u001c\b\u000eU8si\u0006I\u0001/^:i!>\u0014H\u000fI\u0001\nM\u0016$8\r\u001b)peR\f!BZ3uG\"\u0004vN\u001d;!\u00035\u0011X\r\u001d7jG\u0006$X\rU8si\u0006q!/\u001a9mS\u000e\fG/\u001a)peR\u0004\u0013!\u00033jg.LeNZ8t+\u00059\b\u0003\u0002=~;~l\u0011!\u001f\u0006\u0003un\fA!\u001e;jY*\tA0\u0001\u0003kCZ\f\u0017B\u0001@z\u0005\ri\u0015\r\u001d\t\u0005\u0003\u0003\t\u0019!D\u0001A\u0013\r\t)\u0001\u0011\u0002\t\t&\u001c8.\u00138g_\u0006QA-[:l\u0013:4wn\u001d\u0011\u0002/U\u001cXM\u001d*fg>,(oY3D_:\u001cX/\u001c9uS>tWCAA\u0007!\u0019AX0a\u0004\u0002\u001cA!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016\t\u000b\u0001\"\u001b3f]RLG/_\u0005\u0005\u00033\t\u0019B\u0001\bVg\u0016\u0014\u0018\nZ3oi&4\u0017.\u001a:\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\tC\u0003\u0015\tXo\u001c;b\u0013\u0011\t)#a\b\u0003'I+7o\\;sG\u0016\u001cuN\\:v[B$\u0018n\u001c8\u00021U\u001cXM\u001d*fg>,(oY3D_:\u001cX/\u001c9uS>t\u0007%\u0001\u0005f]\u0012\u0004x.\u001b8u+\t\ti\u0003\u0005\u0003\u00020\u0005URBAA\u0019\u0015\r\t\u0019DQ\u0001\u0004eB\u001c\u0017\u0002BA\u001c\u0003c\u0011aB\u00159d\u000b:$\u0007o\\5oiJ+g-\u0001\u0007f]\u0012\u0004x.\u001b8u?\u0012*\u0017\u000f\u0006\u0003\u0002>\u0005\r\u0003cA'\u0002@%\u0019\u0011\u0011\t(\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u000b\u0002\u0012\u0011!a\u0001\u0003[\t1\u0001\u001f\u00132\u0003%)g\u000e\u001a9pS:$\b%\u0001\u0004=S:LGO\u0010\u000b\u0013\u0003\u001b\ny%!\u0015\u0002T\u0005U\u0013qKA-\u00037\ni\u0006E\u0002\u0002\u0002\u0001AQa\u0017\nA\u0002uCQ!\u001b\nA\u0002-DQa\u001c\nA\u0002-DQ!\u001d\nA\u0002-DQa\u001d\nA\u0002-DQ!\u001e\nA\u0002]Dq!!\u0003\u0013\u0001\u0004\ti\u0001C\u0004\u0002*I\u0001\r!!\f\u0002!Ut7N\\8x]\u0012K7o[*m_R\u001cXCAA2!\u0019A\u0018QM/\u0002j%\u0019\u0011qM=\u0003\u000f!\u000b7\u000f['baB!\u00111NA9\u001b\t\tiGC\u0002\u0002pm\fA\u0001\\1oO&!\u00111OA7\u0005\u001dIe\u000e^3hKJ\fA#\u001e8l]><h\u000eR5tWNcw\u000e^:`I\u0015\fH\u0003BA\u001f\u0003sB\u0011\"!\u0012\u0015\u0003\u0003\u0005\r!a\u0019\u0002#Ut7N\\8x]\u0012K7o[*m_R\u001c\b%A\u0007mCN$\b*Z1si\n,\u0017\r^\u000b\u0003\u0003\u0003\u00032!TAB\u0013\r\t)I\u0014\u0002\u0005\u0019>tw-A\tmCN$\b*Z1si\n,\u0017\r^0%KF$B!!\u0010\u0002\f\"I\u0011QI\f\u0002\u0002\u0003\u0007\u0011\u0011Q\u0001\u000fY\u0006\u001cH\u000fS3beR\u0014W-\u0019;!)1\ti%!%\u0002\u0014\u0006U\u0015qSAM\u0011\u0015Y\u0016\u00041\u0001^\u0011\u0015I\u0017\u00041\u0001l\u0011\u0015y\u0017\u00041\u0001l\u0011\u0015\t\u0018\u00041\u0001l\u0011\u0015\u0019\u0018\u00041\u0001l)9\ti%!(\u0002 \u0006\u0005\u00161UAS\u0003OCQa\u0017\u000eA\u0002uCQ!\u001b\u000eA\u0002-DQa\u001c\u000eA\u0002-DQ!\u001d\u000eA\u0002-DQa\u001d\u000eA\u0002-Dq!!\u000b\u001b\u0001\u0004\ti#A\tbY2|7-\u0019;j_:\u0014UoY6fiN,\"!!,\u0011\t5\u000byk[\u0005\u0004\u0003cs%!B!se\u0006L\u0018AE1mY>\u001c\u0017\r^5p]\n+8m[3ug\u0002\n1BY;dW\u0016$\u0018J\u001c3fq\u0006y!-^2lKRLe\u000eZ3y?\u0012*\u0017\u000f\u0006\u0003\u0002>\u0005m\u0006\u0002CA#=\u0005\u0005\t\u0019A6\u0002\u0019\t,8m[3u\u0013:$W\r\u001f\u0011\u0002\u0015\t,8m[3u)&lW-\u0001\bck\u000e\\W\r\u001e+j[\u0016|F%Z9\u0015\t\u0005u\u0012Q\u0019\u0005\n\u0003\u000b\n\u0013\u0011!a\u0001\u0003\u0003\u000b1BY;dW\u0016$H+[7fA\u0005\t\"-^2lKR\fE\u000e\\8dCRLwN\\:\u0002+\t,8m[3u\u00032dwnY1uS>t7o\u0018\u0013fcR!\u0011QHAh\u0011!\t)\u0005JA\u0001\u0002\u0004Y\u0017A\u00052vG.,G/\u00117m_\u000e\fG/[8og\u0002\n\u0001\"[:BGRLg/Z\u000b\u0003\u0003/\u00042!TAm\u0013\r\tYN\u0014\u0002\b\u0005>|G.Z1o\u0003%)8/\u001a3TY>$8\u000f\u0006\u0002\u0002\u0002\u0006i\u0011\r\u001c7pG\u0006$Xm\u00157piN$b!!\u0010\u0002f\u0006%\bBBAtQ\u0001\u0007Q,\u0001\u0006tQV4g\r\\3LKfDq!a;)\u0001\u0004\ti/\u0001\u0007tY>$8\u000fU3s\t&\u001c8\u000eE\u0003y{v\u000bI'\u0001\u0007sK2,\u0017m]3TY>$8\u000f\u0006\u0004\u0002>\u0005M\u0018Q\u001f\u0005\u0007\u0003OL\u0003\u0019A/\t\u000f\u0005]\u0018\u00061\u0001\u0002n\u0006)1\u000f\\8ugR!\u0011QHA~\u0011\u0019\t9O\u000ba\u0001;\u0006\u0001r-\u001a;TQV4g\r\\3LKf\u001cV\r\u001e\u000b\u0003\u0005\u0003\u0001B\u0001\u001fB\u0002;&\u0019!QA=\u0003\u000f!\u000b7\u000f[*fi\u0006)\u0012\r\u001c7pG\u0006$\u0018n\u001c8t\u0013:d\u0015m\u001d;I_V\u0014H#A6\u0002\u001f!\f7oU1nK&sgm\\,ji\"$B!a6\u0003\u0010!9!\u0011C\u0017A\u0002\u00055\u0013!B8uQ\u0016\u0014\u0018!D:fiV\u0004XI\u001c3q_&tG\u000f\u0006\u0003\u0002>\t]\u0001b\u0002B\r]\u0001\u0007\u0011QF\u0001\fK:$\u0007o\\5oiJ+g-A\bsK\u0006$\u0017M\u00197f\u0003\u0012$'/Z:t)\u0005i\u0016A\u0003;p+:L\u0017/^3JI\u0006i1\u000f\\8u\u0003Z\f\u0017\u000e\\1cY\u0016$\"!a6\u0002\u001b\u001d,G\u000fV8uC2\u001cFn\u001c;t\u0003I)\b\u000fZ1uK\u0012K7o['bqNcw\u000e^:\u0015\t\u0005u\"1\u0006\u0005\b\u0005[\u0019\u0004\u0019AAA\u0003Y)7\u000f^5nCR,G\rU1si&$\u0018n\u001c8TSj,\u0017a\u0005;pi\u0006d\u0017I^1jY\u0006\u0014G.Z*m_R\u001c\u0018AF;qI\u0006$X\r\u00165f]\u001e+G\u000fR5tW&sgm\\:\u0015\u000b]\u0014)D!\u000f\t\r\t]R\u00071\u0001x\u00031qWm\u001e#jg.LeNZ8t\u0011\u001d\u0011i#\u000ea\u0001\u0003\u0003\u000bA%\u001e9eCR,G\u000b[3o\u000f\u0016$Xk]3s%\u0016\u001cx.\u001e:dK\u000e{gn];naRLwN\u001c\u000b\u0005\u0003\u001b\u0011y\u0004C\u0004\u0003BY\u0002\r!!\u0004\u0002\u0017\r|gn];naRLwN\\\u0001\ti>\u001cFO]5oO\u00061Q-];bYN$B!a6\u0003J!9!\u0011\u0003\u001dA\u0002\t-\u0003cA'\u0003N%\u0019!q\n(\u0003\u0007\u0005s\u00170\u0001\u0005iCND7i\u001c3f\u0003)9vN]6fe&sgm\u001c\t\u0004\u0003\u0003Y4cA\u001eM%R\u0011!QK\u0001\rMJ|W.\u00168jcV,\u0017\n\u001a\u000b\u0005\u0003\u001b\u0012y\u0006\u0003\u0004\u0003bu\u0002\r!X\u0001\u0003S\u0012\f1B]3bIJ+7o\u001c7wKR\u0011!q\r\t\u0005\u0003W\u0012I'\u0003\u0003\u0003l\u00055$AB(cU\u0016\u001cG\u000f")
public class WorkerInfo
implements scala.Serializable,
Logging {
    private final String host;
    private final int rpcPort;
    private final int pushPort;
    private final int fetchPort;
    private final int replicatePort;
    private final Map<String, DiskInfo> diskInfos;
    private final Map<UserIdentifier, ResourceConsumption> userResourceConsumption;
    private RpcEndpointRef endpoint;
    private HashMap<String, Integer> unknownDiskSlots;
    private long lastHeartbeat;
    private final int[] allocationBuckets;
    private int bucketIndex;
    private long bucketTime;
    private int bucketAllocations;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public static WorkerInfo fromUniqueId(String string) {
        return WorkerInfo$.MODULE$.fromUniqueId(string);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        WorkerInfo workerInfo = this;
        synchronized (workerInfo) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public String host() {
        return this.host;
    }

    public int rpcPort() {
        return this.rpcPort;
    }

    public int pushPort() {
        return this.pushPort;
    }

    public int fetchPort() {
        return this.fetchPort;
    }

    public int replicatePort() {
        return this.replicatePort;
    }

    public Map<String, DiskInfo> diskInfos() {
        return this.diskInfos;
    }

    public Map<UserIdentifier, ResourceConsumption> userResourceConsumption() {
        return this.userResourceConsumption;
    }

    public RpcEndpointRef endpoint() {
        return this.endpoint;
    }

    public void endpoint_$eq(RpcEndpointRef x$1) {
        this.endpoint = x$1;
    }

    public HashMap<String, Integer> unknownDiskSlots() {
        return this.unknownDiskSlots;
    }

    public void unknownDiskSlots_$eq(HashMap<String, Integer> x$1) {
        this.unknownDiskSlots = x$1;
    }

    public long lastHeartbeat() {
        return this.lastHeartbeat;
    }

    public void lastHeartbeat_$eq(long x$1) {
        this.lastHeartbeat = x$1;
    }

    public int[] allocationBuckets() {
        return this.allocationBuckets;
    }

    public int bucketIndex() {
        return this.bucketIndex;
    }

    public void bucketIndex_$eq(int x$1) {
        this.bucketIndex = x$1;
    }

    public long bucketTime() {
        return this.bucketTime;
    }

    public void bucketTime_$eq(long x$1) {
        this.bucketTime = x$1;
    }

    public int bucketAllocations() {
        return this.bucketAllocations;
    }

    public void bucketAllocations_$eq(int x$1) {
        this.bucketAllocations = x$1;
    }

    public boolean isActive() {
        return ((NettyRpcEndpointRef)this.endpoint()).client().isActive();
    }

    public synchronized long usedSlots() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.diskInfos()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)WorkerInfo.$anonfun$usedSlots$1(x$1)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) + (long)BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.unknownDiskSlots().values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2), scala.collection.Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public synchronized void allocateSlots(String shuffleKey, Map<String, Integer> slotsPerDisk) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("shuffle ").append(shuffleKey).append(" allocations ").append(slotsPerDisk).toString());
        IntRef totalSlots = IntRef.create((int)0);
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(slotsPerDisk).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            WorkerInfo.$anonfun$allocateSlots$2(this, shuffleKey, totalSlots, x0$1);
            return BoxedUnit.UNIT;
        });
        long current = System.currentTimeMillis();
        if (current - this.bucketTime() > 60000L) {
            this.bucketIndex_$eq((this.bucketIndex() + 1) % this.allocationBuckets().length);
            this.allocationBuckets()[this.bucketIndex()] = 0;
            this.bucketTime_$eq(current);
        }
        this.allocationBuckets()[this.bucketIndex()] = this.allocationBuckets()[this.bucketIndex()] + totalSlots.elem;
    }

    public synchronized void releaseSlots(String shuffleKey, Map<String, Integer> slots) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(slots).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String disk = (String)tuple2._1();
                Integer slot = (Integer)tuple2._2();
                if (this.diskInfos().containsKey(disk)) {
                    this.diskInfos().get(disk).releaseSlots(shuffleKey, Predef$.MODULE$.Integer2int(slot));
                    object = BoxedUnit.UNIT;
                } else {
                    object = this.unknownDiskSlots().containsKey(shuffleKey) ? this.unknownDiskSlots().put(shuffleKey, Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(this.unknownDiskSlots().get(shuffleKey)) - Predef$.MODULE$.Integer2int(slot))) : BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit = object;
            return boxedUnit;
        });
    }

    public void releaseSlots(String shuffleKey) {
        WorkerInfo workerInfo = this;
        synchronized (workerInfo) {
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.diskInfos()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                WorkerInfo.$anonfun$releaseSlots$2(shuffleKey, x$3);
                return BoxedUnit.UNIT;
            });
            this.unknownDiskSlots().remove(shuffleKey);
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized HashSet<String> getShuffleKeySet() {
        void var1_1;
        HashSet shuffleKeySet = new HashSet();
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.diskInfos().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)diskInfo -> BoxesRunTime.boxToBoolean((boolean)shuffleKeySet.addAll(diskInfo.getShuffleKeySet())));
        return var1_1;
    }

    public synchronized int allocationsInLastHour() {
        IntRef total = IntRef.create((int)0);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 60).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x0$1 -> {
            int n = x0$1;
            total$1.elem += this.allocationBuckets()[(this.bucketIndex() + n) % this.allocationBuckets().length];
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        return total.elem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasSameInfoWith(WorkerInfo other) {
        if (this.rpcPort() != other.rpcPort()) return false;
        if (this.pushPort() != other.pushPort()) return false;
        String string = this.host();
        String string2 = other.host();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.fetchPort() != other.fetchPort()) return false;
        if (this.replicatePort() != other.replicatePort()) return false;
        return true;
    }

    public void setupEndpoint(RpcEndpointRef endpointRef) {
        block0: {
            if (this.endpoint() != null) break block0;
            this.endpoint_$eq(endpointRef);
        }
    }

    public String readableAddress() {
        return new StringBuilder(50).append("Host:").append(this.host()).append(":RpcPort:").append(this.rpcPort()).append(":PushPort:").append(this.pushPort()).append(":").append("FetchPort:").append(this.fetchPort()).append(":ReplicatePort:").append(this.replicatePort()).toString();
    }

    public String toUniqueId() {
        return new StringBuilder(4).append(this.host()).append(":").append(this.rpcPort()).append(":").append(this.pushPort()).append(":").append(this.fetchPort()).append(":").append(this.replicatePort()).toString();
    }

    public synchronized boolean slotAvailable() {
        return ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.diskInfos()).asScala()).exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)WorkerInfo.$anonfun$slotAvailable$1(x0$1)));
    }

    public synchronized long getTotalSlots() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.diskInfos()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)WorkerInfo.$anonfun$getTotalSlots$1(x$4)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public synchronized void updateDiskMaxSlots(long estimatedPartitionSize) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.diskInfos()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            WorkerInfo.$anonfun$updateDiskMaxSlots$1(estimatedPartitionSize, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized long totalAvailableSlots() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.diskInfos()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)WorkerInfo.$anonfun$totalAvailableSlots$1(x$5)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public synchronized Map<String, DiskInfo> updateThenGetDiskInfos(Map<String, DiskInfo> newDiskInfos, long estimatedPartitionSize) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(newDiskInfos.values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)newDisk -> {
            DiskInfo diskInfo;
            String mountPoint = newDisk.mountPoint();
            DiskInfo curDisk = this.diskInfos().get(mountPoint);
            if (curDisk != null) {
                curDisk.actualUsableSpace_$eq(newDisk.actualUsableSpace());
                curDisk.activeSlots_$eq(Math.max(curDisk.activeSlots(), newDisk.activeSlots()));
                curDisk.avgFlushTime_$eq(newDisk.avgFlushTime());
                curDisk.avgFetchTime_$eq(newDisk.avgFetchTime());
                curDisk.maxSlots_$eq(curDisk.actualUsableSpace() / estimatedPartitionSize);
                diskInfo = curDisk.setStatus(newDisk.status());
            } else {
                newDisk.maxSlots_$eq(newDisk.actualUsableSpace() / estimatedPartitionSize);
                diskInfo = this.diskInfos().put(mountPoint, (DiskInfo)newDisk);
            }
            return diskInfo;
        });
        HashSet<String> nonExistsMountPoints = new HashSet<String>();
        nonExistsMountPoints.addAll(this.diskInfos().keySet());
        nonExistsMountPoints.removeAll(newDiskInfos.keySet());
        if (!nonExistsMountPoints.isEmpty()) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(nonExistsMountPoints).asScala()).foreach((Function1 & Serializable & scala.Serializable)nonExistsMountPoint -> this.diskInfos().remove(nonExistsMountPoint));
        }
        return new ConcurrentHashMap<String, DiskInfo>(this.diskInfos());
    }

    public Map<UserIdentifier, ResourceConsumption> updateThenGetUserResourceConsumption(Map<UserIdentifier, ResourceConsumption> consumption) {
        this.userResourceConsumption().clear();
        this.userResourceConsumption().putAll(consumption);
        return this.userResourceConsumption();
    }

    public String toString() {
        Tuple2 tuple2;
        Tuple2 tuple22;
        if (this.diskInfos() == null || this.diskInfos().isEmpty()) {
            tuple22 = new Tuple2((Object)"empty", (Object)BoxesRunTime.boxToInteger((int)0));
        } else if (this.diskInfos() != null) {
            String str = ((TraversableOnce)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.diskInfos().values()).asScala()).zipWithIndex(scala.collection.Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DiskInfo diskInfo = (DiskInfo)tuple2._1();
                int index = tuple2._2$mcI$sp();
                String string = new StringBuilder(13).append("\n  DiskInfo").append(index).append(": ").append(diskInfo).toString();
                return string;
            }, scala.collection.Iterable$.MODULE$.canBuildFrom())).mkString("");
            tuple22 = new Tuple2((Object)str, (Object)BoxesRunTime.boxToLong((long)this.usedSlots()));
        } else {
            tuple22 = tuple2 = BoxedUnit.UNIT;
        }
        if (!(tuple2 instanceof Tuple2)) {
            throw new MatchError((Object)tuple2);
        }
        Tuple2 tuple23 = tuple2;
        Object diskInfosString = tuple23._1();
        Object slots = tuple23._2();
        Tuple2 tuple24 = new Tuple2(diskInfosString, slots);
        Tuple2 tuple25 = tuple24;
        Object diskInfosString2 = tuple25._1();
        Object slots2 = tuple25._2();
        String userResourceConsumptionString = this.userResourceConsumption() == null || this.userResourceConsumption().isEmpty() ? "empty" : (this.userResourceConsumption() != null ? ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.userResourceConsumption()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            UserIdentifier userIdentifier = (UserIdentifier)tuple2._1();
            ResourceConsumption resourceConsumption = (ResourceConsumption)tuple2._2();
            String string = new StringBuilder(42).append("\n  UserIdentifier: ").append(userIdentifier).append(", ResourceConsumption: ").append(resourceConsumption).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString("") : BoxedUnit.UNIT);
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(219).append("\n       |Host: ").append(this.host()).append("\n       |RpcPort: ").append(this.rpcPort()).append("\n       |PushPort: ").append(this.pushPort()).append("\n       |FetchPort: ").append(this.fetchPort()).append("\n       |ReplicatePort: ").append(this.replicatePort()).append("\n       |SlotsUsed: ").append(slots2).append("\n       |LastHeartbeat: ").append(this.lastHeartbeat()).append("\n       |Disks: ").append(diskInfosString2).append("\n       |UserResourceConsumption: ").append((Object)userResourceConsumptionString).append("\n       |WorkerRef: ").append(this.endpoint()).append("\n       |").toString())).stripMargin();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof WorkerInfo)) return false;
        WorkerInfo workerInfo = (WorkerInfo)object;
        String string = this.host();
        String string2 = workerInfo.host();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.rpcPort() != workerInfo.rpcPort()) return false;
        if (this.pushPort() != workerInfo.pushPort()) return false;
        if (this.fetchPort() != workerInfo.fetchPort()) return false;
        if (this.replicatePort() != workerInfo.replicatePort()) return false;
        return true;
    }

    public int hashCode() {
        Seq state = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host(), BoxesRunTime.boxToInteger((int)this.rpcPort()), BoxesRunTime.boxToInteger((int)this.pushPort()), BoxesRunTime.boxToInteger((int)this.fetchPort()), BoxesRunTime.boxToInteger((int)this.replicatePort())}));
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)state.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.hashCode()), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(a, b) -> 31 * a + b));
    }

    public static final /* synthetic */ long $anonfun$usedSlots$1(Tuple2 x$1) {
        return ((DiskInfo)x$1._2()).activeSlots();
    }

    public static final /* synthetic */ void $anonfun$allocateSlots$2(WorkerInfo $this, String shuffleKey$1, IntRef totalSlots$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object object;
            String disk = (String)tuple2._1();
            Integer slots = (Integer)tuple2._2();
            if (!$this.diskInfos().containsKey(disk)) {
                $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Unknown disk ").append(disk).toString());
                object = $this.unknownDiskSlots().containsKey(shuffleKey$1) ? $this.unknownDiskSlots().put(shuffleKey$1, Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(slots) + Predef$.MODULE$.Integer2int($this.unknownDiskSlots().get(shuffleKey$1)))) : $this.unknownDiskSlots().put(shuffleKey$1, slots);
            } else {
                $this.diskInfos().get(disk).allocateSlots(shuffleKey$1, Predef$.MODULE$.Integer2int(slots));
                object = BoxedUnit.UNIT;
            }
            totalSlots$1.elem += Predef$.MODULE$.Integer2int(slots);
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$releaseSlots$2(String shuffleKey$3, Tuple2 x$3) {
        ((DiskInfo)x$3._2()).releaseSlots(shuffleKey$3);
    }

    public static final /* synthetic */ boolean $anonfun$slotAvailable$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        DiskInfo disk = (DiskInfo)tuple2._2();
        boolean bl = disk.maxSlots() - disk.activeSlots() > 0L;
        return bl;
    }

    public static final /* synthetic */ long $anonfun$getTotalSlots$1(Tuple2 x$4) {
        return ((DiskInfo)x$4._2()).maxSlots();
    }

    public static final /* synthetic */ void $anonfun$updateDiskMaxSlots$1(long estimatedPartitionSize$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        DiskInfo disk = (DiskInfo)tuple2._2();
        disk.maxSlots_$eq(disk.actualUsableSpace() / estimatedPartitionSize$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ long $anonfun$totalAvailableSlots$1(Tuple2 x$5) {
        return ((DiskInfo)x$5._2()).availableSlots();
    }

    public WorkerInfo(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, Map<String, DiskInfo> diskInfos, Map<UserIdentifier, ResourceConsumption> userResourceConsumption, RpcEndpointRef endpoint) {
        this.host = host;
        this.rpcPort = rpcPort;
        this.pushPort = pushPort;
        this.fetchPort = fetchPort;
        this.replicatePort = replicatePort;
        this.diskInfos = diskInfos;
        this.userResourceConsumption = userResourceConsumption;
        this.endpoint = endpoint;
        Logging.$init$(this);
        this.unknownDiskSlots = new HashMap();
        this.lastHeartbeat = 0L;
        this.allocationBuckets = new int[61];
        this.bucketIndex = 0;
        this.bucketTime = System.currentTimeMillis();
        this.bucketAllocations = 0;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.allocationBuckets().length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x0$1 -> {
            int n = x0$1;
            $this.allocationBuckets()[n] = 0;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
    }

    public WorkerInfo(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort) {
        this(host, rpcPort, pushPort, fetchPort, replicatePort, new HashMap<String, DiskInfo>(), new ConcurrentHashMap<UserIdentifier, ResourceConsumption>(), null);
    }

    public WorkerInfo(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, RpcEndpointRef endpoint) {
        this(host, rpcPort, pushPort, fetchPort, replicatePort, new HashMap<String, DiskInfo>(), new ConcurrentHashMap<UserIdentifier, ResourceConsumption>(), endpoint);
    }
}

