/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.meta;

import java.io.File;
import java.util.BitSet;
import java.util.List;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.network.buffer.FileSegmentManagedBuffer;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;
import org.apache.celeborn.common.network.util.TransportConf;

public class FileManagedBuffers {
    private final File file;
    private final long[] offsets;
    private final int numChunks;
    private final BitSet chunkTracker;
    private final TransportConf conf;
    private volatile boolean fullyRead = false;

    public FileManagedBuffers(FileInfo fileInfo, TransportConf conf) {
        this.file = fileInfo.getFile();
        this.numChunks = fileInfo.numChunks();
        if (this.numChunks > 0) {
            this.offsets = new long[this.numChunks + 1];
            List<Long> chunkOffsets = fileInfo.getChunkOffsets();
            for (int i = 0; i <= this.numChunks; ++i) {
                this.offsets[i] = chunkOffsets.get(i);
            }
        } else {
            this.offsets = new long[1];
            this.offsets[0] = 0L;
        }
        this.chunkTracker = new BitSet(this.numChunks);
        this.chunkTracker.clear();
        this.conf = conf;
    }

    public int numChunks() {
        return this.numChunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAlreadyRead(int chunkIndex) {
        BitSet bitSet = this.chunkTracker;
        synchronized (bitSet) {
            return this.chunkTracker.get(chunkIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedBuffer chunk(int chunkIndex, int offset, int len) {
        BitSet bitSet = this.chunkTracker;
        synchronized (bitSet) {
            this.chunkTracker.set(chunkIndex, true);
        }
        long chunkOffset = this.offsets[chunkIndex];
        long chunkLength = this.offsets[chunkIndex + 1] - chunkOffset;
        assert ((long)offset < chunkLength);
        long length = Math.min(chunkLength - (long)offset, (long)len);
        if ((long)(len + offset) >= chunkLength) {
            BitSet bitSet2 = this.chunkTracker;
            synchronized (bitSet2) {
                this.chunkTracker.set(chunkIndex);
            }
            if (this.chunkTracker.cardinality() == this.numChunks) {
                this.fullyRead = true;
            }
        }
        return new FileSegmentManagedBuffer(this.conf, this.file, chunkOffset + (long)offset, length);
    }

    public boolean isFullyRead() {
        return this.fullyRead;
    }
}

