/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client.impl.metrics;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableRollingAverages;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;

@InterfaceAudience.Private
@Metrics(name="HdfsShortCircuitReads", about="Block Reader Local's Short Circuit Read latency", context="dfs")
public class BlockReaderLocalMetrics {
    @Metric(value={"short circuit read operation rate"}, valueName="LatencyMs")
    private MutableRollingAverages shortCircuitReadRollingAverages;
    private static final String SHORT_CIRCUIT_READ_METRIC_REGISTERED_NAME = "HdfsShortCircuitReads";
    private static final String SHORT_CIRCUIT_LOCAL_READS_METRIC_VALUE_NAME = "ShortCircuitLocalReads";

    public static BlockReaderLocalMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        BlockReaderLocalMetrics metrics = new BlockReaderLocalMetrics();
        ms.register(SHORT_CIRCUIT_READ_METRIC_REGISTERED_NAME, null, metrics);
        return metrics;
    }

    public void addShortCircuitReadLatency(long latency) {
        this.shortCircuitReadRollingAverages.add(SHORT_CIRCUIT_LOCAL_READS_METRIC_VALUE_NAME, latency);
    }

    public void collectThreadLocalStates() {
        this.shortCircuitReadRollingAverages.collectThreadLocalStates();
    }

    @VisibleForTesting
    public MutableRollingAverages getShortCircuitReadRollingAverages() {
        return this.shortCircuitReadRollingAverages;
    }
}

