/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.Decoder;
import org.apache.spark.sql.execution.columnar.Encoder;
import org.apache.spark.sql.execution.columnar.NativeRssColumnType;
import org.apache.spark.sql.execution.columnar.RssColumnType;
import org.apache.spark.sql.execution.columnar.RssPassThrough$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t%t!\u0002\u0015*\u0011\u00033d!\u0002\u001d*\u0011\u0003K\u0004\"B%\u0002\t\u0003Q\u0005bB&\u0002\u0005\u0004%\t\u0005\u0014\u0005\u0007!\u0006\u0001\u000b\u0011B'\t\u000bE\u000bA\u0011\t*\t\u000b\u001d\fA\u0011\t5\t\u000bm\fA\u0011\t?\u0007\r\u0005}\u0011\u0001AA\u0011\u0011%9\u0006B!A!\u0002\u0013\tY\u0003\u0003\u0004J\u0011\u0011\u0005\u0011Q\u0006\u0005\u0007\u0003kAA\u0011\t'\t\r\u0005]\u0002\u0002\"\u0011M\u0011\u001d\tI\u0004\u0003C!\u0003w1a!!\u0012\u0002\u0001\u0005\u001d\u0003BCA\u0005\u001d\t\u0005\t\u0015!\u0003\u0002\f!IqK\u0004B\u0001B\u0003%\u0011\u0011\u000b\u0005\u0007\u0013:!\t!a\u0015\t\u000f\u0005mc\u0002\"\u0011\u0002^!9\u0011\u0011\u0010\b\u0005B\u0005m\u0004bBA?\u001d\u0011%\u0011q\u0010\u0005\b\u0003;sA\u0011BAP\u0011\u001d\tIK\u0004C\u0005\u0003WCq!!.\u000f\t\u0013\t9\fC\u0004\u0002B:!I!a1\t\u000f\u00055g\u0002\"\u0003\u0002P\"9\u0011\u0011\u001c\b\u0005\n\u0005m\u0007bBAs\u001d\u0011%\u0011q\u001d\u0005\b\u0003ctA\u0011BAz\u0011\u001d\u0011IA\u0004C\u0005\u0005\u0017AqAa\u0005\u000f\t\u0013\u0011)\u0002C\u0004\u0003 9!\tE!\t\t\u0013\t\u001d\u0012!!A\u0005B\t%\u0002\u0002\u0003B\u001c\u0003\u0005\u0005I\u0011\u0001'\t\u0013\te\u0012!!A\u0005\u0002\tm\u0002\"\u0003B!\u0003\u0005\u0005I\u0011\tB\"\u0011%\u0011\t&AA\u0001\n\u0003\u0011\u0019\u0006C\u0005\u0003X\u0005\t\t\u0011\"\u0011\u0003Z!I!1L\u0001\u0002\u0002\u0013\u0005#Q\f\u0005\n\u0005?\n\u0011\u0011!C\u0005\u0005C\naBU:t!\u0006\u001c8\u000f\u00165s_V<\u0007N\u0003\u0002+W\u0005A1m\u001c7v[:\f'O\u0003\u0002-[\u0005IQ\r_3dkRLwN\u001c\u0006\u0003]=\n1a]9m\u0015\t\u0001\u0014'A\u0003ta\u0006\u00148N\u0003\u00023g\u00051\u0011\r]1dQ\u0016T\u0011\u0001N\u0001\u0004_J<7\u0001\u0001\t\u0003o\u0005i\u0011!\u000b\u0002\u000f%N\u001c\b+Y:t)\"\u0014x.^4i'\u0015\t!\bQ\"G!\tYd(D\u0001=\u0015\u0005i\u0014!B:dC2\f\u0017BA =\u0005\u0019\te.\u001f*fMB\u0011q'Q\u0005\u0003\u0005&\u0012ACU:t\u0007>l\u0007O]3tg&|gnU2iK6,\u0007CA\u001eE\u0013\t)EHA\u0004Qe>$Wo\u0019;\u0011\u0005m:\u0015B\u0001%=\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019a\u0014N\\5u}Q\ta'\u0001\u0004usB,\u0017\nZ\u000b\u0002\u001bB\u00111HT\u0005\u0003\u001fr\u00121!\u00138u\u0003\u001d!\u0018\u0010]3JI\u0002\n\u0001b];qa>\u0014Ho\u001d\u000b\u0003'Z\u0003\"a\u000f+\n\u0005Uc$a\u0002\"p_2,\u0017M\u001c\u0005\u0006/\u0016\u0001\r\u0001W\u0001\u000bG>dW/\u001c8UsB,\u0007GA-_!\r9$\fX\u0005\u00037&\u0012QBU:t\u0007>dW/\u001c8UsB,\u0007CA/_\u0019\u0001!\u0011b\u0018,\u0002\u0002\u0003\u0005)\u0011\u00011\u0003\u0007}#\u0013'\u0005\u0002bIB\u00111HY\u0005\u0003Gr\u0012qAT8uQ&tw\r\u0005\u0002<K&\u0011a\r\u0010\u0002\u0004\u0003:L\u0018aB3oG>$WM]\u000b\u0003S:$\"A[<\u0011\u0007]ZW.\u0003\u0002mS\t9QI\\2pI\u0016\u0014\bCA/o\t\u0015ygA1\u0001q\u0005\u0005!\u0016CA1r!\t\u0011X/D\u0001t\u0015\t!X&A\u0003usB,7/\u0003\u0002wg\nQ\u0011\t^8nS\u000e$\u0016\u0010]3\t\u000b]3\u0001\u0019\u0001=\u0011\u0007]JX.\u0003\u0002{S\t\u0019b*\u0019;jm\u0016\u00146o]\"pYVlg\u000eV=qK\u00069A-Z2pI\u0016\u0014XcA?\u0002\u0006Q)a0a\u0002\u0002\u001cA!qg`A\u0002\u0013\r\t\t!\u000b\u0002\b\t\u0016\u001cw\u000eZ3s!\ri\u0016Q\u0001\u0003\u0006_\u001e\u0011\r\u0001\u001d\u0005\b\u0003\u00139\u0001\u0019AA\u0006\u0003\u0019\u0011WO\u001a4feB!\u0011QBA\f\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011a\u00018j_*\u0011\u0011QC\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001a\u0005=!A\u0003\"zi\u0016\u0014UO\u001a4fe\"1qk\u0002a\u0001\u0003;\u0001BaN=\u0002\u0004\tQ!k]:F]\u000e|G-\u001a:\u0016\t\u0005\r\u0012\u0011F\n\u0005\u0011i\n)\u0003\u0005\u00038W\u0006\u001d\u0002cA/\u0002*\u0011)q\u000e\u0003b\u0001aB!q'_A\u0014)\u0011\ty#a\r\u0011\u000b\u0005E\u0002\"a\n\u000e\u0003\u0005Aaa\u0016\u0006A\u0002\u0005-\u0012\u0001E;oG>l\u0007O]3tg\u0016$7+\u001b>f\u00039\u0019w.\u001c9sKN\u001cX\rZ*ju\u0016\f\u0001bY8naJ,7o\u001d\u000b\u0007\u0003\u0017\ti$!\u0011\t\u000f\u0005}R\u00021\u0001\u0002\f\u0005!aM]8n\u0011\u001d\t\u0019%\u0004a\u0001\u0003\u0017\t!\u0001^8\u0003\u0015I\u001b8\u000fR3d_\u0012,'/\u0006\u0003\u0002J\u0005=3\u0003\u0002\b;\u0003\u0017\u0002BaN@\u0002NA\u0019Q,a\u0014\u0005\u000b=t!\u0019\u00019\u0011\t]J\u0018Q\n\u000b\u0007\u0003+\n9&!\u0017\u0011\u000b\u0005Eb\"!\u0014\t\u000f\u0005%\u0011\u00031\u0001\u0002\f!1q+\u0005a\u0001\u0003#\nAA\\3yiR1\u0011qLA3\u0003k\u00022aOA1\u0013\r\t\u0019\u0007\u0010\u0002\u0005+:LG\u000fC\u0004\u0002hI\u0001\r!!\u001b\u0002\u0007I|w\u000f\u0005\u0003\u0002l\u0005ETBAA7\u0015\r\ty'L\u0001\tG\u0006$\u0018\r\\=ti&!\u00111OA7\u0005-Ie\u000e^3s]\u0006d'k\\<\t\r\u0005]$\u00031\u0001N\u0003\u001dy'\u000fZ5oC2\fq\u0001[1t\u001d\u0016DH/F\u0001T\u0003-\u0001X\u000f\u001e\"p_2,\u0017M\\:\u0015\u0015\u0005}\u0013\u0011QAI\u0003+\u000bI\nC\u0004\u0002\u0004R\u0001\r!!\"\u0002\u0019\r|G.^7o-\u0016\u001cGo\u001c:\u0011\t\u0005\u001d\u0015QR\u0007\u0003\u0003\u0013S1!a#,\u0003)1Xm\u0019;pe&TX\rZ\u0005\u0005\u0003\u001f\u000bII\u0001\u000bXe&$\u0018M\u00197f\u0007>dW/\u001c8WK\u000e$xN\u001d\u0005\u0007\u0003'#\u0002\u0019A'\u0002\u0007A|7\u000f\u0003\u0004\u0002\u0018R\u0001\r!T\u0001\nEV4g-\u001a:Q_NDa!a'\u0015\u0001\u0004i\u0015a\u00017f]\u0006A\u0001/\u001e;CsR,7\u000f\u0006\u0006\u0002`\u0005\u0005\u00161UAS\u0003OCq!a!\u0016\u0001\u0004\t)\t\u0003\u0004\u0002\u0014V\u0001\r!\u0014\u0005\u0007\u0003/+\u0002\u0019A'\t\r\u0005mU\u00031\u0001N\u0003%\u0001X\u000f^*i_J$8\u000f\u0006\u0006\u0002`\u00055\u0016qVAY\u0003gCq!a!\u0017\u0001\u0004\t)\t\u0003\u0004\u0002\u0014Z\u0001\r!\u0014\u0005\u0007\u0003/3\u0002\u0019A'\t\r\u0005me\u00031\u0001N\u0003\u001d\u0001X\u000f^%oiN$\"\"a\u0018\u0002:\u0006m\u0016QXA`\u0011\u001d\t\u0019i\u0006a\u0001\u0003\u000bCa!a%\u0018\u0001\u0004i\u0005BBAL/\u0001\u0007Q\n\u0003\u0004\u0002\u001c^\u0001\r!T\u0001\taV$Hj\u001c8hgRQ\u0011qLAc\u0003\u000f\fI-a3\t\u000f\u0005\r\u0005\u00041\u0001\u0002\u0006\"1\u00111\u0013\rA\u00025Ca!a&\u0019\u0001\u0004i\u0005BBAN1\u0001\u0007Q*A\u0005qkR4En\\1ugRQ\u0011qLAi\u0003'\f).a6\t\u000f\u0005\r\u0015\u00041\u0001\u0002\u0006\"1\u00111S\rA\u00025Ca!a&\u001a\u0001\u0004i\u0005BBAN3\u0001\u0007Q*\u0001\u0006qkR$u.\u001e2mKN$\"\"a\u0018\u0002^\u0006}\u0017\u0011]Ar\u0011\u001d\t\u0019I\u0007a\u0001\u0003\u000bCa!a%\u001b\u0001\u0004i\u0005BBAL5\u0001\u0007Q\n\u0003\u0004\u0002\u001cj\u0001\r!T\u0001\raV$()\u001f;f\u0003J\u0014\u0018-\u001f\u000b\u000b\u0003?\nI/a;\u0002n\u0006=\bbBAB7\u0001\u0007\u0011Q\u0011\u0005\u0007\u0003'[\u0002\u0019A'\t\r\u0005]5\u00041\u0001N\u0011\u0019\tYj\u0007a\u0001\u001b\u0006\u0019B-Z2p[B\u0014Xm]:Qe&l\u0017\u000e^5wKRQ\u0011qLA{\u0003o\fY0a@\t\u000f\u0005\rE\u00041\u0001\u0002\u0006\"1\u0011\u0011 \u000fA\u00025\u000baA]8x\u0007:$\bBBA\u007f9\u0001\u0007Q*\u0001\u0005v]&$8+\u001b>f\u0011\u001d\u0011\t\u0001\ba\u0001\u0005\u0007\t1\u0002];u\rVt7\r^5p]BQ1H!\u0002\u0002\u00066kU*a\u0018\n\u0007\t\u001dAHA\u0005Gk:\u001cG/[8oi\u0005\u0001B-Z2p[B\u0014Xm]:TiJLgn\u001a\u000b\t\u0003?\u0012iAa\u0004\u0003\u0012!9\u00111Q\u000fA\u0002\u0005\u0015\u0005BBA};\u0001\u0007Q\nC\u0004\u0003\u0002u\u0001\rAa\u0001\u0002#\u0011,7m\\7qe\u0016\u001c8\u000fR3dS6\fG\u000e\u0006\u0005\u0002`\t]!\u0011\u0004B\u000e\u0011\u001d\t\u0019I\ba\u0001\u0003\u000bCa!!?\u001f\u0001\u0004i\u0005B\u0002B\u000f=\u0001\u0007Q*A\u0005qe\u0016\u001c\u0017n]5p]\u0006QA-Z2p[B\u0014Xm]:\u0015\r\u0005}#1\u0005B\u0013\u0011\u001d\t\u0019i\ba\u0001\u0003\u000bCa!!? \u0001\u0004i\u0015!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003,A!!Q\u0006B\u001a\u001b\t\u0011yC\u0003\u0003\u00032\u0005M\u0011\u0001\u00027b]\u001eLAA!\u000e\u00030\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002e\u0005{A\u0001Ba\u0010#\u0003\u0003\u0005\r!T\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\u0015\u0003#\u0002B$\u0005\u001b\"WB\u0001B%\u0015\r\u0011Y\u0005P\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B(\u0005\u0013\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u00191K!\u0016\t\u0011\t}B%!AA\u0002\u0011\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002\u001b\u0006AAo\\*ue&tw\r\u0006\u0002\u0003,\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\u0019\u0007\u0005\u0003\u0003.\t\u0015\u0014\u0002\u0002B4\u0005_\u0011aa\u00142kK\u000e$\b")
public final class RssPassThrough {
    public static String toString() {
        return RssPassThrough$.MODULE$.toString();
    }

    public static int hashCode() {
        return RssPassThrough$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object object) {
        return RssPassThrough$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return RssPassThrough$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return RssPassThrough$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return RssPassThrough$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return RssPassThrough$.MODULE$.productPrefix();
    }

    public static <T extends AtomicType> Decoder<T> decoder(ByteBuffer byteBuffer, NativeRssColumnType<T> nativeRssColumnType) {
        return RssPassThrough$.MODULE$.decoder(byteBuffer, nativeRssColumnType);
    }

    public static <T extends AtomicType> Encoder<T> encoder(NativeRssColumnType<T> nativeRssColumnType) {
        return RssPassThrough$.MODULE$.encoder(nativeRssColumnType);
    }

    public static boolean supports(RssColumnType<?> rssColumnType) {
        return RssPassThrough$.MODULE$.supports(rssColumnType);
    }

    public static int typeId() {
        return RssPassThrough$.MODULE$.typeId();
    }

    public static class RssDecoder<T extends AtomicType>
    implements Decoder<T> {
        private final ByteBuffer buffer;
        private final NativeRssColumnType<T> columnType;

        @Override
        public void next(InternalRow row, int ordinal) {
            this.columnType.extract(this.buffer, row, ordinal);
        }

        @Override
        public boolean hasNext() {
            return this.buffer.hasRemaining();
        }

        private void putBooleans(WritableColumnVector columnVector, int pos, int bufferPos, int len) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> columnVector.putBoolean(pos + i, $this.buffer.get(bufferPos + i) != 0));
        }

        private void putBytes(WritableColumnVector columnVector, int pos, int bufferPos, int len) {
            columnVector.putBytes(pos, len, this.buffer.array(), bufferPos);
        }

        private void putShorts(WritableColumnVector columnVector, int pos, int bufferPos, int len) {
            columnVector.putShorts(pos, len, this.buffer.array(), bufferPos);
        }

        private void putInts(WritableColumnVector columnVector, int pos, int bufferPos, int len) {
            columnVector.putInts(pos, len, this.buffer.array(), bufferPos);
        }

        private void putLongs(WritableColumnVector columnVector, int pos, int bufferPos, int len) {
            columnVector.putLongs(pos, len, this.buffer.array(), bufferPos);
        }

        private void putFloats(WritableColumnVector columnVector, int pos, int bufferPos, int len) {
            columnVector.putFloats(pos, len, this.buffer.array(), bufferPos);
        }

        private void putDoubles(WritableColumnVector columnVector, int pos, int bufferPos, int len) {
            columnVector.putDoubles(pos, len, this.buffer.array(), bufferPos);
        }

        private void putByteArray(WritableColumnVector columnVector, int pos, int bufferPos, int len) {
            columnVector.putByteArray(pos, this.buffer.array(), bufferPos, len);
        }

        private void decompressPrimitive(WritableColumnVector columnVector, int rowCnt, int unitSize, Function4<WritableColumnVector, Object, Object, Object, BoxedUnit> putFunction) {
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : rowCnt;
            int valueIndex = 0;
            int seenNulls = 0;
            int bufferPos = this.buffer.position();
            while (valueIndex < rowCnt) {
                if (valueIndex != nextNullIndex) {
                    int len = nextNullIndex - valueIndex;
                    Predef$.MODULE$.assert((long)len * (long)unitSize < Integer.MAX_VALUE);
                    putFunction.apply((Object)columnVector, (Object)BoxesRunTime.boxToInteger((int)valueIndex), (Object)BoxesRunTime.boxToInteger((int)bufferPos), (Object)BoxesRunTime.boxToInteger((int)len));
                    bufferPos += len * unitSize;
                    valueIndex += len;
                    continue;
                }
                nextNullIndex = ++seenNulls < nullCount ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : rowCnt;
                columnVector.putNull(valueIndex);
                ++valueIndex;
            }
        }

        private void decompressString(WritableColumnVector columnVector, int rowCnt, Function4<WritableColumnVector, Object, Object, Object, BoxedUnit> putFunction) {
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : rowCnt;
            int valueIndex = 0;
            int seenNulls = 0;
            while (valueIndex < rowCnt) {
                if (valueIndex != nextNullIndex) {
                    int len = nextNullIndex - valueIndex;
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(valueIndex), nextNullIndex).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
                        int length = $this.buffer.getInt();
                        int cursor = $this.buffer.position();
                        $this.buffer.position(cursor + length);
                        putFunction.apply((Object)columnVector, (Object)BoxesRunTime.boxToInteger((int)index), (Object)BoxesRunTime.boxToInteger((int)($this.buffer.arrayOffset() + cursor)), (Object)BoxesRunTime.boxToInteger((int)length));
                    });
                    valueIndex += len;
                    continue;
                }
                nextNullIndex = ++seenNulls < nullCount ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : rowCnt;
                columnVector.putNull(valueIndex);
                ++valueIndex;
            }
        }

        private void decompressDecimal(WritableColumnVector columnVector2, int rowCnt, int precision) {
            if (precision <= Decimal$.MODULE$.MAX_INT_DIGITS()) {
                this.decompressPrimitive(columnVector2, rowCnt, 4, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putInts(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
            } else if (precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
                this.decompressPrimitive(columnVector2, rowCnt, 8, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putLongs(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
            } else {
                this.decompressString(columnVector2, rowCnt, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putByteArray(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
            }
        }

        @Override
        public void decompress(WritableColumnVector columnVector2, int rowCnt) {
            T t = this.columnType.dataType();
            if (t instanceof BooleanType) {
                int unitSize = 1;
                this.decompressPrimitive(columnVector2, rowCnt, unitSize, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putBooleans(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof ByteType) {
                int unitSize = 1;
                this.decompressPrimitive(columnVector2, rowCnt, unitSize, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putBytes(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof ShortType) {
                int unitSize = 2;
                this.decompressPrimitive(columnVector2, rowCnt, unitSize, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putShorts(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof IntegerType) {
                int unitSize = 4;
                this.decompressPrimitive(columnVector2, rowCnt, unitSize, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putInts(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof LongType) {
                int unitSize = 8;
                this.decompressPrimitive(columnVector2, rowCnt, unitSize, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putLongs(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof FloatType) {
                int unitSize = 4;
                this.decompressPrimitive(columnVector2, rowCnt, unitSize, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putFloats(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof DoubleType) {
                int unitSize = 8;
                this.decompressPrimitive(columnVector2, rowCnt, unitSize, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putDoubles(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof StringType) {
                this.decompressString(columnVector2, rowCnt, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putByteArray(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)t;
                this.decompressDecimal(columnVector2, rowCnt, decimalType.precision());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(t);
            }
        }

        public RssDecoder(ByteBuffer buffer, NativeRssColumnType<T> columnType) {
            this.buffer = buffer;
            this.columnType = columnType;
        }
    }

    public static class RssEncoder<T extends AtomicType>
    implements Encoder<T> {
        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            Encoder.gatherCompressibilityStats$(this, row, ordinal);
        }

        @Override
        public double compressionRatio() {
            return Encoder.compressionRatio$(this);
        }

        @Override
        public int uncompressedSize() {
            return 0;
        }

        @Override
        public int compressedSize() {
            return 0;
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            to.putInt(RssPassThrough$.MODULE$.typeId()).put(from).rewind();
            return to;
        }

        public RssEncoder(NativeRssColumnType<T> columnType) {
            Encoder.$init$(this);
        }
    }
}

