/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeAndComment;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeFormatter$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.codegen.GeneratedClass;
import org.apache.spark.sql.execution.columnar.RssBatchBuilder;
import org.apache.spark.sql.execution.columnar.RssBooleanCodeGenColumnBuilder;
import org.apache.spark.sql.execution.columnar.RssByteCodeGenColumnBuilder;
import org.apache.spark.sql.execution.columnar.RssCompactDecimalCodeGenColumnBuilder;
import org.apache.spark.sql.execution.columnar.RssCompactMiniDecimalCodeGenColumnBuilder;
import org.apache.spark.sql.execution.columnar.RssDecimalCodeGenColumnBuilder;
import org.apache.spark.sql.execution.columnar.RssDoubleCodeGenColumnBuilder;
import org.apache.spark.sql.execution.columnar.RssFloatCodeGenColumnBuilder;
import org.apache.spark.sql.execution.columnar.RssIntCodeGenColumnBuilder;
import org.apache.spark.sql.execution.columnar.RssLongCodeGenColumnBuilder;
import org.apache.spark.sql.execution.columnar.RssNullColumnBuilder;
import org.apache.spark.sql.execution.columnar.RssShortCodeGenColumnBuilder;
import org.apache.spark.sql.execution.columnar.RssStringCodeGenColumnBuilder;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e3Aa\u0002\u0005\u0001+!)A\u0004\u0001C\u0001;!9\u0001\u0005\u0001b\u0001\n\u0013\t\u0003B\u0002\u0015\u0001A\u0003%!\u0005C\u0003*\u0001\u0011\u0005!\u0006C\u0003<\u0001\u0011\u0005A\bC\u0003K\u0001\u0011\u00051J\u0001\u000fSgN\u001cu\u000e\\;n]\u0006\u0014()\u0019;dQ\u000e{G-Z$f]\n+\u0018\u000e\u001c3\u000b\u0005%Q\u0011\u0001C2pYVlg.\u0019:\u000b\u0005-a\u0011!C3yK\u000e,H/[8o\u0015\tia\"A\u0002tc2T!a\u0004\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\u0001\"a\b\u0001\u000e\u0003!\ta\u0001\\8hO\u0016\u0014X#\u0001\u0012\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015\u0012\u0012!B:mMRR\u0017BA\u0014%\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013AB2sK\u0006$X\rF\u0002,]Y\u0002\"a\b\u0017\n\u00055B!a\u0004*tg\n\u000bGo\u00195Ck&dG-\u001a:\t\u000b=\"\u0001\u0019\u0001\u0019\u0002\rM\u001c\u0007.Z7b!\t\tD'D\u00013\u0015\t\u0019D\"A\u0003usB,7/\u0003\u00026e\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000b]\"\u0001\u0019\u0001\u001d\u0002\u0013\t\fGo\u00195TSj,\u0007CA\f:\u0013\tQ\u0004DA\u0002J]R\fqaZ3o\u0007>$W\rF\u0002>\u0011&\u0003ba\u0006 A\u0001\u0002\u0003\u0015BA \u0019\u0005\u0019!V\u000f\u001d7fiA\u0011\u0011IR\u0007\u0002\u0005*\u00111\tR\u0001\b[V$\u0018M\u00197f\u0015\t)\u0005$\u0001\u0006d_2dWm\u0019;j_:L!a\u0012\"\u0003\u001bM#(/\u001b8h\u0005VLG\u000eZ3s\u0011\u0015yS\u00011\u00011\u0011\u00159T\u00011\u00019\u000319WM\\,sSR,7i\u001c3f)\tau\u000b\u0005\u0002N):\u0011aJ\u0015\t\u0003\u001fbi\u0011\u0001\u0015\u0006\u0003#R\ta\u0001\u0010:p_Rt\u0014BA*\u0019\u0003\u0019\u0001&/\u001a3fM&\u0011QK\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005MC\u0002\"\u0002-\u0007\u0001\u0004A\u0014!B5oI\u0016D\b")
public class RssColumnarBatchCodeGenBuild {
    private final Logger logger = LoggerFactory.getLogger(RssColumnarBatchCodeGenBuild.class);

    private Logger logger() {
        return this.logger;
    }

    public RssBatchBuilder create(StructType schema, int batchSize) {
        GeneratedClass clazz;
        CodegenContext ctx = GenerateUnsafeProjection$.MODULE$.newCodeGenContext();
        Tuple4<StringBuilder, StringBuilder, StringBuilder, StringBuilder> codes = this.genCode(schema, batchSize);
        String codeBody = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(1231).append("\n         |\n         |public java.lang.Object generate(Object[] references) {\n         |  return new SpecificRssColumnarBatchBuilder(references);\n         |}\n         |\n         |class SpecificRssColumnarBatchBuilder extends ").append(RssBatchBuilder.class.getName()).append(" {\n         |\n         |  private Object[] references;\n         |  int rowCnt = 0;\n         |  ").append(codes._1()).append("\n         |\n         |  public SpecificRssColumnarBatchBuilder(Object[] references) {\n         |    this.references = references;\n         |  }\n         |\n         |  public void newBuilders() throws Exception {\n         |    rowCnt = 0;\n         |    ").append(codes._2()).append("\n         |  }\n         |\n         |  public byte[] buildColumnBytes() throws Exception {\n         |    int offset = 0;\n         |    byte[] giantBuffer = new byte[totalSize];\n         |    byte[] rowCntBytes = int2ByteArray(rowCnt);\n         |    System.arraycopy(rowCntBytes, 0, giantBuffer, offset, rowCntBytes.length);\n         |    offset += 4;\n         |    ").append(codes._3()).append("\n         |    return giantBuffer;\n         |  }\n         |\n         |  public void writeRow(InternalRow row) throws Exception {\n         |    ").append(codes._4()).append("\n         |    rowCnt += 1;\n         |  }\n         |\n         |  public int getRowCnt() {\n         |    return rowCnt;\n         |  }\n         |}\n       ").toString())).stripMargin();
        CodeAndComment code = CodeFormatter$.MODULE$.stripOverlappingComments(new CodeAndComment(codeBody, ctx.getPlaceHolderToComments()));
        this.logger().debug(new java.lang.StringBuilder(1).append("\n").append(CodeFormatter$.MODULE$.format(code, CodeFormatter$.MODULE$.format$default$2())).toString());
        Tuple2 tuple2 = CodeGenerator$.MODULE$.compile(code);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        GeneratedClass generatedClass = clazz = (GeneratedClass)tuple2._1();
        GeneratedClass clazz2 = generatedClass;
        return (RssBatchBuilder)clazz2.generate((Object[])ctx.references().toArray(ClassTag$.MODULE$.Any()));
    }

    public Tuple4<StringBuilder, StringBuilder, StringBuilder, StringBuilder> genCode(StructType schema, int batchSize) {
        StringBuilder initCode = new StringBuilder();
        StringBuilder buildCode = new StringBuilder();
        StringBuilder writeCode = new StringBuilder();
        StringBuilder writeRowCode = new StringBuilder();
        schema.indices().foreach((Function1 & Serializable & scala.Serializable)index -> RssColumnarBatchCodeGenBuild.$anonfun$genCode$1(this, schema, initCode, buildCode, batchSize, writeCode, writeRowCode, BoxesRunTime.unboxToInt((Object)index)));
        return new Tuple4((Object)initCode, (Object)buildCode, (Object)writeCode, (Object)writeRowCode);
    }

    public String genWriteCode(int index) {
        return new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(389).append("\n       |  ").append(ByteBuffer.class.getName()).append(" buffers").append(index).append(" = b").append(index).append(".build();\n       |  byte[] bytes").append(index).append(" = ").append(JavaUtils.class.getName()).append(".bufferToArray(buffers").append(index).append(");\n       |  byte[] columnBuilderBytes").append(index).append(" = int2ByteArray(bytes").append(index).append(".length);\n       |  System.arraycopy(columnBuilderBytes").append(index).append(", 0, giantBuffer, offset, columnBuilderBytes").append(index).append(".length);\n       |  offset += 4;\n       |  System.arraycopy(bytes").append(index).append(", 0, giantBuffer, offset, bytes").append(index).append(".length);\n       |  offset += bytes").append(index).append(".length;\n          ").toString())).stripMargin();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ StringBuilder $anonfun$genCode$1(RssColumnarBatchCodeGenBuild $this, StructType schema$1, StringBuilder initCode$1, StringBuilder buildCode$1, int batchSize$1, StringBuilder writeCode$1, StringBuilder writeRowCode$1, int index) {
        boolean bl = false;
        DecimalType decimalType = null;
        DataType dataType = schema$1.fields()[index].dataType();
        if (NullType$.MODULE$.equals(dataType)) {
            initCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(33).append("\n               |  ").append(RssNullColumnBuilder.class.getName()).append(" b").append(index).append(";\n          ").toString())).stripMargin());
            buildCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(92).append("\n               |  b").append(index).append(" = new ").append(RssNullColumnBuilder.class.getName()).append("();\n               |  builder.initialize(").append(batchSize$1).append(", \"").append(schema$1.fields()[index].name()).append("\", false);\n          ").toString())).stripMargin());
            writeCode$1.append($this.genWriteCode(index));
            return writeRowCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("\n               |  b").append(index).append(".appendFrom(row, ").append(index).append(");\n          ").toString())).stripMargin());
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            initCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(33).append("\n               |  ").append(RssByteCodeGenColumnBuilder.class.getName()).append(" b").append(index).append(";\n          ").toString())).stripMargin());
            buildCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(86).append("\n               |  b").append(index).append(" = new ").append(RssByteCodeGenColumnBuilder.class.getName()).append("();\n               |  b").append(index).append(".initialize(").append(batchSize$1).append(", \"").append(schema$1.fields()[index].name()).append("\", false);\n          ").toString())).stripMargin());
            writeCode$1.append($this.genWriteCode(index));
            return writeRowCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("\n               |  b").append(index).append(".appendFrom(row, ").append(index).append(");\n          ").toString())).stripMargin());
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            initCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(33).append("\n               |  ").append(RssBooleanCodeGenColumnBuilder.class.getName()).append(" b").append(index).append(";\n          ").toString())).stripMargin());
            buildCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(87).append("\n               |  b").append(index).append("  = new ").append(RssBooleanCodeGenColumnBuilder.class.getName()).append("();\n               |  b").append(index).append(".initialize(").append(batchSize$1).append(", \"").append(schema$1.fields()[index].name()).append("\", false);\n          ").toString())).stripMargin());
            writeCode$1.append($this.genWriteCode(index));
            return writeRowCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("\n               |  b").append(index).append(".appendFrom(row, ").append(index).append(");\n          ").toString())).stripMargin());
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            initCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(33).append("\n               |  ").append(RssShortCodeGenColumnBuilder.class.getName()).append(" b").append(index).append(";\n          ").toString())).stripMargin());
            buildCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(86).append("\n               |  b").append(index).append(" = new ").append(RssShortCodeGenColumnBuilder.class.getName()).append("();\n               |  b").append(index).append(".initialize(").append(batchSize$1).append(", \"").append(schema$1.fields()[index].name()).append("\", false);\n          ").toString())).stripMargin());
            writeCode$1.append($this.genWriteCode(index));
            return writeRowCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("\n               |  b").append(index).append(".appendFrom(row, ").append(index).append(");\n          ").toString())).stripMargin());
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            initCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(33).append("\n               |  ").append(RssIntCodeGenColumnBuilder.class.getName()).append(" b").append(index).append(";\n          ").toString())).stripMargin());
            buildCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(86).append("\n               |  b").append(index).append(" = new ").append(RssIntCodeGenColumnBuilder.class.getName()).append("();\n               |  b").append(index).append(".initialize(").append(batchSize$1).append(", \"").append(schema$1.fields()[index].name()).append("\", false);\n          ").toString())).stripMargin());
            writeCode$1.append($this.genWriteCode(index));
            return writeRowCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("\n               |  b").append(index).append(".appendFrom(row, ").append(index).append(");\n          ").toString())).stripMargin());
        }
        if (LongType$.MODULE$.equals(dataType)) {
            initCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(33).append("\n               |  ").append(RssLongCodeGenColumnBuilder.class.getName()).append(" b").append(index).append(";\n          ").toString())).stripMargin());
            buildCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(86).append("\n               |  b").append(index).append(" = new ").append(RssLongCodeGenColumnBuilder.class.getName()).append("();\n               |  b").append(index).append(".initialize(").append(batchSize$1).append(", \"").append(schema$1.fields()[index].name()).append("\", false);\n          ").toString())).stripMargin());
            writeCode$1.append($this.genWriteCode(index));
            return writeRowCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("\n               |  b").append(index).append(".appendFrom(row, ").append(index).append(");\n          ").toString())).stripMargin());
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            initCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(33).append("\n               |  ").append(RssFloatCodeGenColumnBuilder.class.getName()).append(" b").append(index).append(";\n          ").toString())).stripMargin());
            buildCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(86).append("\n               |  b").append(index).append(" = new ").append(RssFloatCodeGenColumnBuilder.class.getName()).append("();\n               |  b").append(index).append(".initialize(").append(batchSize$1).append(", \"").append(schema$1.fields()[index].name()).append("\", false);\n          ").toString())).stripMargin());
            writeCode$1.append($this.genWriteCode(index));
            return writeRowCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("\n               |  b").append(index).append(".appendFrom(row, ").append(index).append(");\n          ").toString())).stripMargin());
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            initCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(33).append("\n               |  ").append(RssDoubleCodeGenColumnBuilder.class.getName()).append(" b").append(index).append(";\n          ").toString())).stripMargin());
            buildCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(86).append("\n               |  b").append(index).append(" = new ").append(RssDoubleCodeGenColumnBuilder.class.getName()).append("();\n               |  b").append(index).append(".initialize(").append(batchSize$1).append(", \"").append(schema$1.fields()[index].name()).append("\", false);\n          ").toString())).stripMargin());
            writeCode$1.append($this.genWriteCode(index));
            return writeRowCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("\n               |  b").append(index).append(".appendFrom(row, ").append(index).append(");\n          ").toString())).stripMargin());
        }
        if (StringType$.MODULE$.equals(dataType)) {
            initCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(33).append("\n               |  ").append(RssStringCodeGenColumnBuilder.class.getName()).append(" b").append(index).append(";\n          ").toString())).stripMargin());
            buildCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(86).append("\n               |  b").append(index).append(" = new ").append(RssStringCodeGenColumnBuilder.class.getName()).append("();\n               |  b").append(index).append(".initialize(").append(batchSize$1).append(", \"").append(schema$1.fields()[index].name()).append("\", false);\n          ").toString())).stripMargin());
            writeCode$1.append($this.genWriteCode(index));
            return writeRowCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("\n               |  b").append(index).append(".appendFrom(row, ").append(index).append(");\n          ").toString())).stripMargin());
        }
        if (dataType instanceof DecimalType) {
            bl = true;
            decimalType = (DecimalType)dataType;
            if (decimalType.precision() <= Decimal$.MODULE$.MAX_INT_DIGITS()) {
                initCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(33).append("\n               |  ").append(RssCompactMiniDecimalCodeGenColumnBuilder.class.getName()).append(" b").append(index).append(";\n          ").toString())).stripMargin());
                buildCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(131).append("\n               |  b").append(index).append(" =\n               |  new ").append(RssCompactMiniDecimalCodeGenColumnBuilder.class.getName()).append("(\n               |  new ").append(DecimalType.class.getName()).append("(").append(decimalType.precision()).append(", ").append(decimalType.scale()).append("));\n               |  b").append(index).append(".initialize(").append(batchSize$1).append(", \"").append(schema$1.fields()[index].name()).append("\", false);\n          ").toString())).stripMargin());
                writeCode$1.append($this.genWriteCode(index));
                return writeRowCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("\n               |  b").append(index).append(".appendFrom(row, ").append(index).append(");\n          ").toString())).stripMargin());
            }
        }
        if (bl && decimalType.precision() <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            initCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(33).append("\n               |  ").append(RssCompactDecimalCodeGenColumnBuilder.class.getName()).append(" b").append(index).append(";\n          ").toString())).stripMargin());
            buildCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(131).append("\n               |  b").append(index).append(" =\n               |  new ").append(RssCompactDecimalCodeGenColumnBuilder.class.getName()).append("\n               |  (new ").append(DecimalType.class.getName()).append("(").append(decimalType.precision()).append(", ").append(decimalType.scale()).append("));\n               |  b").append(index).append(".initialize(").append(batchSize$1).append(", \"").append(schema$1.fields()[index].name()).append("\", false);\n          ").toString())).stripMargin());
            writeCode$1.append($this.genWriteCode(index));
            return writeRowCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("\n               |  b").append(index).append(".appendFrom(row, ").append(index).append(");\n          ").toString())).stripMargin());
        }
        if (!bl) throw new MatchError((Object)dataType);
        initCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(33).append("\n               |  ").append(RssDecimalCodeGenColumnBuilder.class.getName()).append(" b").append(index).append(";\n          ").toString())).stripMargin());
        buildCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(113).append("\n               |  b").append(index).append(" = new ").append(RssDecimalCodeGenColumnBuilder.class.getName()).append("\n               |  (new ").append(DecimalType.class.getName()).append("(").append(decimalType.precision()).append(", ").append(decimalType.scale()).append("));\n               |  b").append(index).append(".initialize(").append(batchSize$1).append(", \"").append(schema$1.fields()[index].name()).append("\", false);\n          ").toString())).stripMargin());
        writeCode$1.append($this.genWriteCode(index));
        return writeRowCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("\n               |  b").append(index).append(".appendFrom(row, ").append(index).append(");\n          ").toString())).stripMargin());
    }
}

