/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.util;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.util.FrameDecoder;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBuf;
import org.apache.celeborn.shaded.io.netty.buffer.CompositeByteBuf;
import org.apache.celeborn.shaded.io.netty.buffer.Unpooled;
import org.apache.celeborn.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.celeborn.shaded.io.netty.channel.ChannelInboundHandlerAdapter;

public class TransportFrameDecoderWithBufferSupplier
extends ChannelInboundHandlerAdapter
implements FrameDecoder {
    private final Function<Integer, Supplier<ByteBuf>> bufferSuppliers;
    private int msgSize = -1;
    private int bodySize = -1;
    private Message.Type curType = Message.Type.UNKNOWN_TYPE;
    private ByteBuf headerBuf = Unpooled.buffer(9, 9);
    private CompositeByteBuf bodyBuf = null;
    private ByteBuf externalBuf = null;
    private final ByteBuf msgBuf = Unpooled.buffer(8);
    private Message curMsg = null;

    public TransportFrameDecoderWithBufferSupplier() {
        this.bufferSuppliers = new Function<Integer, Supplier<ByteBuf>>(){

            @Override
            public Supplier<ByteBuf> apply(final Integer size) {
                return new Supplier<ByteBuf>(){

                    @Override
                    public ByteBuf get() {
                        return Unpooled.buffer(size);
                    }
                };
            }
        };
    }

    public TransportFrameDecoderWithBufferSupplier(Function<Integer, Supplier<ByteBuf>> bufferSuppliers) {
        this.bufferSuppliers = bufferSuppliers;
    }

    private void copyByteBuf(ByteBuf source, ByteBuf target, int targetSize) {
        int bytes = Math.min(source.readableBytes(), targetSize - target.readableBytes());
        target.writeBytes(source, bytes);
    }

    private void decodeHeader(ByteBuf buf, ChannelHandlerContext ctx) {
        this.copyByteBuf(buf, this.headerBuf, 9);
        if (!this.headerBuf.isWritable()) {
            this.msgSize = this.headerBuf.readInt();
            if (this.msgBuf.capacity() < this.msgSize) {
                this.msgBuf.capacity(this.msgSize);
            }
            this.msgBuf.clear();
            this.curType = Message.Type.decode(this.headerBuf);
            this.bodySize = this.headerBuf.readInt();
            this.decodeMsg(buf, ctx);
        }
    }

    private void decodeMsg(ByteBuf buf, ChannelHandlerContext ctx) {
        if (this.msgBuf.readableBytes() < this.msgSize) {
            this.copyByteBuf(buf, this.msgBuf, this.msgSize);
        }
        if (this.msgBuf.readableBytes() == this.msgSize) {
            this.curMsg = Message.decode(this.curType, this.msgBuf, false);
            if (this.bodySize <= 0) {
                ctx.fireChannelRead(this.curMsg);
                this.clear();
            }
        }
    }

    private ByteBuf decodeBody(ByteBuf buf, ChannelHandlerContext ctx) {
        ByteBuf next;
        int remaining;
        if (this.bodyBuf == null) {
            if (buf.readableBytes() >= this.bodySize) {
                ByteBuf body = buf.retain().readSlice(this.bodySize);
                this.curMsg.setBody(body);
                ctx.fireChannelRead(this.curMsg);
                this.clear();
                return buf;
            }
            this.bodyBuf = buf.alloc().compositeBuffer(Integer.MAX_VALUE);
        }
        if ((remaining = this.bodySize - this.bodyBuf.readableBytes()) >= buf.readableBytes()) {
            next = buf;
            buf = null;
        } else {
            next = buf.retain().readSlice(remaining);
        }
        this.bodyBuf.addComponent(next).writerIndex(this.bodyBuf.writerIndex() + next.readableBytes());
        if (this.bodyBuf.readableBytes() == this.bodySize) {
            this.curMsg.setBody(this.bodyBuf);
            ctx.fireChannelRead(this.curMsg);
            this.clear();
        }
        return buf;
    }

    private ByteBuf decodeBodyCopyOut(ByteBuf buf, ChannelHandlerContext ctx) {
        if (this.externalBuf == null) {
            this.externalBuf = this.bufferSuppliers.apply(this.bodySize).get();
        }
        this.copyByteBuf(buf, this.externalBuf, this.bodySize);
        if (this.externalBuf.readableBytes() == this.bodySize) {
            this.curMsg.setBody(this.externalBuf);
            ctx.fireChannelRead(this.curMsg);
            this.clear();
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object data) {
        ByteBuf buf = (ByteBuf)data;
        try {
            while (buf != null && buf.isReadable()) {
                if (this.headerBuf.isWritable()) {
                    this.decodeHeader(buf, ctx);
                    continue;
                }
                if (this.curMsg == null) {
                    this.decodeMsg(buf, ctx);
                    continue;
                }
                if (this.bodySize <= 0) continue;
                if (this.curMsg.needCopyOut()) {
                    buf = this.decodeBodyCopyOut(buf, ctx);
                    continue;
                }
                buf = this.decodeBody(buf, ctx);
            }
        }
        finally {
            if (buf != null) {
                buf.release();
            }
        }
    }

    private void clear() {
        this.externalBuf = null;
        this.curMsg = null;
        this.curType = Message.Type.UNKNOWN_TYPE;
        this.headerBuf.clear();
        this.bodyBuf = null;
        this.bodySize = -1;
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.clear();
        if (this.externalBuf != null) {
            this.externalBuf.clear();
        }
        this.headerBuf.release();
        super.handlerRemoved(ctx);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
    }
}

