/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.server.memory;

import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.celeborn.common.network.server.memory.MemoryManager;
import org.apache.celeborn.common.network.server.memory.ReadBufferRequest;
import org.apache.celeborn.common.network.util.NettyUtils;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBuf;
import org.apache.celeborn.shaded.io.netty.buffer.PooledByteBufAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadBufferDispatcher
extends Thread {
    private Logger logger = LoggerFactory.getLogger(ReadBufferDispatcher.class);
    private final LinkedBlockingQueue<ReadBufferRequest> requests = new LinkedBlockingQueue();
    private final MemoryManager memoryManager;
    private final PooledByteBufAllocator readBufferAllocator = NettyUtils.createPooledByteBufAllocator(true, true, 1);

    public ReadBufferDispatcher(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
        this.setName("Read-Buffer-Dispatcher");
        this.start();
    }

    public void addBufferRequest(ReadBufferRequest request) {
        this.requests.add(request);
    }

    public void recycle(ByteBuf buf) {
        buf.release();
        int bufferSize = buf.capacity();
        this.memoryManager.changeReadBufferCounter(-1 * bufferSize);
    }

    @Override
    public void run() {
        while (true) {
            ReadBufferRequest request = null;
            try {
                request = this.requests.poll(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                this.logger.info("Buffer dispatcher is closing");
            }
            if (request != null) {
                ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>();
                int bufferSize = request.getBufferSize();
                while (buffers.size() < request.getMin()) {
                    if (this.memoryManager.readBufferAvailable(bufferSize)) {
                        this.memoryManager.incrementDiskBuffer(bufferSize);
                        buffers.add(this.readBufferAllocator.buffer(bufferSize, bufferSize));
                        continue;
                    }
                    try {
                        Thread.sleep(3L);
                    }
                    catch (InterruptedException e) {
                        this.logger.info("Buffer dispatcher is closing");
                        request.getBufferListener().notifyBuffers(null, e);
                        return;
                    }
                }
                while (this.memoryManager.readBufferAvailable(request.getBufferSize()) && buffers.size() < request.getMax()) {
                    this.memoryManager.changeReadBufferCounter(bufferSize);
                    buffers.add(this.readBufferAllocator.buffer(bufferSize, bufferSize));
                }
                request.getBufferListener().notifyBuffers(buffers, null);
                continue;
            }
            this.readBufferAllocator.trimCurrentThreadCache();
        }
    }
}

