/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.read;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.celeborn.client.read.PartitionReader;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;
import org.apache.celeborn.common.network.buffer.NettyManagedBuffer;
import org.apache.celeborn.common.network.client.ChunkReceivedCallback;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.OpenStream;
import org.apache.celeborn.common.network.protocol.StreamHandle;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.util.ExceptionUtils;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBuf;
import org.apache.celeborn.shaded.io.netty.util.ReferenceCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerPartitionReader
implements PartitionReader {
    private final Logger logger = LoggerFactory.getLogger(WorkerPartitionReader.class);
    private PartitionLocation location;
    private final TransportClientFactory clientFactory;
    private StreamHandle streamHandle;
    private int returnedChunks;
    private int chunkIndex;
    private final LinkedBlockingQueue<ByteBuf> results;
    private final ChunkReceivedCallback callback;
    private final AtomicReference<IOException> exception = new AtomicReference();
    private final int fetchMaxReqsInFlight;
    private boolean closed = false;
    private int fetchChunkRetryCnt;
    private int fetchChunkMaxRetry;
    private final boolean testFetch;

    WorkerPartitionReader(CelebornConf conf, String shuffleKey, PartitionLocation location, TransportClientFactory clientFactory, int startMapIndex, int endMapIndex, int fetchChunkRetryCnt, int fetchChunkMaxRetry) throws IOException {
        TransportClient client;
        this.fetchMaxReqsInFlight = conf.fetchMaxReqsInFlight();
        this.results = new LinkedBlockingQueue();
        this.callback = new ChunkReceivedCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(int chunkIndex, ManagedBuffer buffer) {
                1 var3_3 = this;
                synchronized (var3_3) {
                    ByteBuf buf = ((NettyManagedBuffer)buffer).getBuf();
                    if (!WorkerPartitionReader.this.closed) {
                        buf.retain();
                        WorkerPartitionReader.this.results.add(buf);
                    }
                }
            }

            @Override
            public void onFailure(int chunkIndex, Throwable e) {
                String errorMsg = "Fetch chunk " + chunkIndex + " failed.";
                WorkerPartitionReader.this.logger.error(errorMsg, e);
                WorkerPartitionReader.this.exception.set(new IOException(errorMsg, e));
            }
        };
        try {
            client = clientFactory.createClient(location.getHost(), location.getFetchPort());
        }
        catch (InterruptedException ie) {
            throw new IOException("Interrupted when createClient", ie);
        }
        OpenStream openBlocks = new OpenStream(shuffleKey, location.getFileName(), startMapIndex, endMapIndex);
        long timeoutMs = conf.fetchTimeoutMs();
        ByteBuffer response = client.sendRpcSync(openBlocks.toByteBuffer(), timeoutMs);
        this.streamHandle = (StreamHandle)Message.decode(response);
        this.location = location;
        this.clientFactory = clientFactory;
        this.fetchChunkRetryCnt = fetchChunkRetryCnt;
        this.fetchChunkMaxRetry = fetchChunkMaxRetry;
        this.testFetch = conf.testFetchFailure();
    }

    @Override
    public boolean hasNext() {
        return this.returnedChunks < this.streamHandle.numChunks;
    }

    @Override
    public ByteBuf next() throws IOException {
        this.checkException();
        if (this.chunkIndex < this.streamHandle.numChunks) {
            this.fetchChunks();
        }
        ByteBuf chunk = null;
        try {
            while (chunk == null) {
                this.checkException();
                chunk = this.results.poll(500L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            IOException ioe = new IOException(e);
            this.exception.set(ioe);
            throw ioe;
        }
        ++this.returnedChunks;
        return chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        WorkerPartitionReader workerPartitionReader = this;
        synchronized (workerPartitionReader) {
            this.closed = true;
        }
        if (this.results.size() > 0) {
            this.results.forEach(ReferenceCounted::release);
        }
        this.results.clear();
    }

    @Override
    public PartitionLocation getLocation() {
        return this.location;
    }

    private void fetchChunks() throws IOException {
        int inFlight = this.chunkIndex - this.returnedChunks;
        if (inFlight < this.fetchMaxReqsInFlight) {
            int toFetch = Math.min(this.fetchMaxReqsInFlight - inFlight + 1, this.streamHandle.numChunks - this.chunkIndex);
            for (int i = 0; i < toFetch; ++i) {
                if (this.testFetch && this.fetchChunkRetryCnt < this.fetchChunkMaxRetry - 1 && this.chunkIndex == 3) {
                    this.callback.onFailure(this.chunkIndex, new IOException("Test fetch chunk failure"));
                    continue;
                }
                try {
                    TransportClient client = this.clientFactory.createClient(this.location.getHost(), this.location.getFetchPort());
                    client.fetchChunk(this.streamHandle.streamId, this.chunkIndex, this.callback);
                    ++this.chunkIndex;
                    continue;
                }
                catch (IOException | InterruptedException e) {
                    this.logger.error("fetchChunk for streamId: {}, chunkIndex: {} failed.", new Object[]{this.streamHandle.streamId, this.chunkIndex, e});
                    ExceptionUtils.wrapAndThrowIOException(e);
                }
            }
        }
    }

    private void checkException() throws IOException {
        IOException e = this.exception.get();
        if (e != null) {
            throw e;
        }
    }
}

