/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.read;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.client.read.PartitionReader;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.OpenStream;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.util.ShuffleBlockInfoUtils;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBuf;
import org.apache.celeborn.shaded.io.netty.buffer.Unpooled;
import org.apache.celeborn.shaded.io.netty.util.ReferenceCounted;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DfsPartitionReader
implements PartitionReader {
    private static Logger logger = LoggerFactory.getLogger(DfsPartitionReader.class);
    PartitionLocation location;
    private final int shuffleChunkSize;
    private final int fetchMaxReqsInFlight;
    private final LinkedBlockingQueue<ByteBuf> results;
    private final AtomicReference<IOException> exception = new AtomicReference();
    private volatile boolean closed = false;
    private Thread fetchThread;
    private final FSDataInputStream hdfsInputStream;
    private int numChunks = 0;
    private final AtomicInteger currentChunkIndex = new AtomicInteger(0);

    public DfsPartitionReader(CelebornConf conf, String shuffleKey, PartitionLocation location, TransportClientFactory clientFactory, int startMapIndex, int endMapIndex) throws IOException {
        this.shuffleChunkSize = (int)conf.shuffleChunkSize();
        this.fetchMaxReqsInFlight = conf.fetchMaxReqsInFlight();
        this.results = new LinkedBlockingQueue();
        this.location = location;
        ArrayList<Long> chunkOffsets = new ArrayList<Long>();
        if (endMapIndex != Integer.MAX_VALUE) {
            long fetchTimeoutMs = conf.fetchTimeoutMs();
            try {
                TransportClient client = clientFactory.createClient(location.getHost(), location.getFetchPort());
                OpenStream openBlocks = new OpenStream(shuffleKey, location.getFileName(), startMapIndex, endMapIndex);
                ByteBuffer response = client.sendRpcSync(openBlocks.toByteBuffer(), fetchTimeoutMs);
                Message.decode(response);
            }
            catch (IOException | InterruptedException e) {
                throw new IOException("read shuffle file from hdfs failed, filePath: " + location.getStorageInfo().getFilePath(), e);
            }
            this.hdfsInputStream = ShuffleClient.getHdfsFs(conf).open(new Path(Utils.getSortedFilePath(location.getStorageInfo().getFilePath())));
            chunkOffsets.addAll(this.getChunkOffsetsFromSortedIndex(conf, location, startMapIndex, endMapIndex));
        } else {
            this.hdfsInputStream = ShuffleClient.getHdfsFs(conf).open(new Path(location.getStorageInfo().getFilePath()));
            chunkOffsets.addAll(this.getChunkOffsetsFromUnsortedIndex(conf, location));
        }
        if (chunkOffsets.size() > 1) {
            this.numChunks = chunkOffsets.size() - 1;
            this.fetchThread = new Thread(() -> {
                try {
                    while (!this.closed && this.currentChunkIndex.get() < this.numChunks) {
                        while (this.results.size() >= this.fetchMaxReqsInFlight) {
                            Thread.sleep(50L);
                        }
                        long offset = (Long)chunkOffsets.get(this.currentChunkIndex.get());
                        long length = (Long)chunkOffsets.get(this.currentChunkIndex.get() + 1) - offset;
                        byte[] buffer = new byte[(int)length];
                        this.hdfsInputStream.readFully(offset, buffer);
                        this.results.add(Unpooled.wrappedBuffer(buffer));
                        this.currentChunkIndex.incrementAndGet();
                    }
                }
                catch (IOException e) {
                    this.exception.set(e);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            this.fetchThread.start();
            logger.debug("Start dfs read on location {}", (Object)location);
        }
    }

    private List<Long> getChunkOffsetsFromUnsortedIndex(CelebornConf conf, PartitionLocation location) throws IOException {
        FSDataInputStream indexInputStream = ShuffleClient.getHdfsFs(conf).open(new Path(Utils.getIndexFilePath(location.getStorageInfo().getFilePath())));
        ArrayList<Long> offsets = new ArrayList<Long>();
        int offsetCount = indexInputStream.readInt();
        for (int i = 0; i < offsetCount; ++i) {
            offsets.add(indexInputStream.readLong());
        }
        indexInputStream.close();
        return offsets;
    }

    private List<Long> getChunkOffsetsFromSortedIndex(CelebornConf conf, PartitionLocation location, int startMapIndex, int endMapIndex) throws IOException {
        String indexPath = Utils.getIndexFilePath(location.getStorageInfo().getFilePath());
        FSDataInputStream indexInputStream = ShuffleClient.getHdfsFs(conf).open(new Path(indexPath));
        long indexSize = ShuffleClient.getHdfsFs(conf).getFileStatus(new Path(indexPath)).getLen();
        byte[] indexBuffer = new byte[(int)indexSize];
        indexInputStream.readFully(0L, indexBuffer);
        ArrayList<Long> offsets = new ArrayList<Long>(ShuffleBlockInfoUtils.getChunkOffsetsFromShuffleBlockInfos(startMapIndex, endMapIndex, this.shuffleChunkSize, ShuffleBlockInfoUtils.parseShuffleBlockInfosFromByteBuffer(indexBuffer)));
        indexInputStream.close();
        return offsets;
    }

    @Override
    public boolean hasNext() {
        return this.currentChunkIndex.get() < this.numChunks;
    }

    @Override
    public ByteBuf next() throws IOException {
        this.checkException();
        ByteBuf chunk = null;
        try {
            while (chunk == null) {
                this.checkException();
                chunk = this.results.poll(500L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            IOException ioe = new IOException(e);
            this.exception.set(ioe);
            throw ioe;
        }
        return chunk;
    }

    private void checkException() throws IOException {
        IOException e = this.exception.get();
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this.fetchThread.interrupt();
        try {
            this.hdfsInputStream.close();
        }
        catch (IOException e) {
            logger.warn("close hdfs input stream failed.", (Throwable)e);
        }
        if (this.results.size() > 0) {
            this.results.forEach(ReferenceCounted::release);
        }
        this.results.clear();
    }

    @Override
    public PartitionLocation getLocation() {
        return this.location;
    }
}

