/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.compress;

import org.apache.celeborn.client.compress.RssLz4Decompressor;
import org.apache.celeborn.client.compress.RssLz4Trait;
import org.apache.celeborn.client.compress.RssZstdDecompressor;
import org.apache.celeborn.client.compress.RssZstdTrait;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.protocol.CompressionCodec;

public interface Decompressor {
    public int decompress(byte[] var1, byte[] var2, int var3);

    public int getOriginalLen(byte[] var1);

    default public int readIntLE(byte[] buf, int i) {
        return buf[i] & 0xFF | (buf[i + 1] & 0xFF) << 8 | (buf[i + 2] & 0xFF) << 16 | (buf[i + 3] & 0xFF) << 24;
    }

    public static Decompressor getDecompressor(CelebornConf conf) {
        CompressionCodec codec = conf.shuffleCompressionCodec();
        switch (codec) {
            case LZ4: {
                return new RssLz4Decompressor();
            }
            case ZSTD: {
                return new RssZstdDecompressor();
            }
        }
        throw new IllegalArgumentException("Unknown compression codec: " + (Object)((Object)codec));
    }

    public static int getCompressionHeaderLength(CelebornConf conf) {
        CompressionCodec codec = conf.shuffleCompressionCodec();
        switch (codec) {
            case LZ4: {
                return RssLz4Trait.HEADER_LENGTH;
            }
            case ZSTD: {
                return RssZstdTrait.HEADER_LENGTH;
            }
        }
        throw new IllegalArgumentException("Unknown compression codec: " + (Object)((Object)codec));
    }
}

