/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client;

import java.io.IOException;
import java.util.Optional;
import org.apache.celeborn.client.ShuffleClientImpl;
import org.apache.celeborn.client.read.RssInputStream;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.rpc.RpcEndpointRef;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public abstract class ShuffleClient {
    private static volatile ShuffleClient _instance;
    private static volatile boolean initialized;
    private static volatile FileSystem hdfsFs;

    public static void reset() {
        _instance = null;
        initialized = false;
        hdfsFs = null;
    }

    protected ShuffleClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ShuffleClient get(RpcEndpointRef driverRef, CelebornConf conf, UserIdentifier userIdentifier) {
        if (null != _instance && initialized) return _instance;
        Class<ShuffleClient> clazz = ShuffleClient.class;
        synchronized (ShuffleClient.class) {
            if (null == _instance) {
                _instance = new ShuffleClientImpl(conf, userIdentifier);
                _instance.setupMetaServiceRef(driverRef);
                initialized = true;
            } else {
                if (initialized) return _instance;
                _instance.shutdown();
                _instance = new ShuffleClientImpl(conf, userIdentifier);
                _instance.setupMetaServiceRef(driverRef);
                initialized = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return _instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ShuffleClient get(String driverHost, int port, CelebornConf conf, UserIdentifier userIdentifier) {
        if (null != _instance && initialized) return _instance;
        Class<ShuffleClient> clazz = ShuffleClient.class;
        synchronized (ShuffleClient.class) {
            if (null == _instance) {
                _instance = new ShuffleClientImpl(conf, userIdentifier);
                _instance.setupMetaServiceRef(driverHost, port);
                initialized = true;
            } else {
                if (initialized) return _instance;
                _instance.shutdown();
                _instance = new ShuffleClientImpl(conf, userIdentifier);
                _instance.setupMetaServiceRef(driverHost, port);
                initialized = true;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return _instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileSystem getHdfsFs(CelebornConf conf) {
        if (null != hdfsFs) return hdfsFs;
        Class<ShuffleClient> clazz = ShuffleClient.class;
        synchronized (ShuffleClient.class) {
            if (null != hdfsFs) return hdfsFs;
            Configuration hdfsConfiguration = new Configuration();
            try {
                hdfsFs = FileSystem.get((Configuration)hdfsConfiguration);
            }
            catch (IOException e) {
                System.err.println("Rss initialize hdfs failed.");
                e.printStackTrace(System.err);
            }
            return hdfsFs;
        }
    }

    public abstract void setupMetaServiceRef(String var1, int var2);

    public abstract void setupMetaServiceRef(RpcEndpointRef var1);

    public abstract int pushData(String var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8, int var9, int var10) throws IOException;

    public abstract void prepareForMergeData(int var1, int var2, int var3) throws IOException;

    public abstract int mergeData(String var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8, int var9, int var10) throws IOException;

    public abstract void pushMergedData(String var1, int var2, int var3, int var4) throws IOException;

    public abstract void mapperEnd(String var1, int var2, int var3, int var4, int var5) throws IOException;

    public abstract void cleanup(String var1, int var2, int var3, int var4);

    public abstract RssInputStream readPartition(String var1, int var2, int var3, int var4, int var5, int var6) throws IOException;

    public abstract RssInputStream readPartition(String var1, int var2, int var3, int var4) throws IOException;

    public abstract boolean unregisterShuffle(String var1, int var2, boolean var3);

    public abstract void shutdown();

    public abstract Optional<PartitionLocation> regionStart(String var1, int var2, int var3, int var4, PartitionLocation var5, int var6, boolean var7) throws IOException;

    public abstract void regionFinish(String var1, int var2, int var3, int var4, PartitionLocation var5) throws IOException;

    public abstract void pushDataHandShake(String var1, int var2, int var3, int var4, int var5, int var6, PartitionLocation var7) throws IOException;

    static {
        initialized = false;
    }
}

