/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.protocol;

import java.io.Serializable;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.util.PackedPartitionId;
import org.roaringbitmap.RoaringBitmap;

public class PartitionLocation
implements Serializable {
    private int id;
    private int epoch;
    private String host;
    private int rpcPort;
    private int pushPort;
    private int fetchPort;
    private int replicatePort;
    private Mode mode;
    private PartitionLocation peer;
    private StorageInfo storageInfo;
    private RoaringBitmap mapIdBitMap;

    public static Mode getMode(byte mode) {
        if (mode == 0) {
            return Mode.MASTER;
        }
        return Mode.SLAVE;
    }

    public PartitionLocation(PartitionLocation loc) {
        this.id = loc.id;
        this.epoch = loc.epoch;
        this.host = loc.host;
        this.rpcPort = loc.rpcPort;
        this.pushPort = loc.pushPort;
        this.fetchPort = loc.fetchPort;
        this.replicatePort = loc.replicatePort;
        this.mode = loc.mode;
        this.peer = loc.peer;
        this.storageInfo = loc.storageInfo;
        this.mapIdBitMap = loc.mapIdBitMap;
    }

    public PartitionLocation(int id, int epoch, String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, Mode mode) {
        this(id, epoch, host, rpcPort, pushPort, fetchPort, replicatePort, mode, null, new StorageInfo(), new RoaringBitmap());
    }

    public PartitionLocation(int id, int epoch, String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, Mode mode, PartitionLocation peer) {
        this(id, epoch, host, rpcPort, pushPort, fetchPort, replicatePort, mode, peer, new StorageInfo(), new RoaringBitmap());
    }

    public PartitionLocation(int id, int epoch, String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, Mode mode, PartitionLocation peer, StorageInfo hint, RoaringBitmap mapIdBitMap) {
        this.id = id;
        this.epoch = epoch;
        this.host = host;
        this.rpcPort = rpcPort;
        this.pushPort = pushPort;
        this.fetchPort = fetchPort;
        this.replicatePort = replicatePort;
        this.mode = mode;
        this.peer = peer;
        this.storageInfo = hint;
        this.mapIdBitMap = mapIdBitMap;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getEpoch() {
        return this.epoch;
    }

    public void setEpoch(int epoch) {
        this.epoch = epoch;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPushPort() {
        return this.pushPort;
    }

    public void setPushPort(int pushPort) {
        this.pushPort = pushPort;
    }

    public int getFetchPort() {
        return this.fetchPort;
    }

    public void setFetchPort(int fetchPort) {
        this.fetchPort = fetchPort;
    }

    public String hostAndPorts() {
        return "host-rpcPort-pushPort-fetchPort-replicatePort:" + this.host + "-" + this.rpcPort + "-" + this.pushPort + "-" + this.fetchPort + "-" + this.replicatePort;
    }

    public String hostAndPushPort() {
        return this.host + ":" + this.pushPort;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public PartitionLocation getPeer() {
        return this.peer;
    }

    public void setPeer(PartitionLocation peer) {
        this.peer = peer;
    }

    public String getUniqueId() {
        return this.id + "-" + this.epoch;
    }

    public String getFileName() {
        return this.id + "-" + this.epoch + "-" + this.mode.mode;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public void setRpcPort(int rpcPort) {
        this.rpcPort = rpcPort;
    }

    public int getReplicatePort() {
        return this.replicatePort;
    }

    public void setReplicatePort(int replicatePort) {
        this.replicatePort = replicatePort;
    }

    public StorageInfo getStorageInfo() {
        return this.storageInfo;
    }

    public void setStorageInfo(StorageInfo storageInfo) {
        this.storageInfo = storageInfo;
    }

    public boolean equals(Object other) {
        if (!(other instanceof PartitionLocation)) {
            return false;
        }
        PartitionLocation o = (PartitionLocation)other;
        return this.id == o.id && this.epoch == o.epoch && this.host.equals(o.host) && this.rpcPort == o.rpcPort && this.pushPort == o.pushPort && this.fetchPort == o.fetchPort;
    }

    public int hashCode() {
        return (this.id + this.epoch + this.host + this.rpcPort + this.pushPort + this.fetchPort).hashCode();
    }

    public String toString() {
        String peerAddr = "empty";
        if (this.peer != null) {
            peerAddr = this.peer.hostAndPorts();
        }
        return "PartitionLocation[\n  id(rawId-attemptId)-epoch:" + this.id + "(" + this.getRawId() + "-" + this.getAttemptId() + ")-" + this.epoch + "\n  host-rpcPort-pushPort-fetchPort-replicatePort:" + this.host + "-" + this.rpcPort + "-" + this.pushPort + "-" + this.fetchPort + "-" + this.replicatePort + "\n  mode:" + (Object)((Object)this.mode) + "\n  peer:(" + peerAddr + ")\n  storage hint:" + this.storageInfo + "\n  mapIdBitMap:" + this.mapIdBitMap + "]";
    }

    public WorkerInfo getWorker() {
        return new WorkerInfo(this.host, this.rpcPort, this.pushPort, this.fetchPort, this.replicatePort);
    }

    public RoaringBitmap getMapIdBitMap() {
        return this.mapIdBitMap;
    }

    public void setMapIdBitMap(RoaringBitmap mapIdBitMap) {
        this.mapIdBitMap = mapIdBitMap;
    }

    public int getRawId() {
        return PackedPartitionId.getRawPartitionId(this.id);
    }

    public int getAttemptId() {
        return PackedPartitionId.getAttemptId(this.id);
    }

    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode MASTER = new Mode(0);
        public static final /* enum */ Mode SLAVE = new Mode(1);
        private final byte mode;
        private static final /* synthetic */ Mode[] $VALUES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String name) {
            return Enum.valueOf(Mode.class, name);
        }

        private Mode(int id) {
            assert (id < 128) : "Cannot have more than 128 message types";
            this.mode = (byte)id;
        }

        public byte mode() {
            return this.mode;
        }

        static {
            $VALUES = new Mode[]{MASTER, SLAVE};
        }
    }
}

