/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.util;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.PoolArenaMetric;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocatorMetric;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.network.util.TransportConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyMemoryMetrics {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PooledByteBufAllocator pooledAllocator;
    private final boolean verboseMetricsEnabled;
    private final String metricPrefix;
    private final AbstractSource source;
    @VisibleForTesting
    static final Set<String> VERBOSE_METRICS = new HashSet<String>();

    public NettyMemoryMetrics(PooledByteBufAllocator pooledAllocator, String metricPrefix, TransportConf conf, AbstractSource source) {
        this.pooledAllocator = pooledAllocator;
        this.metricPrefix = metricPrefix;
        this.verboseMetricsEnabled = conf.verboseMetrics();
        this.source = source;
        this.registerMetrics(this.pooledAllocator);
    }

    private void registerMetrics(PooledByteBufAllocator allocator) {
        PooledByteBufAllocatorMetric pooledAllocatorMetric = allocator.metric();
        if (this.source != null) {
            this.logger.debug("setup netty metrics");
            this.source.addGauge(MetricRegistry.name((String)this.metricPrefix, (String[])new String[]{"usedHeapMemory"}), () -> ((PooledByteBufAllocatorMetric)pooledAllocatorMetric).usedHeapMemory());
            this.source.addGauge(MetricRegistry.name((String)this.metricPrefix, (String[])new String[]{"usedDirectMemory"}), () -> ((PooledByteBufAllocatorMetric)pooledAllocatorMetric).usedDirectMemory());
            if (this.verboseMetricsEnabled) {
                int directArenaIndex = 0;
                for (PoolArenaMetric metric : pooledAllocatorMetric.directArenas()) {
                    this.registerArenaMetric(metric, "directArena" + directArenaIndex);
                    ++directArenaIndex;
                }
                int heapArenaIndex = 0;
                for (PoolArenaMetric metric : pooledAllocatorMetric.heapArenas()) {
                    this.registerArenaMetric(metric, "heapArena" + heapArenaIndex);
                    ++heapArenaIndex;
                }
            }
        }
    }

    private void registerArenaMetric(PoolArenaMetric arenaMetric, String arenaName) {
        for (String methodName : VERBOSE_METRICS) {
            Method m;
            try {
                m = PoolArenaMetric.class.getMethod(methodName, new Class[0]);
            }
            catch (Exception e) {
                continue;
            }
            if (!Modifier.isPublic(m.getModifiers())) continue;
            Class<?> returnType = m.getReturnType();
            String metricName = MetricRegistry.name((String)this.metricPrefix, (String[])new String[]{arenaName, m.getName()});
            if (returnType.equals(Integer.TYPE)) {
                this.source.addGauge(metricName, () -> {
                    try {
                        return (Integer)m.invoke((Object)arenaMetric, new Object[0]);
                    }
                    catch (Exception e) {
                        return -1;
                    }
                });
                continue;
            }
            if (!returnType.equals(Long.TYPE)) continue;
            this.source.addGauge(metricName, () -> {
                try {
                    return (Long)m.invoke((Object)arenaMetric, new Object[0]);
                }
                catch (Exception e) {
                    return -1L;
                }
            });
        }
    }

    static {
        VERBOSE_METRICS.addAll(Arrays.asList("numAllocations", "numTinyAllocations", "numSmallAllocations", "numNormalAllocations", "numHugeAllocations", "numDeallocations", "numTinyDeallocations", "numSmallDeallocations", "numNormalDeallocations", "numHugeDeallocations", "numActiveAllocations", "numActiveTinyAllocations", "numActiveSmallAllocations", "numActiveNormalAllocations", "numActiveHugeAllocations", "numActiveBytes"));
    }
}

