/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.celeborn.common.network.TransportContext;
import org.apache.celeborn.common.network.util.IOMode;
import org.apache.celeborn.common.network.util.JavaUtils;
import org.apache.celeborn.common.network.util.NettyUtils;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportServer
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(TransportServer.class);
    private final TransportContext context;
    private final TransportConf conf;
    private ServerBootstrap bootstrap;
    private ChannelFuture channelFuture;
    private int port = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportServer(TransportContext context, String hostToBind, int portToBind) {
        this.context = context;
        this.conf = context.getConf();
        boolean shouldClose = true;
        try {
            this.init(hostToBind, portToBind);
            shouldClose = false;
        }
        finally {
            if (shouldClose) {
                JavaUtils.closeQuietly(this);
            }
        }
    }

    public int getPort() {
        if (this.port == -1) {
            throw new IllegalStateException("Server not initialized");
        }
        return this.port;
    }

    private void init(String hostToBind, int portToBind) {
        IOMode ioMode = IOMode.valueOf(this.conf.ioMode());
        EventLoopGroup bossGroup = NettyUtils.createEventLoop(ioMode, 1, this.conf.getModuleName() + "-boss");
        EventLoopGroup workerGroup = NettyUtils.createEventLoop(ioMode, this.conf.serverThreads(), this.conf.getModuleName() + "-server");
        PooledByteBufAllocator allocator = NettyUtils.createPooledByteBufAllocator(this.conf.preferDirectBufs(), true, this.conf.serverThreads());
        this.bootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(bossGroup, workerGroup).channel(NettyUtils.getServerChannelClass(ioMode))).option(ChannelOption.ALLOCATOR, (Object)allocator)).option(ChannelOption.SO_REUSEADDR, (Object)(!SystemUtils.IS_OS_WINDOWS ? 1 : 0))).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)allocator);
        if (this.conf.backLog() > 0) {
            this.bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.conf.backLog());
        }
        if (this.conf.receiveBuf() > 0) {
            this.bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.conf.receiveBuf());
        }
        if (this.conf.sendBuf() > 0) {
            this.bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.conf.sendBuf());
        }
        this.initializeChannel(this.bootstrap);
        InetSocketAddress address = hostToBind == null ? new InetSocketAddress(portToBind) : new InetSocketAddress(hostToBind, portToBind);
        this.channelFuture = this.bootstrap.bind((SocketAddress)address);
        this.channelFuture.syncUninterruptibly();
        this.port = ((InetSocketAddress)this.channelFuture.channel().localAddress()).getPort();
        logger.debug("Shuffle server started on port: {}", (Object)this.port);
    }

    protected void initializeChannel(ServerBootstrap bootstrap) {
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                TransportServer.this.context.initializePipeline(ch);
            }
        });
    }

    @Override
    public void close() {
        if (this.channelFuture != null) {
            this.channelFuture.channel().close().awaitUninterruptibly(10L, TimeUnit.SECONDS);
            this.channelFuture = null;
        }
        if (this.bootstrap != null && this.bootstrap.config().group() != null) {
            this.bootstrap.config().group().shutdownGracefully();
        }
        if (this.bootstrap != null && this.bootstrap.config().childGroup() != null) {
            this.bootstrap.config().childGroup().shutdownGracefully();
        }
        this.bootstrap = null;
    }
}

