/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.metrics.source;

import com.codahale.metrics.Gauge;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.metrics.source.JVMCPUSource$;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001)3Aa\u0003\u0007\u00013!Aa\u0004\u0001B\u0001B\u0003%q\u0004\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0011\u0015\t\u0004\u0001\"\u00013\u0011\u001d1\u0004A1A\u0005B]Baa\u0010\u0001!\u0002\u0013At!\u0002!\r\u0011\u0003\te!B\u0006\r\u0011\u0003\u0011\u0005\"B\u0019\b\t\u00039\u0005b\u0002%\b\u0005\u0004%\ta\u000e\u0005\u0007\u0013\u001e\u0001\u000b\u0011\u0002\u001d\u0003\u0019)3Vj\u0011)V'>,(oY3\u000b\u00055q\u0011AB:pkJ\u001cWM\u0003\u0002\u0010!\u00059Q.\u001a;sS\u000e\u001c(BA\t\u0013\u0003\u0019\u0019w.\\7p]*\u00111\u0003F\u0001\tG\u0016dWMY8s]*\u0011QCF\u0001\u0007CB\f7\r[3\u000b\u0003]\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000e\u0011\u0005maR\"\u0001\u0007\n\u0005ua!AD!cgR\u0014\u0018m\u0019;T_V\u00148-Z\u0001\u0005G>tg\r\u0005\u0002!C5\t\u0001#\u0003\u0002#!\ta1)\u001a7fE>\u0014hnQ8oM\u0006!!o\u001c7f!\t)cF\u0004\u0002'YA\u0011qEK\u0007\u0002Q)\u0011\u0011\u0006G\u0001\u0007yI|w\u000e\u001e \u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0002\rA\u0013X\rZ3g\u0013\ty\u0003G\u0001\u0004TiJLgn\u001a\u0006\u0003[)\na\u0001P5oSRtDcA\u001a5kA\u00111\u0004\u0001\u0005\u0006=\r\u0001\ra\b\u0005\u0006G\r\u0001\r\u0001J\u0001\u000bg>,(oY3OC6,W#\u0001\u001d\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014\u0001\u00027b]\u001eT\u0011!P\u0001\u0005U\u00064\u0018-\u0003\u00020u\u0005Y1o\\;sG\u0016t\u0015-\\3!\u00031Qe+T\"Q+N{WO]2f!\tYra\u0005\u0002\b\u0007B\u0011A)R\u0007\u0002U%\u0011aI\u000b\u0002\u0007\u0003:L(+\u001a4\u0015\u0003\u0005\u000b!B\u0013,N\u0007B+F+[7f\u0003-Qe+T\"Q+RKW.\u001a\u0011")
public class JVMCPUSource
extends AbstractSource {
    private final String sourceName;

    public static String JVMCPUTime() {
        return JVMCPUSource$.MODULE$.JVMCPUTime();
    }

    @Override
    public String sourceName() {
        return this.sourceName;
    }

    public JVMCPUSource(CelebornConf conf, String role) {
        super(conf, role);
        this.sourceName = "CPU";
        this.addGauge(JVMCPUSource$.MODULE$.JVMCPUTime(), new Gauge<Object>(null){
            private final MBeanServer mBean;
            private final ObjectName name;

            public MBeanServer mBean() {
                return this.mBean;
            }

            public ObjectName name() {
                return this.name;
            }

            public long getValue() {
                long l;
                try {
                    l = BoxesRunTime.unboxToLong((Object)this.mBean().getAttribute(this.name(), "ProcessCpuTime"));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    long l2 = -1L;
                    l = l2;
                }
                return l;
            }
            {
                this.mBean = ManagementFactory.getPlatformMBeanServer();
                this.name = new ObjectName("java.lang", "type", "OperatingSystem");
            }
        });
        this.startCleaner();
    }
}

