/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.rpc.netty;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.apache.celeborn.common.exception.CelebornException;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.network.client.RpcResponseCallback;
import org.apache.celeborn.common.rpc.RpcEndpoint;
import org.apache.celeborn.common.rpc.RpcEndpointAddress;
import org.apache.celeborn.common.rpc.RpcEndpointRef;
import org.apache.celeborn.common.rpc.RpcEnvStoppedException;
import org.apache.celeborn.common.rpc.netty.Inbox;
import org.apache.celeborn.common.rpc.netty.InboxMessage;
import org.apache.celeborn.common.rpc.netty.LocalNettyRpcCallContext;
import org.apache.celeborn.common.rpc.netty.NettyRpcEndpointRef;
import org.apache.celeborn.common.rpc.netty.NettyRpcEnv;
import org.apache.celeborn.common.rpc.netty.OneWayMessage;
import org.apache.celeborn.common.rpc.netty.RemoteNettyRpcCallContext;
import org.apache.celeborn.common.rpc.netty.RequestMessage;
import org.apache.celeborn.common.rpc.netty.RpcMessage;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.concurrent.Promise;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tEb!B\u0016-\u0001IB\u0004\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u0011-\u0003!\u0011!Q\u0001\n1CQa\u0014\u0001\u0005\u0002A3A\u0001\u0016\u0001\u0005+\"Aa\u000b\u0002BC\u0002\u0013\u0005q\u000b\u0003\u0005d\t\t\u0005\t\u0015!\u0003Y\u0011!!GA!b\u0001\n\u0003)\u0007\u0002\u00036\u0005\u0005\u0003\u0005\u000b\u0011\u00024\t\u0011-$!Q1A\u0005\u00021D\u0001\u0002\u001d\u0003\u0003\u0002\u0003\u0006I!\u001c\u0005\u0006\u001f\u0012!\t!\u001d\u0005\bo\u0012\u0011\r\u0011\"\u0001y\u0011\u0019aH\u0001)A\u0005s\"9Q\u0010\u0001b\u0001\n\u0013q\bbBA\n\u0001\u0001\u0006Ia \u0005\n\u0003+\u0001!\u0019!C\u0005\u0003/A\u0001\"!\t\u0001A\u0003%\u0011\u0011\u0004\u0005\n\u0003G\u0001!\u0019!C\u0005\u0003KA\u0001\"!\f\u0001A\u0003%\u0011q\u0005\u0005\n\u0003_\u0001\u0001\u0019!C\u0005\u0003cA\u0011\"!\u000f\u0001\u0001\u0004%I!a\u000f\t\u0011\u0005\u001d\u0003\u0001)Q\u0005\u0003gAq!a\u0019\u0001\t\u0003\t)\u0007C\u0004\u0002l\u0001!\t!!\u001c\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t!9\u0011q\u000f\u0001\u0005\n\u0005e\u0004bBA?\u0001\u0011\u0005\u0011q\u0010\u0005\b\u0003\u000b\u0003A\u0011AAD\u0011\u001d\t\u0019\n\u0001C\u0001\u0003+Cq!a-\u0001\t\u0003\t)\fC\u0004\u0002N\u0002!\t!a4\t\u000f\u0005M\u0007\u0001\"\u0001\u0002V\"9\u0011Q\u0010\u0001\u0005\u0002\u0005e\bbBA~\u0001\u0011\u0005\u0011\u0011 \u0005\b\u0003{\u0004A\u0011AA\u0000\u0011%\u0011\u0019\u0001\u0001b\u0001\n\u0013\u0011)\u0001\u0003\u0005\u0003\u000e\u0001\u0001\u000b\u0011\u0002B\u0004\r\u0019\u0011y\u0001\u0001\u0003\u0003\u0012!1qJ\nC\u0001\u0005KAqA!\u000b'\t\u0003\nI\u0010C\u0005\u0003,\u0001\u0011\r\u0011\"\u0003\u0003.!9!q\u0006\u0001!\u0002\u0013\u0011(A\u0003#jgB\fGo\u00195fe*\u0011QFL\u0001\u0006]\u0016$H/\u001f\u0006\u0003_A\n1A\u001d9d\u0015\t\t$'\u0001\u0004d_6lwN\u001c\u0006\u0003gQ\n\u0001bY3mK\n|'O\u001c\u0006\u0003kY\na!\u00199bG\",'\"A\u001c\u0002\u0007=\u0014xmE\u0002\u0001s}\u0002\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012a!\u00118z%\u00164\u0007C\u0001!D\u001b\u0005\t%B\u0001\"1\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001#B\u0005\u001daunZ4j]\u001e\f\u0001B\\3uif,eN^\u0002\u0001!\tA\u0015*D\u0001-\u0013\tQEFA\u0006OKR$\u0018P\u00159d\u000b:4\u0018A\u00048v[V\u001b\u0018M\u00197f\u0007>\u0014Xm\u001d\t\u0003u5K!AT\u001e\u0003\u0007%sG/\u0001\u0004=S:LGO\u0010\u000b\u0004#J\u001b\u0006C\u0001%\u0001\u0011\u0015)5\u00011\u0001H\u0011\u0015Y5\u00011\u0001M\u00051)e\u000e\u001a9pS:$H)\u0019;b'\t!\u0011(\u0001\u0003oC6,W#\u0001-\u0011\u0005e\u0003gB\u0001._!\tY6(D\u0001]\u0015\tif)\u0001\u0004=e>|GOP\u0005\u0003?n\na\u0001\u0015:fI\u00164\u0017BA1c\u0005\u0019\u0019FO]5oO*\u0011qlO\u0001\u0006]\u0006lW\rI\u0001\tK:$\u0007o\\5oiV\ta\r\u0005\u0002hQ6\ta&\u0003\u0002j]\tY!\u000b]2F]\u0012\u0004x.\u001b8u\u0003%)g\u000e\u001a9pS:$\b%A\u0002sK\u001a,\u0012!\u001c\t\u0003\u0011:L!a\u001c\u0017\u0003'9+G\u000f^=Sa\u000e,e\u000e\u001a9pS:$(+\u001a4\u0002\tI,g\r\t\u000b\u0005eR,h\u000f\u0005\u0002t\t5\t\u0001\u0001C\u0003W\u0017\u0001\u0007\u0001\fC\u0003e\u0017\u0001\u0007a\rC\u0003l\u0017\u0001\u0007Q.A\u0003j]\n|\u00070F\u0001z!\tA%0\u0003\u0002|Y\t)\u0011J\u001c2pq\u00061\u0011N\u001c2pq\u0002\n\u0011\"\u001a8ea>Lg\u000e^:\u0016\u0003}\u0004b!!\u0001\u0002\u0010a\u0013XBAA\u0002\u0015\u0011\t)!a\u0002\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002\n\u0005-\u0011\u0001B;uS2T!!!\u0004\u0002\t)\fg/Y\u0005\u0005\u0003#\t\u0019AA\u0007D_:\u001cWO\u001d:f]Rl\u0015\r]\u0001\u000bK:$\u0007o\\5oiN\u0004\u0013\u0001D3oIB|\u0017N\u001c;SK\u001a\u001cXCAA\r!\u001d\t\t!a\u0004g\u00037\u00012aZA\u000f\u0013\r\tyB\f\u0002\u000f%B\u001cWI\u001c3q_&tGOU3g\u00035)g\u000e\u001a9pS:$(+\u001a4tA\u0005I!/Z2fSZ,'o]\u000b\u0003\u0003O\u0001R!!\u0001\u0002*ILA!a\u000b\u0002\u0004\t\u0019B*\u001b8lK\u0012\u0014En\\2lS:<\u0017+^3vK\u0006Q!/Z2fSZ,'o\u001d\u0011\u0002\u000fM$x\u000e\u001d9fIV\u0011\u00111\u0007\t\u0004u\u0005U\u0012bAA\u001cw\t9!i\\8mK\u0006t\u0017aC:u_B\u0004X\rZ0%KF$B!!\u0010\u0002DA\u0019!(a\u0010\n\u0007\u0005\u00053H\u0001\u0003V]&$\b\"CA#+\u0005\u0005\t\u0019AA\u001a\u0003\rAH%M\u0001\tgR|\u0007\u000f]3eA!:a#a\u0013\u0002^\u0005}\u0003\u0003BA'\u00033j!!a\u0014\u000b\t\u0005\u0015\u0011\u0011\u000b\u0006\u0005\u0003'\n)&\u0001\u0006b]:|G/\u0019;j_:T!!a\u0016\u0002\u000b)\fg/\u0019=\n\t\u0005m\u0013q\n\u0002\n\u000fV\f'\u000fZ3e\u0005f\fQA^1mk\u0016\f#!!\u0019\u0002\tQD\u0017n]\u0001\u0014e\u0016<\u0017n\u001d;feJ\u00038-\u00128ea>Lg\u000e\u001e\u000b\u0006[\u0006\u001d\u0014\u0011\u000e\u0005\u0006-^\u0001\r\u0001\u0017\u0005\u0006I^\u0001\rAZ\u0001\u0012O\u0016$(\u000b]2F]\u0012\u0004x.\u001b8u%\u00164G\u0003BA\u000e\u0003_BQ\u0001\u001a\rA\u0002\u0019\fAC]3n_Z,'\u000b]2F]\u0012\u0004x.\u001b8u%\u00164G\u0003BA\u001f\u0003kBQ\u0001Z\rA\u0002\u0019\fQ#\u001e8sK\u001eL7\u000f^3s%B\u001cWI\u001c3q_&tG\u000f\u0006\u0003\u0002>\u0005m\u0004\"\u0002,\u001b\u0001\u0004A\u0016\u0001B:u_B$B!!\u0010\u0002\u0002\"9\u00111Q\u000eA\u0002\u0005m\u0011A\u0004:qG\u0016sG\r]8j]R\u0014VMZ\u0001\na>\u001cH\u000fV8BY2$B!!\u0010\u0002\n\"9\u00111\u0012\u000fA\u0002\u00055\u0015aB7fgN\fw-\u001a\t\u0004\u0011\u0006=\u0015bAAIY\ta\u0011J\u001c2pq6+7o]1hK\u0006\t\u0002o\\:u%\u0016lw\u000e^3NKN\u001c\u0018mZ3\u0015\r\u0005u\u0012qSAP\u0011\u001d\tY)\ba\u0001\u00033\u00032\u0001SAN\u0013\r\ti\n\f\u0002\u000f%\u0016\fX/Z:u\u001b\u0016\u001c8/Y4f\u0011\u001d\t\t+\ba\u0001\u0003G\u000b\u0001bY1mY\n\f7m\u001b\t\u0005\u0003K\u000by+\u0004\u0002\u0002(*!\u0011\u0011VAV\u0003\u0019\u0019G.[3oi*\u0019\u0011Q\u0016\u0019\u0002\u000f9,Go^8sW&!\u0011\u0011WAT\u0005M\u0011\u0006o\u0019*fgB|gn]3DC2d'-Y2l\u0003A\u0001xn\u001d;M_\u000e\fG.T3tg\u0006<W\r\u0006\u0004\u0002>\u0005]\u0016\u0011\u0018\u0005\b\u0003\u0017s\u0002\u0019AAM\u0011\u001d\tYL\ba\u0001\u0003{\u000b\u0011\u0001\u001d\t\u0007\u0003\u007f\u000b\u0019-a2\u000e\u0005\u0005\u0005'bAA\u0003w%!\u0011QYAa\u0005\u001d\u0001&o\\7jg\u0016\u00042AOAe\u0013\r\tYm\u000f\u0002\u0004\u0003:L\u0018!\u00059pgR|e.Z,bs6+7o]1hKR!\u0011QHAi\u0011\u001d\tYi\ba\u0001\u00033\u000b1\u0002]8ti6+7o]1hKRA\u0011QHAl\u00037\fi\u000e\u0003\u0004\u0002Z\u0002\u0002\r\u0001W\u0001\rK:$\u0007o\\5oi:\u000bW.\u001a\u0005\b\u0003\u0017\u0003\u0003\u0019AAG\u0011\u001d\ty\u000e\ta\u0001\u0003C\f\u0011cY1mY\n\f7m[%g'R|\u0007\u000f]3e!\u001dQ\u00141]At\u0003{I1!!:<\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002j\u0006Mh\u0002BAv\u0003_t1aWAw\u0013\u0005a\u0014bAAyw\u00059\u0001/Y2lC\u001e,\u0017\u0002BA{\u0003o\u0014\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005E8\b\u0006\u0002\u0002>\u0005\u0001\u0012m^1jiR+'/\\5oCRLwN\\\u0001\u0007m\u0016\u0014\u0018NZ=\u0015\t\u0005M\"\u0011\u0001\u0005\u0006-\u000e\u0002\r\u0001W\u0001\u000bi\"\u0014X-\u00193q_>dWC\u0001B\u0004!\u0011\t\tA!\u0003\n\t\t-\u00111\u0001\u0002\u0013)\"\u0014X-\u00193Q_>dW\t_3dkR|'/A\u0006uQJ,\u0017\r\u001a9p_2\u0004#aC'fgN\fw-\u001a'p_B\u001cRA\nB\n\u0005?\u0001BA!\u0006\u0003\u001c5\u0011!q\u0003\u0006\u0005\u00053\tY!\u0001\u0003mC:<\u0017\u0002\u0002B\u000f\u0005/\u0011aa\u00142kK\u000e$\b\u0003\u0002B\u000b\u0005CIAAa\t\u0003\u0018\tA!+\u001e8oC\ndW\r\u0006\u0002\u0003(A\u00111OJ\u0001\u0004eVt\u0017A\u0003)pSN|g\u000eU5mYV\t!/A\u0006Q_&\u001cxN\u001c)jY2\u0004\u0003")
public class Dispatcher
implements Logging {
    private final NettyRpcEnv nettyEnv;
    private final ConcurrentMap<String, EndpointData> endpoints;
    private final ConcurrentMap<RpcEndpoint, RpcEndpointRef> endpointRefs;
    private final LinkedBlockingQueue<EndpointData> org$apache$celeborn$common$rpc$netty$Dispatcher$$receivers;
    @GuardedBy(value="this")
    private boolean stopped;
    private final ThreadPoolExecutor org$apache$celeborn$common$rpc$netty$Dispatcher$$threadpool;
    private final EndpointData org$apache$celeborn$common$rpc$netty$Dispatcher$$PoisonPill;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    private ConcurrentMap<String, EndpointData> endpoints() {
        return this.endpoints;
    }

    private ConcurrentMap<RpcEndpoint, RpcEndpointRef> endpointRefs() {
        return this.endpointRefs;
    }

    public LinkedBlockingQueue<EndpointData> org$apache$celeborn$common$rpc$netty$Dispatcher$$receivers() {
        return this.org$apache$celeborn$common$rpc$netty$Dispatcher$$receivers;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    public NettyRpcEndpointRef registerRpcEndpoint(String name, RpcEndpoint endpoint) {
        RpcEndpointAddress addr = new RpcEndpointAddress(this.nettyEnv.address(), name);
        NettyRpcEndpointRef endpointRef = new NettyRpcEndpointRef(this.nettyEnv.conf(), addr, this.nettyEnv);
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            if (this.stopped()) {
                throw new IllegalStateException("RpcEnv has been stopped");
            }
            if (this.endpoints().putIfAbsent(name, new EndpointData(this, name, endpoint, endpointRef)) != null) {
                throw new IllegalArgumentException(new StringBuilder(39).append("There is already an RpcEndpoint called ").append(name).toString());
            }
            EndpointData data = (EndpointData)this.endpoints().get(name);
            this.endpointRefs().put(data.endpoint(), data.ref());
            this.org$apache$celeborn$common$rpc$netty$Dispatcher$$receivers().offer(data);
        }
        return endpointRef;
    }

    public RpcEndpointRef getRpcEndpointRef(RpcEndpoint endpoint) {
        return (RpcEndpointRef)this.endpointRefs().get(endpoint);
    }

    public void removeRpcEndpointRef(RpcEndpoint endpoint) {
        this.endpointRefs().remove(endpoint);
    }

    private void unregisterRpcEndpoint(String name) {
        block0: {
            EndpointData data = (EndpointData)this.endpoints().remove(name);
            if (data == null) break block0;
            data.inbox().stop();
            this.org$apache$celeborn$common$rpc$netty$Dispatcher$$receivers().offer(data);
        }
    }

    public synchronized void stop(RpcEndpointRef rpcEndpointRef) {
        if (this.stopped()) {
            return;
        }
        this.unregisterRpcEndpoint(rpcEndpointRef.name());
    }

    public void postToAll(InboxMessage message) {
        for (String name : this.endpoints().keySet()) {
            this.postMessage(name, message, (Function1<Exception, BoxedUnit>)(Function1 & Serializable & scala.Serializable)e -> {
                Dispatcher.$anonfun$postToAll$1(this, message, e);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void postRemoteMessage(RequestMessage message, RpcResponseCallback callback) {
        RemoteNettyRpcCallContext rpcCallContext = new RemoteNettyRpcCallContext(this.nettyEnv, callback, message.senderAddress());
        RpcMessage rpcMessage = new RpcMessage(message.senderAddress(), message.content(), rpcCallContext);
        this.postMessage(message.receiver().name(), rpcMessage, (Function1<Exception, BoxedUnit>)(Function1 & Serializable & scala.Serializable)e -> {
            callback.onFailure(e);
            return BoxedUnit.UNIT;
        });
    }

    public void postLocalMessage(RequestMessage message, Promise<Object> p) {
        LocalNettyRpcCallContext rpcCallContext = new LocalNettyRpcCallContext(message.senderAddress(), p);
        RpcMessage rpcMessage = new RpcMessage(message.senderAddress(), message.content(), rpcCallContext);
        this.postMessage(message.receiver().name(), rpcMessage, (Function1<Exception, BoxedUnit>)(Function1 & Serializable & scala.Serializable)e -> {
            p.tryFailure((Throwable)e);
            return BoxedUnit.UNIT;
        });
    }

    public void postOneWayMessage(RequestMessage message) {
        this.postMessage(message.receiver().name(), new OneWayMessage(message.senderAddress(), message.content()), (Function1<Exception, BoxedUnit>)(Function1 & Serializable & scala.Serializable)e -> {
            throw e;
        });
    }

    public void postMessage(String endpointName, InboxMessage message, Function1<Exception, BoxedUnit> callbackIfStopped) {
        Some some;
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            Some some2;
            EndpointData data = (EndpointData)this.endpoints().get(endpointName);
            if (this.stopped()) {
                some2 = new Some((Object)new RpcEnvStoppedException());
            } else if (data == null) {
                some2 = new Some((Object)new CelebornException(new StringBuilder(16).append("Could not find ").append(endpointName).append(".").toString()));
            } else {
                data.inbox().post(message);
                this.org$apache$celeborn$common$rpc$netty$Dispatcher$$receivers().offer(data);
                some2 = None$.MODULE$;
            }
            some = some2;
        }
        Some error = some;
        error.foreach(callbackIfStopped);
    }

    public void stop() {
        block4: {
            Dispatcher dispatcher = this;
            synchronized (dispatcher) {
                block3: {
                    if (this.stopped()) break block3;
                    this.stopped_$eq(true);
                    break block4;
                }
                return;
            }
        }
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.endpoints().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)name -> {
            this.unregisterRpcEndpoint(name);
            return BoxedUnit.UNIT;
        });
        this.org$apache$celeborn$common$rpc$netty$Dispatcher$$receivers().offer(this.org$apache$celeborn$common$rpc$netty$Dispatcher$$PoisonPill());
        this.org$apache$celeborn$common$rpc$netty$Dispatcher$$threadpool().shutdown();
    }

    public void awaitTermination() {
        this.org$apache$celeborn$common$rpc$netty$Dispatcher$$threadpool().awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public boolean verify(String name) {
        return this.endpoints().containsKey(name);
    }

    public ThreadPoolExecutor org$apache$celeborn$common$rpc$netty$Dispatcher$$threadpool() {
        return this.org$apache$celeborn$common$rpc$netty$Dispatcher$$threadpool;
    }

    public EndpointData org$apache$celeborn$common$rpc$netty$Dispatcher$$PoisonPill() {
        return this.org$apache$celeborn$common$rpc$netty$Dispatcher$$PoisonPill;
    }

    public static final /* synthetic */ void $anonfun$postToAll$1(Dispatcher $this, InboxMessage message$1, Exception e) {
        Exception exception = e;
        if (exception instanceof RpcEnvStoppedException) {
            RpcEnvStoppedException rpcEnvStoppedException = (RpcEnvStoppedException)exception;
            $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Message ").append(message$1).append(" dropped. ").append(rpcEnvStoppedException.getMessage()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (exception != null) {
            Exception exception2 = exception;
            $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Message ").append(message$1).append(" dropped. ").append(exception2.getMessage()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)exception);
        }
    }

    public Dispatcher(NettyRpcEnv nettyEnv, int numUsableCores) {
        this.nettyEnv = nettyEnv;
        Logging.$init$(this);
        this.endpoints = new ConcurrentHashMap<String, EndpointData>();
        this.endpointRefs = new ConcurrentHashMap<RpcEndpoint, RpcEndpointRef>();
        this.org$apache$celeborn$common$rpc$netty$Dispatcher$$receivers = new LinkedBlockingQueue();
        this.stopped = false;
        int availableCores = numUsableCores > 0 ? numUsableCores : Math.max(16, Runtime.getRuntime().availableProcessors());
        int numThreads = nettyEnv.conf().getInt("celeborn.rpc.dispatcher.numThreads", availableCores);
        ThreadPoolExecutor pool = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(numThreads, "dispatcher-event-loop");
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Dispatcher numThreads: ").append(numThreads).toString());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> pool.execute(new MessageLoop()));
        this.org$apache$celeborn$common$rpc$netty$Dispatcher$$threadpool = pool;
        this.org$apache$celeborn$common$rpc$netty$Dispatcher$$PoisonPill = new EndpointData(this, null, null, null);
    }

    private class EndpointData {
        private final String name;
        private final RpcEndpoint endpoint;
        private final NettyRpcEndpointRef ref;
        private final Inbox inbox;
        public final /* synthetic */ Dispatcher $outer;

        public String name() {
            return this.name;
        }

        public RpcEndpoint endpoint() {
            return this.endpoint;
        }

        public NettyRpcEndpointRef ref() {
            return this.ref;
        }

        public Inbox inbox() {
            return this.inbox;
        }

        public /* synthetic */ Dispatcher org$apache$celeborn$common$rpc$netty$Dispatcher$EndpointData$$$outer() {
            return this.$outer;
        }

        public EndpointData(Dispatcher $outer, String name, RpcEndpoint endpoint, NettyRpcEndpointRef ref) {
            this.name = name;
            this.endpoint = endpoint;
            this.ref = ref;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.inbox = new Inbox(ref, endpoint);
        }
    }

    private class MessageLoop
    implements Runnable {
        @Override
        public void run() {
            block8: while (true) {
                try {
                    while (true) {
                        try {
                            EndpointData data;
                            EndpointData endpointData = data = this.org$apache$celeborn$common$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$celeborn$common$rpc$netty$Dispatcher$$receivers().take();
                            EndpointData endpointData2 = this.org$apache$celeborn$common$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$celeborn$common$rpc$netty$Dispatcher$$PoisonPill();
                            if (!(endpointData != null ? !endpointData.equals(endpointData2) : endpointData2 != null)) {
                                this.org$apache$celeborn$common$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$celeborn$common$rpc$netty$Dispatcher$$receivers().offer(this.org$apache$celeborn$common$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$celeborn$common$rpc$netty$Dispatcher$$PoisonPill());
                                return;
                            }
                            data.inbox().process(this.org$apache$celeborn$common$rpc$netty$Dispatcher$MessageLoop$$$outer());
                            continue block8;
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (!option.isEmpty()) {
                                Throwable e = (Throwable)option.get();
                                this.org$apache$celeborn$common$rpc$netty$Dispatcher$MessageLoop$$$outer().logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage(), e);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                continue;
                            }
                            throw throwable;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                catch (Throwable t) {
                    try {
                        this.org$apache$celeborn$common$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$celeborn$common$rpc$netty$Dispatcher$$threadpool().execute(this.org$apache$celeborn$common$rpc$netty$Dispatcher$MessageLoop$$$outer().new MessageLoop());
                    }
                    finally {
                        throw t;
                    }
                }
            }
        }

        public /* synthetic */ Dispatcher org$apache$celeborn$common$rpc$netty$Dispatcher$MessageLoop$$$outer() {
            return Dispatcher.this;
        }

        public MessageLoop() {
            if (Dispatcher.this == null) {
                throw null;
            }
        }
    }
}

