/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.celeborn.common.meta.FileManagedBuffers;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkStreamManager {
    private static final Logger logger = LoggerFactory.getLogger(ChunkStreamManager.class);
    private final AtomicLong nextStreamId = new AtomicLong((long)new Random().nextInt(Integer.MAX_VALUE) * 1000L);
    protected final ConcurrentHashMap<Long, StreamState> streams = new ConcurrentHashMap();

    public ManagedBuffer getChunk(long streamId, int chunkIndex, int offset, int len) {
        StreamState state = this.streams.get(streamId);
        if (state == null) {
            throw new IllegalStateException(String.format("Stream %s for chunk %s is not registered(Maybe removed).", streamId, chunkIndex));
        }
        if (chunkIndex >= state.buffers.numChunks()) {
            throw new IllegalStateException(String.format("Requested chunk index beyond end %s", chunkIndex));
        }
        FileManagedBuffers buffers = state.buffers;
        if (buffers.hasAlreadyRead(chunkIndex)) {
            throw new IllegalStateException(String.format("Chunk %s for stream %s has already been read.", chunkIndex, streamId));
        }
        ManagedBuffer nextChunk = buffers.chunk(chunkIndex, offset, len);
        if (state.buffers.isFullyRead()) {
            logger.trace("Removing stream id {}", (Object)streamId);
            this.streams.remove(streamId);
        }
        return nextChunk;
    }

    public static String genStreamChunkId(long streamId, int chunkId) {
        return String.format("%d_%d", streamId, chunkId);
    }

    public static Pair<Long, Integer> parseStreamChunkId(String streamChunkId) {
        String[] array = streamChunkId.split("_");
        assert (array.length == 2) : "Stream id and chunk index should be specified.";
        long streamId = Long.parseLong(array[0]);
        int chunkIndex = Integer.parseInt(array[1]);
        return ImmutablePair.of((Object)streamId, (Object)chunkIndex);
    }

    public void connectionTerminated(Channel channel) {
        for (Map.Entry<Long, StreamState> entry : this.streams.entrySet()) {
            StreamState state = entry.getValue();
            if (state.associatedChannel != channel) continue;
            this.streams.remove(entry.getKey());
        }
    }

    public void chunkBeingSent(long streamId) {
        StreamState streamState = this.streams.get(streamId);
        if (streamState != null) {
            ++streamState.chunksBeingTransferred;
        }
    }

    public void chunkSent(long streamId) {
        StreamState streamState = this.streams.get(streamId);
        if (streamState != null) {
            --streamState.chunksBeingTransferred;
        }
    }

    public long chunksBeingTransferred() {
        long sum = 0L;
        for (StreamState streamState : this.streams.values()) {
            sum += streamState.chunksBeingTransferred;
        }
        return sum;
    }

    public long registerStream(FileManagedBuffers buffers, Channel channel) {
        long myStreamId = this.nextStreamId.getAndIncrement();
        this.streams.put(myStreamId, new StreamState(buffers, channel));
        return myStreamId;
    }

    @VisibleForTesting
    public int numStreamStates() {
        return this.streams.size();
    }

    protected static class StreamState {
        final FileManagedBuffers buffers;
        final Channel associatedChannel;
        int curChunk = 0;
        volatile long chunksBeingTransferred = 0L;

        StreamState(FileManagedBuffers buffers, Channel channel) {
            this.buffers = (FileManagedBuffers)Preconditions.checkNotNull((Object)buffers);
            this.associatedChannel = channel;
        }
    }
}

