/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.server;

import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.celeborn.common.network.server.memory.MemoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ChannelsLimiter
extends ChannelDuplexHandler
implements MemoryManager.MemoryPressureListener {
    private static final Logger logger = LoggerFactory.getLogger(ChannelsLimiter.class);
    private final Set<Channel> channels = ConcurrentHashMap.newKeySet();
    private final String moduleName;
    private final AtomicBoolean isPaused = new AtomicBoolean(false);

    public ChannelsLimiter(String moduleName) {
        this.moduleName = moduleName;
        MemoryManager memoryManager = MemoryManager.instance();
        memoryManager.registerMemoryListener(this);
    }

    private void pauseAllChannels() {
        this.isPaused.set(true);
        this.channels.forEach(c -> {
            if (c.config().isAutoRead()) {
                c.config().setAutoRead(false);
            }
        });
    }

    private void trimCache() {
        this.channels.forEach(c -> c.pipeline().fireUserEventTriggered((Object)new TrimCache()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeAllChannels() {
        AtomicBoolean atomicBoolean = this.isPaused;
        synchronized (atomicBoolean) {
            this.isPaused.set(false);
            this.channels.forEach(c -> {
                if (!c.config().isAutoRead()) {
                    c.config().setAutoRead(true);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.channels.add(ctx.channel());
        AtomicBoolean atomicBoolean = this.isPaused;
        synchronized (atomicBoolean) {
            if (this.isPaused.get()) {
                ctx.channel().config().setAutoRead(false);
            }
        }
        super.handlerAdded(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (!ctx.channel().config().isAutoRead()) {
            ctx.channel().config().setAutoRead(true);
        }
        this.channels.remove(ctx.channel());
        super.handlerRemoved(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof TrimCache) {
            ((PooledByteBufAllocator)ctx.alloc()).trimCurrentThreadCache();
        }
    }

    @Override
    public void onPause(String moduleName) {
        if (this.moduleName.equals(moduleName)) {
            logger.info(this.moduleName + " channels pause read.");
            this.pauseAllChannels();
        }
    }

    @Override
    public void onResume(String moduleName) {
        if (moduleName.equalsIgnoreCase("all")) {
            logger.info(this.moduleName + " channels resume read.");
            this.resumeAllChannels();
        }
        if (this.moduleName.equals(moduleName)) {
            logger.info(this.moduleName + " channels resume read.");
            this.resumeAllChannels();
        }
    }

    @Override
    public void onTrim() {
        this.trimCache();
    }

    class TrimCache {
        TrimCache() {
        }
    }
}

