/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;
import org.apache.celeborn.common.network.buffer.NettyManagedBuffer;
import org.apache.celeborn.common.network.protocol.ChunkFetchFailure;
import org.apache.celeborn.common.network.protocol.ChunkFetchRequest;
import org.apache.celeborn.common.network.protocol.ChunkFetchSuccess;
import org.apache.celeborn.common.network.protocol.Encodable;
import org.apache.celeborn.common.network.protocol.OneWayMessage;
import org.apache.celeborn.common.network.protocol.OpenStream;
import org.apache.celeborn.common.network.protocol.PushData;
import org.apache.celeborn.common.network.protocol.PushDataHandShake;
import org.apache.celeborn.common.network.protocol.PushMergedData;
import org.apache.celeborn.common.network.protocol.RegionFinish;
import org.apache.celeborn.common.network.protocol.RegionStart;
import org.apache.celeborn.common.network.protocol.RpcFailure;
import org.apache.celeborn.common.network.protocol.RpcRequest;
import org.apache.celeborn.common.network.protocol.RpcResponse;
import org.apache.celeborn.common.network.protocol.StreamHandle;

public abstract class Message
implements Encodable {
    private ManagedBuffer body;

    protected Message() {
        this(null);
    }

    protected Message(ManagedBuffer body) {
        this.body = body;
    }

    public abstract Type type();

    public ManagedBuffer body() {
        return this.body;
    }

    public void setBody(ByteBuf buf) {
        this.body = new NettyManagedBuffer(buf);
    }

    public boolean needCopyOut() {
        return false;
    }

    protected boolean equals(Message other) {
        return Objects.equal((Object)this.body, (Object)other.body);
    }

    public ByteBuffer toByteBuffer() {
        ByteBuf buf = Unpooled.buffer((int)(this.encodedLength() + 1));
        buf.writeByte((int)this.type().id());
        this.encode(buf);
        assert (buf.writableBytes() == 0) : "Writable bytes remain: " + buf.writableBytes();
        return buf.nioBuffer();
    }

    public static Message decode(Type msgType, ByteBuf in) {
        return Message.decode(msgType, in, true);
    }

    public static Message decode(Type msgType, ByteBuf in, boolean decodeBody) {
        switch (msgType) {
            case CHUNK_FETCH_REQUEST: {
                return ChunkFetchRequest.decode(in);
            }
            case CHUNK_FETCH_SUCCESS: {
                return ChunkFetchSuccess.decode(in, decodeBody);
            }
            case CHUNK_FETCH_FAILURE: {
                return ChunkFetchFailure.decode(in);
            }
            case RPC_REQUEST: {
                return RpcRequest.decode(in, decodeBody);
            }
            case RPC_RESPONSE: {
                return RpcResponse.decode(in, decodeBody);
            }
            case RPC_FAILURE: {
                return RpcFailure.decode(in);
            }
            case OPEN_STREAM: {
                return OpenStream.decode(in);
            }
            case STREAM_HANDLE: {
                return StreamHandle.decode(in);
            }
            case ONE_WAY_MESSAGE: {
                return OneWayMessage.decode(in, decodeBody);
            }
            case PUSH_DATA: {
                return PushData.decode(in, decodeBody);
            }
            case PUSH_MERGED_DATA: {
                return PushMergedData.decode(in, decodeBody);
            }
            case REGION_START: {
                return RegionStart.decode(in);
            }
            case REGION_FINISH: {
                return RegionFinish.decode(in);
            }
            case PUSH_DATA_HAND_SHAKE: {
                return PushDataHandShake.decode(in);
            }
        }
        throw new IllegalArgumentException("Unexpected message type: " + msgType);
    }

    public static Message decode(ByteBuffer buffer) {
        ByteBuf buf = Unpooled.wrappedBuffer((ByteBuffer)buffer);
        Type type = Type.decode(buf);
        return Message.decode(type, buf);
    }

    public static final class Type
    extends Enum<Type>
    implements Encodable {
        public static final /* enum */ Type UNKNOWN_TYPE = new Type(-1);
        public static final /* enum */ Type CHUNK_FETCH_REQUEST = new Type(0);
        public static final /* enum */ Type CHUNK_FETCH_SUCCESS = new Type(1);
        public static final /* enum */ Type CHUNK_FETCH_FAILURE = new Type(2);
        public static final /* enum */ Type RPC_REQUEST = new Type(3);
        public static final /* enum */ Type RPC_RESPONSE = new Type(4);
        public static final /* enum */ Type RPC_FAILURE = new Type(5);
        public static final /* enum */ Type OPEN_STREAM = new Type(6);
        public static final /* enum */ Type STREAM_HANDLE = new Type(7);
        public static final /* enum */ Type ONE_WAY_MESSAGE = new Type(9);
        public static final /* enum */ Type PUSH_DATA = new Type(11);
        public static final /* enum */ Type PUSH_MERGED_DATA = new Type(12);
        public static final /* enum */ Type REGION_START = new Type(13);
        public static final /* enum */ Type REGION_FINISH = new Type(14);
        public static final /* enum */ Type PUSH_DATA_HAND_SHAKE = new Type(15);
        private final byte id;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(int id) {
            assert (id < 128) : "Cannot have more than 128 message types";
            this.id = (byte)id;
        }

        public byte id() {
            return this.id;
        }

        @Override
        public int encodedLength() {
            return 1;
        }

        @Override
        public void encode(ByteBuf buf) {
            buf.writeByte((int)this.id);
        }

        public static Type decode(ByteBuf buf) {
            byte id = buf.readByte();
            switch (id) {
                case 0: {
                    return CHUNK_FETCH_REQUEST;
                }
                case 1: {
                    return CHUNK_FETCH_SUCCESS;
                }
                case 2: {
                    return CHUNK_FETCH_FAILURE;
                }
                case 3: {
                    return RPC_REQUEST;
                }
                case 4: {
                    return RPC_RESPONSE;
                }
                case 5: {
                    return RPC_FAILURE;
                }
                case 6: {
                    return OPEN_STREAM;
                }
                case 7: {
                    return STREAM_HANDLE;
                }
                case 9: {
                    return ONE_WAY_MESSAGE;
                }
                case 11: {
                    return PUSH_DATA;
                }
                case 12: {
                    return PUSH_MERGED_DATA;
                }
                case 13: {
                    return REGION_START;
                }
                case 14: {
                    return REGION_FINISH;
                }
                case 15: {
                    return PUSH_DATA_HAND_SHAKE;
                }
                case -1: {
                    throw new IllegalArgumentException("User type messages cannot be decoded.");
                }
            }
            throw new IllegalArgumentException("Unknown message type: " + id);
        }

        static {
            $VALUES = new Type[]{UNKNOWN_TYPE, CHUNK_FETCH_REQUEST, CHUNK_FETCH_SUCCESS, CHUNK_FETCH_FAILURE, RPC_REQUEST, RPC_RESPONSE, RPC_FAILURE, OPEN_STREAM, STREAM_HANDLE, ONE_WAY_MESSAGE, PUSH_DATA, PUSH_MERGED_DATA, REGION_START, REGION_FINISH, PUSH_DATA_HAND_SHAKE};
        }
    }
}

