/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.client;

import io.netty.channel.Channel;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.celeborn.common.network.client.ChunkFetchFailureException;
import org.apache.celeborn.common.network.client.ChunkReceivedCallback;
import org.apache.celeborn.common.network.client.RpcResponseCallback;
import org.apache.celeborn.common.network.protocol.ChunkFetchFailure;
import org.apache.celeborn.common.network.protocol.ChunkFetchSuccess;
import org.apache.celeborn.common.network.protocol.ResponseMessage;
import org.apache.celeborn.common.network.protocol.RpcFailure;
import org.apache.celeborn.common.network.protocol.RpcResponse;
import org.apache.celeborn.common.network.protocol.StreamChunkSlice;
import org.apache.celeborn.common.network.server.MessageHandler;
import org.apache.celeborn.common.network.util.NettyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportResponseHandler
extends MessageHandler<ResponseMessage> {
    private static final Logger logger = LoggerFactory.getLogger(TransportResponseHandler.class);
    private final Channel channel;
    private final Map<StreamChunkSlice, ChunkReceivedCallback> outstandingFetches;
    private final Map<Long, RpcResponseCallback> outstandingRpcs;
    private final AtomicLong timeOfLastRequestNs;

    public TransportResponseHandler(Channel channel) {
        this.channel = channel;
        this.outstandingFetches = new ConcurrentHashMap<StreamChunkSlice, ChunkReceivedCallback>();
        this.outstandingRpcs = new ConcurrentHashMap<Long, RpcResponseCallback>();
        this.timeOfLastRequestNs = new AtomicLong(0L);
    }

    public void addFetchRequest(StreamChunkSlice streamChunkSlice, ChunkReceivedCallback callback) {
        this.updateTimeOfLastRequest();
        if (this.outstandingFetches.containsKey(streamChunkSlice)) {
            logger.warn("[addFetchRequest] streamChunkSlice {} already exists!", (Object)streamChunkSlice);
        }
        this.outstandingFetches.put(streamChunkSlice, callback);
    }

    public void removeFetchRequest(StreamChunkSlice streamChunkSlice) {
        this.outstandingFetches.remove(streamChunkSlice);
    }

    public void addRpcRequest(long requestId, RpcResponseCallback callback) {
        this.updateTimeOfLastRequest();
        if (this.outstandingRpcs.containsKey(requestId)) {
            logger.warn("[addRpcRequest] requestId {} already exists!", (Object)requestId);
        }
        this.outstandingRpcs.put(requestId, callback);
    }

    public void removeRpcRequest(long requestId) {
        this.outstandingRpcs.remove(requestId);
    }

    private void failOutstandingRequests(Throwable cause) {
        for (Map.Entry<StreamChunkSlice, ChunkReceivedCallback> entry : this.outstandingFetches.entrySet()) {
            try {
                entry.getValue().onFailure(entry.getKey().chunkIndex, cause);
            }
            catch (Exception e) {
                logger.warn("ChunkReceivedCallback.onFailure throws exception", (Throwable)e);
            }
        }
        for (Map.Entry<Object, Object> entry : this.outstandingRpcs.entrySet()) {
            try {
                ((RpcResponseCallback)entry.getValue()).onFailure(cause);
            }
            catch (Exception e) {
                logger.warn("RpcResponseCallback.onFailure throws exception", (Throwable)e);
            }
        }
        this.outstandingFetches.clear();
        this.outstandingRpcs.clear();
    }

    @Override
    public void channelActive() {
    }

    @Override
    public void channelInactive() {
        if (this.numOutstandingRequests() > 0) {
            String remoteAddress = NettyUtils.getRemoteAddress(this.channel);
            logger.error("Still have {} requests outstanding when connection from {} is closed", (Object)this.numOutstandingRequests(), (Object)remoteAddress);
            this.failOutstandingRequests(new IOException("Connection from " + remoteAddress + " closed"));
        }
    }

    @Override
    public void exceptionCaught(Throwable cause) {
        if (this.numOutstandingRequests() > 0) {
            String remoteAddress = NettyUtils.getRemoteAddress(this.channel);
            logger.error("Still have {} requests outstanding when connection from {} is closed", (Object)this.numOutstandingRequests(), (Object)remoteAddress);
            this.failOutstandingRequests(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(ResponseMessage message) throws Exception {
        if (message instanceof ChunkFetchSuccess) {
            ChunkFetchSuccess resp = (ChunkFetchSuccess)message;
            ChunkReceivedCallback listener = this.outstandingFetches.get(resp.streamChunkSlice);
            if (listener == null) {
                logger.warn("Ignoring response for block {} from {} since it is not outstanding", (Object)resp.streamChunkSlice, (Object)NettyUtils.getRemoteAddress(this.channel));
                resp.body().release();
            } else {
                this.outstandingFetches.remove(resp.streamChunkSlice);
                listener.onSuccess(resp.streamChunkSlice.chunkIndex, resp.body());
                resp.body().release();
            }
        } else if (message instanceof ChunkFetchFailure) {
            ChunkFetchFailure resp = (ChunkFetchFailure)message;
            ChunkReceivedCallback listener = this.outstandingFetches.get(resp.streamChunkSlice);
            if (listener == null) {
                logger.warn("Ignoring response for block {} from {} ({}) since it is not outstanding", new Object[]{resp.streamChunkSlice, NettyUtils.getRemoteAddress(this.channel), resp.errorString});
            } else {
                this.outstandingFetches.remove(resp.streamChunkSlice);
                logger.warn("Receive ChunkFetchFailure, errorMsg {}", (Object)resp.errorString);
                listener.onFailure(resp.streamChunkSlice.chunkIndex, new ChunkFetchFailureException("Failure while fetching " + resp.streamChunkSlice + ": " + resp.errorString));
            }
        } else if (message instanceof RpcResponse) {
            RpcResponse resp = (RpcResponse)message;
            RpcResponseCallback listener = this.outstandingRpcs.get(resp.requestId);
            if (listener == null) {
                logger.warn("Ignoring response for RPC {} from {} ({} bytes) since it is not outstanding", new Object[]{resp.requestId, NettyUtils.getRemoteAddress(this.channel), resp.body().size()});
                resp.body().release();
            } else {
                this.outstandingRpcs.remove(resp.requestId);
                try {
                    listener.onSuccess(resp.body().nioByteBuffer());
                }
                finally {
                    resp.body().release();
                }
            }
        } else if (message instanceof RpcFailure) {
            RpcFailure resp = (RpcFailure)message;
            RpcResponseCallback listener = this.outstandingRpcs.get(resp.requestId);
            if (listener == null) {
                logger.warn("Ignoring response for RPC {} from {} ({}) since it is not outstanding", new Object[]{resp.requestId, NettyUtils.getRemoteAddress(this.channel), resp.errorString});
            } else {
                this.outstandingRpcs.remove(resp.requestId);
                listener.onFailure(new RuntimeException(resp.errorString));
            }
        } else {
            throw new IllegalStateException("Unknown response type: " + message.type());
        }
    }

    public int numOutstandingRequests() {
        return this.outstandingFetches.size() + this.outstandingRpcs.size();
    }

    public long getTimeOfLastRequestNs() {
        return this.timeOfLastRequestNs.get();
    }

    public void updateTimeOfLastRequest() {
        this.timeOfLastRequestNs.set(System.nanoTime());
    }
}

