/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.CelebornException;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.DeviceInfo;
import org.apache.celeborn.common.meta.DeviceInfo$;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.meta.DiskStatus;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.network.server.memory.MemoryManager;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PartitionSplitMode;
import org.apache.celeborn.common.protocol.PartitionType;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.quota.ResourceConsumption;
import org.apache.celeborn.common.util.PbSerDeUtils$;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.common.util.Utils$;
import org.apache.celeborn.service.deploy.worker.LevelDBProvider;
import org.apache.celeborn.service.deploy.worker.ShuffleRecoverHelper;
import org.apache.celeborn.service.deploy.worker.storage.DeviceMonitor;
import org.apache.celeborn.service.deploy.worker.storage.DeviceMonitor$;
import org.apache.celeborn.service.deploy.worker.storage.DeviceObserver;
import org.apache.celeborn.service.deploy.worker.storage.FileWriter;
import org.apache.celeborn.service.deploy.worker.storage.Flusher;
import org.apache.celeborn.service.deploy.worker.storage.HdfsFlusher;
import org.apache.celeborn.service.deploy.worker.storage.LocalFlusher;
import org.apache.celeborn.service.deploy.worker.storage.StorageManager$;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBIterator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0011\u001dd!B)S\u0005Q\u0003\u0007BCA\u0011\u0001\t\u0005\t\u0015!\u0003\u0002$!Q\u00111\u0006\u0001\u0003\u0002\u0003\u0006I!!\f\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@!I\u0011q\t\u0001C\u0002\u0013\u0005\u0011\u0011\n\u0005\t\u0003\u000f\u0003\u0001\u0015!\u0003\u0002L!a\u0011\u0011\u0012\u0001\u0011\u0002\u0003\r\t\u0015!\u0003\u0002\f\"I\u0011q\u0016\u0001C\u0002\u0013\u0005\u0011\u0011\u0017\u0005\t\u0003g\u0003\u0001\u0015!\u0003\u0002\u0014\"I\u0011Q\u0017\u0001C\u0002\u0013\u0005\u0011q\u0017\u0005\t\u0003s\u0003\u0001\u0015!\u0003\u0002(\"I\u00111\u0018\u0001C\u0002\u0013\u0005\u0011Q\u0018\u0005\t\u0003\u000b\u0004\u0001\u0015!\u0003\u0002@\"9\u0011q\u0019\u0001\u0005\u0002\u0005%\u0007bBAo\u0001\u0011\u0005\u0011q\u001c\u0005\n\u0003G\u0004!\u0019!C\u0005\u0003KD\u0001\"a<\u0001A\u0003%\u0011q\u001d\u0005\n\u0003c\u0004!\u0019!C\u0001\u0003gD\u0001\"a>\u0001A\u0003%\u0011Q\u001f\u0005\n\u0003s\u0004!\u0019!C\u0005\u0003wD\u0001Ba\u0001\u0001A\u0003%\u0011Q \u0005\n\u0005\u000b\u0001!\u0019!C\u0005\u0005\u000fA\u0001B!\u0005\u0001A\u0003%!\u0011\u0002\u0005\n\u0005'\u0001!\u0019!C\u0005\u0005+A\u0001B!\b\u0001A\u0003%!q\u0003\u0005\n\u0005?\u0001!\u0019!C\u0001\u0005CA\u0001Ba\t\u0001A\u0003%\u0011Q\u000e\u0005\n\u0005K\u0001!\u0019!C\u0001\u0005OA\u0001B!\u0010\u0001A\u0003%!\u0011\u0006\u0005\n\u0005\u007f\u0001!\u0019!C\u0001\u0005\u0003B\u0001Ba\u0011\u0001A\u0003%\u00111\u000e\u0005\n\u0005\u000b\u0002!\u0019!C\u0001\u0005\u000fB\u0001B!\u0016\u0001A\u0003%!\u0011\n\u0005\b\u0005/\u0002A\u0011\tB-\u0011\u001d\u0011y\u0007\u0001C!\u0005cB\u0011B!\u001e\u0001\u0005\u0004%IAa\u001e\t\u0011\t\u0015\u0005\u0001)A\u0005\u0005sB\u0011Ba\"\u0001\u0005\u0004%IA!#\t\u0011\tE\u0005\u0001)A\u0005\u0005\u0017C\u0011Ba+\u0001\u0005\u0004%IA!,\t\u0011\te\u0006\u0001)A\u0005\u0005_C\u0011Ba/\u0001\u0005\u0004%IA!0\t\u0011\t\r\u0007\u0001)A\u0005\u0005\u007fC\u0011B!2\u0001\u0001\u0004%IAa2\t\u0013\te\u0007\u00011A\u0005\n\tm\u0007\u0002\u0003Bp\u0001\u0001\u0006KA!3\t\u000f\t\u0005\b\u0001\"\u0003\u0003d\"9!q\u001d\u0001\u0005\u0002\t%\bb\u0002Bv\u0001\u0011%!Q\u001e\u0005\n\u0005k\u0004!\u0019!C\u0005\u0005oD\u0001B!@\u0001A\u0003%!\u0011 \u0005\n\u0007\u000b\u0001!\u0019!C\u0005\u0007\u000fA\u0001b!\u0004\u0001A\u0003%1\u0011\u0002\u0005\b\u0007#\u0001A\u0011AB\n\u0011\u001d\u0019\t\u000b\u0001C\u0001\u0007GCqa!,\u0001\t\u0003\u0019y\u000bC\u0004\u00042\u0002!\taa-\t\u000f\r]\u0006\u0001\"\u0001\u0004:\"I1q\u0018\u0001C\u0002\u0013%1\u0011\u0019\u0005\t\u0007\u0007\u0004\u0001\u0015!\u0003\u00042!I1Q\u0019\u0001C\u0002\u0013%!Q\u0003\u0005\t\u0007\u000f\u0004\u0001\u0015!\u0003\u0003\u0018!91\u0011\u001a\u0001\u0005\n\r-\u0007\"CBk\u0001E\u0005I\u0011BBl\u0011\u001d\u0019i\u000f\u0001C\u0005\u0007_Dqa!?\u0001\t\u0013\u0019Y\u0010C\u0004\u0005\u0002\u0001!I\u0001b\u0001\t\u000f\u0011\u0015\u0001\u0001\"\u0001\u0003j\"9Aq\u0001\u0001\u0005\n\t%\bb\u0002C\u0005\u0001\u0011\u0005C1\u0002\u0005\b\t#\u0001A\u0011\tC\n\u0011\u001d!9\u0002\u0001C!\u0005SDq\u0001\"\u0007\u0001\t\u0003\u0011I\u000fC\u0004\u0005\u001c\u0001!\t\u0001\"\b\t\u0019\u0011=\u0002\u0001%A\u0001\u0002\u0003%\t\u0001\"\r\b\u000f\u0011\u0015#\u000b#\u0001\u0005H\u00191\u0011K\u0015E\u0001\t\u0013Bq!!\u0010M\t\u0003!\t\u0006C\u0006\u0005T1\u0003\r\u00111A\u0005\u0002\u0011U\u0003b\u0003C0\u0019\u0002\u0007\t\u0019!C\u0001\tCB1\u0002\"\u001aM\u0001\u0004\u0005\t\u0015)\u0003\u0005X\tq1\u000b^8sC\u001e,W*\u00198bO\u0016\u0014(BA*U\u0003\u001d\u0019Ho\u001c:bO\u0016T!!\u0016,\u0002\r]|'o[3s\u0015\t9\u0006,\u0001\u0004eKBdw.\u001f\u0006\u00033j\u000bqa]3sm&\u001cWM\u0003\u0002\\9\u0006A1-\u001a7fE>\u0014hN\u0003\u0002^=\u00061\u0011\r]1dQ\u0016T\u0011aX\u0001\u0004_J<7#\u0002\u0001bK&\f\bC\u00012d\u001b\u0005!\u0016B\u00013U\u0005Q\u0019\u0006.\u001e4gY\u0016\u0014VmY8wKJDU\r\u001c9feB\u0011amZ\u0007\u0002%&\u0011\u0001N\u0015\u0002\u000f\t\u00164\u0018nY3PEN,'O^3s!\tQw.D\u0001l\u0015\taW.\u0001\u0005j]R,'O\\1m\u0015\tq',\u0001\u0004d_6lwN\\\u0005\u0003a.\u0014q\u0001T8hO&tw\rE\u0002s\u00037q1a]A\u000b\u001d\r!\u0018q\u0002\b\u0004k\u0006%ab\u0001<\u0002\u00069\u0019q/a\u0001\u000f\u0007a\f\tA\u0004\u0002z\u007f:\u0011!P`\u0007\u0002w*\u0011A0`\u0001\u0007yI|w\u000e\u001e \u0004\u0001%\tq,\u0003\u0002^=&\u00111\fX\u0005\u0003]jK1!a\u0002n\u0003\u001dqW\r^<pe.LA!a\u0003\u0002\u000e\u000511/\u001a:wKJT1!a\u0002n\u0013\u0011\t\t\"a\u0005\u0002\r5,Wn\u001c:z\u0015\u0011\tY!!\u0004\n\t\u0005]\u0011\u0011D\u0001\u000e\u001b\u0016lwN]=NC:\fw-\u001a:\u000b\t\u0005E\u00111C\u0005\u0005\u0003;\tyB\u0001\fNK6|'/\u001f)sKN\u001cXO]3MSN$XM\\3s\u0015\u0011\t9\"!\u0007\u0002\t\r|gN\u001a\t\u0005\u0003K\t9#D\u0001n\u0013\r\tI#\u001c\u0002\r\u0007\u0016dWMY8s]\u000e{gNZ\u0001\ro>\u00148.\u001a:T_V\u00148-\u001a\t\u0005\u0003_\tI$\u0004\u0002\u00022)!\u00111GA\u001b\u0003\u0019\u0019x.\u001e:dK*\u0019\u0011qG7\u0002\u000f5,GO]5dg&!\u00111HA\u0019\u00059\t%m\u001d;sC\u000e$8k\\;sG\u0016\fa\u0001P5oSRtDCBA!\u0003\u0007\n)\u0005\u0005\u0002g\u0001!9\u0011\u0011E\u0002A\u0002\u0005\r\u0002bBA\u0016\u0007\u0001\u0007\u0011QF\u0001\u0012o>\u00148.\u001b8h\t&\u0014xK]5uKJ\u001cXCAA&!!\ti%a\u0017\u0002`\u0005-TBAA(\u0015\u0011\t\t&a\u0015\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002V\u0005]\u0013\u0001B;uS2T!!!\u0017\u0002\t)\fg/Y\u0005\u0005\u0003;\nyEA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004B!!\u0019\u0002h5\u0011\u00111\r\u0006\u0005\u0003K\n9&\u0001\u0002j_&!\u0011\u0011NA2\u0005\u00111\u0015\u000e\\3\u0011\u0011\u00055\u00131LA7\u0003\u0003\u0003B!a\u001c\u0002|9!\u0011\u0011OA<!\rQ\u00181\u000f\u0006\u0003\u0003k\nQa]2bY\u0006LA!!\u001f\u0002t\u00051\u0001K]3eK\u001aLA!! \u0002\u0000\t11\u000b\u001e:j]\u001eTA!!\u001f\u0002tA\u0019a-a!\n\u0007\u0005\u0015%K\u0001\u0006GS2,wK]5uKJ\f!c^8sW&tw\rR5s/JLG/\u001a:tA\u0005\u0019\u0001\u0010J\u0019\u0011\u0011\u00055\u0015qRAJ\u0003Ok!!a\u001d\n\t\u0005E\u00151\u000f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0011\u0005U\u0015qSA7\u00037k!!a\u0015\n\t\u0005e\u00151\u000b\u0002\u0004\u001b\u0006\u0004\b\u0003BAO\u0003Gk!!a(\u000b\u0007\u0005\u0005V.\u0001\u0003nKR\f\u0017\u0002BAS\u0003?\u0013!\u0002R3wS\u000e,\u0017J\u001c4p!!\t)*a&\u0002n\u0005%\u0006\u0003BAO\u0003WKA!!,\u0002 \nAA)[:l\u0013:4w.A\u0006eKZL7-Z%oM>\u001cXCAAJ\u00031!WM^5dK&sgm\\:!\u0003%!\u0017n]6J]\u001a|7/\u0006\u0002\u0002(\u0006QA-[:l\u0013:4wn\u001d\u0011\u0002\u00175|WO\u001c;Q_&tGo]\u000b\u0003\u0003\u007f\u0003b!!&\u0002B\u00065\u0014\u0002BAb\u0003'\u0012q\u0001S1tQN+G/\u0001\u0007n_VtG\u000fU8j]R\u001c\b%A\u0007eSN\\7o\u00158baNDw\u000e\u001e\u000b\u0003\u0003\u0017\u0004b!!4\u0002X\u0006%f\u0002BAh\u0003't1A_Ai\u0013\t\t)(\u0003\u0003\u0002V\u0006M\u0014a\u00029bG.\fw-Z\u0005\u0005\u00033\fYN\u0001\u0003MSN$(\u0002BAk\u0003g\n!\u0003[3bYRD\u0017pV8sW&tw\rR5sgR\u0011\u0011\u0011\u001d\t\u0007\u0003\u001b\f9.a\u0018\u0002\u001b\u0011L7o[(qKJ\fGo\u001c:t+\t\t9\u000f\u0005\u0005\u0002N\u0005m\u0013QNAu!\u0011\ti%a;\n\t\u00055\u0018q\n\u0002\u0013)\"\u0014X-\u00193Q_>dW\t_3dkR|'/\u0001\beSN\\w\n]3sCR|'o\u001d\u0011\u0002\u0019Ql\u0007\u000fR5tW&sgm\\:\u0016\u0005\u0005U\b\u0003CA'\u00037\ni'!+\u0002\u001bQl\u0007\u000fR5tW&sgm\\:!\u00035!WM^5dK6{g.\u001b;peV\u0011\u0011Q \t\u0004M\u0006}\u0018b\u0001B\u0001%\niA)\u001a<jG\u0016luN\\5u_J\fa\u0002Z3wS\u000e,Wj\u001c8ji>\u0014\b%A\u0007m_\u000e\fGN\u00127vg\",'o]\u000b\u0003\u0005\u0013\u0001\u0002\"!\u0014\u0002\\\u00055$1\u0002\t\u0004M\n5\u0011b\u0001B\b%\naAj\\2bY\u001acWo\u001d5fe\u0006qAn\\2bY\u001acWo\u001d5feN\u0004\u0013!D1di&|gnU3sm&\u001cW-\u0006\u0002\u0003\u0018A!\u0011Q\nB\r\u0013\u0011\u0011Y\"a\u0014\u00031M\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW-\u0001\bbGRLwN\\*feZL7-\u001a\u0011\u0002\u000f!$gm\u001d#jeV\u0011\u0011QN\u0001\tQ\u001247\u000fR5sA\u0005q\u0001\u000e\u001a4t!\u0016\u0014X.[:tS>tWC\u0001B\u0015!\u0011\u0011YC!\u000f\u000e\u0005\t5\"\u0002\u0002B\u0018\u0005c\t!\u0002]3s[&\u001c8/[8o\u0015\u0011\u0011\u0019D!\u000e\u0002\u0005\u0019\u001c(b\u0001B\u001c9\u00061\u0001.\u00193p_BLAAa\u000f\u0003.\taai\u001d)fe6L7o]5p]\u0006y\u0001\u000e\u001a4t!\u0016\u0014X.[:tS>t\u0007%A\u0006iI\u001a\u001cxK]5uKJ\u001cXCAA6\u00031AGMZ:Xe&$XM]:!\u0003-AGMZ:GYV\u001c\b.\u001a:\u0016\u0005\t%\u0003CBAG\u0005\u0017\u0012y%\u0003\u0003\u0003N\u0005M$AB(qi&|g\u000eE\u0002g\u0005#J1Aa\u0015S\u0005-AEMZ:GYV\u001c\b.\u001a:\u0002\u0019!$gm\u001d$mkNDWM\u001d\u0011\u0002\u00179|G/\u001b4z\u000bJ\u0014xN\u001d\u000b\u0007\u00057\u0012\tG!\u001a\u0011\t\u00055%QL\u0005\u0005\u0005?\n\u0019H\u0001\u0003V]&$\bb\u0002B2C\u0001\u0007\u0011QN\u0001\u000b[>,h\u000e\u001e)pS:$\bb\u0002B4C\u0001\u0007!\u0011N\u0001\u000bI&\u001c8n\u0015;biV\u001c\b\u0003BAO\u0005WJAA!\u001c\u0002 \nQA)[:l'R\fG/^:\u0002\u001b9|G/\u001b4z\u0011\u0016\fG\u000e\u001e5z)\u0011\u0011YFa\u001d\t\u000f\t\r$\u00051\u0001\u0002n\u000591m\\;oi\u0016\u0014XC\u0001B=!\u0011\u0011YH!!\u000e\u0005\tu$\u0002\u0002B@\u0003\u001f\na!\u0019;p[&\u001c\u0017\u0002\u0002BB\u0005{\u0012Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018\u0001C2pk:$XM\u001d\u0011\u0002\u001f\r|WO\u001c;fe>\u0003XM]1u_J,\"Aa#\u0013\r\t5%1\u0013BP\r\u0019\u0011yI\n\u0001\u0003\f\naAH]3gS:,W.\u001a8u}\u0005\u00012m\\;oi\u0016\u0014x\n]3sCR|'\u000f\t\t\u0005\u0005+\u0013Y*\u0004\u0002\u0003\u0018*!!\u0011TA,\u0003\u0011a\u0017M\\4\n\t\tu%q\u0013\u0002\u0007\u001f\nTWm\u0019;\u0011\t\t\u0005&qU\u0007\u0003\u0005GSAA!*\u0002T\u0005Aa-\u001e8di&|g.\u0003\u0003\u0003*\n\r&\u0001E%oiVs\u0017M]=Pa\u0016\u0014\u0018\r^8s\u0003%1\u0017\u000e\\3J]\u001a|7/\u0006\u0002\u00030BA\u0011QJA.\u0003[\u0012\t\f\u0005\u0005\u0002N\u0005m\u0013Q\u000eBZ!\u0011\tiJ!.\n\t\t]\u0016q\u0014\u0002\t\r&dW-\u00138g_\u0006Qa-\u001b7f\u0013:4wn\u001d\u0011\u0002%I+5i\u0014,F%f{f)\u0013'F?:\u000bU*R\u000b\u0003\u0005\u007f\u0003BA!&\u0003B&!\u0011Q\u0010BL\u0003M\u0011ViQ(W\u000bJKvLR%M\u000b~s\u0015)T#!\u0003\t!'-\u0006\u0002\u0003JB!!1\u001aBk\u001b\t\u0011iM\u0003\u0003\u0003P\nE\u0017a\u00027fm\u0016dGM\u0019\u0006\u0004\u0005't\u0016\u0001B5rqAJAAa6\u0003N\n\u0011AIQ\u0001\u0007I\n|F%Z9\u0015\t\tm#Q\u001c\u0005\n\u0003\u0013c\u0013\u0011!a\u0001\u0005\u0013\f1\u0001\u001a2!\u0003]\u0011X\r\\8bI\u0006sGm\u00117fC:4\u0015\u000e\\3J]\u001a|7\u000f\u0006\u0003\u0003\\\t\u0015\bb\u0002Bc]\u0001\u0007!\u0011Z\u0001\u0014kB$\u0017\r^3GS2,\u0017J\u001c4pg&sGI\u0011\u000b\u0003\u00057\nAbZ3u\u001d\u0016DH/\u00138eKb$\"Aa<\u0011\t\u00055%\u0011_\u0005\u0005\u0005g\f\u0019HA\u0002J]R\f!B\\3x\u001b\u0006\u0004h)\u001e8d+\t\u0011IP\u0005\u0004\u0003|\nM%q \u0004\u0007\u0005\u001f\u0013\u0004A!?\u0002\u00179,w/T1q\rVt7\r\t\t\t\u0005C\u001b\t!!\u001c\u00032&!11\u0001BR\u0005!1UO\\2uS>t\u0017\u0001G<pe.Lgn\u001a#je^\u0013\u0018\u000e^3s\u0019&\u001cHOR;oGV\u00111\u0011\u0002\n\u0007\u0007\u0017\u0011\u0019ja\u0004\u0007\r\t=E\u0007AB\u0005\u0003e9xN]6j]\u001e$\u0015N],sSR,'\u000fT5ti\u001a+hn\u0019\u0011\u0011\u0011\t\u00056\u0011AA0\u0003W\nAb\u0019:fCR,wK]5uKJ$\"#!!\u0004\u0016\re1QDB\u0017\u0007o\u0019\tea\u0013\u0004V!91qC\u001bA\u0002\u00055\u0014!B1qa&#\u0007bBB\u000ek\u0001\u0007!q^\u0001\ng\",hM\u001a7f\u0013\u0012Dqaa\b6\u0001\u0004\u0019\t#\u0001\u0005m_\u000e\fG/[8o!\u0011\u0019\u0019c!\u000b\u000e\u0005\r\u0015\"bAB\u0014[\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0004,\r\u0015\"!\u0005)beRLG/[8o\u0019>\u001c\u0017\r^5p]\"91qF\u001bA\u0002\rE\u0012AD:qY&$H\u000b\u001b:fg\"|G\u000e\u001a\t\u0005\u0003\u001b\u001b\u0019$\u0003\u0003\u00046\u0005M$\u0001\u0002'p]\u001eDqa!\u000f6\u0001\u0004\u0019Y$A\u0005ta2LG/T8eKB!11EB\u001f\u0013\u0011\u0019yd!\n\u0003%A\u000b'\u000f^5uS>t7\u000b\u001d7ji6{G-\u001a\u0005\b\u0007\u0007*\u0004\u0019AB#\u00035\u0001\u0018M\u001d;ji&|g\u000eV=qKB!11EB$\u0013\u0011\u0019Ie!\n\u0003\u001bA\u000b'\u000f^5uS>tG+\u001f9f\u0011\u001d\u0019i%\u000ea\u0001\u0007\u001f\nqB]1oO\u0016\u0014V-\u00193GS2$XM\u001d\t\u0005\u0003\u001b\u001b\t&\u0003\u0003\u0004T\u0005M$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0007/*\u0004\u0019AB-\u00039)8/\u001a:JI\u0016tG/\u001b4jKJ\u0004Baa\u0017\u0004b5\u00111Q\f\u0006\u0004\u0007?j\u0017\u0001C5eK:$\u0018\u000e^=\n\t\r\r4Q\f\u0002\u000f+N,'/\u00133f]RLg-[3sQ\u0015)4qMB:!\u0019\tii!\u001b\u0004n%!11NA:\u0005\u0019!\bN]8xgB!\u0011\u0011MB8\u0013\u0011\u0019\t(a\u0019\u0003\u0017%{U\t_2faRLwN\\\u0019\b=\u000554QOBPc%\u00193qOB?\u0007+\u001by(\u0006\u0003\u0003\"\reDaBB>{\n\u00071Q\u0011\u0002\u0002)&!1qPBA\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)!11QA:\u0003\u0019!\bN]8xgF!1qQBG!\u0011\tii!#\n\t\r-\u00151\u000f\u0002\b\u001d>$\b.\u001b8h!\u0011\u0019yi!%\u000f\t\u00055\u00151[\u0005\u0005\u0007'\u000bYNA\u0005UQJ|w/\u00192mKFJ1ea&\u0004\u001a\u000em51\u0011\b\u0005\u0003\u001b\u001bI*\u0003\u0003\u0004\u0004\u0006M\u0014g\u0002\u0012\u0002\u000e\u0006M4Q\u0014\u0002\u0006g\u000e\fG.Y\u0019\u0004M\r5\u0014aC4fi\u001aKG.Z%oM>$bAa-\u0004&\u000e%\u0006bBBTm\u0001\u0007\u0011QN\u0001\u000bg\",hM\u001a7f\u0017\u0016L\bbBBVm\u0001\u0007\u0011QN\u0001\tM&dWMT1nK\u0006i1\u000f[;gM2,7*Z=TKR$\"!a0\u0002\u001fQ|\u0007/\u00119q\t&\u001c8.V:bO\u0016,\"a!.\u0011\u0011\u0005U\u0015qSA7\u0007c\t\u0001d\u00197fC:,\b/\u0012=qSJ,Gm\u00155vM\u001adWmS3z)\u0011\u0011Yfa/\t\u000f\ru\u0016\b1\u0001\u0002@\u0006\u0011R\r\u001f9je\u0016$7\u000b[;gM2,7*Z=t\u0003qqwN\\3F[B$\u0018\u0010R5s\u000bb\u0004\u0018N]3EkJ\fG/[8o\u001bN,\"a!\r\u0002;9|g.Z#naRLH)\u001b:FqBL'/\u001a#ve\u0006$\u0018n\u001c8Ng\u0002\n\u0001c\u001d;pe\u0006<WmU2iK\u0012,H.\u001a:\u0002#M$xN]1hKN\u001b\u0007.\u001a3vY\u0016\u0014\b%A\u000bdY\u0016\fg.\u001e9FqBL'/\u001a3BaB$\u0015N]:\u0015\r\tm3QZBi\u0011\u001d\u0019yM\u0010a\u0001\u0007c\t!\"\u001a=qSJ,G+[7f\u0011%\u0019\u0019N\u0010I\u0001\u0002\u0004\u0019y%\u0001\njg\u001e\u0013\u0018mY3gk2\u001c\u0006.\u001e;e_^t\u0017aH2mK\u0006tW\u000f]#ya&\u0014X\rZ!qa\u0012K'o\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u00111\u0011\u001c\u0016\u0005\u0007\u001f\u001aYn\u000b\u0002\u0004^B!1q\\Bu\u001b\t\u0019\tO\u0003\u0003\u0004d\u000e\u0015\u0018!C;oG\",7m[3e\u0015\u0011\u00199/a\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004l\u000e\u0005(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006yA-\u001a7fi\u0016$\u0015N]3di>\u0014\u0018\u0010\u0006\u0004\u0003\\\rE8Q\u001f\u0005\b\u0007g\u0004\u0005\u0019AA0\u0003\r!\u0017N\u001d\u0005\b\u0007o\u0004\u0005\u0019AAu\u0003)!\bN]3bIB{w\u000e\\\u0001\u0014I\u0016dW\r^3GS2,w+\u001b;i%\u0016$(/\u001f\u000b\u0005\u00057\u001ai\u0010C\u0004\u0004\u0000\u0006\u0003\r!a\u0018\u0002\t\u0019LG.Z\u0001\u0019G\",7m[%g/>\u00148.\u001b8h\t&\u00148\t\\3b]\u0016$WCAB(\u0003\u0015\u0019Gn\\:f\u0003A1G.^:i\r&dWm\u0016:ji\u0016\u00148/A\u0004p]B\u000bWo]3\u0015\t\tmCQ\u0002\u0005\b\t\u001f)\u0005\u0019AA7\u0003)iw\u000eZ;mK:\u000bW.Z\u0001\t_:\u0014Vm];nKR!!1\fC\u000b\u0011\u001d!yA\u0012a\u0001\u0003[\naa\u001c8Ue&l\u0017aD;qI\u0006$X\rR5tW&sgm\\:\u0002?U\u001cXM\u001d*fg>,(oY3D_:\u001cX/\u001c9uS>t7K\\1qg\"|G\u000f\u0006\u0002\u0005 AA\u0011q\u000eC\u0011\u00073\"\u0019#\u0003\u0003\u0002\u001a\u0006}\u0004\u0003\u0002C\u0013\tWi!\u0001b\n\u000b\u0007\u0011%R.A\u0003rk>$\u0018-\u0003\u0003\u0005.\u0011\u001d\"a\u0005*fg>,(oY3D_:\u001cX/\u001c9uS>t\u0017A\u00069s_R,7\r^3eI\u0011\u00147\u000b[;gM2,7*Z=\u0015\t\u0011MB1\t\u000b\u0005\tk!\t\u0005\u0005\u0004\u0002\u000e\u0012]B1H\u0005\u0005\ts\t\u0019HA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002\u000e\u0012u\u0012\u0002\u0002C \u0003g\u0012AAQ=uK\"91q\u0015&A\u0002\t}\u0006\"CAE\u0015\u0006\u0005\t\u0019AA!\u00039\u0019Fo\u001c:bO\u0016l\u0015M\\1hKJ\u0004\"A\u001a'\u0014\u00071#Y\u0005\u0005\u0003\u0002\u000e\u00125\u0013\u0002\u0002C(\u0003g\u0012a!\u00118z%\u00164GC\u0001C$\u0003\u0019AGMZ:GgV\u0011Aq\u000b\t\u0005\t3\"Y&\u0004\u0002\u00032%!AQ\fB\u0019\u0005)1\u0015\u000e\\3TsN$X-\\\u0001\u000bQ\u001247OR:`I\u0015\fH\u0003\u0002B.\tGB\u0011\"!#P\u0003\u0003\u0005\r\u0001b\u0016\u0002\u000f!$gm\u001d$tA\u0001")
public final class StorageManager
extends ShuffleRecoverHelper
implements DeviceObserver,
Logging,
MemoryManager.MemoryPressureListener {
    private final CelebornConf conf;
    private final AbstractSource workerSource;
    private final ConcurrentHashMap<File, ConcurrentHashMap<String, FileWriter>> workingDirWriters;
    private final /* synthetic */ Tuple2 x$1;
    private final java.util.Map<String, DeviceInfo> deviceInfos;
    private final java.util.Map<String, DiskInfo> diskInfos;
    private final HashSet<String> mountPoints;
    private final ConcurrentHashMap<String, ThreadPoolExecutor> diskOperators;
    private final ConcurrentHashMap<String, DiskInfo> tmpDiskInfos;
    private final DeviceMonitor deviceMonitor;
    private final ConcurrentHashMap<String, LocalFlusher> localFlushers;
    private final ScheduledExecutorService actionService;
    private final String hdfsDir;
    private final FsPermission hdfsPermission;
    private final ConcurrentHashMap<String, FileWriter> hdfsWriters;
    private final Option<HdfsFlusher> hdfsFlusher;
    private final AtomicInteger counter;
    private final IntUnaryOperator counterOperator;
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, FileInfo>> fileInfos;
    private final String RECOVERY_FILE_NAME;
    private DB db;
    private final Function<String, ConcurrentHashMap<String, FileInfo>> newMapFunc;
    private final Function<File, ConcurrentHashMap<String, FileWriter>> workingDirWriterListFunc;
    private final long org$apache$celeborn$service$deploy$worker$storage$StorageManager$$noneEmptyDirExpireDurationMs;
    private final ScheduledExecutorService storageScheduler;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public static void hdfsFs_$eq(FileSystem fileSystem) {
        StorageManager$.MODULE$.hdfsFs_$eq(fileSystem);
    }

    public static FileSystem hdfsFs() {
        return StorageManager$.MODULE$.hdfsFs();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    @Override
    public void notifyNonCriticalError(String mountPoint, DiskStatus diskStatus) {
        DeviceObserver.notifyNonCriticalError$(this, mountPoint, diskStatus);
    }

    @Override
    public void notifyHighDiskUsage(String mountPoint) {
        DeviceObserver.notifyHighDiskUsage$(this, mountPoint);
    }

    private Logger log$lzycompute() {
        StorageManager storageManager = this;
        synchronized (storageManager) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public /* synthetic */ byte[] protected$dbShuffleKey(StorageManager x$1, String shuffleKey) {
        return x$1.dbShuffleKey(shuffleKey);
    }

    public ConcurrentHashMap<File, ConcurrentHashMap<String, FileWriter>> workingDirWriters() {
        return this.workingDirWriters;
    }

    public java.util.Map<String, DeviceInfo> deviceInfos() {
        return this.deviceInfos;
    }

    public java.util.Map<String, DiskInfo> diskInfos() {
        return this.diskInfos;
    }

    public HashSet<String> mountPoints() {
        return this.mountPoints;
    }

    public List<DiskInfo> disksSnapshot() {
        List list;
        java.util.Map<String, DiskInfo> map = this.diskInfos();
        synchronized (map) {
            ArrayList<DiskInfo> disks = new ArrayList<DiskInfo>(this.diskInfos().values());
            list = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(disks).asScala()).toList();
        }
        return list;
    }

    public List<File> healthyWorkingDirs() {
        return (List)((List)this.disksSnapshot().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StorageManager.$anonfun$healthyWorkingDirs$1(x$2)))).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.dirs(), List$.MODULE$.canBuildFrom());
    }

    private ConcurrentHashMap<String, ThreadPoolExecutor> diskOperators() {
        return this.diskOperators;
    }

    public ConcurrentHashMap<String, DiskInfo> tmpDiskInfos() {
        return this.tmpDiskInfos;
    }

    private DeviceMonitor deviceMonitor() {
        return this.deviceMonitor;
    }

    private ConcurrentHashMap<String, LocalFlusher> localFlushers() {
        return this.localFlushers;
    }

    private ScheduledExecutorService actionService() {
        return this.actionService;
    }

    public String hdfsDir() {
        return this.hdfsDir;
    }

    public FsPermission hdfsPermission() {
        return this.hdfsPermission;
    }

    public ConcurrentHashMap<String, FileWriter> hdfsWriters() {
        return this.hdfsWriters;
    }

    public Option<HdfsFlusher> hdfsFlusher() {
        return this.hdfsFlusher;
    }

    @Override
    public synchronized void notifyError(String mountPoint, DiskStatus diskStatus) {
        block1: {
            DiskStatus diskStatus2 = diskStatus;
            DiskStatus diskStatus3 = DiskStatus.IO_HANG;
            if (diskStatus2 != null ? !diskStatus2.equals(diskStatus3) : diskStatus3 != null) break block1;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "IoHang, remove disk operator.");
            ThreadPoolExecutor operator = this.diskOperators().remove(mountPoint);
            if (operator != null) {
                operator.shutdown();
            }
        }
    }

    @Override
    public void notifyHealthy(String mountPoint) {
        StorageManager storageManager = this;
        synchronized (storageManager) {
            Object object = !this.diskOperators().containsKey(mountPoint) ? this.diskOperators().put(mountPoint, ThreadUtils$.MODULE$.newDaemonCachedThreadPool(new StringBuilder(13).append("Disk-cleaner-").append(mountPoint).toString(), 1, ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3())) : BoxedUnit.UNIT;
        }
    }

    private AtomicInteger counter() {
        return this.counter;
    }

    private IntUnaryOperator counterOperator() {
        return this.counterOperator;
    }

    private ConcurrentHashMap<String, ConcurrentHashMap<String, FileInfo>> fileInfos() {
        return this.fileInfos;
    }

    private String RECOVERY_FILE_NAME() {
        return this.RECOVERY_FILE_NAME;
    }

    private DB db() {
        return this.db;
    }

    private void db_$eq(DB x$1) {
        this.db = x$1;
    }

    private void reloadAndCleanFileInfos(DB db) {
        if (db != null) {
            ConcurrentHashMap cache = new ConcurrentHashMap();
            DBIterator itr = db.iterator();
            itr.seek(this.SHUFFLE_KEY_PREFIX.getBytes(StandardCharsets.UTF_8));
            while (itr.hasNext()) {
                Map.Entry entry = (Map.Entry)itr.next();
                String key = new String((byte[])entry.getKey(), StandardCharsets.UTF_8);
                if (key.startsWith(this.SHUFFLE_KEY_PREFIX)) {
                    String shuffleKey = this.parseDbShuffleKey(key);
                    try {
                        ConcurrentHashMap files = PbSerDeUtils$.MODULE$.fromPbFileInfoMap((byte[])entry.getValue(), cache);
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Reload DB: ").append(shuffleKey).append(" -> ").append(files).toString());
                        this.fileInfos().put(shuffleKey, files);
                        db.delete((byte[])entry.getKey());
                    }
                    catch (Exception exception) {
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Reload DB: ").append(shuffleKey).append(" failed.").toString(), exception);
                    }
                    continue;
                }
                return;
            }
        }
    }

    public void updateFileInfosInDB() {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.fileInfos()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StorageManager.$anonfun$updateFileInfosInDB$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private int getNextIndex() {
        return this.counter().getAndUpdate(this.counterOperator());
    }

    private Function<String, ConcurrentHashMap<String, FileInfo>> newMapFunc() {
        return this.newMapFunc;
    }

    private Function<File, ConcurrentHashMap<String, FileWriter>> workingDirWriterListFunc() {
        return this.workingDirWriterListFunc;
    }

    public FileWriter createWriter(String appId, int shuffleId, PartitionLocation location, long splitThreshold, PartitionSplitMode splitMode, PartitionType partitionType, boolean rangeReadFilter, UserIdentifier userIdentifier) throws IOException {
        if (this.healthyWorkingDirs().size() <= 0 && this.hdfsDir().isEmpty()) {
            throw new IOException("No available working dirs!");
        }
        String fileName = location.getFileName();
        IOException exception = null;
        String suggestedMountPoint = location.getStorageInfo().getMountPoint();
        for (int retryCount = 0; retryCount < this.conf.createWriterMaxAttempts(); ++retryCount) {
            List<File> dirs;
            List<File> list;
            DiskInfo diskInfo = this.diskInfos().get(suggestedMountPoint);
            if (diskInfo != null && diskInfo.status().equals((Object)DiskStatus.HEALTHY)) {
                list = diskInfo.dirs();
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Disk unavailable for ").append(suggestedMountPoint).append(", return all healthy").append(" working dirs. diskInfo ").append(diskInfo).toString());
                list = dirs = this.healthyWorkingDirs();
            }
            if (dirs.isEmpty() && this.hdfsFlusher().isEmpty()) {
                throw new IOException(new StringBuilder(41).append("No available disks! suggested mountPoint ").append(suggestedMountPoint).toString());
            }
            String shuffleKey = Utils$.MODULE$.makeShuffleKey(appId, shuffleId);
            if (dirs.isEmpty()) {
                Path shuffleDir = new Path(new Path(this.hdfsDir(), this.conf.workerWorkingDir()), new StringBuilder(1).append(appId).append("/").append(shuffleId).toString());
                FileSystem.mkdirs((FileSystem)StorageManager$.MODULE$.hdfsFs(), (Path)shuffleDir, (FsPermission)this.hdfsPermission());
                FileInfo fileInfo = new FileInfo(new Path(shuffleDir, fileName).toString(), userIdentifier, partitionType);
                FileWriter hdfsWriter = new FileWriter(fileInfo, (Flusher)this.hdfsFlusher().get(), this.workerSource, this.conf, this.deviceMonitor(), splitThreshold, splitMode, partitionType, rangeReadFilter);
                this.fileInfos().computeIfAbsent(shuffleKey, this.newMapFunc()).put(fileName, fileInfo);
                this.hdfsWriters().put(fileInfo.getFilePath(), hdfsWriter);
                return hdfsWriter;
            }
            File dir = (File)dirs.apply(this.getNextIndex() % dirs.size());
            String mountPoint = DeviceInfo$.MODULE$.getMountPoint(dir.getAbsolutePath(), this.mountPoints());
            File shuffleDir = new File(dir, new StringBuilder(1).append(appId).append("/").append(shuffleId).toString());
            File file = new File(shuffleDir, fileName);
            try {
                shuffleDir.mkdirs();
                if (file.exists()) {
                    throw new FileAlreadyExistsException(new StringBuilder(34).append("Shuffle data file ").append(file.getAbsolutePath()).append(" already exists.").toString());
                }
                boolean createFileSuccess = file.createNewFile();
                if (!createFileSuccess) {
                    throw new CelebornException(new StringBuilder(33).append("Create shuffle data file ").append(file.getAbsolutePath()).append(" failed!").toString());
                }
                FileInfo fileInfo = new FileInfo(file.getAbsolutePath(), userIdentifier, partitionType);
                FileWriter fileWriter = new FileWriter(fileInfo, this.localFlushers().get(mountPoint), this.workerSource, this.conf, this.deviceMonitor(), splitThreshold, splitMode, partitionType, rangeReadFilter);
                this.deviceMonitor().registerFileWriter(fileWriter);
                ConcurrentHashMap<String, FileWriter> map = this.workingDirWriters().computeIfAbsent(dir, this.workingDirWriterListFunc());
                map.put(fileInfo.getFilePath(), fileWriter);
                this.fileInfos().computeIfAbsent(shuffleKey, this.newMapFunc()).put(fileName, fileInfo);
                location.getStorageInfo().setMountPoint(mountPoint);
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("location ").append(location).append(" set disk hint to ").append(location.getStorageInfo()).append(" ").toString());
                return fileWriter;
            }
            catch (FileAlreadyExistsException fe) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to create fileWriter because of existed file", fe);
                throw fe;
            }
            catch (Throwable t) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Create FileWriter for ").append(file.getAbsolutePath()).append(" of mount ").append(mountPoint).append(" ").append("failed, report to DeviceMonitor").toString(), t);
                exception = new IOException(t);
                this.deviceMonitor().reportNonCriticalError(mountPoint, exception, DiskStatus.READ_OR_WRITE_FAILURE);
                continue;
            }
        }
        throw exception;
    }

    public FileInfo getFileInfo(String shuffleKey, String fileName) {
        ConcurrentHashMap<String, FileInfo> shuffleMap = this.fileInfos().get(shuffleKey);
        return shuffleMap != null ? shuffleMap.get(fileName) : null;
    }

    /*
     * WARNING - void declaration
     */
    public HashSet<String> shuffleKeySet() {
        void var1_1;
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.fileInfos().keySet());
        return var1_1;
    }

    public java.util.Map<String, Object> topAppDiskUsage() {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((IterableLike)((SeqLike)((MapLike)((TraversableLike)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.fileInfos()).asScala()).map((Function1 & Serializable & scala.Serializable)keyedWriters -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(keyedWriters._1()), ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((ConcurrentHashMap)keyedWriters._2()).values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.getFileLength()), scala.collection.Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), Map$.MODULE$.canBuildFrom())).toList().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String shuffleKey = (String)tuple2._1();
            long usage = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)shuffleKey.split("-")[0]), (Object)BoxesRunTime.boxToLong((long)usage));
            return tuple22;
        }, List$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5._1()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            List values = (List)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), ((TraversableOnce)values.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6._2$mcJ$sp()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7._2$mcJ$sp()), (Ordering)Ordering.Long$.MODULE$)).reverse()).take(this.conf.metricsAppTopDiskUsageCount() * 2)).toMap(Predef$.MODULE$.$conforms())).asJava();
    }

    public void cleanupExpiredShuffleKey(HashSet<String> expiredShuffleKeys) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(expiredShuffleKeys).asScala()).foreach((Function1 & Serializable & scala.Serializable)shuffleKey -> {
            StorageManager.$anonfun$cleanupExpiredShuffleKey$1(this, shuffleKey);
            return BoxedUnit.UNIT;
        });
    }

    public long org$apache$celeborn$service$deploy$worker$storage$StorageManager$$noneEmptyDirExpireDurationMs() {
        return this.org$apache$celeborn$service$deploy$worker$storage$StorageManager$$noneEmptyDirExpireDurationMs;
    }

    private ScheduledExecutorService storageScheduler() {
        return this.storageScheduler;
    }

    public void org$apache$celeborn$service$deploy$worker$storage$StorageManager$$cleanupExpiredAppDirs(long expireTime, boolean isGracefulShutdown) {
        Set appIds = (Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(this.shuffleKeySet()).asScala()).map((Function1 & Serializable & scala.Serializable)key -> (String)Utils$.MODULE$.splitShuffleKey(key)._1(), Set$.MODULE$.canBuildFrom());
        ((List)this.disksSnapshot().filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)StorageManager.$anonfun$cleanupExpiredAppDirs$2(x$10)))).foreach((Function1 & Serializable & scala.Serializable)diskInfo -> {
            StorageManager.$anonfun$cleanupExpiredAppDirs$3(this, isGracefulShutdown, appIds, expireTime, diskInfo);
            return BoxedUnit.UNIT;
        });
        if (StorageManager$.MODULE$.hdfsFs() != null) {
            Path hdfsWorkPath = new Path(this.hdfsDir(), this.conf.workerWorkingDir());
            if (StorageManager$.MODULE$.hdfsFs().exists(hdfsWorkPath)) {
                RemoteIterator iter = StorageManager$.MODULE$.hdfsFs().listFiles(hdfsWorkPath, false);
                while (iter.hasNext()) {
                    LocatedFileStatus fileStatus = (LocatedFileStatus)iter.next();
                    Object object = fileStatus.getModificationTime() < expireTime ? BoxesRunTime.boxToBoolean((boolean)StorageManager$.MODULE$.hdfsFs().delete(fileStatus.getPath(), true)) : BoxedUnit.UNIT;
                }
            }
        }
    }

    public boolean org$apache$celeborn$service$deploy$worker$storage$StorageManager$$cleanupExpiredAppDirs$default$2() {
        return false;
    }

    private void deleteDirectory(File dir, ThreadPoolExecutor threadPool) {
        File[] allContents = dir.listFiles();
        if (allContents != null) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allContents)).foreach((Function1 & Serializable & scala.Serializable)file -> {
                this.deleteDirectory(file, threadPool);
                return BoxedUnit.UNIT;
            });
        }
        threadPool.submit(new Runnable(this, dir){
            private final /* synthetic */ StorageManager $outer;
            private final File dir$1;

            public void run() {
                this.$outer.org$apache$celeborn$service$deploy$worker$storage$StorageManager$$deleteFileWithRetry(this.dir$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dir$1 = dir$1;
            }
        });
    }

    public void org$apache$celeborn$service$deploy$worker$storage$StorageManager$$deleteFileWithRetry(File file) {
        block3: {
            if (!file.exists()) break block3;
            boolean deleteSuccess = false;
            for (int retryCount = 0; !deleteSuccess && retryCount <= 3; ++retryCount) {
                deleteSuccess = file.delete();
                if (deleteSuccess) continue;
                Thread.sleep(200 * retryCount);
            }
            if (deleteSuccess) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Deleted expired shuffle file ").append(file).append(".").toString());
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Failed to delete expired shuffle file ").append(file).append(".").toString());
            }
        }
    }

    private boolean checkIfWorkingDirCleaned() {
        IntRef retryTimes = IntRef.create((int)0);
        long workerCheckFileCleanTimeout = this.conf.workerCheckFileCleanTimeout();
        Set appIds = (Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(this.shuffleKeySet()).asScala()).map((Function1 & Serializable & scala.Serializable)key -> (String)Utils$.MODULE$.splitShuffleKey(key)._1(), Set$.MODULE$.canBuildFrom());
        while (retryTimes.elem < this.conf.workerCheckFileCleanMaxRetries()) {
            Path hdfsWorkPath;
            FileSystem fileSystem;
            boolean localCleaned = !((LinearSeqOptimized)this.disksSnapshot().filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)StorageManager.$anonfun$checkIfWorkingDirCleaned$2(x$11)))).exists((Function1 & Serializable & scala.Serializable)diskInfo -> BoxesRunTime.boxToBoolean((boolean)StorageManager.$anonfun$checkIfWorkingDirCleaned$3(appIds, diskInfo)));
            FileSystem fileSystem2 = StorageManager$.MODULE$.hdfsFs();
            boolean bl = fileSystem2 != null ? ((fileSystem = fileSystem2).exists(hdfsWorkPath = new Path(this.hdfsDir(), this.conf.workerWorkingDir())) ? !fileSystem.listFiles(hdfsWorkPath, false).hasNext() : true) : true;
            boolean hdfsCleaned = bl;
            if (localCleaned && hdfsCleaned) {
                return true;
            }
            ++retryTimes.elem;
            if (retryTimes.elem < this.conf.workerCheckFileCleanMaxRetries()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(105).append("Working directory's files have not been cleaned up completely, ").append("will start ").append(retryTimes$1.elem + 1).append("th attempt after ").append(workerCheckFileCleanTimeout).append(" milliseconds.").toString());
            }
            Thread.sleep(workerCheckFileCleanTimeout);
        }
        return false;
    }

    public void close() {
        block6: {
            BoxedUnit boxedUnit;
            if (this.db() != null) {
                try {
                    this.updateFileInfosInDB();
                    this.db().close();
                }
                catch (Exception exception) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Store recover data to LevelDB failed.", exception);
                }
            }
            if (this.diskOperators() != null) {
                if (!this.conf.workerGracefulShutdown()) {
                    this.cleanupExpiredShuffleKey(this.shuffleKeySet());
                }
                boxedUnit = ThreadUtils$.MODULE$.parmap((TraversableLike)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskOperators()).asScala()).toMap(Predef$.MODULE$.$conforms()), "ShutdownDiskOperators", this.diskOperators().size(), (Function1 & Serializable & scala.Serializable)entry -> {
                    ThreadUtils$.MODULE$.shutdown((ExecutorService)entry._2(), (Duration)new package.DurationLong(package$.MODULE$.DurationLong(this.conf.workerFlusherShutdownTimeoutMs())).milliseconds());
                    return BoxedUnit.UNIT;
                }, Iterable$.MODULE$.canBuildFrom(), Iterable$.MODULE$.canBuildFrom());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.storageScheduler().shutdownNow();
            if (this.deviceMonitor() == null) break block6;
            this.deviceMonitor().close();
        }
    }

    public void org$apache$celeborn$service$deploy$worker$storage$StorageManager$$flushFileWriters() {
        HashSet allWriters = new HashSet();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.workingDirWriters()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StorageManager.$anonfun$flushFileWriters$1(allWriters, x0$1)));
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(allWriters).asScala()).foreach((Function1 & Serializable & scala.Serializable)writer -> {
            StorageManager.$anonfun$flushFileWriters$3(this, writer);
            return BoxedUnit.UNIT;
        });
    }

    public void onPause(String moduleName) {
    }

    public void onResume(String moduleName) {
    }

    public void onTrim() {
        this.actionService().submit(new Runnable(this){
            private final /* synthetic */ StorageManager $outer;

            public void run() {
                this.$outer.org$apache$celeborn$service$deploy$worker$storage$StorageManager$$flushFileWriters();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public synchronized void updateDiskInfos() {
        ((List)this.disksSnapshot().filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)StorageManager.$anonfun$updateDiskInfos$1(x$13)))).foreach((Function1 & Serializable & scala.Serializable)diskInfo -> {
            long totalUsage = BoxesRunTime.unboxToLong((Object)((TraversableOnce)diskInfo.dirs().map((Function1 & Serializable & scala.Serializable)dir -> BoxesRunTime.boxToLong((long)StorageManager.$anonfun$updateDiskInfos$3(this, dir)), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            long fileSystemReportedUsableSpace = Files.getFileStore(Paths.get(diskInfo.mountPoint(), new String[0])).getUsableSpace();
            long workingDirUsableSpace = Math.min(diskInfo.configuredUsableSpace() - totalUsage, fileSystemReportedUsableSpace);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("updateDiskInfos  workingDirUsableSpace:").append(workingDirUsableSpace).append(" filemeta:").append(fileSystemReportedUsableSpace).append(" conf:").append(diskInfo.configuredUsableSpace()).append(" totalUsage:").append(totalUsage).toString());
            long flushTimeAverage = ((Flusher)this.localFlushers().get(diskInfo.mountPoint())).averageFlushTime();
            diskInfo.setUsableSpace(workingDirUsableSpace);
            return diskInfo.setFlushTime(flushTimeAverage);
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Updated diskInfos: ").append(this.disksSnapshot()).toString());
    }

    public scala.collection.immutable.Map<UserIdentifier, ResourceConsumption> userResourceConsumptionSnapshot() {
        scala.collection.immutable.Map map;
        ConcurrentHashMap<String, ConcurrentHashMap<String, FileInfo>> concurrentHashMap = this.fileInfos();
        synchronized (concurrentHashMap) {
            map = (scala.collection.immutable.Map)((TraversableLike)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.fileInfos()).asScala()).toList().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ConcurrentHashMap fileInfoMaps = (ConcurrentHashMap)tuple2._2();
                Iterable iterable = (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(fileInfoMaps.values()).asScala()).map((Function1 & Serializable & scala.Serializable)fileInfo -> new Tuple2((Object)fileInfo.getUserIdentifier(), fileInfo), scala.collection.Iterable$.MODULE$.canBuildFrom());
                return iterable;
            }, List$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$15 -> (UserIdentifier)x$15._1()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                UserIdentifier userIdentifier = (UserIdentifier)tuple2._1();
                List userWithFileInfoList = (List)tuple2._2();
                List userFileInfos = (List)userWithFileInfoList.map((Function1 & Serializable & scala.Serializable)x$16 -> (FileInfo)x$16._2(), List$.MODULE$.canBuildFrom());
                List diskFileInfos = (List)userFileInfos.filter((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)StorageManager.$anonfun$userResourceConsumptionSnapshot$6(x$17)));
                List hdfsFileInfos = (List)userFileInfos.filter((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isHdfs()));
                long diskBytesWritten = BoxesRunTime.unboxToLong((Object)((TraversableOnce)diskFileInfos.map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToLong((long)x$19.getFileLength()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                int diskFileCount = diskFileInfos.size();
                long hdfsBytesWritten = BoxesRunTime.unboxToLong((Object)((TraversableOnce)hdfsFileInfos.map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToLong((long)x$20.getFileLength()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                int hdfsFileCount = hdfsFileInfos.size();
                ResourceConsumption resourceConsumption = new ResourceConsumption(diskBytesWritten, (long)diskFileCount, hdfsBytesWritten, (long)hdfsFileCount);
                Tuple2 tuple22 = new Tuple2((Object)userIdentifier, (Object)resourceConsumption);
                return tuple22;
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        }
        return map;
    }

    public static final /* synthetic */ boolean $anonfun$healthyWorkingDirs$1(DiskInfo x$2) {
        DiskStatus diskStatus = x$2.status();
        DiskStatus diskStatus2 = DiskStatus.HEALTHY;
        return !(diskStatus != null ? !diskStatus.equals(diskStatus2) : diskStatus2 != null);
    }

    public static final /* synthetic */ void $anonfun$updateFileInfosInDB$1(StorageManager $this, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String shuffleKey = (String)tuple2._1();
            ConcurrentHashMap files = (ConcurrentHashMap)tuple2._2();
            try {
                $this.db().put($this.protected$dbShuffleKey($this, shuffleKey), PbSerDeUtils$.MODULE$.toPbFileInfoMap(files));
                $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Update FileInfos into DB: ").append(shuffleKey).append(" -> ").append(files).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception exception) {
                $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Update FileInfos into DB: ").append(shuffleKey).append(" failed.").toString(), exception);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$cleanupExpiredShuffleKey$4(DiskInfo x$9) {
        DiskStatus diskStatus = x$9.status();
        DiskStatus diskStatus2 = DiskStatus.IO_HANG;
        return diskStatus == null ? diskStatus2 != null : !diskStatus.equals(diskStatus2);
    }

    public static final /* synthetic */ void $anonfun$cleanupExpiredShuffleKey$6(StorageManager $this, String appId$1, int shuffleId$1, DiskInfo diskInfo$2, File dir) {
        File file = new File(dir, new StringBuilder(1).append(appId$1).append("/").append(shuffleId$1).toString());
        $this.deleteDirectory(file, $this.diskOperators().get(diskInfo$2.mountPoint()));
    }

    public static final /* synthetic */ void $anonfun$cleanupExpiredShuffleKey$5(StorageManager $this, String appId$1, int shuffleId$1, DiskInfo diskInfo) {
        diskInfo.dirs().foreach((Function1 & Serializable & scala.Serializable)dir -> {
            StorageManager.$anonfun$cleanupExpiredShuffleKey$6($this, appId$1, shuffleId$1, diskInfo, dir);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$cleanupExpiredShuffleKey$1(StorageManager $this, String shuffleKey) {
        block2: {
            Tuple2 tuple2;
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Cleanup expired shuffle ").append(shuffleKey).append(".").toString());
            if (!$this.fileInfos().containsKey(shuffleKey)) break block2;
            ConcurrentHashMap<String, FileInfo> removedFileInfos = $this.fileInfos().remove(shuffleKey);
            BooleanRef isHdfsExpired = BooleanRef.create((boolean)false);
            if (removedFileInfos != null) {
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(removedFileInfos).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Object object;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        FileInfo fileInfo = (FileInfo)tuple2._2();
                        if (fileInfo.isHdfs()) {
                            isHdfsExpired$1.elem = true;
                            FileWriter hdfsFileWriter = $this.hdfsWriters().get(fileInfo.getFilePath());
                            if (hdfsFileWriter != null) {
                                hdfsFileWriter.destroy(new IOException(new StringBuilder(47).append("Destroy FileWriter ").append(hdfsFileWriter).append(" caused by shuffle ").append(shuffleKey).append(" expired.").toString()));
                                fileInfo.deleteAllFiles(StorageManager$.MODULE$.hdfsFs());
                                object = $this.hdfsWriters().remove(fileInfo.getFilePath());
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                        } else {
                            File workingDir = fileInfo.getFile().getParentFile().getParentFile().getParentFile();
                            ConcurrentHashMap<String, FileWriter> writers = $this.workingDirWriters().get(workingDir);
                            if (writers != null) {
                                FileWriter fileWriter = writers.get(fileInfo.getFilePath());
                                if (fileWriter != null) {
                                    fileWriter.destroy(new IOException(new StringBuilder(47).append("Destroy FileWriter ").append(fileWriter).append(" caused by shuffle ").append(shuffleKey).append(" expired.").toString()));
                                    object = writers.remove(fileInfo.getFilePath());
                                } else {
                                    object = BoxedUnit.UNIT;
                                }
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    BoxedUnit boxedUnit = object;
                    return boxedUnit;
                });
            }
            if ((tuple2 = Utils$.MODULE$.splitShuffleKey(shuffleKey)) == null) {
                throw new MatchError((Object)tuple2);
            }
            String appId = (String)tuple2._1();
            int shuffleId = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)appId, (Object)BoxesRunTime.boxToInteger((int)shuffleId));
            Tuple2 tuple23 = tuple22;
            String appId2 = (String)tuple23._1();
            int shuffleId2 = tuple23._2$mcI$sp();
            ((List)$this.disksSnapshot().filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)StorageManager.$anonfun$cleanupExpiredShuffleKey$4(x$9)))).foreach((Function1 & Serializable & scala.Serializable)diskInfo -> {
                StorageManager.$anonfun$cleanupExpiredShuffleKey$5($this, appId2, shuffleId2, diskInfo);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$cleanupExpiredAppDirs$2(DiskInfo x$10) {
        DiskStatus diskStatus = x$10.status();
        DiskStatus diskStatus2 = DiskStatus.IO_HANG;
        return diskStatus == null ? diskStatus2 != null : !diskStatus.equals(diskStatus2);
    }

    public static final /* synthetic */ void $anonfun$cleanupExpiredAppDirs$5(StorageManager $this, boolean isGracefulShutdown$1, Set appIds$1, long expireTime$1, DiskInfo diskInfo$3, File appDir) {
        block0: {
            if (isGracefulShutdown$1 && appIds$1.contains((Object)appDir.getName()) || appDir.lastModified() >= expireTime$1) break block0;
            ThreadPoolExecutor threadPool = $this.diskOperators().get(diskInfo$3.mountPoint());
            $this.deleteDirectory(appDir, threadPool);
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Delete expired app dir ").append(appDir).append(".").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$cleanupExpiredAppDirs$4(StorageManager $this, boolean isGracefulShutdown$1, Set appIds$1, long expireTime$1, DiskInfo diskInfo$3, File x0$1) {
        File file = x0$1;
        if (file.exists()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file.listFiles())).foreach((Function1 & Serializable & scala.Serializable)appDir -> {
                StorageManager.$anonfun$cleanupExpiredAppDirs$5($this, isGracefulShutdown$1, appIds$1, expireTime$1, diskInfo$3, appDir);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$cleanupExpiredAppDirs$3(StorageManager $this, boolean isGracefulShutdown$1, Set appIds$1, long expireTime$1, DiskInfo diskInfo) {
        diskInfo.dirs().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StorageManager.$anonfun$cleanupExpiredAppDirs$4($this, isGracefulShutdown$1, appIds$1, expireTime$1, diskInfo, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$checkIfWorkingDirCleaned$2(DiskInfo x$11) {
        DiskStatus diskStatus = x$11.status();
        DiskStatus diskStatus2 = DiskStatus.IO_HANG;
        return diskStatus == null ? diskStatus2 != null : !diskStatus.equals(diskStatus2);
    }

    public static final /* synthetic */ boolean $anonfun$checkIfWorkingDirCleaned$5(Set appIds$2, File appDir) {
        return !appIds$2.contains((Object)appDir.getName());
    }

    public static final /* synthetic */ boolean $anonfun$checkIfWorkingDirCleaned$4(Set appIds$2, File x0$1) {
        File file = x0$1;
        boolean bl = file.exists() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file.listFiles())).exists((Function1 & Serializable & scala.Serializable)appDir -> BoxesRunTime.boxToBoolean((boolean)StorageManager.$anonfun$checkIfWorkingDirCleaned$5(appIds$2, appDir))) : false;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$checkIfWorkingDirCleaned$3(Set appIds$2, DiskInfo diskInfo) {
        return diskInfo.dirs().exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StorageManager.$anonfun$checkIfWorkingDirCleaned$4(appIds$2, x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$flushFileWriters$2(FileWriter x$12) {
        return x$12.getException() == null;
    }

    public static final /* synthetic */ boolean $anonfun$flushFileWriters$1(HashSet allWriters$1, Tuple2 x0$1) {
        boolean bl;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ConcurrentHashMap writers;
            ConcurrentHashMap concurrentHashMap = writers = (ConcurrentHashMap)tuple2._2();
            synchronized (concurrentHashMap) {
                bl = allWriters$1.addAll(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(writers.values()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)StorageManager.$anonfun$flushFileWriters$2(x$12)))).asJavaCollection());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ void $anonfun$flushFileWriters$3(StorageManager $this, FileWriter writer) {
        try {
            writer.flushOnMemoryPressure();
        }
        catch (Throwable t) {
            $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("FileWrite of ").append(writer).append(" faces unexpected exception when flush on memory pressure.").toString(), t);
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateDiskInfos$1(DiskInfo x$13) {
        DiskStatus diskStatus = x$13.status();
        DiskStatus diskStatus2 = DiskStatus.IO_HANG;
        return diskStatus == null ? diskStatus2 != null : !diskStatus.equals(diskStatus2);
    }

    public static final /* synthetic */ long $anonfun$updateDiskInfos$4(FileWriter x$14) {
        return x$14.getFileInfo().getFileLength();
    }

    public static final /* synthetic */ long $anonfun$updateDiskInfos$3(StorageManager $this, File dir) {
        long l;
        ConcurrentHashMap<String, FileWriter> writers = $this.workingDirWriters().get(dir);
        if (writers != null) {
            ConcurrentHashMap<String, FileWriter> concurrentHashMap = writers;
            synchronized (concurrentHashMap) {
                long l2 = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(writers.values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)StorageManager.$anonfun$updateDiskInfos$4(x$14)), scala.collection.Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl7 : MonitorExitStatement: MONITOREXIT : var3_3
                l = l2;
            }
        } else {
            l = 0L;
        }
        return l;
    }

    public static final /* synthetic */ boolean $anonfun$userResourceConsumptionSnapshot$6(FileInfo x$17) {
        return !x$17.isHdfs();
    }

    public StorageManager(CelebornConf conf, AbstractSource workerSource) {
        None$ none$;
        this.conf = conf;
        this.workerSource = workerSource;
        DeviceObserver.$init$(this);
        Logging.$init$((Logging)this);
        this.workingDirWriters = new ConcurrentHashMap();
        Seq workingDirInfos = (Seq)conf.workerBaseDirs().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            String workdir = (String)tuple4._1();
            long maxSpace = BoxesRunTime.unboxToLong((Object)tuple4._2());
            int flusherThread = BoxesRunTime.unboxToInt((Object)tuple4._3());
            StorageInfo.Type storageType = (StorageInfo.Type)tuple4._4();
            Tuple4 tuple42 = new Tuple4((Object)new File(workdir, $this.conf.workerWorkingDir()), (Object)BoxesRunTime.boxToLong((long)maxSpace), (Object)BoxesRunTime.boxToInteger((int)flusherThread), (Object)storageType);
            return tuple42;
        }, Seq$.MODULE$.canBuildFrom());
        if (workingDirInfos.size() <= 0) {
            throw new IOException("Empty working directory configuration!");
        }
        Tuple2 tuple2 = DeviceInfo$.MODULE$.getDeviceAndDiskInfos(workingDirInfos);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        java.util.Map deviceInfos = (java.util.Map)tuple2._1();
        java.util.Map diskInfos = (java.util.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)deviceInfos, (Object)diskInfos);
        this.x$1 = tuple22;
        this.deviceInfos = (java.util.Map)this.x$1._1();
        this.diskInfos = (java.util.Map)this.x$1._2();
        this.mountPoints = new HashSet<String>(this.diskInfos().keySet());
        ConcurrentHashMap cleaners = new ConcurrentHashMap();
        this.disksSnapshot().foreach((Function1 & Serializable & scala.Serializable)diskInfo -> cleaners.put(diskInfo.mountPoint(), ThreadUtils$.MODULE$.newDaemonCachedThreadPool(new StringBuilder(13).append("Disk-cleaner-").append(diskInfo.mountPoint()).toString(), 1, ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3())));
        this.diskOperators = cleaners;
        this.tmpDiskInfos = new ConcurrentHashMap();
        this.disksSnapshot().foreach((Function1 & Serializable & scala.Serializable)diskInfo -> this.tmpDiskInfos().put(diskInfo.mountPoint(), (DiskInfo)diskInfo));
        this.deviceMonitor = DeviceMonitor$.MODULE$.createDeviceMonitor(conf, this, this.deviceInfos(), this.tmpDiskInfos());
        ConcurrentHashMap flushers = new ConcurrentHashMap();
        this.disksSnapshot().foreach((Function1 & Serializable & scala.Serializable)diskInfo -> {
            Object object;
            if (!flushers.containsKey(diskInfo.mountPoint())) {
                LocalFlusher flusher = new LocalFlusher($this.workerSource, this.deviceMonitor(), diskInfo.threadCount(), diskInfo.mountPoint(), $this.conf.avgFlushTimeSlidingWindowSize(), $this.conf.avgFlushTimeSlidingWindowMinCount(), diskInfo.storageType());
                object = flushers.put(diskInfo.mountPoint(), flusher);
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        this.localFlushers = flushers;
        this.actionService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("StorageManager-action-thread").build());
        this.deviceMonitor().startCheck();
        this.hdfsDir = conf.hdfsDir();
        if (!this.hdfsDir().isEmpty()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Initialize HDFS support with path ").append(this.hdfsDir()).toString());
        }
        this.hdfsPermission = FsPermission.createImmutable((short)755);
        this.hdfsWriters = new ConcurrentHashMap();
        if (!this.hdfsDir().isEmpty()) {
            Configuration hdfsConfiguration = new Configuration();
            hdfsConfiguration.set("fs.defaultFS", this.hdfsDir());
            hdfsConfiguration.set("dfs.replication", "2");
            StorageManager$.MODULE$.hdfsFs_$eq(FileSystem.get((Configuration)hdfsConfiguration));
            none$ = new Some((Object)new HdfsFlusher(workerSource, conf.hdfsFlusherThreads(), conf.avgFlushTimeSlidingWindowSize(), conf.avgFlushTimeSlidingWindowMinCount()));
        } else {
            none$ = None$.MODULE$;
        }
        this.hdfsFlusher = none$;
        this.counter = new AtomicInteger();
        this.counterOperator = new IntUnaryOperator(this){
            private final /* synthetic */ StorageManager $outer;

            public IntUnaryOperator compose(IntUnaryOperator x$1) {
                return IntUnaryOperator.super.compose(x$1);
            }

            public IntUnaryOperator andThen(IntUnaryOperator x$1) {
                return IntUnaryOperator.super.andThen(x$1);
            }

            public int applyAsInt(int operand) {
                List<File> dirs = this.$outer.healthyWorkingDirs();
                return dirs.length() > 0 ? (operand + 1) % dirs.length() : 0;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.fileInfos = new ConcurrentHashMap();
        this.RECOVERY_FILE_NAME = "recovery.ldb";
        this.db = null;
        if (conf.workerGracefulShutdown()) {
            try {
                File recoverFile = new File(conf.workerRecoverPath(), this.RECOVERY_FILE_NAME());
                this.db_$eq(LevelDBProvider.initLevelDB(recoverFile, this.CURRENT_VERSION));
                this.reloadAndCleanFileInfos(this.db());
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Init level DB failed:", e);
                this.db_$eq(null);
            }
        }
        this.org$apache$celeborn$service$deploy$worker$storage$StorageManager$$cleanupExpiredAppDirs(System.currentTimeMillis(), conf.workerGracefulShutdown());
        if (!this.checkIfWorkingDirCleaned()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Worker still has residual files in the working directory before registering with Master, please refer to the configuration document to increase celeborn.worker.disk.checkFileClean.maxRetries or celeborn.worker.disk.checkFileClean.timeout .");
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Successfully remove all files under working directory.");
        }
        this.newMapFunc = new Function<String, ConcurrentHashMap<String, FileInfo>>(null){

            public <V> Function<V, ConcurrentHashMap<String, FileInfo>> compose(Function<? super V, ? extends String> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<String, V> andThen(Function<? super ConcurrentHashMap<String, FileInfo>, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public ConcurrentHashMap<String, FileInfo> apply(String key) {
                return new ConcurrentHashMap<String, FileInfo>();
            }
        };
        this.workingDirWriterListFunc = new Function<File, ConcurrentHashMap<String, FileWriter>>(null){

            public <V> Function<V, ConcurrentHashMap<String, FileWriter>> compose(Function<? super V, ? extends File> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<File, V> andThen(Function<? super ConcurrentHashMap<String, FileWriter>, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public ConcurrentHashMap<String, FileWriter> apply(File t) {
                return new ConcurrentHashMap<String, FileWriter>();
            }
        };
        this.org$apache$celeborn$service$deploy$worker$storage$StorageManager$$noneEmptyDirExpireDurationMs = conf.workerNonEmptyDirExpireDuration();
        this.storageScheduler = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("storage-scheduler");
        this.storageScheduler().scheduleAtFixedRate(new Runnable(this){
            private final /* synthetic */ StorageManager $outer;

            public void run() {
                try {
                    this.$outer.org$apache$celeborn$service$deploy$worker$storage$StorageManager$$cleanupExpiredAppDirs(System.currentTimeMillis() - this.$outer.org$apache$celeborn$service$deploy$worker$storage$StorageManager$$noneEmptyDirExpireDurationMs(), this.$outer.org$apache$celeborn$service$deploy$worker$storage$StorageManager$$cleanupExpiredAppDirs$default$2());
                }
                catch (Exception exception) {
                    this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Cleanup expired shuffle data exception: ").append(exception.getMessage()).toString());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(java.lang.Exception )}, serializedLambda);
            }
        }, 0L, 30L, TimeUnit.MINUTES);
    }
}

