/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.channels.ClosedByInterruptException;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.LongAdder;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.DiskStatus;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.network.server.memory.MemoryManager;
import org.apache.celeborn.service.deploy.worker.WorkerSource$;
import org.apache.celeborn.service.deploy.worker.storage.FlushTask;
import org.apache.celeborn.service.deploy.worker.storage.LocalFlusher;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005}hA\u0002\u0017.\u0003\u0003y3\b\u0003\u0005K\u0001\t\u0015\r\u0011\"\u0001M\u0011!)\u0006A!A!\u0002\u0013i\u0005\u0002\u0003,\u0001\u0005\u000b\u0007I\u0011A,\t\u0011m\u0003!\u0011!Q\u0001\naC\u0001\u0002\u0018\u0001\u0003\u0006\u0004%\ta\u0016\u0005\t;\u0002\u0011\t\u0011)A\u00051\"Aa\f\u0001BC\u0002\u0013\u0005q\u000b\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003Y\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011!A\u0007\u0001#b\u0001\n#9\u0006bB5\u0001\u0005\u0004%\tB\u001b\u0005\u0007w\u0002\u0001\u000b\u0011B6\t\u000fq\u0004!\u0019!C\t{\"9\u00111\u0003\u0001!\u0002\u0013q\b\"CA\u000b\u0001\t\u0007I\u0011CA\f\u0011!\t9\u0003\u0001Q\u0001\n\u0005e\u0001\u0002CA\u0015\u0001\u0001\u0007I\u0011C,\t\u0013\u0005-\u0002\u00011A\u0005\u0012\u00055\u0002bBA\u001d\u0001\u0001\u0006K\u0001\u0017\u0005\n\u0003w\u0001!\u0019!C\t\u0003{A\u0001\"a\u0013\u0001A\u0003%\u0011q\b\u0005\n\u0003\u001b\u0002!\u0019!C\t\u0003{A\u0001\"a\u0014\u0001A\u0003%\u0011q\b\u0005\n\u0003#\u0002!\u0019!C\t\u0003'B\u0001\"a\u0019\u0001A\u0003%\u0011Q\u000b\u0005\t\u0003K\u0002\u0001\u0019!C\t/\"I\u0011q\r\u0001A\u0002\u0013E\u0011\u0011\u000e\u0005\b\u0003[\u0002\u0001\u0015)\u0003Y\u0011%\ty\u0007\u0001b\u0001\n\u0003\t\t\b\u0003\u0005\u0002z\u0001\u0001\u000b\u0011BA:\u0011%\tY\b\u0001b\u0001\n\u0003\ti\b\u0003\u0005\u0002\u0006\u0002\u0001\u000b\u0011BA@\u0011%\t9\t\u0001b\u0001\n\u0003\tI\t\u0003\u0005\u0002\u0016\u0002\u0001\u000b\u0011BAF\u0011\u001d\t9\n\u0001C\u0005\u00033Ca!a'\u0001\t\u00039\u0006bBAO\u0001\u0011\u0005\u0011q\u0014\u0005\b\u0003C\u0003A\u0011AAR\u0011\u001d\t)\u000b\u0001C\u0001\u0003OCq!a+\u0001\t\u0003\ti\u000bC\u0004\u0002B\u0002!\t!a1\t\u000f\u0005m\u0007\u0001\"\u0001\u0002\u001a\"9\u0011Q\u001c\u0001\u0007\u0002\u0005}'a\u0002$mkNDWM\u001d\u0006\u0003]=\nqa\u001d;pe\u0006<WM\u0003\u00021c\u00051qo\u001c:lKJT!AM\u001a\u0002\r\u0011,\u0007\u000f\\8z\u0015\t!T'A\u0004tKJ4\u0018nY3\u000b\u0005Y:\u0014\u0001C2fY\u0016\u0014wN\u001d8\u000b\u0005aJ\u0014AB1qC\u000eDWMC\u0001;\u0003\ry'oZ\n\u0004\u0001q\u0012\u0005CA\u001fA\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s$AB!osJ+g\r\u0005\u0002D\u00116\tAI\u0003\u0002F\r\u0006A\u0011N\u001c;fe:\fGN\u0003\u0002Hk\u000511m\\7n_:L!!\u0013#\u0003\u000f1{wmZ5oO\u0006aqo\u001c:lKJ\u001cv.\u001e:dK\u000e\u0001Q#A'\u0011\u00059\u001bV\"A(\u000b\u0005A\u000b\u0016AB:pkJ\u001cWM\u0003\u0002S\r\u00069Q.\u001a;sS\u000e\u001c\u0018B\u0001+P\u00059\t%m\u001d;sC\u000e$8k\\;sG\u0016\fQb^8sW\u0016\u00148k\\;sG\u0016\u0004\u0013a\u0003;ie\u0016\fGmQ8v]R,\u0012\u0001\u0017\t\u0003{eK!A\u0017 \u0003\u0007%sG/\u0001\u0007uQJ,\u0017\rZ\"pk:$\b%A\u000fbm\u001e4E.^:i)&lWm\u00157jI&twmV5oI><8+\u001b>f\u0003y\tgo\u001a$mkNDG+[7f'2LG-\u001b8h/&tGm\\<TSj,\u0007%A\u0011bm\u001e4E.^:i)&lWm\u00157jI&twmV5oI><X*\u001b8D_VtG/\u0001\u0012bm\u001e4E.^:i)&lWm\u00157jI&twmV5oI><X*\u001b8D_VtG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\t$WMZ4\u0011\u0005\r\u0004Q\"A\u0017\t\u000b)K\u0001\u0019A'\t\u000bYK\u0001\u0019\u0001-\t\u000bqK\u0001\u0019\u0001-\t\u000byK\u0001\u0019\u0001-\u0002\u0013\u0019dWo\u001d5fe&#\u0017!D<pe.LgnZ)vKV,7/F\u0001l!\riDN\\\u0005\u0003[z\u0012Q!\u0011:sCf\u00042a\u001c<y\u001b\u0005\u0001(BA9s\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003gR\fA!\u001e;jY*\tQ/\u0001\u0003kCZ\f\u0017BA<q\u0005Ma\u0015N\\6fI\ncwnY6j]\u001e\fV/Z;f!\t\u0019\u00170\u0003\u0002{[\tIa\t\\;tQR\u000b7o[\u0001\u000fo>\u00148.\u001b8h#V,W/Z:!\u0003-\u0011WO\u001a4feF+X-^3\u0016\u0003y\u00042a\u001c<\u0000!\u0011\t\t!a\u0004\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\taAY;gM\u0016\u0014(\u0002BA\u0005\u0003\u0017\tQA\\3uifT!!!\u0004\u0002\u0005%|\u0017\u0002BA\t\u0003\u0007\u0011\u0001cQ8na>\u001c\u0018\u000e^3CsR,')\u001e4\u0002\u0019\t,hMZ3s#V,W/\u001a\u0011\u0002\u000f]|'o[3sgV\u0011\u0011\u0011\u0004\t\u0005{1\fY\u0002\u0005\u0003\u0002\u001e\u0005\rRBAA\u0010\u0015\r\t\t\u0003^\u0001\u0005Y\u0006tw-\u0003\u0003\u0002&\u0005}!A\u0002+ie\u0016\fG-\u0001\u0005x_J\\WM]:!\u0003=qW\r\u001f;X_J\\WM]%oI\u0016D\u0018a\u00058fqR<vN]6fe&sG-\u001a=`I\u0015\fH\u0003BA\u0018\u0003k\u00012!PA\u0019\u0013\r\t\u0019D\u0010\u0002\u0005+:LG\u000f\u0003\u0005\u00028I\t\t\u00111\u0001Y\u0003\rAH%M\u0001\u0011]\u0016DHoV8sW\u0016\u0014\u0018J\u001c3fq\u0002\n!B\u001a7vg\"\u001cu.\u001e8u+\t\ty\u0004\u0005\u0003\u0002B\u0005\u001dSBAA\"\u0015\r\t)\u0005]\u0001\u0007CR|W.[2\n\t\u0005%\u00131\t\u0002\n\u0019>tw-\u00113eKJ\f1B\u001a7vg\"\u001cu.\u001e8uA\u0005qa\r\\;tQR{G/\u00197US6,\u0017a\u00044mkNDGk\u001c;bYRKW.\u001a\u0011\u0002\u001b\u00054x\rV5nK^Kg\u000eZ8x+\t\t)\u0006\u0005\u0003>Y\u0006]\u0003cB\u001f\u0002Z\u0005u\u0013QL\u0005\u0004\u00037r$A\u0002+va2,'\u0007E\u0002>\u0003?J1!!\u0019?\u0005\u0011auN\\4\u0002\u001d\u00054x\rV5nK^Kg\u000eZ8xA\u0005I\u0012M^4US6,w+\u001b8e_^\u001cUO\u001d:f]RLe\u000eZ3y\u0003u\tgo\u001a+j[\u0016<\u0016N\u001c3po\u000e+(O]3oi&sG-\u001a=`I\u0015\fH\u0003BA\u0018\u0003WB\u0001\"a\u000e\u001c\u0003\u0003\u0005\r\u0001W\u0001\u001bCZ<G+[7f/&tGm\\<DkJ\u0014XM\u001c;J]\u0012,\u0007\u0010I\u0001\u0013Y\u0006\u001cHOQ3hS:4E.^:i)&lW-\u0006\u0002\u0002tA!\u0011\u0011IA;\u0013\u0011\t9(a\u0011\u0003\u001f\u0005#x.\\5d\u0019>tw-\u0011:sCf\f1\u0003\\1ti\n+w-\u001b8GYV\u001c\b\u000eV5nK\u0002\n\u0001b\u001d;pa\u001ac\u0017mZ\u000b\u0003\u0003\u007f\u0002B!!\u0011\u0002\u0002&!\u00111QA\"\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006I1\u000f^8q\r2\fw\rI\u0001\u0005e\u0006tG-\u0006\u0002\u0002\fB!\u0011QRAI\u001b\t\tyI\u0003\u0002t}%!\u00111SAH\u0005\u0019\u0011\u0016M\u001c3p[\u0006)!/\u00198eA\u0005!\u0011N\\5u)\t\ty#\u0001\bhKR<vN]6fe&sG-\u001a=\u0002!\u00054XM]1hK\u001acWo\u001d5US6,GCAA/\u0003)!\u0018m[3Ck\u001a4WM\u001d\u000b\u0002\u007f\u0006a!/\u001a;ve:\u0014UO\u001a4feR!\u0011qFAU\u0011\u0019\t)a\na\u0001\u007f\u00069\u0011\r\u001a3UCN\\G\u0003CAX\u0003k\u000bI,!0\u0011\u0007u\n\t,C\u0002\u00024z\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004\u00028\"\u0002\r\u0001_\u0001\u0005i\u0006\u001c8\u000eC\u0004\u0002<\"\u0002\r!!\u0018\u0002\u0013QLW.Z8vi6\u001b\bBBA`Q\u0001\u0007\u0001,A\u0006x_J\\WM]%oI\u0016D\u0018a\u00042vM\u001a,'/U;fk\u0016LeNZ8\u0015\u0005\u0005\u0015\u0007\u0003BAd\u0003+tA!!3\u0002RB\u0019\u00111\u001a \u000e\u0005\u00055'bAAh\u0017\u00061AH]8pizJ1!a5?\u0003\u0019\u0001&/\u001a3fM&!\u0011q[Am\u0005\u0019\u0019FO]5oO*\u0019\u00111\u001b \u0002'M$x\u000e]!oI\u000ecW-\u00198GYV\u001c\b.\u001a:\u0002%A\u0014xnY3tg&{U\t_2faRLwN\u001c\u000b\u0007\u0003_\t\t/a<\t\u000f\u0005\r8\u00061\u0001\u0002f\u0006\tQ\r\u0005\u0003\u0002h\u0006-XBAAu\u0015\r\ti\u0001^\u0005\u0005\u0003[\fIOA\u0006J\u001f\u0016C8-\u001a9uS>t\u0007bBAyW\u0001\u0007\u00111_\u0001\u0010I\u00164\u0018nY3FeJ|'\u000fV=qKB!\u0011Q_A~\u001b\t\t9PC\u0002\u0002z\u001a\u000bA!\\3uC&!\u0011Q`A|\u0005)!\u0015n]6Ti\u0006$Xo\u001d")
public abstract class Flusher
implements Logging {
    private int flusherId;
    private final AbstractSource workerSource;
    private final int threadCount;
    private final int avgFlushTimeSlidingWindowSize;
    private final int avgFlushTimeSlidingWindowMinCount;
    private final LinkedBlockingQueue<FlushTask>[] workingQueues;
    private final LinkedBlockingQueue<CompositeByteBuf> bufferQueue;
    private final Thread[] workers;
    private int nextWorkerIndex;
    private final LongAdder flushCount;
    private final LongAdder flushTotalTime;
    private final Tuple2<Object, Object>[] avgTimeWindow;
    private int avgTimeWindowCurrentIndex;
    private final AtomicLongArray lastBeginFlushTime;
    private final AtomicBoolean stopFlag;
    private final Random rand;
    private transient Logger log;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        Flusher flusher = this;
        synchronized (flusher) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public AbstractSource workerSource() {
        return this.workerSource;
    }

    public int threadCount() {
        return this.threadCount;
    }

    public int avgFlushTimeSlidingWindowSize() {
        return this.avgFlushTimeSlidingWindowSize;
    }

    public int avgFlushTimeSlidingWindowMinCount() {
        return this.avgFlushTimeSlidingWindowMinCount;
    }

    private int flusherId$lzycompute() {
        Flusher flusher = this;
        synchronized (flusher) {
            if (!this.bitmap$0) {
                this.flusherId = System.identityHashCode(this);
                this.bitmap$0 = true;
            }
        }
        return this.flusherId;
    }

    public int flusherId() {
        return !this.bitmap$0 ? this.flusherId$lzycompute() : this.flusherId;
    }

    public LinkedBlockingQueue<FlushTask>[] workingQueues() {
        return this.workingQueues;
    }

    public LinkedBlockingQueue<CompositeByteBuf> bufferQueue() {
        return this.bufferQueue;
    }

    public Thread[] workers() {
        return this.workers;
    }

    public int nextWorkerIndex() {
        return this.nextWorkerIndex;
    }

    public void nextWorkerIndex_$eq(int x$1) {
        this.nextWorkerIndex = x$1;
    }

    public LongAdder flushCount() {
        return this.flushCount;
    }

    public LongAdder flushTotalTime() {
        return this.flushTotalTime;
    }

    public Tuple2<Object, Object>[] avgTimeWindow() {
        return this.avgTimeWindow;
    }

    public int avgTimeWindowCurrentIndex() {
        return this.avgTimeWindowCurrentIndex;
    }

    public void avgTimeWindowCurrentIndex_$eq(int x$1) {
        this.avgTimeWindowCurrentIndex = x$1;
    }

    public AtomicLongArray lastBeginFlushTime() {
        return this.lastBeginFlushTime;
    }

    public AtomicBoolean stopFlag() {
        return this.stopFlag;
    }

    public Random rand() {
        return this.rand;
    }

    private void init() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.avgFlushTimeSlidingWindowSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            $this.avgTimeWindow()[i] = new Tuple2.mcJJ.sp(0L, 0L);
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.lastBeginFlushTime().length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.lastBeginFlushTime().set(i, -1L));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.threadCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            $this.workingQueues()[index] = new LinkedBlockingQueue();
            $this.workers()[index] = new Thread(this, index){
                private final /* synthetic */ Flusher $outer;
                private final int index$1;

                public void run() {
                    while (!this.$outer.stopFlag().get()) {
                        FlushTask task = this.$outer.workingQueues()[this.index$1].take();
                        String key = new StringBuilder(9).append("Flusher-").append(this).append("-").append(this.$outer.rand().nextInt()).toString();
                        this.$outer.workerSource().sample(WorkerSource$.MODULE$.FlushDataTime(), key, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
                            if (!task.notifier().hasException()) {
                                try {
                                    long flushBeginTime = System.nanoTime();
                                    $this.$outer.lastBeginFlushTime().set($this.index$1, flushBeginTime);
                                    task.flush();
                                    $this.$outer.flushTotalTime().add(System.nanoTime() - flushBeginTime);
                                    $this.$outer.flushCount().increment();
                                }
                                catch (ClosedByInterruptException closedByInterruptException) {
                                }
                                catch (IOException e) {
                                    task.notifier().setException(e);
                                    $this.$outer.processIOException(e, DiskStatus.READ_OR_WRITE_FAILURE);
                                }
                                $this.$outer.lastBeginFlushTime().set($this.index$1, -1L);
                            }
                            $this.$outer.returnBuffer(task.buffer());
                            return task$1.notifier().numPendingFlushes.decrementAndGet();
                        });
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.index$1 = index$1;
                    super(new StringBuilder(1).append($outer).append("-").append(index$1).toString());
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.celeborn.service.deploy.worker.storage.Flusher$$anon$1 org.apache.celeborn.service.deploy.worker.storage.FlushTask )}, serializedLambda);
                }
            };
            this.workers()[index].setDaemon(true);
            this.workers()[index].setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(this){
                private final /* synthetic */ Flusher $outer;

                public void uncaughtException(Thread t, Throwable e) {
                    this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append(this).append(" thread terminated.").toString(), e);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$uncaughtException$1(org.apache.celeborn.service.deploy.worker.storage.Flusher$$anon$2 )}, serializedLambda);
                }
            });
            this.workers()[index].start();
        });
    }

    public synchronized int getWorkerIndex() {
        this.nextWorkerIndex_$eq((this.nextWorkerIndex() + 1) % this.threadCount());
        return this.nextWorkerIndex();
    }

    public long averageFlushTime() {
        if (this instanceof LocalFlusher) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Flush count in ").append(((LocalFlusher)this).mountPoint()).append(" last heartbeat interval: ").append(this.flushCount()).toString());
        }
        long currentFlushTime = this.flushTotalTime().sumThenReset();
        long currentFlushCount = this.flushCount().sumThenReset();
        if (currentFlushCount >= (long)this.avgFlushTimeSlidingWindowMinCount()) {
            this.avgTimeWindow()[this.avgTimeWindowCurrentIndex()] = new Tuple2.mcJJ.sp(currentFlushTime, currentFlushCount);
            this.avgTimeWindowCurrentIndex_$eq((this.avgTimeWindowCurrentIndex() + 1) % this.avgFlushTimeSlidingWindowSize());
        }
        LongRef totalFlushTime = LongRef.create((long)0L);
        LongRef totalFlushCount = LongRef.create((long)0L);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.avgTimeWindow())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Flusher.$anonfun$averageFlushTime$2(totalFlushTime, totalFlushCount, x0$1);
            return BoxedUnit.UNIT;
        });
        return totalFlushCount.elem != 0L ? totalFlushTime.elem / totalFlushCount.elem : 0L;
    }

    /*
     * WARNING - void declaration
     */
    public CompositeByteBuf takeBuffer() {
        void var1_1;
        block0: {
            CompositeByteBuf buffer = this.bufferQueue().poll();
            if (buffer != null) break block0;
            buffer = Unpooled.compositeBuffer((int)256);
        }
        return var1_1;
    }

    public void returnBuffer(CompositeByteBuf buffer) {
        MemoryManager.instance().releaseDiskBuffer(buffer.readableBytes());
        buffer.removeComponents(0, buffer.numComponents());
        buffer.clear();
        this.bufferQueue().put(buffer);
    }

    public boolean addTask(FlushTask task, long timeoutMs, int workerIndex) {
        return this.workingQueues()[workerIndex].offer(task, timeoutMs, TimeUnit.MILLISECONDS);
    }

    public String bufferQueueInfo() {
        return new StringBuilder(15).append(this).append(" used buffers: ").append(this.bufferQueue().size()).toString();
    }

    public void stopAndCleanFlusher() {
        this.stopFlag().set(true);
        try {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.workers())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.interrupt();
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Exception when interrupt worker: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.workers())).mkString(",")).append(", ").append(e).toString());
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.workingQueues())).foreach((Function1 & Serializable & scala.Serializable)queue -> {
            Flusher.$anonfun$stopAndCleanFlusher$3(this, queue);
            return BoxedUnit.UNIT;
        });
    }

    public abstract void processIOException(IOException var1, DiskStatus var2);

    public static final /* synthetic */ void $anonfun$averageFlushTime$2(LongRef totalFlushTime$1, LongRef totalFlushCount$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long flushTime = tuple2._1$mcJ$sp();
            long flushCount = tuple2._2$mcJ$sp();
            totalFlushTime$1.elem += flushTime;
            totalFlushCount$1.elem += flushCount;
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$stopAndCleanFlusher$3(Flusher $this, LinkedBlockingQueue queue) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)queue).asScala()).foreach((Function1 & Serializable & scala.Serializable)task -> {
            $this.returnBuffer(task.buffer());
            return BoxedUnit.UNIT;
        });
    }

    public Flusher(AbstractSource workerSource, int threadCount, int avgFlushTimeSlidingWindowSize, int avgFlushTimeSlidingWindowMinCount) {
        this.workerSource = workerSource;
        this.threadCount = threadCount;
        this.avgFlushTimeSlidingWindowSize = avgFlushTimeSlidingWindowSize;
        this.avgFlushTimeSlidingWindowMinCount = avgFlushTimeSlidingWindowMinCount;
        Logging.$init$((Logging)this);
        this.workingQueues = new LinkedBlockingQueue[threadCount];
        this.bufferQueue = new LinkedBlockingQueue();
        this.workers = new Thread[threadCount];
        this.nextWorkerIndex = 0;
        this.flushCount = new LongAdder();
        this.flushTotalTime = new LongAdder();
        this.avgTimeWindow = new Tuple2[avgFlushTimeSlidingWindowSize];
        this.avgTimeWindowCurrentIndex = 0;
        this.lastBeginFlushTime = new AtomicLongArray(threadCount);
        this.stopFlag = new AtomicBoolean(false);
        this.rand = new Random();
        this.init();
    }
}

