/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.AlreadyClosedException;
import org.apache.celeborn.common.meta.DiskStatus;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.network.server.memory.MemoryManager;
import org.apache.celeborn.common.protocol.PartitionSplitMode;
import org.apache.celeborn.common.protocol.PartitionType;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.unsafe.Platform;
import org.apache.celeborn.service.deploy.worker.WorkerSource;
import org.apache.celeborn.service.deploy.worker.storage.DeviceMonitor;
import org.apache.celeborn.service.deploy.worker.storage.DeviceObserver;
import org.apache.celeborn.service.deploy.worker.storage.FlushNotifier;
import org.apache.celeborn.service.deploy.worker.storage.FlushTask;
import org.apache.celeborn.service.deploy.worker.storage.Flusher;
import org.apache.celeborn.service.deploy.worker.storage.HdfsFlushTask;
import org.apache.celeborn.service.deploy.worker.storage.LocalFlushTask;
import org.apache.celeborn.service.deploy.worker.storage.LocalFlusher;
import org.apache.celeborn.service.deploy.worker.storage.StorageManager;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileWriter
implements DeviceObserver {
    private static final Logger logger = LoggerFactory.getLogger(FileWriter.class);
    private static final long WAIT_INTERVAL_MS = 20L;
    private final FileInfo fileInfo;
    private FileChannel channel;
    private FSDataOutputStream stream;
    private volatile boolean closed;
    private volatile boolean destroyed;
    private final AtomicInteger numPendingWrites = new AtomicInteger();
    private long nextBoundary;
    private long bytesFlushed;
    public final Flusher flusher;
    private final int flushWorkerIndex;
    private CompositeByteBuf flushBuffer;
    private final long shuffleChunkSize;
    private final long writerCloseTimeoutMs;
    private final long flusherBufferSize;
    private final DeviceMonitor deviceMonitor;
    private final AbstractSource source;
    private long splitThreshold = 0L;
    private final PartitionSplitMode splitMode;
    private final PartitionType partitionType;
    private final boolean rangeReadFilter;
    protected boolean deleted = false;
    private RoaringBitmap mapIdBitMap = null;
    private final FlushNotifier notifier = new FlushNotifier();
    private int numReducePartitions;
    private int currentDataRegionIndex;
    private boolean isBroadcastRegion;

    public FileWriter(FileInfo fileInfo, Flusher flusher, AbstractSource workerSource, CelebornConf conf, DeviceMonitor deviceMonitor, long splitThreshold, PartitionSplitMode splitMode, PartitionType partitionType, boolean rangeReadFilter) throws IOException {
        this.fileInfo = fileInfo;
        this.flusher = flusher;
        this.flushWorkerIndex = flusher.getWorkerIndex();
        this.nextBoundary = this.shuffleChunkSize = conf.shuffleChunkSize();
        this.writerCloseTimeoutMs = conf.writerCloseTimeoutMs();
        this.splitThreshold = splitThreshold;
        this.flusherBufferSize = conf.workerFlusherBufferSize();
        this.deviceMonitor = deviceMonitor;
        this.splitMode = splitMode;
        this.partitionType = partitionType;
        this.rangeReadFilter = rangeReadFilter;
        if (!fileInfo.isHdfs()) {
            this.channel = new FileOutputStream(fileInfo.getFilePath()).getChannel();
        } else {
            this.stream = StorageManager.hdfsFs().create(fileInfo.getHdfsPath(), true);
        }
        this.source = workerSource;
        logger.debug("FileWriter {} split threshold {} mode {}", new Object[]{this, splitThreshold, splitMode});
        if (rangeReadFilter) {
            this.mapIdBitMap = new RoaringBitmap();
        }
        this.takeBuffer();
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public File getFile() {
        return this.fileInfo.getFile();
    }

    public void incrementPendingWrites() {
        this.numPendingWrites.incrementAndGet();
    }

    public void decrementPendingWrites() {
        this.numPendingWrites.decrementAndGet();
    }

    private void flush(boolean finalFlush) throws IOException {
        int numBytes = this.flushBuffer.readableBytes();
        this.notifier.checkException();
        this.notifier.numPendingFlushes.incrementAndGet();
        FlushTask task = null;
        if (this.channel != null) {
            task = new LocalFlushTask(this.flushBuffer, this.channel, this.notifier);
        } else if (this.stream != null) {
            task = new HdfsFlushTask(this.flushBuffer, this.stream, this.notifier);
        }
        this.addTask(task);
        this.flushBuffer = null;
        this.bytesFlushed += (long)numBytes;
        this.maybeSetChunkOffsets(finalFlush);
    }

    private void maybeSetChunkOffsets(boolean forceSet) {
        if (this.bytesFlushed >= this.nextBoundary || forceSet) {
            this.fileInfo.addChunkOffset(this.bytesFlushed);
            this.nextBoundary = this.bytesFlushed + this.shuffleChunkSize;
        }
    }

    private boolean isChunkOffsetValid() {
        return this.fileInfo.getLastChunkOffset() == this.bytesFlushed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ByteBuf data) throws IOException {
        if (this.closed) {
            String msg = "FileWriter has already closed!, fileName " + this.fileInfo.getFilePath();
            logger.warn(msg);
            throw new AlreadyClosedException(msg);
        }
        if (this.notifier.hasException()) {
            return;
        }
        int mapId = 0;
        if (this.rangeReadFilter) {
            byte[] header = new byte[16];
            data.markReaderIndex();
            data.readBytes(header);
            data.resetReaderIndex();
            mapId = Platform.getInt((Object)header, (long)Platform.BYTE_ARRAY_OFFSET);
        }
        int numBytes = data.readableBytes();
        MemoryManager.instance().incrementDiskBuffer(numBytes);
        FileWriter fileWriter = this;
        synchronized (fileWriter) {
            if (this.closed) {
                String msg = "FileWriter has already closed!, fileName " + this.fileInfo.getFilePath();
                logger.warn(msg);
                throw new AlreadyClosedException(msg);
            }
            if (this.rangeReadFilter) {
                this.mapIdBitMap.add(mapId);
            }
            if (this.flushBuffer.readableBytes() != 0 && (long)(this.flushBuffer.readableBytes() + numBytes) >= this.flusherBufferSize) {
                this.flush(false);
                this.takeBuffer();
            }
            data.retain();
            this.flushBuffer.addComponent(true, data);
            this.numPendingWrites.decrementAndGet();
        }
    }

    public RoaringBitmap getMapIdBitMap() {
        return this.mapIdBitMap;
    }

    public StorageInfo getStorageInfo() {
        if (this.flusher instanceof LocalFlusher) {
            LocalFlusher localFlusher = (LocalFlusher)this.flusher;
            return new StorageInfo(localFlusher.diskType(), localFlusher.mountPoint(), true);
        }
        if (this.deleted) {
            return null;
        }
        return new StorageInfo(StorageInfo.Type.HDFS, true, this.fileInfo.getFilePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long close() throws IOException {
        if (this.closed) {
            String msg = "FileWriter has already closed! fileName " + this.fileInfo.getFilePath();
            logger.error(msg);
            throw new AlreadyClosedException(msg);
        }
        try {
            this.waitOnNoPending(this.numPendingWrites);
            this.closed = true;
            FileWriter msg = this;
            synchronized (msg) {
                if (this.flushBuffer.readableBytes() > 0) {
                    this.flush(true);
                }
                if (!this.isChunkOffsetValid()) {
                    this.maybeSetChunkOffsets(true);
                }
            }
            this.waitOnNoPending(this.notifier.numPendingFlushes);
        }
        finally {
            this.returnBuffer();
            try {
                if (this.channel != null) {
                    this.channel.close();
                }
                if (this.stream != null) {
                    this.stream.close();
                    if (StorageManager.hdfsFs().exists(this.fileInfo.getHdfsPeerWriterSuccessPath())) {
                        StorageManager.hdfsFs().delete(this.fileInfo.getHdfsPath(), false);
                        this.deleted = true;
                    } else {
                        StorageManager.hdfsFs().create(this.fileInfo.getHdfsWriterSuccessPath()).close();
                        FSDataOutputStream indexOutputStream = StorageManager.hdfsFs().create(this.fileInfo.getHdfsIndexPath());
                        indexOutputStream.writeInt(this.fileInfo.getChunkOffsets().size());
                        for (Long offset : this.fileInfo.getChunkOffsets()) {
                            indexOutputStream.writeLong(offset.longValue());
                        }
                        indexOutputStream.close();
                    }
                }
            }
            catch (IOException e) {
                logger.warn("close file writer" + this + "failed", (Throwable)e);
            }
            if (!this.fileInfo.isHdfs()) {
                logger.debug("file info {} register from device monitor");
                this.deviceMonitor.unregisterFileWriter(this);
            }
        }
        return this.bytesFlushed;
    }

    public synchronized void destroy(IOException ioException) {
        if (!this.closed) {
            this.closed = true;
            if (!this.notifier.hasException()) {
                this.notifier.setException(ioException);
            }
            this.returnBuffer();
            try {
                if (this.channel != null) {
                    this.channel.close();
                }
                if (this.stream != null) {
                    this.stream.close();
                }
            }
            catch (IOException e) {
                logger.warn("Close channel failed for file {} caused by {}.", (Object)this.fileInfo.getFilePath(), (Object)e.getMessage());
            }
        }
        if (!this.destroyed) {
            this.destroyed = true;
            try {
                this.fileInfo.deleteAllFiles(StorageManager.hdfsFs());
            }
            catch (Exception e) {
                logger.warn("Exception when cleaning hdfs file {}", (Object)this.fileInfo.getFilePath());
            }
            this.deviceMonitor.unregisterFileWriter(this);
        }
    }

    public IOException getException() {
        if (this.notifier.hasException()) {
            return this.notifier.exception.get();
        }
        return null;
    }

    private void waitOnNoPending(AtomicInteger counter) throws IOException {
        for (long waitTime = this.writerCloseTimeoutMs; counter.get() > 0 && waitTime > 0L; waitTime -= 20L) {
            try {
                this.notifier.checkException();
                TimeUnit.MILLISECONDS.sleep(20L);
                continue;
            }
            catch (InterruptedException e) {
                IOException ioe = new IOException(e);
                this.notifier.setException(ioe);
                throw ioe;
            }
        }
        if (counter.get() > 0) {
            IOException ioe = new IOException("Wait pending actions timeout.");
            this.notifier.setException(ioe);
            throw ioe;
        }
        this.notifier.checkException();
    }

    private void takeBuffer() {
        String metricsName = null;
        String fileAbsPath = null;
        if (this.source.metricsCollectCriticalEnabled()) {
            metricsName = WorkerSource.TakeBufferTime();
            fileAbsPath = this.fileInfo.getFilePath();
            this.source.startTimer(metricsName, fileAbsPath);
        }
        this.flushBuffer = this.flusher.takeBuffer();
        if (this.source.metricsCollectCriticalEnabled()) {
            this.source.stopTimer(metricsName, fileAbsPath);
        }
        if (this.flushBuffer == null) {
            IOException e = new IOException("Take buffer encounter error from Flusher: " + this.flusher.bufferQueueInfo());
            this.notifier.setException(e);
        }
    }

    private void addTask(FlushTask task) throws IOException {
        if (!this.flusher.addTask(task, this.writerCloseTimeoutMs, this.flushWorkerIndex)) {
            IOException e = new IOException("Add flush task timeout.");
            this.notifier.setException(e);
            throw e;
        }
    }

    private synchronized void returnBuffer() {
        if (this.flushBuffer != null) {
            this.flusher.returnBuffer(this.flushBuffer);
            this.flushBuffer = null;
        }
    }

    public int hashCode() {
        return this.fileInfo.getFilePath().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof FileWriter && this.fileInfo.getFilePath().equals(((FileWriter)obj).fileInfo.getFilePath());
    }

    public String toString() {
        return this.fileInfo.getFilePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushOnMemoryPressure() throws IOException {
        FileWriter fileWriter = this;
        synchronized (fileWriter) {
            if (this.flushBuffer != null && this.flushBuffer.readableBytes() != 0) {
                this.flush(false);
                this.takeBuffer();
            }
        }
    }

    public long getSplitThreshold() {
        return this.splitThreshold;
    }

    public PartitionSplitMode getSplitMode() {
        return this.splitMode;
    }

    @Override
    public void notifyError(String mountPoint, DiskStatus diskStatus) {
        this.destroy(new IOException("Destroy FileWriter " + this + " by device ERROR. Disk: " + mountPoint + " Status: " + diskStatus));
    }

    @Override
    public void notifyHealthy(String mountPoint) {
    }

    @Override
    public void notifyHighDiskUsage(String mountPoint) {
    }

    @Override
    public void notifyNonCriticalError(String mountPoint, DiskStatus diskStatus) {
    }

    public PartitionType getPartitionType() {
        return this.partitionType;
    }

    public void pushDataHandShake(int numReducePartitions) {
        this.numReducePartitions = numReducePartitions;
    }

    public void regionStart(int currentDataRegionIndex, boolean isBroadcastRegion) {
        this.currentDataRegionIndex = currentDataRegionIndex;
        this.isBroadcastRegion = isBroadcastRegion;
    }

    public void regionFinish() {
    }
}

