/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.meta.DeviceInfo;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.common.util.Utils$;
import org.apache.celeborn.service.deploy.worker.storage.DeviceMonitor;
import org.apache.celeborn.service.deploy.worker.storage.DeviceObserver;
import org.apache.celeborn.service.deploy.worker.storage.EmptyDeviceMonitor$;
import org.apache.celeborn.service.deploy.worker.storage.LocalDeviceMonitor;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class DeviceMonitor$ {
    public static DeviceMonitor$ MODULE$;
    private final Logger logger;
    private final ThreadPoolExecutor deviceCheckThreadPool;

    static {
        new DeviceMonitor$();
    }

    public Logger logger() {
        return this.logger;
    }

    public ThreadPoolExecutor deviceCheckThreadPool() {
        return this.deviceCheckThreadPool;
    }

    public DeviceMonitor createDeviceMonitor(CelebornConf conf, DeviceObserver deviceObserver, Map<String, DeviceInfo> deviceInfos, Map<String, DiskInfo> diskInfos) {
        DeviceMonitor deviceMonitor;
        try {
            if (conf.diskMonitorEnabled()) {
                LocalDeviceMonitor monitor = new LocalDeviceMonitor(conf, deviceObserver, deviceInfos, diskInfos);
                monitor.init();
                this.logger().info("Device monitor init success");
                deviceMonitor = monitor;
            } else {
                deviceMonitor = EmptyDeviceMonitor$.MODULE$;
            }
        }
        catch (Throwable t) {
            this.logger().error("Device monitor init failed.", t);
            throw t;
        }
        return deviceMonitor;
    }

    public boolean highDiskUsage(CelebornConf conf, DiskInfo diskInfo) {
        return BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryWithTimeoutAndCallback((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean highDiskUsage;
            block0: {
                String[] usage = Utils$.MODULE$.runCommand(new StringBuilder(9).append("df -B 1G ").append(diskInfo.mountPoint()).toString()).trim().split("[ \t]+");
                String totalSpace = usage[usage.length - 5];
                String freeSpace = usage[usage.length - 3];
                String used_percent = usage[usage.length - 2];
                boolean bl = highDiskUsage = new StringOps(Predef$.MODULE$.augmentString(freeSpace)).toLong() < conf.diskReserveSize() / 1024L / 1024L / 1024L || diskInfo.actualUsableSpace() <= 0L;
                if (!highDiskUsage) break block0;
                MODULE$.logger().warn(new StringBuilder(130).append(diskInfo.mountPoint()).append(" usage is above threshold.").append(" Disk usage(Report by OS):{total:").append(totalSpace).append(" GB,").append(" free:").append(freeSpace).append(" GB, used_percent:").append(used_percent).append("} ").append("usage(Report by Celeborn):{").append("total:").append(Utils$.MODULE$.bytesToString(diskInfo.configuredUsableSpace())).append(" free:").append(Utils$.MODULE$.bytesToString(diskInfo.actualUsableSpace())).append(" }").toString());
            }
            return highDiskUsage;
        }, (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, this.deviceCheckThreadPool(), conf.workerDeviceStatusCheckTimeout(), new StringBuilder(26).append("Disk: ").append(diskInfo.mountPoint()).append(" Usage Check Timeout").toString()));
    }

    public boolean readWriteError(CelebornConf conf, File dataDir) {
        if (dataDir == null || !dataDir.isDirectory()) {
            return false;
        }
        return BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryWithTimeoutAndCallback((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            block6: {
                try {
                    File file = new File(dataDir, new StringBuilder(9).append("_SUCCESS_").append(System.currentTimeMillis()).toString());
                    if (!file.exists() && !file.createNewFile()) {
                        bl = true;
                        break block6;
                    }
                    FileUtils.write((File)file, (CharSequence)"test", (Charset)Charset.defaultCharset());
                    FileInputStream fileInputStream = null;
                    InputStreamReader inputStreamReader = null;
                    BufferedReader bufferReader = null;
                    try {
                        fileInputStream = FileUtils.openInputStream((File)file);
                        inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.defaultCharset());
                        bufferReader = new BufferedReader(inputStreamReader);
                        bufferReader.readLine();
                    }
                    finally {
                        bufferReader.close();
                        inputStreamReader.close();
                        fileInputStream.close();
                    }
                    FileUtils.forceDelete((File)file);
                    bl = false;
                }
                catch (Throwable t) {
                    MODULE$.logger().error(new StringBuilder(30).append("Disk dir ").append(dataDir).append(" cannot read or write").toString(), t);
                    bl = true;
                }
            }
            return bl;
        }, (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, this.deviceCheckThreadPool(), conf.workerDeviceStatusCheckTimeout(), new StringBuilder(31).append("Disk: ").append(dataDir).append(" Read_Write Check Timeout").toString()));
    }

    public DeviceMonitor EmptyMonitor() {
        return EmptyDeviceMonitor$.MODULE$;
    }

    private DeviceMonitor$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(DeviceMonitor.class);
        this.deviceCheckThreadPool = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("device-check-thread", 5, ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3());
    }
}

