/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker;

import com.google.common.base.Throwables;
import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.celeborn.common.exception.CelebornException;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.meta.FileManagedBuffers;
import org.apache.celeborn.common.metrics.source.RPCSource;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;
import org.apache.celeborn.common.network.buffer.NioManagedBuffer;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.protocol.ChunkFetchFailure;
import org.apache.celeborn.common.network.protocol.ChunkFetchRequest;
import org.apache.celeborn.common.network.protocol.ChunkFetchSuccess;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.OpenStream;
import org.apache.celeborn.common.network.protocol.RequestMessage;
import org.apache.celeborn.common.network.protocol.RpcFailure;
import org.apache.celeborn.common.network.protocol.RpcRequest;
import org.apache.celeborn.common.network.protocol.RpcResponse;
import org.apache.celeborn.common.network.protocol.StreamHandle;
import org.apache.celeborn.common.network.server.BaseMessageHandler;
import org.apache.celeborn.common.network.server.ChunkStreamManager;
import org.apache.celeborn.common.network.util.NettyUtils;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.protocol.PartitionType;
import org.apache.celeborn.service.deploy.worker.Worker;
import org.apache.celeborn.service.deploy.worker.WorkerSource;
import org.apache.celeborn.service.deploy.worker.WorkerSource$;
import org.apache.celeborn.service.deploy.worker.storage.PartitionFilesSorter;
import org.apache.celeborn.service.deploy.worker.storage.StorageManager;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001\u0002\u0010 \u00011B\u0001\"\u0010\u0001\u0003\u0006\u0004%\tA\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\u007f!)a\t\u0001C\u0001\u000f\"91\n\u0001a\u0001\n\u0003a\u0005b\u0002)\u0001\u0001\u0004%\t!\u0015\u0005\u00075\u0002\u0001\u000b\u0015B'\t\u0013m\u0003\u0001\u0019!a\u0001\n\u0003a\u0006\"\u00031\u0001\u0001\u0004\u0005\r\u0011\"\u0001b\u0011%\u0019\u0007\u00011A\u0001B\u0003&Q\fC\u0005e\u0001\u0001\u0007\t\u0019!C\u0001K\"Ia\u000e\u0001a\u0001\u0002\u0004%\ta\u001c\u0005\nc\u0002\u0001\r\u0011!Q!\n\u0019D\u0011B\u001d\u0001A\u0002\u0003\u0007I\u0011A:\t\u0013i\u0004\u0001\u0019!a\u0001\n\u0003Y\b\"C?\u0001\u0001\u0004\u0005\t\u0015)\u0003u\u0011%q\b\u00011AA\u0002\u0013\u0005q\u0010C\u0006\u0002\b\u0001\u0001\r\u00111A\u0005\u0002\u0005%\u0001bCA\u0007\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0003A\u0011\"a\u0004\u0001\u0001\u0004%\t!!\u0005\t\u0013\u0005%\u0002\u00011A\u0005\u0002\u0005-\u0002\u0002CA\u0018\u0001\u0001\u0006K!a\u0005\t\u000f\u0005E\u0002\u0001\"\u0001\u00024!9\u0011Q\b\u0001\u0005\u0002\u0005}\u0002bBA6\u0001\u0011\u0005\u0013Q\u000e\u0005\b\u0003\u001b\u0003A\u0011AAH\u0011\u001d\ti\n\u0001C\u0001\u0003?Cq!!,\u0001\t\u0003\ny\u000bC\u0004\u00028\u0002!\t%!/\t\u000f\u0005u\u0006\u0001\"\u0011\u0002@\naa)\u001a;dQ\"\u000bg\u000e\u001a7fe*\u0011\u0001%I\u0001\u0007o>\u00148.\u001a:\u000b\u0005\t\u001a\u0013A\u00023fa2|\u0017P\u0003\u0002%K\u000591/\u001a:wS\u000e,'B\u0001\u0014(\u0003!\u0019W\r\\3c_Jt'B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001e\u001c\u0001aE\u0002\u0001[]\u0002\"AL\u001b\u000e\u0003=R!\u0001M\u0019\u0002\rM,'O^3s\u0015\t\u00114'A\u0004oKR<xN]6\u000b\u0005Q*\u0013AB2p[6|g.\u0003\u00027_\t\u0011\")Y:f\u001b\u0016\u001c8/Y4f\u0011\u0006tG\r\\3s!\tA4(D\u0001:\u0015\tQ4'\u0001\u0005j]R,'O\\1m\u0013\ta\u0014HA\u0004M_\u001e<\u0017N\\4\u0002\t\r|gNZ\u000b\u0002\u007fA\u0011\u0001iQ\u0007\u0002\u0003*\u0011!)M\u0001\u0005kRLG.\u0003\u0002E\u0003\niAK]1ogB|'\u000f^\"p]\u001a\fQaY8oM\u0002\na\u0001P5oSRtDC\u0001%K!\tI\u0005!D\u0001 \u0011\u0015i4\u00011\u0001@\u0003I\u0019\u0007.\u001e8l'R\u0014X-Y7NC:\fw-\u001a:\u0016\u00035\u0003\"A\f(\n\u0005={#AE\"ik:\\7\u000b\u001e:fC6l\u0015M\\1hKJ\fac\u00195v].\u001cFO]3b[6\u000bg.Y4fe~#S-\u001d\u000b\u0003%b\u0003\"a\u0015,\u000e\u0003QS\u0011!V\u0001\u0006g\u000e\fG.Y\u0005\u0003/R\u0013A!\u00168ji\"9\u0011,BA\u0001\u0002\u0004i\u0015a\u0001=%c\u0005\u00192\r[;oWN#(/Z1n\u001b\u0006t\u0017mZ3sA\u0005aqo\u001c:lKJ\u001cv.\u001e:dKV\tQ\f\u0005\u0002J=&\u0011ql\b\u0002\r/>\u00148.\u001a:T_V\u00148-Z\u0001\u0011o>\u00148.\u001a:T_V\u00148-Z0%KF$\"A\u00152\t\u000feC\u0011\u0011!a\u0001;\u0006iqo\u001c:lKJ\u001cv.\u001e:dK\u0002\n\u0011B\u001d9d'>,(oY3\u0016\u0003\u0019\u0004\"a\u001a7\u000e\u0003!T!!\u001b6\u0002\rM|WO]2f\u0015\tY7'A\u0004nKR\u0014\u0018nY:\n\u00055D'!\u0003*Q\u0007N{WO]2f\u00035\u0011\boY*pkJ\u001cWm\u0018\u0013fcR\u0011!\u000b\u001d\u0005\b3.\t\t\u00111\u0001g\u0003)\u0011\boY*pkJ\u001cW\rI\u0001\u000fgR|'/Y4f\u001b\u0006t\u0017mZ3s+\u0005!\bCA;y\u001b\u00051(BA< \u0003\u001d\u0019Ho\u001c:bO\u0016L!!\u001f<\u0003\u001dM#xN]1hK6\u000bg.Y4fe\u0006\u00112\u000f^8sC\u001e,W*\u00198bO\u0016\u0014x\fJ3r)\t\u0011F\u0010C\u0004Z\u001d\u0005\u0005\t\u0019\u0001;\u0002\u001fM$xN]1hK6\u000bg.Y4fe\u0002\n\u0001\u0003]1si&$\u0018n\u001c8t'>\u0014H/\u001a:\u0016\u0005\u0005\u0005\u0001cA;\u0002\u0004%\u0019\u0011Q\u0001<\u0003)A\u000b'\u000f^5uS>tg)\u001b7fgN{'\u000f^3s\u0003Q\u0001\u0018M\u001d;ji&|gn]*peR,'o\u0018\u0013fcR\u0019!+a\u0003\t\u0011e\u000b\u0012\u0011!a\u0001\u0003\u0003\t\u0011\u0003]1si&$\u0018n\u001c8t'>\u0014H/\u001a:!\u0003)\u0011XmZ5ti\u0016\u0014X\rZ\u000b\u0003\u0003'\u0001B!!\u0006\u0002&5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003;\ty\"\u0001\u0006d_:\u001cWO\u001d:f]RT1AQA\u0011\u0015\t\t\u0019#\u0001\u0003kCZ\f\u0017\u0002BA\u0014\u0003/\u0011Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017A\u0004:fO&\u001cH/\u001a:fI~#S-\u001d\u000b\u0004%\u00065\u0002\u0002C-\u0015\u0003\u0003\u0005\r!a\u0005\u0002\u0017I,w-[:uKJ,G\rI\u0001\u0005S:LG\u000fF\u0002S\u0003kAa\u0001\t\fA\u0002\u0005]\u0002cA%\u0002:%\u0019\u00111H\u0010\u0003\r]{'o[3s\u000399W\r\u001e*bo\u001aKG.Z%oM>$b!!\u0011\u0002N\u0005\u001d\u0004\u0003BA\"\u0003\u0013j!!!\u0012\u000b\u0007\u0005\u001d3'\u0001\u0003nKR\f\u0017\u0002BA&\u0003\u000b\u0012\u0001BR5mK&sgm\u001c\u0005\b\u0003\u001f:\u0002\u0019AA)\u0003)\u0019\b.\u001e4gY\u0016\\U-\u001f\t\u0005\u0003'\n\tG\u0004\u0003\u0002V\u0005u\u0003cAA,)6\u0011\u0011\u0011\f\u0006\u0004\u00037Z\u0013A\u0002\u001fs_>$h(C\u0002\u0002`Q\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA2\u0003K\u0012aa\u0015;sS:<'bAA0)\"9\u0011\u0011N\fA\u0002\u0005E\u0013\u0001\u00034jY\u0016t\u0015-\\3\u0002\u000fI,7-Z5wKR)!+a\u001c\u0002~!9\u0011\u0011\u000f\rA\u0002\u0005M\u0014AB2mS\u0016tG\u000f\u0005\u0003\u0002v\u0005eTBAA<\u0015\r\t\t(M\u0005\u0005\u0003w\n9HA\bUe\u0006t7\u000f]8si\u000ec\u0017.\u001a8u\u0011\u001d\ty\b\u0007a\u0001\u0003\u0003\u000b1!\\:h!\u0011\t\u0019)!#\u000e\u0005\u0005\u0015%bAADc\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0002\f\u0006\u0015%A\u0004*fcV,7\u000f^'fgN\fw-Z\u0001\u0011Q\u0006tG\r\\3Pa\u0016t7\u000b\u001e:fC6$RAUAI\u0003'Cq!!\u001d\u001a\u0001\u0004\t\u0019\bC\u0004\u0002\u0016f\u0001\r!a&\u0002\u000fI,\u0017/^3tiB!\u00111QAM\u0013\u0011\tY*!\"\u0003\u0015I\u00038MU3rk\u0016\u001cH/A\fiC:$G.Z\"ik:\\g)\u001a;dQJ+\u0017/^3tiR)!+!)\u0002$\"9\u0011\u0011\u000f\u000eA\u0002\u0005M\u0004bBAS5\u0001\u0007\u0011qU\u0001\u0004e\u0016\f\b\u0003BAB\u0003SKA!a+\u0002\u0006\n\t2\t[;oW\u001a+Go\u00195SKF,Xm\u001d;\u0002\u001f\rDWmY6SK\u001eL7\u000f^3sK\u0012$\"!!-\u0011\u0007M\u000b\u0019,C\u0002\u00026R\u0013qAQ8pY\u0016\fg.A\bdQ\u0006tg.\u001a7J]\u0006\u001cG/\u001b<f)\r\u0011\u00161\u0018\u0005\b\u0003cb\u0002\u0019AA:\u0003=)\u0007pY3qi&|gnQ1vO\"$H#\u0002*\u0002B\u0006]\u0007bBAb;\u0001\u0007\u0011QY\u0001\u0006G\u0006,8/\u001a\t\u0005\u0003\u000f\f\tN\u0004\u0003\u0002J\u00065g\u0002BA,\u0003\u0017L\u0011!V\u0005\u0004\u0003\u001f$\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003'\f)NA\u0005UQJ|w/\u00192mK*\u0019\u0011q\u001a+\t\u000f\u0005ET\u00041\u0001\u0002t\u0001")
public class FetchHandler
extends BaseMessageHandler
implements Logging {
    private final TransportConf conf;
    private ChunkStreamManager chunkStreamManager;
    private WorkerSource workerSource;
    private RPCSource rpcSource;
    private StorageManager storageManager;
    private PartitionFilesSorter partitionsSorter;
    private AtomicBoolean registered;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        FetchHandler fetchHandler = this;
        synchronized (fetchHandler) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public TransportConf conf() {
        return this.conf;
    }

    public ChunkStreamManager chunkStreamManager() {
        return this.chunkStreamManager;
    }

    public void chunkStreamManager_$eq(ChunkStreamManager x$1) {
        this.chunkStreamManager = x$1;
    }

    public WorkerSource workerSource() {
        return this.workerSource;
    }

    public void workerSource_$eq(WorkerSource x$1) {
        this.workerSource = x$1;
    }

    public RPCSource rpcSource() {
        return this.rpcSource;
    }

    public void rpcSource_$eq(RPCSource x$1) {
        this.rpcSource = x$1;
    }

    public StorageManager storageManager() {
        return this.storageManager;
    }

    public void storageManager_$eq(StorageManager x$1) {
        this.storageManager = x$1;
    }

    public PartitionFilesSorter partitionsSorter() {
        return this.partitionsSorter;
    }

    public void partitionsSorter_$eq(PartitionFilesSorter x$1) {
        this.partitionsSorter = x$1;
    }

    public AtomicBoolean registered() {
        return this.registered;
    }

    public void registered_$eq(AtomicBoolean x$1) {
        this.registered = x$1;
    }

    public void init(Worker worker) {
        this.workerSource_$eq(worker.workerSource());
        this.rpcSource_$eq(worker.rpcSource());
        this.storageManager_$eq(worker.storageManager());
        this.partitionsSorter_$eq(worker.partitionsSorter());
        this.registered_$eq(worker.registered());
    }

    /*
     * WARNING - void declaration
     */
    public FileInfo getRawFileInfo(String shuffleKey, String fileName) {
        void var3_3;
        FileInfo fileInfo = this.storageManager().getFileInfo(shuffleKey, fileName);
        if (fileInfo == null) {
            String errMsg = new StringBuilder(26).append("Could not find file ").append(fileName).append(" for ").append(shuffleKey).append(".").toString();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errMsg);
            throw new FileNotFoundException(errMsg);
        }
        return var3_3;
    }

    public void receive(TransportClient client, RequestMessage msg) {
        RequestMessage requestMessage = msg;
        if (requestMessage instanceof ChunkFetchRequest) {
            ChunkFetchRequest chunkFetchRequest = (ChunkFetchRequest)requestMessage;
            this.rpcSource().updateMessageMetrics((Object)chunkFetchRequest, 0L);
            this.handleChunkFetchRequest(client, chunkFetchRequest);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (requestMessage instanceof RpcRequest) {
            RpcRequest rpcRequest = (RpcRequest)requestMessage;
            this.handleOpenStream(client, rpcRequest);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (requestMessage != null) {
                RequestMessage requestMessage2 = requestMessage;
                throw new IllegalArgumentException(new StringBuilder(25).append("Unknown message type id: ").append(requestMessage2.type().id()).toString());
            }
            throw new MatchError((Object)requestMessage);
        }
    }

    public void handleOpenStream(TransportClient client, RpcRequest request) {
        block15: {
            Message msg = Message.decode((ByteBuffer)request.body().nioByteBuffer());
            OpenStream openBlocks = (OpenStream)msg;
            String shuffleKey = new String(openBlocks.shuffleKey, StandardCharsets.UTF_8);
            String fileName = new String(openBlocks.fileName, StandardCharsets.UTF_8);
            int startMapIndex = openBlocks.startMapIndex;
            int endMapIndex = openBlocks.endMapIndex;
            this.workerSource().startTimer(WorkerSource$.MODULE$.OpenStreamTime(), shuffleKey);
            try {
                ObjectRef fileInfo = ObjectRef.create((Object)this.getRawFileInfo(shuffleKey, fileName));
                try {
                    try {
                        PartitionType partitionType = ((FileInfo)fileInfo.elem).getPartitionType();
                        if (PartitionType.REDUCE.equals(partitionType)) {
                            BoxedUnit boxedUnit;
                            if (endMapIndex != Integer.MAX_VALUE) {
                                fileInfo.elem = this.partitionsSorter().getSortedFileInfo(shuffleKey, fileName, (FileInfo)fileInfo.elem, startMapIndex, endMapIndex);
                            }
                            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Received chunk fetch request ").append(shuffleKey).append(" ").append(fileName).append(" ").append(startMapIndex).append(" ").append(endMapIndex).append(" get file info ").append((FileInfo)fileInfo$1.elem).toString());
                            if (((FileInfo)fileInfo.elem).isHdfs()) {
                                StreamHandle streamHandle = new StreamHandle(0L, 0);
                                client.getChannel().writeAndFlush((Object)new RpcResponse(request.requestId, (ManagedBuffer)new NioManagedBuffer(streamHandle.toByteBuffer())));
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                FileManagedBuffers buffers = new FileManagedBuffers((FileInfo)fileInfo.elem, this.conf());
                                long streamId = this.chunkStreamManager().registerStream(buffers, client.getChannel());
                                StreamHandle streamHandle = new StreamHandle(streamId, ((FileInfo)fileInfo.elem).numChunks());
                                if (((FileInfo)fileInfo.elem).numChunks() == 0) {
                                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("StreamId ").append(streamId).append(" fileName ").append(fileName).append(" startMapIndex").append(" ").append(startMapIndex).append(" endMapIndex ").append(endMapIndex).append(" is empty.").toString());
                                } else {
                                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("StreamId ").append(streamId).append(" fileName ").append(fileName).append(" numChunks ").append(((FileInfo)fileInfo$1.elem).numChunks()).append(" ").append("startMapIndex ").append(startMapIndex).append(" endMapIndex ").append(endMapIndex).toString());
                                }
                                client.getChannel().writeAndFlush((Object)new RpcResponse(request.requestId, (ManagedBuffer)new NioManagedBuffer(streamHandle.toByteBuffer())));
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                            break block15;
                        }
                        if (PartitionType.MAP.equals(partitionType)) {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block15;
                        }
                        if (PartitionType.MAPGROUP.equals(partitionType)) {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block15;
                        }
                        throw new MatchError((Object)partitionType);
                    }
                    catch (IOException e) {
                        client.getChannel().writeAndFlush((Object)new RpcFailure(request.requestId, Throwables.getStackTraceAsString((Throwable)new CelebornException("Chunk offsets meta exception", (Throwable)e))));
                    }
                }
                finally {
                    this.workerSource().stopTimer(WorkerSource$.MODULE$.OpenStreamTime(), shuffleKey);
                    request.body().release();
                }
            }
            catch (IOException ioe) {
                this.workerSource().stopTimer(WorkerSource$.MODULE$.OpenStreamTime(), shuffleKey);
                client.getChannel().writeAndFlush((Object)new RpcFailure(request.requestId, Throwables.getStackTraceAsString((Throwable)ioe)));
            }
        }
    }

    public void handleChunkFetchRequest(TransportClient client, ChunkFetchRequest req) {
        this.workerSource().startTimer(WorkerSource$.MODULE$.FetchChunkTime(), req.toString());
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Received req from ").append(NettyUtils.getRemoteAddress((Channel)client.getChannel())).append(" to fetch block ").append(req$1.streamChunkSlice).toString());
        long chunksBeingTransferred = this.chunkStreamManager().chunksBeingTransferred();
        if (chunksBeingTransferred > this.conf().maxChunksBeingTransferred()) {
            String message = new StringBuilder(112).append("Worker is too busy. The number of chunks being transferred ").append(chunksBeingTransferred).append(" exceeds celeborn.shuffle.maxChunksBeingTransferred ").append(this.conf().maxChunksBeingTransferred()).append(".").toString();
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            client.getChannel().writeAndFlush((Object)new ChunkFetchFailure(req.streamChunkSlice, message));
            this.workerSource().stopTimer(WorkerSource$.MODULE$.FetchChunkTime(), req.toString());
        } else {
            try {
                ManagedBuffer buf = this.chunkStreamManager().getChunk(req.streamChunkSlice.streamId, req.streamChunkSlice.chunkIndex, req.streamChunkSlice.offset, req.streamChunkSlice.len);
                this.chunkStreamManager().chunkBeingSent(req.streamChunkSlice.streamId);
                client.getChannel().writeAndFlush((Object)new ChunkFetchSuccess(req.streamChunkSlice, buf)).addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(this, req){
                    private final /* synthetic */ FetchHandler $outer;
                    private final ChunkFetchRequest req$1;

                    public void operationComplete(Future<? super Void> future) {
                        this.$outer.chunkStreamManager().chunkSent(this.req$1.streamChunkSlice.streamId);
                        this.$outer.workerSource().stopTimer(WorkerSource$.MODULE$.FetchChunkTime(), this.req$1.toString());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.req$1 = req$1;
                    }
                });
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> String.format(new StringBuilder(38).append("Error opening block ").append(req$1.streamChunkSlice).append(" for request from").append(" ").append(NettyUtils.getRemoteAddress((Channel)client.getChannel())).toString(), new Object[0]), e);
                client.getChannel().writeAndFlush((Object)new ChunkFetchFailure(req.streamChunkSlice, Throwables.getStackTraceAsString((Throwable)e)));
                this.workerSource().stopTimer(WorkerSource$.MODULE$.FetchChunkTime(), req.toString());
            }
        }
    }

    public boolean checkRegistered() {
        return this.registered().get();
    }

    public void channelInactive(TransportClient client) {
        this.chunkStreamManager().connectionTerminated(client.getChannel());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("channel inactive ").append(client.getSocketAddress()).toString());
    }

    public void exceptionCaught(Throwable cause, TransportClient client) {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("exception caught ").append(client.getSocketAddress()).toString(), cause);
    }

    public FetchHandler(TransportConf conf) {
        this.conf = conf;
        Logging.$init$((Logging)this);
        this.chunkStreamManager = new ChunkStreamManager();
        this.registered = new AtomicBoolean(false);
    }
}

