/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.celeborn.client.LifecycleManager;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.protocol.ShuffleMode;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskContext;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.shuffle.ShuffleHandle;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.shuffle.celeborn.HashBasedShuffleWriter;
import org.apache.spark.shuffle.celeborn.RssShuffleFallbackPolicyRunner;
import org.apache.spark.shuffle.celeborn.RssShuffleHandle;
import org.apache.spark.shuffle.celeborn.RssShuffleReader;
import org.apache.spark.shuffle.celeborn.SendBufferPool;
import org.apache.spark.shuffle.celeborn.SortBasedShuffleWriter;
import org.apache.spark.shuffle.celeborn.SparkUtils;
import org.apache.spark.shuffle.sort.SortShuffleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Int;

public class RssShuffleManager
implements ShuffleManager {
    private static final Logger logger = LoggerFactory.getLogger(RssShuffleManager.class);
    private static final String sortShuffleManagerName = "org.apache.spark.shuffle.sort.SortShuffleManager";
    private final SparkConf conf;
    private final CelebornConf celebornConf;
    private final int cores;
    private String newAppId;
    private LifecycleManager lifecycleManager;
    private ShuffleClient rssShuffleClient;
    private volatile SortShuffleManager _sortShuffleManager;
    private final ConcurrentHashMap.KeySetView<Integer, Boolean> sortShuffleIds = ConcurrentHashMap.newKeySet();
    private final RssShuffleFallbackPolicyRunner fallbackPolicyRunner;

    public RssShuffleManager(SparkConf conf) {
        this.conf = conf;
        this.celebornConf = SparkUtils.fromSparkConf(conf);
        this.cores = conf.getInt("spark.executor.cores", 1);
        this.fallbackPolicyRunner = new RssShuffleFallbackPolicyRunner(this.celebornConf);
    }

    private boolean isDriver() {
        return "driver".equals(SparkEnv.get().executorId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortShuffleManager sortShuffleManager() {
        if (this._sortShuffleManager == null) {
            RssShuffleManager rssShuffleManager = this;
            synchronized (rssShuffleManager) {
                if (this._sortShuffleManager == null) {
                    this._sortShuffleManager = (SortShuffleManager)SparkUtils.instantiateClass(sortShuffleManagerName, this.conf, this.isDriver());
                }
            }
        }
        return this._sortShuffleManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeLifecycleManager(String appId) {
        if (this.isDriver() && this.lifecycleManager == null) {
            RssShuffleManager rssShuffleManager = this;
            synchronized (rssShuffleManager) {
                if (this.lifecycleManager == null) {
                    this.lifecycleManager = new LifecycleManager(appId, this.celebornConf);
                    this.rssShuffleClient = ShuffleClient.get(this.lifecycleManager.self(), this.celebornConf, this.lifecycleManager.getUserIdentifier());
                }
            }
        }
    }

    public <K, V, C> ShuffleHandle registerShuffle(int shuffleId, int numMaps, ShuffleDependency<K, V, C> dependency) {
        this.newAppId = SparkUtils.genNewAppId(dependency.rdd().context());
        this.initializeLifecycleManager(this.newAppId);
        if (this.fallbackPolicyRunner.applyAllFallbackPolicy(this.lifecycleManager, dependency.partitioner().numPartitions())) {
            logger.warn("Fallback to SortShuffleManager!");
            this.sortShuffleIds.add(shuffleId);
            return this.sortShuffleManager().registerShuffle(shuffleId, numMaps, dependency);
        }
        return new RssShuffleHandle<K, V, C>(this.newAppId, this.lifecycleManager.getRssMetaServiceHost(), this.lifecycleManager.getRssMetaServicePort(), this.lifecycleManager.getUserIdentifier(), shuffleId, numMaps, dependency);
    }

    public boolean unregisterShuffle(int shuffleId) {
        if (this.sortShuffleIds.contains(shuffleId)) {
            return this.sortShuffleManager().unregisterShuffle(shuffleId);
        }
        if (this.newAppId == null) {
            return true;
        }
        if (this.rssShuffleClient == null) {
            return false;
        }
        return this.rssShuffleClient.unregisterShuffle(this.newAppId, shuffleId, this.isDriver());
    }

    public ShuffleBlockResolver shuffleBlockResolver() {
        return this.sortShuffleManager().shuffleBlockResolver();
    }

    public void stop() {
        if (this.rssShuffleClient != null) {
            this.rssShuffleClient.shutdown();
        }
        if (this.lifecycleManager != null) {
            this.lifecycleManager.stop();
        }
        if (this.sortShuffleManager() != null) {
            this.sortShuffleManager().stop();
        }
    }

    public <K, V> ShuffleWriter<K, V> getWriter(ShuffleHandle handle, int mapId, TaskContext context) {
        try {
            if (handle instanceof RssShuffleHandle) {
                RssShuffleHandle h = (RssShuffleHandle)handle;
                ShuffleClient client = ShuffleClient.get(h.rssMetaServiceHost(), h.rssMetaServicePort(), this.celebornConf, h.userIdentifier());
                if (ShuffleMode.SORT.equals((Object)this.celebornConf.shuffleWriterMode())) {
                    return new SortBasedShuffleWriter(h.dependency(), h.newAppId(), h.numMaps(), context, this.celebornConf, client);
                }
                if (ShuffleMode.HASH.equals((Object)this.celebornConf.shuffleWriterMode())) {
                    return new HashBasedShuffleWriter(h, mapId, context, this.celebornConf, client, SendBufferPool.get(this.cores));
                }
                throw new UnsupportedOperationException("Unrecognized shuffle write mode!" + (Object)((Object)this.celebornConf.shuffleWriterMode()));
            }
            this.sortShuffleIds.add(handle.shuffleId());
            return this.sortShuffleManager().getWriter(handle, mapId, context);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startPartition, int endPartition, TaskContext context) {
        if (handle instanceof RssShuffleHandle) {
            RssShuffleHandle h = (RssShuffleHandle)handle;
            return new RssShuffleReader(h, startPartition, endPartition, 0, Int.MaxValue(), context, this.celebornConf);
        }
        return this._sortShuffleManager.getReader(handle, startPartition, endPartition, context);
    }
}

