/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.rpc.netty;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.internal.Logging$class;
import org.apache.celeborn.common.metrics.source.RPCSource;
import org.apache.celeborn.common.network.buffer.NioManagedBuffer;
import org.apache.celeborn.common.network.client.RpcResponseCallback;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.protocol.OneWayMessage;
import org.apache.celeborn.common.network.protocol.RpcFailure;
import org.apache.celeborn.common.network.protocol.RpcRequest;
import org.apache.celeborn.common.network.protocol.RpcResponse;
import org.apache.celeborn.common.network.server.BaseMessageHandler;
import org.apache.celeborn.common.rpc.RpcAddress;
import org.apache.celeborn.common.rpc.netty.Dispatcher;
import org.apache.celeborn.common.rpc.netty.NettyRpcEnv;
import org.apache.celeborn.common.rpc.netty.RemoteProcessConnected;
import org.apache.celeborn.common.rpc.netty.RemoteProcessConnectionError;
import org.apache.celeborn.common.rpc.netty.RemoteProcessDisconnected;
import org.apache.celeborn.common.rpc.netty.RequestMessage;
import org.apache.celeborn.common.rpc.netty.RequestMessage$;
import org.apache.celeborn.shaded.com.google.common.base.Throwables;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb!B\u0001\u0003\u0001!q!a\u0004(fiRL(\u000b]2IC:$G.\u001a:\u000b\u0005\r!\u0011!\u00028fiRL(BA\u0003\u0007\u0003\r\u0011\bo\u0019\u0006\u0003\u000f!\taaY8n[>t'BA\u0005\u000b\u0003!\u0019W\r\\3c_Jt'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c2\u0001A\b\u0018!\t\u0001R#D\u0001\u0012\u0015\t\u00112#\u0001\u0004tKJ4XM\u001d\u0006\u0003)\u0019\tqA\\3uo>\u00148.\u0003\u0002\u0017#\t\u0011\")Y:f\u001b\u0016\u001c8/Y4f\u0011\u0006tG\r\\3s!\tA2$D\u0001\u001a\u0015\tQb!\u0001\u0005j]R,'O\\1m\u0013\ta\u0012DA\u0004M_\u001e<\u0017N\\4\t\u0011y\u0001!\u0011!Q\u0001\n\u0001\n!\u0002Z5ta\u0006$8\r[3s\u0007\u0001\u0001\"!\t\u0012\u000e\u0003\tI!a\t\u0002\u0003\u0015\u0011K7\u000f]1uG\",'\u000f\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0003!qW\r\u001e;z\u000b:4\bCA\u0011(\u0013\tA#AA\u0006OKR$\u0018P\u00159d\u000b:4\b\"\u0002\u0016\u0001\t\u0003Y\u0013A\u0002\u001fj]&$h\bF\u0002-[9\u0002\"!\t\u0001\t\u000byI\u0003\u0019\u0001\u0011\t\u000b\u0015J\u0003\u0019\u0001\u0014\t\u000fA\u0002!\u0019!C\u0005c\u0005y!/Z7pi\u0016\fE\r\u001a:fgN,7/F\u00013!\u0011\u0019$\b\u0010\u001f\u000e\u0003QR!!\u000e\u001c\u0002\u0015\r|gnY;se\u0016tGO\u0003\u00028q\u0005!Q\u000f^5m\u0015\u0005I\u0014\u0001\u00026bm\u0006L!a\u000f\u001b\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002>}5\tA!\u0003\u0002@\t\tQ!\u000b]2BI\u0012\u0014Xm]:\t\r\u0005\u0003\u0001\u0015!\u00033\u0003A\u0011X-\\8uK\u0006#GM]3tg\u0016\u001c\b\u0005C\u0003D\u0001\u0011\u0005C)A\u0004sK\u000e,\u0017N^3\u0015\u0007\u0015[%\u000b\u0005\u0002G\u00136\tqIC\u0001I\u0003\u0015\u00198-\u00197b\u0013\tQuI\u0001\u0003V]&$\b\"\u0002'C\u0001\u0004i\u0015AB2mS\u0016tG\u000f\u0005\u0002O!6\tqJ\u0003\u0002M'%\u0011\u0011k\u0014\u0002\u0010)J\fgn\u001d9peR\u001cE.[3oi\")1K\u0011a\u0001)\u0006q!/Z9vKN$X*Z:tC\u001e,\u0007CA+Y\u001b\u00051&BA,\u0014\u0003!\u0001(o\u001c;pG>d\u0017BA-W\u00059\u0011V-];fgRlUm]:bO\u0016DQa\u0017\u0001\u0005\nq\u000b!\u0002\u001d:pG\u0016\u001c8O\u00159d)\r)UL\u0018\u0005\u0006\u0019j\u0003\r!\u0014\u0005\u0006?j\u0003\r\u0001Y\u0001\u0002eB\u0011Q+Y\u0005\u0003EZ\u0013!B\u00159d%\u0016\fX/Z:u\u0011\u0015!\u0007\u0001\"\u0003f\u0003Q\u0001(o\\2fgN|e.Z<bs6+7o]1hKR\u0019QIZ4\t\u000b1\u001b\u0007\u0019A'\t\u000b}\u001b\u0007\u0019\u00015\u0011\u0005UK\u0017B\u00016W\u00055ye.Z,bs6+7o]1hK\")A\u000e\u0001C\u0005[\u0006y\u0011N\u001c;fe:\fGNU3dK&4X\rF\u0002oaF\u0004\"!I8\n\u0005e\u0013\u0001\"\u0002'l\u0001\u0004i\u0005\"\u0002:l\u0001\u0004\u0019\u0018aB7fgN\fw-\u001a\t\u0003i^l\u0011!\u001e\u0006\u0003mb\n1A\\5p\u0013\tAXO\u0001\u0006CsR,')\u001e4gKJDQA\u001f\u0001\u0005Bm\fqb\u00195fG.\u0014VmZ5ti\u0016\u0014X\r\u001a\u000b\u0002yB\u0011a)`\u0005\u0003}\u001e\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002\u0002\u0001!\t%a\u0001\u0002\u001f\u0015D8-\u001a9uS>t7)Y;hQR$R!RA\u0003\u0003CAq!a\u0002\u0000\u0001\u0004\tI!A\u0003dCV\u001cX\r\u0005\u0003\u0002\f\u0005ma\u0002BA\u0007\u0003/qA!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'y\u0012A\u0002\u001fs_>$h(C\u0001I\u0013\r\tIbR\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti\"a\b\u0003\u0013QC'o\\<bE2,'bAA\r\u000f\")Aj a\u0001\u001b\"9\u0011Q\u0005\u0001\u0005B\u0005\u001d\u0012!D2iC:tW\r\\!di&4X\rF\u0002F\u0003SAa\u0001TA\u0012\u0001\u0004i\u0005bBA\u0017\u0001\u0011\u0005\u0013qF\u0001\u0010G\"\fgN\\3m\u0013:\f7\r^5wKR\u0019Q)!\r\t\r1\u000bY\u00031\u0001N\u0001")
public class NettyRpcHandler
extends BaseMessageHandler
implements Logging {
    private final Dispatcher dispatcher;
    private final NettyRpcEnv nettyEnv;
    private final ConcurrentHashMap<RpcAddress, RpcAddress> remoteAddresses;
    private final transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    private Logger log$lzycompute() {
        NettyRpcHandler nettyRpcHandler = this;
        synchronized (nettyRpcHandler) {
            if (!this.bitmap$trans$0) {
                this.log = Logging$class.log(this);
                this.bitmap$trans$0 = true;
            }
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$trans$0 ? this.log : this.log$lzycompute();
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    private ConcurrentHashMap<RpcAddress, RpcAddress> remoteAddresses() {
        return this.remoteAddresses;
    }

    @Override
    public void receive(TransportClient client, org.apache.celeborn.common.network.protocol.RequestMessage requestMessage) {
        org.apache.celeborn.common.network.protocol.RequestMessage requestMessage2;
        block4: {
            block3: {
                block2: {
                    requestMessage2 = requestMessage;
                    if (!(requestMessage2 instanceof RpcRequest)) break block2;
                    RpcRequest rpcRequest = (RpcRequest)requestMessage2;
                    this.processRpc(client, rpcRequest);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(requestMessage2 instanceof OneWayMessage)) break block4;
                OneWayMessage oneWayMessage = (OneWayMessage)requestMessage2;
                this.processOnewayMessage(client, oneWayMessage);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)requestMessage2);
    }

    private void processRpc(TransportClient client, RpcRequest r) {
        RpcResponseCallback callback = new RpcResponseCallback(this, client, r){
            private final TransportClient client$1;
            private final RpcRequest r$1;

            public void onSuccess(ByteBuffer response) {
                this.client$1.getChannel().writeAndFlush(new RpcResponse(this.r$1.requestId, new NioManagedBuffer(response)));
            }

            public void onFailure(Throwable e) {
                this.client$1.getChannel().writeAndFlush(new RpcFailure(this.r$1.requestId, Throwables.getStackTraceAsString(e)));
            }
            {
                this.client$1 = client$1;
                this.r$1 = r$1;
            }
        };
        try {
            try {
                ByteBuffer message = r.body().nioByteBuffer();
                RequestMessage messageToDispatch = this.internalReceive(client, message);
                this.dispatcher.postRemoteMessage(messageToDispatch, callback);
            }
            catch (Exception exception) {
                this.logError((Function0<String>)new Serializable(this, r){
                    public static final long serialVersionUID = 0L;
                    private final RpcRequest r$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Error while invoking RpcHandler#receive() on RPC id ").append((Object)BoxesRunTime.boxToLong((long)this.r$1.requestId)).toString();
                    }
                    {
                        this.r$1 = r$1;
                    }
                }, exception);
                client.getChannel().writeAndFlush(new RpcFailure(r.requestId, Throwables.getStackTraceAsString(exception)));
            }
        }
        finally {
            r.body().release();
        }
    }

    private void processOnewayMessage(TransportClient client, OneWayMessage r) {
        try {
            try {
                ByteBuffer message = r.body().nioByteBuffer();
                RequestMessage messageToDispatch = this.internalReceive(client, message);
                this.dispatcher.postOneWayMessage(messageToDispatch);
            }
            catch (Exception exception) {
                this.logError((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Error while invoking RpcHandler#receive() for one-way message.";
                    }
                }, exception);
            }
        }
        finally {
            r.body().release();
        }
    }

    private RequestMessage internalReceive(TransportClient client, ByteBuffer message) {
        RequestMessage requestMessage;
        InetSocketAddress addr = (InetSocketAddress)client.getChannel().remoteAddress();
        Predef$.MODULE$.assert(addr != null);
        int messageLen = message.remaining();
        RpcAddress clientAddr = new RpcAddress(addr.getHostString(), addr.getPort());
        RequestMessage requestMessage2 = RequestMessage$.MODULE$.apply(this.nettyEnv, client, message);
        this.nettyEnv.source().foreach((Function1)new Serializable(this, messageLen, requestMessage2){
            public static final long serialVersionUID = 0L;
            private final int messageLen$1;
            private final RequestMessage requestMessage$1;

            public final void apply(RPCSource x$1) {
                x$1.updateMessageMetrics(this.requestMessage$1.content(), this.messageLen$1);
            }
            {
                this.messageLen$1 = messageLen$1;
                this.requestMessage$1 = requestMessage$1;
            }
        });
        if (requestMessage2.senderAddress() == null) {
            requestMessage = new RequestMessage(clientAddr, requestMessage2.receiver(), requestMessage2.content());
        } else {
            RpcAddress remoteEnvAddress = requestMessage2.senderAddress();
            if (this.remoteAddresses().putIfAbsent(clientAddr, remoteEnvAddress) == null) {
                this.dispatcher.postToAll(new RemoteProcessConnected(remoteEnvAddress));
            }
            requestMessage = requestMessage2;
        }
        return requestMessage;
    }

    @Override
    public boolean checkRegistered() {
        return this.nettyEnv.checkRegistered();
    }

    @Override
    public void exceptionCaught(Throwable cause, TransportClient client) {
        InetSocketAddress addr = (InetSocketAddress)client.getChannel().remoteAddress();
        if (addr == null) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Exception before connecting to the client";
                }
            }, cause);
        } else {
            RpcAddress clientAddr = new RpcAddress(addr.getHostString(), addr.getPort());
            this.dispatcher.postToAll(new RemoteProcessConnectionError(cause, clientAddr));
            RpcAddress remoteEnvAddress = this.remoteAddresses().get(clientAddr);
            if (remoteEnvAddress != null) {
                this.dispatcher.postToAll(new RemoteProcessConnectionError(cause, remoteEnvAddress));
            }
        }
    }

    @Override
    public void channelActive(TransportClient client) {
        InetSocketAddress addr = (InetSocketAddress)client.getChannel().remoteAddress();
        Predef$.MODULE$.assert(addr != null);
        RpcAddress clientAddr = new RpcAddress(addr.getHostString(), addr.getPort());
        this.dispatcher.postToAll(new RemoteProcessConnected(clientAddr));
    }

    @Override
    public void channelInactive(TransportClient client) {
        InetSocketAddress addr = (InetSocketAddress)client.getChannel().remoteAddress();
        if (addr != null) {
            RpcAddress clientAddr = new RpcAddress(addr.getHostString(), addr.getPort());
            this.nettyEnv.removeOutbox(clientAddr);
            this.dispatcher.postToAll(new RemoteProcessDisconnected(clientAddr));
            RpcAddress remoteEnvAddress = this.remoteAddresses().remove(clientAddr);
            if (remoteEnvAddress != null) {
                this.dispatcher.postToAll(new RemoteProcessDisconnected(remoteEnvAddress));
            }
        }
    }

    public NettyRpcHandler(Dispatcher dispatcher, NettyRpcEnv nettyEnv) {
        this.dispatcher = dispatcher;
        this.nettyEnv = nettyEnv;
        Logging$class.$init$(this);
        this.remoteAddresses = new ConcurrentHashMap();
    }
}

