/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.rpc.netty;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.internal.Logging$class;
import org.apache.celeborn.common.metrics.source.RPCSource;
import org.apache.celeborn.common.network.TransportContext;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.network.server.TransportServer;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.protocol.RpcNameConstants;
import org.apache.celeborn.common.rpc.RpcAddress;
import org.apache.celeborn.common.rpc.RpcEndpoint;
import org.apache.celeborn.common.rpc.RpcEndpointAddress;
import org.apache.celeborn.common.rpc.RpcEndpointAddress$;
import org.apache.celeborn.common.rpc.RpcEndpointNotFoundException;
import org.apache.celeborn.common.rpc.RpcEndpointRef;
import org.apache.celeborn.common.rpc.RpcEnv;
import org.apache.celeborn.common.rpc.RpcEnvStoppedException;
import org.apache.celeborn.common.rpc.RpcTimeout;
import org.apache.celeborn.common.rpc.netty.Dispatcher;
import org.apache.celeborn.common.rpc.netty.NettyRpcEndpointRef;
import org.apache.celeborn.common.rpc.netty.NettyRpcEnv$;
import org.apache.celeborn.common.rpc.netty.NettyRpcHandler;
import org.apache.celeborn.common.rpc.netty.OneWayOutboxMessage;
import org.apache.celeborn.common.rpc.netty.Outbox;
import org.apache.celeborn.common.rpc.netty.OutboxMessage;
import org.apache.celeborn.common.rpc.netty.RequestMessage;
import org.apache.celeborn.common.rpc.netty.RpcEndpointVerifier;
import org.apache.celeborn.common.rpc.netty.RpcEndpointVerifier$;
import org.apache.celeborn.common.rpc.netty.RpcFailure;
import org.apache.celeborn.common.rpc.netty.RpcOutboxMessage;
import org.apache.celeborn.common.serializer.JavaSerializerInstance;
import org.apache.celeborn.common.serializer.SerializationStream;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.common.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r5c\u0001B\u0001\u0003\u0001=\u00111BT3uif\u0014\u0006oY#om*\u00111\u0001B\u0001\u0006]\u0016$H/\u001f\u0006\u0003\u000b\u0019\t1A\u001d9d\u0015\t9\u0001\"\u0001\u0004d_6lwN\u001c\u0006\u0003\u0013)\t\u0001bY3mK\n|'O\u001c\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001B\u0003\u0005\u0002\u0012%5\tA!\u0003\u0002\u0014\t\t1!\u000b]2F]Z\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\u0011%tG/\u001a:oC2L!!\u0007\f\u0003\u000f1{wmZ5oO\"A1\u0004\u0001BC\u0002\u0013\u0005A$\u0001\u0003d_:4W#A\u000f\u0011\u0005yyR\"\u0001\u0004\n\u0005\u00012!\u0001D\"fY\u0016\u0014wN\u001d8D_:4\u0007\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0002\u000b\r|gN\u001a\u0011\t\u0011\u0011\u0002!\u0011!Q\u0001\n\u0015\naC[1wCN+'/[1mSj,'/\u00138ti\u0006t7-\u001a\t\u0003M%j\u0011a\n\u0006\u0003Q\u0019\t!b]3sS\u0006d\u0017N_3s\u0013\tQsE\u0001\fKCZ\f7+\u001a:jC2L'0\u001a:J]N$\u0018M\\2f\u0011!a\u0003A!A!\u0002\u0013i\u0013\u0001\u00025pgR\u0004\"A\f\u001b\u000f\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0002\rA\u0013X\rZ3g\u0013\t)dG\u0001\u0004TiJLgn\u001a\u0006\u0003gAB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!O\u0001\u000f]VlWk]1cY\u0016\u001cuN]3t!\ty#(\u0003\u0002<a\t\u0019\u0011J\u001c;\t\u000bu\u0002A\u0011\u0001 \u0002\rqJg.\u001b;?)\u0015y\u0014IQ\"E!\t\u0001\u0005!D\u0001\u0003\u0011\u0015YB\b1\u0001\u001e\u0011\u0015!C\b1\u0001&\u0011\u0015aC\b1\u0001.\u0011\u0015AD\b1\u0001:\u0011!1\u0005A1A\u0005\u0002!9\u0015!\u0004;sC:\u001c\bo\u001c:u\u0007>tg-F\u0001I!\tIe*D\u0001K\u0015\tYE*\u0001\u0003vi&d'BA'\u0007\u0003\u001dqW\r^<pe.L!a\u0014&\u0003\u001bQ\u0013\u0018M\\:q_J$8i\u001c8g\u0011\u0019\t\u0006\u0001)A\u0005\u0011\u0006qAO]1ogB|'\u000f^\"p]\u001a\u0004\u0003bB*\u0001\u0005\u0004%I\u0001V\u0001\u000bI&\u001c\b/\u0019;dQ\u0016\u0014X#A+\u0011\u0005\u00013\u0016BA,\u0003\u0005)!\u0015n\u001d9bi\u000eDWM\u001d\u0005\u00073\u0002\u0001\u000b\u0011B+\u0002\u0017\u0011L7\u000f]1uG\",'\u000f\t\u0005\b7\u0002\u0001\r\u0011\"\u0003]\u0003\u00199xN]6feV\tQ\f\u0005\u0002\u0012=&\u0011q\f\u0002\u0002\f%B\u001cWI\u001c3q_&tG\u000fC\u0004b\u0001\u0001\u0007I\u0011\u00022\u0002\u0015]|'o[3s?\u0012*\u0017\u000f\u0006\u0002dMB\u0011q\u0006Z\u0005\u0003KB\u0012A!\u00168ji\"9q\rYA\u0001\u0002\u0004i\u0016a\u0001=%c!1\u0011\u000e\u0001Q!\nu\u000bqa^8sW\u0016\u0014\b\u0005C\u0004l\u0001\u0001\u0007I\u0011\u00017\u0002\rM|WO]2f+\u0005i\u0007cA\u0018oa&\u0011q\u000e\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005E,X\"\u0001:\u000b\u0005-\u001c(B\u0001;\u0007\u0003\u001diW\r\u001e:jGNL!A\u001e:\u0003\u0013I\u00036iU8ve\u000e,\u0007b\u0002=\u0001\u0001\u0004%\t!_\u0001\u000bg>,(oY3`I\u0015\fHCA2{\u0011\u001d9w/!AA\u00025Da\u0001 \u0001!B\u0013i\u0017aB:pkJ\u001cW\r\t\u0005\b}\u0002\u0011\r\u0011\"\u0003\u0000\u0003A!(/\u00198ta>\u0014HoQ8oi\u0016DH/\u0006\u0002\u0002\u0002A!\u00111AA\u0003\u001b\u0005a\u0015bAA\u0004\u0019\n\u0001BK]1ogB|'\u000f^\"p]R,\u0007\u0010\u001e\u0005\t\u0003\u0017\u0001\u0001\u0015!\u0003\u0002\u0002\u0005\tBO]1ogB|'\u000f^\"p]R,\u0007\u0010\u001e\u0011\t\u0013\u0005=\u0001A1A\u0005\u0002\u0005E\u0011!D2mS\u0016tGOR1di>\u0014\u00180\u0006\u0002\u0002\u0014A!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001a1\u000baa\u00197jK:$\u0018\u0002BA\u000f\u0003/\u0011a\u0003\u0016:b]N\u0004xN\u001d;DY&,g\u000e\u001e$bGR|'/\u001f\u0005\t\u0003C\u0001\u0001\u0015!\u0003\u0002\u0014\u0005q1\r\\5f]R4\u0015m\u0019;pef\u0004\u0003\"CA\u0013\u0001\t\u0007I\u0011BA\u0014\u0003A!\u0018.\\3pkR\u001c6\r[3ek2,'/\u0006\u0002\u0002*A!\u00111FA\u001c\u001b\t\tiC\u0003\u0003\u00020\u0005E\u0012AC2p]\u000e,(O]3oi*\u00191*a\r\u000b\u0005\u0005U\u0012\u0001\u00026bm\u0006LA!!\u000f\u0002.\tA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\u0011\u0005u\u0002\u0001)A\u0005\u0003S\t\u0011\u0003^5nK>,HoU2iK\u0012,H.\u001a:!\u0011)\t\t\u0005\u0001b\u0001\n\u0003A\u00111I\u0001\u0019G2LWM\u001c;D_:tWm\u0019;j_:,\u00050Z2vi>\u0014XCAA#!\u0011\tY#a\u0012\n\t\u0005%\u0013Q\u0006\u0002\u0013)\"\u0014X-\u00193Q_>dW\t_3dkR|'\u000f\u0003\u0005\u0002N\u0001\u0001\u000b\u0011BA#\u0003e\u0019G.[3oi\u000e{gN\\3di&|g.\u0012=fGV$xN\u001d\u0011\t\u0017\u0005E\u0003\u00011AA\u0002\u0013%\u00111K\u0001\u0007g\u0016\u0014h/\u001a:\u0016\u0005\u0005U\u0003\u0003BA,\u00037j!!!\u0017\u000b\u0007\u0005EC*\u0003\u0003\u0002^\u0005e#a\u0004+sC:\u001c\bo\u001c:u'\u0016\u0014h/\u001a:\t\u0017\u0005\u0005\u0004\u00011AA\u0002\u0013%\u00111M\u0001\u000bg\u0016\u0014h/\u001a:`I\u0015\fHcA2\u0002f!Iq-a\u0018\u0002\u0002\u0003\u0007\u0011Q\u000b\u0005\t\u0003S\u0002\u0001\u0015)\u0003\u0002V\u000591/\u001a:wKJ\u0004\u0003\u0006BA4\u0003[\u00022aLA8\u0013\r\t\t\b\r\u0002\tm>d\u0017\r^5mK\"I\u0011Q\u000f\u0001C\u0002\u0013%\u0011qO\u0001\bgR|\u0007\u000f]3e+\t\tI\b\u0005\u0003\u0002|\u0005\u0005UBAA?\u0015\u0011\ty(!\f\u0002\r\u0005$x.\\5d\u0013\u0011\t\u0019)! \u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0011!\t9\t\u0001Q\u0001\n\u0005e\u0014\u0001C:u_B\u0004X\r\u001a\u0011\t\u0013\u0005-\u0005A1A\u0005\n\u00055\u0015\u0001C8vi\n|\u00070Z:\u0016\u0005\u0005=\u0005\u0003CA\u0016\u0003#\u000b)*a'\n\t\u0005M\u0015Q\u0006\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bcA\t\u0002\u0018&\u0019\u0011\u0011\u0014\u0003\u0003\u0015I\u00038-\u00113ee\u0016\u001c8\u000fE\u0002A\u0003;K1!a(\u0003\u0005\u0019yU\u000f\u001e2pq\"A\u00111\u0015\u0001!\u0002\u0013\ty)A\u0005pkR\u0014w\u000e_3tA!A\u0011q\u0015\u0001\u0005\u0002!\tI+\u0001\u0007sK6|g/Z(vi\n|\u0007\u0010F\u0002d\u0003WC\u0001\"!,\u0002&\u0002\u0007\u0011QS\u0001\bC\u0012$'/Z:t\u0011\u001d\t\t\f\u0001C\u0001\u0003g\u000b1b\u001d;beR\u001cVM\u001d<feR)1-!.\u0002:\"9\u0011qWAX\u0001\u0004i\u0013a\u00032j]\u0012\fE\r\u001a:fgNDq!a/\u00020\u0002\u0007\u0011(\u0001\u0003q_J$\bBCAW\u0001!\u0015\r\u0011\"\u0011\u0002@V\u0011\u0011Q\u0013\u0005\u000b\u0003\u0007\u0004\u0001\u0012!Q!\n\u0005U\u0015\u0001C1eIJ,7o\u001d\u0011)\t\u0005\u0005\u0017q\u0019\t\u0005\u0003\u0013\f\u0019.\u0004\u0002\u0002L*!\u0011QZAh\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u0003#\fQA[1wCbLA!!6\u0002L\nAa*\u001e7mC\ndW\rC\u0004\u0002Z\u0002!\t%a7\u0002\u001bM,G/\u001e9F]\u0012\u0004x.\u001b8u)!\ti.a9\u0002h\u0006-\bcA\t\u0002`&\u0019\u0011\u0011\u001d\u0003\u0003\u001dI\u00038-\u00128ea>Lg\u000e\u001e*fM\"9\u0011Q]Al\u0001\u0004i\u0013\u0001\u00028b[\u0016Dq!!;\u0002X\u0002\u0007Q,\u0001\u0005f]\u0012\u0004x.\u001b8u\u0011%\ti/a6\u0011\u0002\u0003\u0007Q.\u0001\bbEN$(/Y2u'>,(oY3\t\u000f\u0005E\b\u0001\"\u0001\u0002t\u0006y1\r[3dWJ+w-[:uKJ,G\r\u0006\u0002\u0002vB\u0019q&a>\n\u0007\u0005e\bGA\u0004C_>dW-\u00198\t\u000f\u0005u\b\u0001\"\u0001\u0002\u0000\u0006Q\u0012m]=oGN+G/\u001e9F]\u0012\u0004x.\u001b8u%\u00164')_+S\u0013R!!\u0011\u0001B\u0006!\u0019\u0011\u0019Aa\u0002\u0002^6\u0011!Q\u0001\u0006\u0004\u0003_\u0001\u0014\u0002\u0002B\u0005\u0005\u000b\u0011aAR;ukJ,\u0007b\u0002B\u0007\u0003w\u0004\r!L\u0001\u0004kJL\u0007b\u0002B\t\u0001\u0011\u0005#1C\u0001\u0005gR|\u0007\u000fF\u0002d\u0005+A\u0001Ba\u0006\u0003\u0010\u0001\u0007\u0011Q\\\u0001\fK:$\u0007o\\5oiJ+g\rC\u0004\u0003\u001c\u0001!IA!\b\u0002\u0019A|7\u000f\u001e+p\u001fV$(m\u001c=\u0015\u000b\r\u0014yB!\u000b\t\u0011\t\u0005\"\u0011\u0004a\u0001\u0005G\t\u0001B]3dK&4XM\u001d\t\u0004\u0001\n\u0015\u0012b\u0001B\u0014\u0005\t\u0019b*\u001a;usJ\u00038-\u00128ea>Lg\u000e\u001e*fM\"A!1\u0006B\r\u0001\u0004\u0011i#A\u0004nKN\u001c\u0018mZ3\u0011\u0007\u0001\u0013y#C\u0002\u00032\t\u0011QbT;uE>DX*Z:tC\u001e,\u0007\u0002\u0003B\u001b\u0001\u0011\u0005\u0001Ba\u000e\u0002\tM,g\u000e\u001a\u000b\u0004G\ne\u0002\u0002\u0003B\u0016\u0005g\u0001\rAa\u000f\u0011\u0007\u0001\u0013i$C\u0002\u0003@\t\u0011aBU3rk\u0016\u001cH/T3tg\u0006<W\r\u0003\u0005\u0003D\u0001!\t\u0001\u0003B#\u00031\u0019'/Z1uK\u000ec\u0017.\u001a8u)\u0011\u00119E!\u0014\u0011\t\u0005U!\u0011J\u0005\u0005\u0005\u0017\n9BA\bUe\u0006t7\u000f]8si\u000ec\u0017.\u001a8u\u0011!\tiK!\u0011A\u0002\u0005U\u0005\u0002\u0003B)\u0001\u0011\u0005\u0001Ba\u0015\u0002\u0007\u0005\u001c8.\u0006\u0003\u0003V\t}CC\u0002B,\u0005\u0003\u0013\u0019\t\u0006\u0003\u0003Z\tE\u0004C\u0002B\u0002\u0005\u000f\u0011Y\u0006\u0005\u0003\u0003^\t}C\u0002\u0001\u0003\t\u0005C\u0012yE1\u0001\u0003d\t\tA+\u0005\u0003\u0003f\t-\u0004cA\u0018\u0003h%\u0019!\u0011\u000e\u0019\u0003\u000f9{G\u000f[5oOB\u0019qF!\u001c\n\u0007\t=\u0004GA\u0002B]fD!Ba\u001d\u0003P\u0005\u0005\t9\u0001B;\u0003))g/\u001b3f]\u000e,G%\r\t\u0007\u0005o\u0012iHa\u0017\u000e\u0005\te$b\u0001B>a\u00059!/\u001a4mK\u000e$\u0018\u0002\u0002B@\u0005s\u0012\u0001b\u00117bgN$\u0016m\u001a\u0005\t\u0005W\u0011y\u00051\u0001\u0003<!A!Q\u0011B(\u0001\u0004\u00119)A\u0004uS6,w.\u001e;\u0011\u0007E\u0011I)C\u0002\u0003\f\u0012\u0011!B\u00159d)&lWm\\;u\u0011!\u0011y\t\u0001C\u0001\u0011\tE\u0015!C:fe&\fG.\u001b>f)\u0011\u0011\u0019Ja(\u0011\t\tU%1T\u0007\u0003\u0005/SAA!'\u00024\u0005\u0019a.[8\n\t\tu%q\u0013\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\u0002\u0003BQ\u0005\u001b\u0003\rAa\u001b\u0002\u000f\r|g\u000e^3oi\"A!Q\u0015\u0001\u0005\u0002!\u00119+A\btKJL\u0017\r\\5{KN#(/Z1n)\u0011\u0011IKa,\u0011\u0007\u0019\u0012Y+C\u0002\u0003.\u001e\u00121cU3sS\u0006d\u0017N_1uS>t7\u000b\u001e:fC6D\u0001B!-\u0003$\u0002\u0007!1W\u0001\u0004_V$\b\u0003\u0002B[\u0005wk!Aa.\u000b\t\te\u00161G\u0001\u0003S>LAA!0\u00038\naq*\u001e;qkR\u001cFO]3b[\"A!\u0011\u0019\u0001\u0005\u0002!\u0011\u0019-A\u0006eKN,'/[1mSj,W\u0003\u0002Bc\u0005\u0017$bAa2\u0003T\nUG\u0003\u0002Be\u0005\u001b\u0004BA!\u0018\u0003L\u0012A!\u0011\rB`\u0005\u0004\u0011\u0019\u0007\u0003\u0006\u0003P\n}\u0016\u0011!a\u0002\u0005#\f!\"\u001a<jI\u0016t7-\u001a\u00133!\u0019\u00119H! \u0003J\"A\u0011\u0011\u0004B`\u0001\u0004\u00119\u0005\u0003\u0005\u0003X\n}\u0006\u0019\u0001BJ\u0003\u0015\u0011\u0017\u0010^3t\u0011\u001d\u00119\u0002\u0001C!\u00057$B!!8\u0003^\"9\u0011\u0011\u001eBm\u0001\u0004i\u0006b\u0002Bq\u0001\u0011\u0005#1]\u0001\tg\",H\u000fZ8x]R\t1\rC\u0004\u0003h\u0002!\tEa9\u0002!\u0005<\u0018-\u001b;UKJl\u0017N\\1uS>t\u0007b\u0002Bv\u0001\u0011%!1]\u0001\bG2,\u0017M\\;q\u0011\u001d\u0011\t\r\u0001C!\u0005_,BA!=\u0003vR!!1\u001fB|!\u0011\u0011iF!>\u0005\u0011\t\u0005$Q\u001eb\u0001\u0005GB\u0001B!?\u0003n\u0002\u0007!1`\u0001\u0016I\u0016\u001cXM]5bY&T\u0018\r^5p]\u0006\u001bG/[8o!\u0015y#Q Bz\u0013\r\u0011y\u0010\r\u0002\n\rVt7\r^5p]BB\u0011ba\u0001\u0001#\u0003%\te!\u0002\u0002/M,G/\u001e9F]\u0012\u0004x.\u001b8uI\u0011,g-Y;mi\u0012\u001aTCAB\u0004U\ri7\u0011B\u0016\u0003\u0007\u0017\u0001Ba!\u0004\u0004\u00165\u00111q\u0002\u0006\u0005\u0007#\u0019\u0019\"A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u001a\u0019\n\t\r]1q\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,w\u0001CB\u000e\u0005!\u0005\u0001b!\b\u0002\u00179+G\u000f^=Sa\u000e,eN\u001e\t\u0004\u0001\u000e}aaB\u0001\u0003\u0011\u0003A1\u0011E\n\u0006\u0007?\u0019\u0019\u0003\u0006\t\u0004_\r\u0015\u0012bAB\u0014a\t1\u0011I\\=SK\u001aDq!PB\u0010\t\u0003\u0019Y\u0003\u0006\u0002\u0004\u001e!Y1qFB\u0010\u0005\u0004%\t\u0001CB\u0019\u0003)\u0019WO\u001d:f]R,eN^\u000b\u0003\u0007g\u0001Ra!\u000e\u0004:}j!aa\u000e\u000b\u0005-\u0003\u0014\u0002BB\u001e\u0007o\u0011q\u0002R=oC6L7MV1sS\u0006\u0014G.\u001a\u0005\n\u0007\u007f\u0019y\u0002)A\u0005\u0007g\t1bY;se\u0016tG/\u00128wA!Y11IB\u0010\u0005\u0004%\t\u0001CB#\u00035\u0019WO\u001d:f]R\u001cE.[3oiV\u00111q\t\t\u0007\u0007k\u0019IDa\u0012\t\u0013\r-3q\u0004Q\u0001\n\r\u001d\u0013AD2veJ,g\u000e^\"mS\u0016tG\u000f\t")
public class NettyRpcEnv
extends RpcEnv
implements Logging {
    private final CelebornConf conf;
    public final JavaSerializerInstance org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$javaSerializerInstance;
    private final String host;
    private final TransportConf transportConf;
    private final Dispatcher dispatcher;
    private RpcEndpoint worker;
    private Option<RPCSource> source;
    private final TransportContext transportContext;
    private final TransportClientFactory clientFactory;
    private final ScheduledExecutorService timeoutScheduler;
    private final ThreadPoolExecutor clientConnectionExecutor;
    private volatile TransportServer server;
    private final AtomicBoolean stopped;
    private final ConcurrentHashMap<RpcAddress, Outbox> outboxes;
    @Nullable
    private RpcAddress address;
    private final transient Logger log;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    private RpcAddress address$lzycompute() {
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            if (!this.bitmap$0) {
                this.address = this.server() == null ? null : new RpcAddress(this.host, this.server().getPort());
                this.bitmap$0 = true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
            this.host = null;
            return this.address;
        }
    }

    private Logger log$lzycompute() {
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            if (!this.bitmap$trans$0) {
                this.log = Logging$class.log(this);
                this.bitmap$trans$0 = true;
            }
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$trans$0 ? this.log : this.log$lzycompute();
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    public CelebornConf conf() {
        return this.conf;
    }

    public TransportConf transportConf() {
        return this.transportConf;
    }

    private Dispatcher dispatcher() {
        return this.dispatcher;
    }

    private RpcEndpoint worker() {
        return this.worker;
    }

    private void worker_$eq(RpcEndpoint x$1) {
        this.worker = x$1;
    }

    public Option<RPCSource> source() {
        return this.source;
    }

    public void source_$eq(Option<RPCSource> x$1) {
        this.source = x$1;
    }

    private TransportContext transportContext() {
        return this.transportContext;
    }

    public TransportClientFactory clientFactory() {
        return this.clientFactory;
    }

    private ScheduledExecutorService timeoutScheduler() {
        return this.timeoutScheduler;
    }

    public ThreadPoolExecutor clientConnectionExecutor() {
        return this.clientConnectionExecutor;
    }

    private TransportServer server() {
        return this.server;
    }

    private void server_$eq(TransportServer x$1) {
        this.server = x$1;
    }

    private AtomicBoolean stopped() {
        return this.stopped;
    }

    private ConcurrentHashMap<RpcAddress, Outbox> outboxes() {
        return this.outboxes;
    }

    public void removeOutbox(RpcAddress address) {
        Outbox outbox = this.outboxes().remove(address);
        if (outbox != null) {
            outbox.stop();
        }
    }

    public void startServer(String bindAddress, int port) {
        this.server_$eq(this.transportContext().createServer(bindAddress, port));
        this.dispatcher().registerRpcEndpoint(RpcEndpointVerifier$.MODULE$.NAME(), new RpcEndpointVerifier(this, this.dispatcher()));
    }

    @Override
    public RpcAddress address() {
        return this.bitmap$0 ? this.address : this.address$lzycompute();
    }

    @Override
    public RpcEndpointRef setupEndpoint(String name, RpcEndpoint endpoint, Option<RPCSource> abstractSource) {
        String string = name;
        String string2 = RpcNameConstants.WORKER_EP;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.worker_$eq(endpoint);
        }
        this.source_$eq(abstractSource);
        return this.dispatcher().registerRpcEndpoint(name, endpoint);
    }

    @Override
    public Option<RPCSource> setupEndpoint$default$3() {
        return None$.MODULE$;
    }

    public boolean checkRegistered() {
        return this.worker() == null ? true : this.worker().checkRegistered();
    }

    @Override
    public Future<RpcEndpointRef> asyncSetupEndpointRefByURI(String uri) {
        RpcEndpointAddress addr = RpcEndpointAddress$.MODULE$.apply(uri);
        NettyRpcEndpointRef endpointRef = new NettyRpcEndpointRef(this.conf(), addr, this);
        NettyRpcEndpointRef verifier = new NettyRpcEndpointRef(this.conf(), new RpcEndpointAddress(addr.rpcAddress(), RpcEndpointVerifier$.MODULE$.NAME()), this);
        return verifier.ask(new RpcEndpointVerifier.CheckExistence(endpointRef.name()), ClassTag$.MODULE$.Boolean()).flatMap((Function1)new Serializable(this, uri, endpointRef){
            public static final long serialVersionUID = 0L;
            private final String uri$1;
            private final NettyRpcEndpointRef endpointRef$1;

            public final Future<NettyRpcEndpointRef> apply(boolean find) {
                return find ? Future$.MODULE$.successful((Object)this.endpointRef$1) : Future$.MODULE$.failed((Throwable)new RpcEndpointNotFoundException(this.uri$1));
            }
            {
                this.uri$1 = uri$1;
                this.endpointRef$1 = endpointRef$1;
            }
        }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    @Override
    public void stop(RpcEndpointRef endpointRef) {
        Predef$.MODULE$.require(endpointRef instanceof NettyRpcEndpointRef);
        this.dispatcher().stop(endpointRef);
    }

    private void postToOutbox(NettyRpcEndpointRef receiver, OutboxMessage message) {
        if (receiver.client() != null && receiver.client().isActive()) {
            message.sendWith(receiver.client());
        } else {
            Outbox targetOutbox;
            Outbox outbox;
            Predef$.MODULE$.require(receiver.address() != null, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Cannot send message to client endpoint with no listen address.";
                }
            });
            Outbox outbox2 = this.outboxes().get(receiver.address());
            if (outbox2 == null) {
                Outbox newOutbox = new Outbox(this, receiver.address());
                Outbox oldOutbox = this.outboxes().putIfAbsent(receiver.address(), newOutbox);
                outbox = oldOutbox == null ? newOutbox : oldOutbox;
            } else {
                outbox = targetOutbox = outbox2;
            }
            if (this.stopped().get()) {
                this.outboxes().remove(receiver.address());
                targetOutbox.stop();
            } else {
                targetOutbox.send(message);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(RequestMessage message) {
        RpcAddress remoteAddr;
        RpcAddress rpcAddress = remoteAddr = message.receiver().address();
        RpcAddress rpcAddress2 = this.address();
        if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
            try {
                this.dispatcher().postOneWayMessage(message);
                return;
            }
            catch (RpcEnvStoppedException rpcEnvStoppedException) {
                this.logDebug((Function0<String>)new Serializable(this, rpcEnvStoppedException){
                    public static final long serialVersionUID = 0L;
                    private final RpcEnvStoppedException e$1;

                    public final String apply() {
                        return this.e$1.getMessage();
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
                return;
            }
        } else {
            this.postToOutbox(message.receiver(), new OneWayOutboxMessage(message.serialize(this)));
            return;
        }
    }

    public TransportClient createClient(RpcAddress address) {
        return this.clientFactory().createClient(address.host(), address.port());
    }

    public <T> Future<T> ask(RequestMessage message, RpcTimeout timeout, ClassTag<T> evidence$1) {
        Promise promise = Promise$.MODULE$.apply();
        RpcAddress remoteAddr = message.receiver().address();
        try {
            RpcAddress rpcAddress = remoteAddr;
            RpcAddress rpcAddress2 = this.address();
            if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
                Promise p = Promise$.MODULE$.apply();
                p.future().onComplete((Function1)new Serializable(this, promise){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ NettyRpcEnv $outer;
                    private final Promise promise$1;

                    public final void apply(Try<Object> x0$1) {
                        Try<Object> try_;
                        block4: {
                            block3: {
                                block2: {
                                    try_ = x0$1;
                                    if (!(try_ instanceof Success)) break block2;
                                    Success success = (Success)try_;
                                    Object response = success.value();
                                    this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onSuccess$1(response, this.promise$1);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                if (!(try_ instanceof Failure)) break block4;
                                Failure failure = (Failure)try_;
                                Throwable e = failure.exception();
                                this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e, this.promise$1);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            return;
                        }
                        throw new MatchError(try_);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.promise$1 = promise$1;
                    }
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
                this.dispatcher().postLocalMessage(message, (Promise<Object>)p);
            } else {
                RpcOutboxMessage rpcMessage = new RpcOutboxMessage(message.serialize(this), (Function1<Throwable, BoxedUnit>)new Serializable(this, promise){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ NettyRpcEnv $outer;
                    private final Promise promise$1;

                    public final void apply(Throwable e) {
                        this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e, this.promise$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.promise$1 = promise$1;
                    }
                }, (Function2<TransportClient, ByteBuffer, BoxedUnit>)new Serializable(this, promise){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ NettyRpcEnv $outer;
                    private final Promise promise$1;

                    public final void apply(TransportClient client, ByteBuffer response) {
                        this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onSuccess$1(this.$outer.deserialize(client, response, ClassTag$.MODULE$.Any()), this.promise$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.promise$1 = promise$1;
                    }
                });
                this.postToOutbox(message.receiver(), rpcMessage);
                promise.future().failed().foreach((Function1)new Serializable(this, rpcMessage){
                    public static final long serialVersionUID = 0L;
                    private final RpcOutboxMessage rpcMessage$1;

                    public final void apply(Throwable x0$2) {
                        Throwable throwable = x0$2;
                        if (throwable instanceof TimeoutException) {
                            this.rpcMessage$1.onTimeout();
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    {
                        this.rpcMessage$1 = rpcMessage$1;
                    }
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            }
            ScheduledFuture<?> timeoutCancelable = this.timeoutScheduler().schedule(new Runnable(this, timeout, promise, remoteAddr){
                private final /* synthetic */ NettyRpcEnv $outer;
                private final RpcTimeout timeout$1;
                private final Promise promise$1;
                private final RpcAddress remoteAddr$1;

                public void run() {
                    this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(new TimeoutException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot receive any reply from ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.remoteAddr$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timeout$1.duration()}))).toString()), this.promise$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timeout$1 = timeout$1;
                    this.promise$1 = promise$1;
                    this.remoteAddr$1 = remoteAddr$1;
                }
            }, timeout.duration().toNanos(), TimeUnit.NANOSECONDS);
            promise.future().onComplete((Function1)new Serializable(this, timeoutCancelable){
                public static final long serialVersionUID = 0L;
                private final ScheduledFuture timeoutCancelable$1;

                public final boolean apply(Try<Object> v) {
                    return this.timeoutCancelable$1.cancel(true);
                }
                {
                    this.timeoutCancelable$1 = timeoutCancelable$1;
                }
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return promise.future().mapTo(evidence$1).recover(timeout.addMessageIfTimeout(), (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    public ByteBuffer serialize(Object content) {
        return this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$javaSerializerInstance.serialize(content, ClassTag$.MODULE$.Any());
    }

    public SerializationStream serializeStream(OutputStream out) {
        return this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$javaSerializerInstance.serializeStream(out);
    }

    public <T> T deserialize(TransportClient client, ByteBuffer bytes, ClassTag<T> evidence$2) {
        return (T)NettyRpcEnv$.MODULE$.currentClient().withValue((Object)client, (Function0)new Serializable(this, bytes, evidence$2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyRpcEnv $outer;
            public final ByteBuffer bytes$1;
            public final ClassTag evidence$2$1;

            public final T apply() {
                return this.$outer.deserialize(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deserialize$1 $outer;

                    public final T apply() {
                        return this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer().org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$javaSerializerInstance.deserialize(this.$outer.bytes$1, this.$outer.evidence$2$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ NettyRpcEnv org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bytes$1 = bytes$1;
                this.evidence$2$1 = evidence$2$1;
            }
        });
    }

    @Override
    public RpcEndpointRef endpointRef(RpcEndpoint endpoint) {
        return this.dispatcher().getRpcEndpointRef(endpoint);
    }

    @Override
    public void shutdown() {
        this.cleanup();
    }

    @Override
    public void awaitTermination() {
        this.dispatcher().awaitTermination();
    }

    private void cleanup() {
        if (this.stopped().compareAndSet(false, true)) {
            for (Outbox outbox : this.outboxes().values()) {
                this.outboxes().remove(outbox.address());
                outbox.stop();
            }
            Object object = this.timeoutScheduler() == null ? BoxedUnit.UNIT : this.timeoutScheduler().shutdownNow();
            if (this.dispatcher() != null) {
                this.dispatcher().stop();
            }
            if (this.server() != null) {
                this.server().close();
            }
            if (this.clientFactory() != null) {
                this.clientFactory().close();
            }
            if (this.clientConnectionExecutor() != null) {
                this.clientConnectionExecutor().shutdownNow();
            }
            return;
        }
    }

    @Override
    public <T> T deserialize(Function0<T> deserializationAction) {
        return (T)NettyRpcEnv$.MODULE$.currentEnv().withValue((Object)this, deserializationAction);
    }

    public final void org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(Throwable e, Promise promise$1) {
        if (!promise$1.tryFailure(e)) {
            Throwable throwable = e;
            if (throwable instanceof RpcEnvStoppedException) {
                RpcEnvStoppedException rpcEnvStoppedException = (RpcEnvStoppedException)throwable;
                this.logDebug((Function0<String>)new Serializable(this, rpcEnvStoppedException){
                    public static final long serialVersionUID = 0L;
                    private final RpcEnvStoppedException x2$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignored failure: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x2$1}));
                    }
                    {
                        this.x2$1 = x2$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logWarning((Function0<String>)new Serializable(this, e){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignored failure: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$2}));
                    }
                    {
                        this.e$2 = e$2;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public final void org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onSuccess$1(Object reply2, Promise promise$1) {
        Object object = reply2;
        if (object instanceof RpcFailure) {
            RpcFailure rpcFailure = (RpcFailure)object;
            Throwable e = rpcFailure.e();
            this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (promise$1.trySuccess(object)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logWarning((Function0<String>)new Serializable(this, reply2){
                    public static final long serialVersionUID = 0L;
                    private final Object reply$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignored message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.reply$1}));
                    }
                    {
                        this.reply$1 = reply$1;
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public NettyRpcEnv(CelebornConf conf, JavaSerializerInstance javaSerializerInstance, String host, int numUsableCores) {
        this.conf = conf;
        this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$javaSerializerInstance = javaSerializerInstance;
        this.host = host;
        super(conf);
        Logging$class.$init$(this);
        this.transportConf = Utils$.MODULE$.fromCelebornConf(conf.clone(), "rpc", conf.getInt("celeborn.rpc.io.threads", numUsableCores));
        this.dispatcher = new Dispatcher(this, numUsableCores);
        this.worker = null;
        this.source = None$.MODULE$;
        this.transportContext = new TransportContext(this.transportConf(), new NettyRpcHandler(this.dispatcher(), this));
        this.clientFactory = this.transportContext().createClientFactory();
        this.timeoutScheduler = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("netty-rpc-env-timeout");
        this.clientConnectionExecutor = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("netty-rpc-connection", conf.rpcConnectThreads(), ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3());
        this.stopped = new AtomicBoolean(false);
        this.outboxes = new ConcurrentHashMap();
    }
}

