/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network;

import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.network.client.TransportResponseHandler;
import org.apache.celeborn.common.network.protocol.MessageEncoder;
import org.apache.celeborn.common.network.server.BaseMessageHandler;
import org.apache.celeborn.common.network.server.ChannelsLimiter;
import org.apache.celeborn.common.network.server.TransportChannelHandler;
import org.apache.celeborn.common.network.server.TransportRequestHandler;
import org.apache.celeborn.common.network.server.TransportServer;
import org.apache.celeborn.common.network.util.NettyUtils;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.shaded.io.netty.channel.Channel;
import org.apache.celeborn.shaded.io.netty.channel.ChannelHandler;
import org.apache.celeborn.shaded.io.netty.channel.socket.SocketChannel;
import org.apache.celeborn.shaded.io.netty.handler.timeout.IdleStateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportContext {
    private static final Logger logger = LoggerFactory.getLogger(TransportContext.class);
    private final TransportConf conf;
    private final BaseMessageHandler msgHandler;
    private ChannelsLimiter channelsLimiter;
    private final boolean closeIdleConnections;
    private static final MessageEncoder ENCODER = MessageEncoder.INSTANCE;

    public TransportContext(TransportConf conf, BaseMessageHandler msgHandler, boolean closeIdleConnections, ChannelsLimiter channelsLimiter) {
        this.conf = conf;
        this.msgHandler = msgHandler;
        this.closeIdleConnections = closeIdleConnections;
        this.channelsLimiter = channelsLimiter;
    }

    public TransportContext(TransportConf conf, BaseMessageHandler msgHandler, boolean closeIdleConnections) {
        this(conf, msgHandler, closeIdleConnections, null);
    }

    public TransportContext(TransportConf conf, BaseMessageHandler msgHandler) {
        this(conf, msgHandler, false);
    }

    public TransportClientFactory createClientFactory() {
        return new TransportClientFactory(this);
    }

    public TransportServer createServer(String host, int port) {
        return new TransportServer(this, host, port);
    }

    public TransportServer createServer(int port) {
        return this.createServer(null, port);
    }

    public TransportServer createServer() {
        return this.createServer(null, 0);
    }

    public TransportChannelHandler initializePipeline(SocketChannel channel) {
        try {
            if (this.channelsLimiter != null) {
                channel.pipeline().addLast("limiter", (ChannelHandler)this.channelsLimiter);
            }
            TransportChannelHandler channelHandler = this.createChannelHandler(channel, this.msgHandler);
            channel.pipeline().addLast("encoder", (ChannelHandler)ENCODER).addLast("frameDecoder", (ChannelHandler)NettyUtils.createFrameDecoder(this.conf)).addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, this.conf.connectionTimeoutMs() / 1000)).addLast("handler", (ChannelHandler)channelHandler);
            return channelHandler;
        }
        catch (RuntimeException e) {
            logger.error("Error while initializing Netty pipeline", (Throwable)e);
            throw e;
        }
    }

    private TransportChannelHandler createChannelHandler(Channel channel, BaseMessageHandler msgHandler) {
        TransportResponseHandler responseHandler = new TransportResponseHandler(channel);
        TransportClient client = new TransportClient(channel, responseHandler);
        TransportRequestHandler requestHandler = new TransportRequestHandler(channel, client, msgHandler);
        return new TransportChannelHandler(client, responseHandler, requestHandler, this.conf.connectionTimeoutMs(), this.closeIdleConnections);
    }

    public TransportConf getConf() {
        return this.conf;
    }
}

