/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.metrics.source;

import com.codahale.metrics.Gauge;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.metrics.source.JVMCPUSource$;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u00193A!\u0001\u0002\u0001\u001f\ta!JV'D!V\u001bv.\u001e:dK*\u00111\u0001B\u0001\u0007g>,(oY3\u000b\u0005\u00151\u0011aB7fiJL7m\u001d\u0006\u0003\u000f!\taaY8n[>t'BA\u0005\u000b\u0003!\u0019W\r\\3c_Jt'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u000f\u0003\n\u001cHO]1diN{WO]2f\u0011!)\u0002A!A!\u0002\u00131\u0012\u0001B2p]\u001a\u0004\"a\u0006\r\u000e\u0003\u0019I!!\u0007\u0004\u0003\u0019\r+G.\u001a2pe:\u001cuN\u001c4\t\u0011m\u0001!\u0011!Q\u0001\nq\tAA]8mKB\u0011Qd\t\b\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!eH\u0001\u0007!J,G-\u001a4\n\u0005\u0011*#AB*ue&twM\u0003\u0002#?!)q\u0005\u0001C\u0001Q\u00051A(\u001b8jiz\"2!\u000b\u0016,!\t\t\u0002\u0001C\u0003\u0016M\u0001\u0007a\u0003C\u0003\u001cM\u0001\u0007A\u0004C\u0004.\u0001\t\u0007I\u0011\t\u0018\u0002\u0015M|WO]2f\u001d\u0006lW-F\u00010!\t\u0001T'D\u00012\u0015\t\u00114'\u0001\u0003mC:<'\"\u0001\u001b\u0002\t)\fg/Y\u0005\u0003IEBaa\u000e\u0001!\u0002\u0013y\u0013aC:pkJ\u001cWMT1nK\u0002:Q!\u000f\u0002\t\u0002i\nAB\u0013,N\u0007B+6k\\;sG\u0016\u0004\"!E\u001e\u0007\u000b\u0005\u0011\u0001\u0012\u0001\u001f\u0014\u0005mj\u0004C\u0001\u0010?\u0013\tytD\u0001\u0004B]f\u0014VM\u001a\u0005\u0006Om\"\t!\u0011\u000b\u0002u!91i\u000fb\u0001\n\u0003q\u0013A\u0003&W\u001b\u000e\u0003V\u000bV5nK\"1Qi\u000fQ\u0001\n=\n1B\u0013,N\u0007B+F+[7fA\u0001")
public class JVMCPUSource
extends AbstractSource {
    private final String sourceName;

    public static String JVMCPUTime() {
        return JVMCPUSource$.MODULE$.JVMCPUTime();
    }

    @Override
    public String sourceName() {
        return this.sourceName;
    }

    public JVMCPUSource(CelebornConf conf, String role) {
        super(conf, role);
        this.sourceName = "CPU";
        this.addGauge(JVMCPUSource$.MODULE$.JVMCPUTime(), new Gauge<Object>(this){
            private final MBeanServer mBean;
            private final ObjectName name;

            public MBeanServer mBean() {
                return this.mBean;
            }

            public ObjectName name() {
                return this.name;
            }

            public long getValue() {
                long l;
                try {
                    l = BoxesRunTime.unboxToLong((Object)this.mBean().getAttribute(this.name(), "ProcessCpuTime"));
                }
                catch (Throwable throwable) {
                    long l2;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    l = l2 = -1L;
                }
                return l;
            }
            {
                this.mBean = ManagementFactory.getPlatformMBeanServer();
                this.name = new ObjectName("java.lang", "type", "OperatingSystem");
            }
        });
        this.startCleaner();
    }
}

