/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.metrics.MetricsSystem;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class MetricsSystem$ {
    public static final MetricsSystem$ MODULE$;
    private final Regex SINK_REGEX;
    private final Regex SOURCE_REGEX;
    private final String ROLE_WORKER;
    private final String ROLE_MASTER;
    private final TimeUnit MINIMAL_POLL_UNIT;
    private final int MINIMAL_POLL_PERIOD;

    static {
        new MetricsSystem$();
    }

    public Regex SINK_REGEX() {
        return this.SINK_REGEX;
    }

    public Regex SOURCE_REGEX() {
        return this.SOURCE_REGEX;
    }

    public String ROLE_WORKER() {
        return this.ROLE_WORKER;
    }

    public String ROLE_MASTER() {
        return this.ROLE_MASTER;
    }

    public void checkMinimalPollingPeriod(TimeUnit pollUnit, int pollPeriod) {
        long period = this.MINIMAL_POLL_UNIT.convert(pollPeriod, pollUnit);
        if (period < (long)this.MINIMAL_POLL_PERIOD) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Polling period ").append((Object)BoxesRunTime.boxToInteger((int)pollPeriod)).append((Object)" ").append((Object)pollUnit).append((Object)" below than minimal polling period ").toString());
        }
    }

    public MetricsSystem createMetricsSystem(String instance, CelebornConf conf, String servletPath) {
        return new MetricsSystem(instance, conf, servletPath);
    }

    private MetricsSystem$() {
        MODULE$ = this;
        this.SINK_REGEX = new StringOps(Predef$.MODULE$.augmentString("^sink\\.(.+)\\.(.+)")).r();
        this.SOURCE_REGEX = new StringOps(Predef$.MODULE$.augmentString("^org.apache.celeborn.common.metrics.source\\.(.+)\\.(.+)")).r();
        this.ROLE_WORKER = "Worker";
        this.ROLE_MASTER = "Master";
        this.MINIMAL_POLL_UNIT = TimeUnit.SECONDS;
        this.MINIMAL_POLL_PERIOD = 1;
    }
}

