/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.internal.config;

import java.util.concurrent.TimeUnit;
import java.util.regex.PatternSyntaxException;
import org.apache.celeborn.common.network.util.ByteUnit;
import org.apache.celeborn.common.network.util.JavaUtils;
import org.apache.celeborn.common.util.Utils$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class ConfigHelpers$ {
    public static final ConfigHelpers$ MODULE$;

    static {
        new ConfigHelpers$();
    }

    public <T> T toNumber(String s, Function1<String, T> converter, String key, String configType) {
        try {
            return (T)converter.apply((Object)s.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " should be ", ", but was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, configType, s})));
        }
    }

    public boolean toBoolean(String s, String key) {
        try {
            return new StringOps(Predef$.MODULE$.augmentString(s.trim())).toBoolean();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " should be boolean, but was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, s})));
        }
    }

    public <T> Seq<T> stringToSeq(String str, Function1<String, T> converter) {
        return (Seq)Utils$.MODULE$.stringToSeq(str).map(converter, Seq$.MODULE$.canBuildFrom());
    }

    public <T> String seqToString(Seq<T> v, Function1<T, String> stringConverter) {
        return ((TraversableOnce)v.map(stringConverter, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    public long timeFromString(String str, TimeUnit unit) {
        return JavaUtils.timeStringAs(str, unit);
    }

    public String timeToString(long v, TimeUnit unit) {
        return new StringBuilder().append(TimeUnit.MILLISECONDS.convert(v, unit)).append((Object)"ms").toString();
    }

    public long byteFromString(String str, ByteUnit unit) {
        Tuple2 tuple2;
        Tuple2 tuple22 = tuple2 = new StringOps(Predef$.MODULE$.augmentString(str)).nonEmpty() && str.charAt(0) == '-' ? new Tuple2((Object)str.substring(1), (Object)BoxesRunTime.boxToInteger((int)-1)) : new Tuple2((Object)str, (Object)BoxesRunTime.boxToInteger((int)1));
        if (tuple2 != null) {
            Tuple2 tuple23;
            String input = (String)tuple2._1();
            int multiplier = tuple2._2$mcI$sp();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)input, (Object)BoxesRunTime.boxToInteger((int)multiplier));
            String input2 = (String)tuple24._1();
            int multiplier2 = tuple24._2$mcI$sp();
            return (long)multiplier2 * JavaUtils.byteStringAs(input2, unit);
        }
        throw new MatchError((Object)tuple2);
    }

    public String byteToString(long v, ByteUnit unit) {
        return new StringBuilder().append(unit.convertTo(v, ByteUnit.BYTE)).append((Object)"b").toString();
    }

    public Regex regexFromString(String str, String key) {
        try {
            return new StringOps(Predef$.MODULE$.augmentString(str)).r();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " should be a regex, but was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, str})), patternSyntaxException);
        }
    }

    private ConfigHelpers$() {
        MODULE$ = this;
    }
}

