/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.write;

import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.client.write.PushTask;
import org.apache.celeborn.common.CelebornConf;

public class DataPusher {
    private final long WAIT_TIME_NANOS = TimeUnit.MILLISECONDS.toNanos(500L);
    private final LinkedBlockingQueue<PushTask> idleQueue;
    private final LinkedBlockingQueue<PushTask> workingQueue;
    private final ReentrantLock idleLock = new ReentrantLock();
    private final Condition idleFull = this.idleLock.newCondition();
    private final AtomicReference<IOException> exceptionRef = new AtomicReference();
    private final String appId;
    private final int shuffleId;
    private final int mapId;
    private final int attemptId;
    private final int numMappers;
    private final int numPartitions;
    private final ShuffleClient client;
    private final Consumer<Integer> afterPush;
    private volatile boolean terminated;
    private final LongAdder[] mapStatusLengths;

    public DataPusher(String appId, int shuffleId, int mapId, int attemptId, long taskId, int numMappers, int numPartitions, CelebornConf conf, ShuffleClient client, Consumer<Integer> afterPush, LongAdder[] mapStatusLengths) throws IOException {
        int pushQueueCapacity = conf.pushQueueCapacity();
        int pushBufferMaxSize = conf.pushBufferMaxSize();
        this.idleQueue = new LinkedBlockingQueue(pushQueueCapacity);
        this.workingQueue = new LinkedBlockingQueue(pushQueueCapacity);
        for (int i = 0; i < pushQueueCapacity; ++i) {
            try {
                this.idleQueue.put(new PushTask(pushBufferMaxSize));
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
        }
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.mapId = mapId;
        this.attemptId = attemptId;
        this.numMappers = numMappers;
        this.numPartitions = numPartitions;
        this.client = client;
        this.afterPush = afterPush;
        this.mapStatusLengths = mapStatusLengths;
        new Thread("DataPusher-" + taskId){

            private void reclaimTask(PushTask task) throws InterruptedException {
                DataPusher.this.idleLock.lockInterruptibly();
                try {
                    DataPusher.this.idleQueue.put(task);
                    if (DataPusher.this.idleQueue.remainingCapacity() == 0) {
                        DataPusher.this.idleFull.signal();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    DataPusher.this.exceptionRef.set(new IOException(e));
                }
                finally {
                    DataPusher.this.idleLock.unlock();
                }
            }

            @Override
            public void run() {
                while (!DataPusher.this.terminated && DataPusher.this.exceptionRef.get() == null) {
                    try {
                        PushTask task = (PushTask)DataPusher.this.workingQueue.poll(DataPusher.this.WAIT_TIME_NANOS, TimeUnit.NANOSECONDS);
                        if (task == null) continue;
                        DataPusher.this.pushData(task);
                        this.reclaimTask(task);
                    }
                    catch (InterruptedException e) {
                        DataPusher.this.exceptionRef.set(new IOException(e));
                    }
                    catch (IOException e) {
                        DataPusher.this.exceptionRef.set(e);
                    }
                }
            }
        }.start();
    }

    public void addTask(int partitionId, byte[] buffer, int size) throws IOException {
        try {
            PushTask task = null;
            while (task == null) {
                this.checkException();
                task = this.idleQueue.poll(this.WAIT_TIME_NANOS, TimeUnit.NANOSECONDS);
            }
            task.setSize(size);
            task.setPartitionId(partitionId);
            System.arraycopy(buffer, 0, task.getBuffer(), 0, size);
            while (!this.workingQueue.offer(task, this.WAIT_TIME_NANOS, TimeUnit.NANOSECONDS)) {
                this.checkException();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            IOException ioe = new IOException(e);
            this.exceptionRef.set(ioe);
            throw ioe;
        }
    }

    public void waitOnTermination() throws IOException {
        try {
            this.idleLock.lockInterruptibly();
            this.waitIdleQueueFullWithLock();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.exceptionRef.set(new IOException(e));
        }
        this.terminated = true;
        this.idleQueue.clear();
        this.workingQueue.clear();
        this.checkException();
    }

    private void checkException() throws IOException {
        if (this.exceptionRef.get() != null) {
            throw this.exceptionRef.get();
        }
    }

    private void pushData(PushTask task) throws IOException {
        int bytesWritten = this.client.pushData(this.appId, this.shuffleId, this.mapId, this.attemptId, task.getPartitionId(), task.getBuffer(), 0, task.getSize(), this.numMappers, this.numPartitions);
        this.afterPush.accept(bytesWritten);
        this.mapStatusLengths[task.getPartitionId()].add(bytesWritten);
    }

    private void waitIdleQueueFullWithLock() {
        try {
            while (this.idleQueue.remainingCapacity() > 0 && this.exceptionRef.get() == null) {
                this.idleFull.await(this.WAIT_TIME_NANOS, TimeUnit.NANOSECONDS);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.exceptionRef.set(new IOException(e));
        }
        finally {
            this.idleLock.unlock();
        }
    }
}

