/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.compress;

import com.github.luben.zstd.Zstd;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.celeborn.client.compress.Decompressor;
import org.apache.celeborn.client.compress.RssZstdTrait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RssZstdDecompressor
extends RssZstdTrait
implements Decompressor {
    private static final Logger logger = LoggerFactory.getLogger(RssZstdDecompressor.class);
    private final Checksum checksum = new CRC32();

    @Override
    public int getOriginalLen(byte[] src) {
        return this.readIntLE(src, MAGIC_LENGTH + 5);
    }

    @Override
    public int decompress(byte[] src, byte[] dst, int dstOff) {
        int compressionMethod = src[MAGIC_LENGTH] & 0xFF;
        int compressedLen = this.readIntLE(src, MAGIC_LENGTH + 1);
        int originalLen = this.readIntLE(src, MAGIC_LENGTH + 5);
        int check = this.readIntLE(src, MAGIC_LENGTH + 9);
        switch (compressionMethod) {
            case 16: {
                System.arraycopy(src, HEADER_LENGTH, dst, dstOff, originalLen);
                break;
            }
            case 48: {
                int originalLen2 = (int)Zstd.decompressByteArray((byte[])dst, (int)dstOff, (int)originalLen, (byte[])src, (int)HEADER_LENGTH, (int)compressedLen);
                if (originalLen == originalLen2) break;
                logger.error("Original length corrupted! expected: {}, actual: {}.", (Object)originalLen, (Object)originalLen2);
                return -1;
            }
            default: {
                logger.error("Unknown compression method whose decimal number is {} .", (Object)compressionMethod);
                return -1;
            }
        }
        this.checksum.reset();
        this.checksum.update(dst, dstOff, originalLen);
        if ((int)this.checksum.getValue() != check) {
            logger.error("Checksum not equal! expected: {}, actual: {}.", (Object)check, (Object)this.checksum.getValue());
            return -1;
        }
        return originalLen;
    }
}

