/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.meta;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.celeborn.common.meta.DeviceInfo;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class DeviceInfo$
implements scala.Serializable {
    public static DeviceInfo$ MODULE$;
    private final Logger logger;

    static {
        new DeviceInfo$();
    }

    public Logger logger() {
        return this.logger;
    }

    public Tuple2<Map<String, DeviceInfo>, Map<String, DiskInfo>> getDeviceAndDiskInfos(Seq<Tuple4<File, Object, Object, StorageInfo.Type>> workingDirs) {
        HashMap deviceNameToDeviceInfo = new HashMap();
        HashMap mountPointToDeviceInfo = new HashMap();
        String dfResult = Utils$.MODULE$.runCommand("df -ah").trim();
        this.logger().info(new StringBuilder(10).append("df result ").append(dfResult).toString());
        Tuple2[] fsMounts = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dfResult.split("[\n\r]"))).tail())).map((Function1 & Serializable & scala.Serializable)line -> {
            String[] tokens = line.trim().split("[ \t]+");
            return new Tuple2(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokens)).head(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokens)).last());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        String lsBlockResult = Utils$.MODULE$.runCommand("ls /sys/block/").trim();
        this.logger().info(new StringBuilder(9).append("ls block ").append(lsBlockResult).toString());
        String[] blocks = lsBlockResult.split("[ \n\r\t]+");
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fsMounts)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String fileSystem = (String)tuple2._1();
            String mountPoint = (String)tuple2._2();
            String deviceName = fileSystem.substring(fileSystem.lastIndexOf(47) + 1);
            IntRef index = IntRef.create((int)-1);
            IntRef maxLength = IntRef.create((int)-1);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)block -> {
                DeviceInfo$.$anonfun$getDeviceAndDiskInfos$3(deviceName, maxLength, index, block);
                return BoxedUnit.UNIT;
            });
            Function<String, DeviceInfo> newDeviceInfoFunc = new Function<String, DeviceInfo>(index){
                private final IntRef index$1;

                public <V> Function<V, DeviceInfo> compose(Function<? super V, ? extends String> x$1) {
                    return Function.super.compose(x$1);
                }

                public <V> Function<String, V> andThen(Function<? super DeviceInfo, ? extends V> x$1) {
                    return Function.super.andThen(x$1);
                }

                /*
                 * WARNING - void declaration
                 */
                public DeviceInfo apply(String s) {
                    void var2_2;
                    block0: {
                        DeviceInfo deviceInfo = new DeviceInfo(s);
                        if (this.index$1.elem >= 0) break block0;
                        deviceInfo.deviceStatAvailable_$eq(true);
                    }
                    return var2_2;
                }
                {
                    this.index$1 = index$1;
                }
            };
            DeviceInfo deviceInfo = index.elem >= 0 ? deviceNameToDeviceInfo.computeIfAbsent(blocks[index.elem], newDeviceInfoFunc) : deviceNameToDeviceInfo.computeIfAbsent(deviceName, newDeviceInfoFunc);
            DeviceInfo deviceInfo2 = mountPointToDeviceInfo.putIfAbsent(mountPoint, deviceInfo);
            return deviceInfo2;
        });
        ConcurrentHashMap retDeviceInfos = new ConcurrentHashMap();
        ConcurrentHashMap retDiskInfos = new ConcurrentHashMap();
        workingDirs.groupBy((Function1 & Serializable & scala.Serializable)f -> MODULE$.getMountPoint(((File)f._1()).getAbsolutePath(), mountPointToDeviceInfo.keySet())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple3 tuple3;
            DiskInfo diskInfo;
            DeviceInfo deviceInfo;
            String mountPoint;
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                mountPoint = (String)tuple2._1();
                Seq dirs = (Seq)tuple2._2();
                deviceInfo = (DeviceInfo)mountPointToDeviceInfo.get(mountPoint);
                diskInfo = new DiskInfo(mountPoint, (List<File>)((TraversableOnce)dirs.map((Function1 & Serializable & scala.Serializable)x$3 -> (File)x$3._1(), Seq$.MODULE$.canBuildFrom())).toList(), deviceInfo);
                Tuple4 tuple4 = (Tuple4)dirs.apply(0);
                if (tuple4 == null) {
                    throw new MatchError((Object)tuple4);
                }
                long maxUsableSpace = BoxesRunTime.unboxToLong((Object)tuple4._2());
                int threadCount = BoxesRunTime.unboxToInt((Object)tuple4._3());
                StorageInfo.Type storageType = (StorageInfo.Type)((Object)((Object)tuple4._4()));
                tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)maxUsableSpace), (Object)BoxesRunTime.boxToInteger((int)threadCount), (Object)storageType);
            } else {
                throw new MatchError((Object)tuple2);
            }
            Tuple3 tuple32 = tuple3;
            long maxUsableSpace = BoxesRunTime.unboxToLong((Object)tuple32._1());
            int threadCount = BoxesRunTime.unboxToInt((Object)tuple32._2());
            StorageInfo.Type storageType = (StorageInfo.Type)((Object)((Object)tuple32._3()));
            diskInfo.configuredUsableSpace_$eq(maxUsableSpace);
            diskInfo.threadCount_$eq(threadCount);
            diskInfo.storageType_$eq(storageType);
            deviceInfo.addDiskInfo(diskInfo);
            DiskInfo diskInfo2 = retDiskInfos.put(mountPoint, diskInfo);
            return diskInfo2;
        });
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(deviceNameToDeviceInfo).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DeviceInfo deviceInfo = (DeviceInfo)tuple2._2();
            BoxedUnit boxedUnit = deviceInfo.diskInfos().nonEmpty() ? retDeviceInfos.put(deviceInfo.name(), deviceInfo) : BoxedUnit.UNIT;
            return boxedUnit;
        });
        this.logger().info(new StringBuilder(27).append("Device initialization \n ").append(retDeviceInfos).append(" \n ").append(retDiskInfos).toString());
        return new Tuple2(retDeviceInfos, retDiskInfos);
    }

    public String getMountPoint(String absPath, Set<String> mountPoints) {
        IntRef curMax = IntRef.create((int)-1);
        ObjectRef curMount = ObjectRef.create((Object)"");
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(mountPoints).asScala()).foreach((Function1 & Serializable & scala.Serializable)mount -> {
            DeviceInfo$.$anonfun$getMountPoint$1(absPath, curMax, curMount, mount);
            return BoxedUnit.UNIT;
        });
        return (String)curMount.elem;
    }

    public String getMountPoint(String absPath, Map<String, DiskInfo> diskInfos) {
        return this.getMountPoint(absPath, diskInfos.keySet());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$getDeviceAndDiskInfos$3(String deviceName$1, IntRef maxLength$1, IntRef index$1, Tuple2 block) {
        block0: {
            if (!deviceName$1.startsWith((String)block._1()) || ((String)block._1()).length() <= maxLength$1.elem) break block0;
            index$1.elem = block._2$mcI$sp();
            maxLength$1.elem = ((String)block._1()).length();
        }
    }

    public static final /* synthetic */ void $anonfun$getMountPoint$1(String absPath$1, IntRef curMax$1, ObjectRef curMount$1, String mount) {
        block0: {
            if (!absPath$1.startsWith(mount) || mount.length() <= curMax$1.elem) break block0;
            curMax$1.elem = mount.length();
            curMount$1.elem = mount;
        }
    }

    private DeviceInfo$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(DeviceInfo.class);
    }
}

