/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.master.clustermeta.ha;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.util.List;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.CelebornConf$;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.service.deploy.master.clustermeta.ha.MasterClusterInfo;
import org.apache.celeborn.service.deploy.master.clustermeta.ha.MasterNode;
import org.apache.ratis.util.NetUtils;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class MasterClusterInfo$
implements Logging,
scala.Serializable {
    public static MasterClusterInfo$ MODULE$;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    static {
        new MasterClusterInfo$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        MasterClusterInfo$ masterClusterInfo$ = this;
        synchronized (masterClusterInfo$) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public MasterClusterInfo loadHAConfig(CelebornConf conf) throws IllegalArgumentException {
        Tuple2 tuple2;
        Option localNodeIdOpt = conf.haMasterNodeId();
        String[] clusterNodeIds = conf.haMasterNodeIds();
        MasterNode[] masterNodes = (MasterNode[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])clusterNodeIds)).map((Function1 & Serializable & scala.Serializable)nodeId -> {
            String ratisHost = conf.haMasterRatisHost(nodeId);
            int ratisPort = conf.haMasterRatisPort(nodeId);
            InetSocketAddress ratisAddr = MODULE$.createSocketAddr(ratisHost, ratisPort);
            String rpcHost = conf.haMasterNodeHost(nodeId);
            int rpcPort = conf.haMasterNodePort(nodeId);
            InetSocketAddress rpcAddr = MODULE$.createSocketAddr(rpcHost, rpcPort);
            return new MasterNode((String)nodeId, ratisAddr, rpcAddr);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(MasterNode.class)));
        Option option = localNodeIdOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            String localNodeId = (String)some.value();
            tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])masterNodes)).partition((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MasterClusterInfo$.$anonfun$loadHAConfig$2(localNodeId, x$1)));
        } else if (None$.MODULE$.equals(option)) {
            tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])masterNodes)).partition((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)MasterClusterInfo$.$anonfun$loadHAConfig$3(node)));
        } else {
            throw new MatchError((Object)option);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        MasterNode[] localNodes = (MasterNode[])tuple22._1();
        MasterNode[] peerNodes = (MasterNode[])tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)localNodes, (Object)peerNodes);
        Tuple2 tuple24 = tuple23;
        MasterNode[] localNodes2 = (MasterNode[])tuple24._1();
        MasterNode[] peerNodes2 = (MasterNode[])tuple24._2();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])localNodes2)).isEmpty()) {
            throw new IllegalArgumentException("Can not found local node");
        }
        if (localNodes2.length > 1) {
            String nodesAddr = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])localNodes2)).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.ratisEndpoint(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
            throw new IllegalArgumentException(new StringBuilder(67).append("Detecting multi Ratis instances[").append(nodesAddr).append("] in single node, please specific ").append(CelebornConf$.MODULE$.HA_MASTER_NODE_ID().key()).append(".").toString());
        }
        return new MasterClusterInfo((MasterNode)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])localNodes2)).head(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peerNodes2)).toList()).asJava());
    }

    public InetSocketAddress createSocketAddr(String host, int port) {
        InetSocketAddress socketAddr;
        block2: {
            InetSocketAddress addr;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> NetUtils.createSocketAddr((String)host, (int)port));
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    throw new IOException(new StringBuilder(36).append("Couldn't create socket address for ").append(host).append(":").append(port).toString(), e);
                }
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            InetSocketAddress inetSocketAddress = addr = (InetSocketAddress)success.value();
            socketAddr = inetSocketAddress;
            if (!socketAddr.isUnresolved()) break block2;
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("Address of ").append(host).append(":").append(port).append(" couldn't be resolved. ").append("Proceeding with unresolved host to create Ratis ring.").toString());
        }
        return socketAddr;
    }

    private boolean isLocalAddress(InetAddress addr) {
        boolean bl;
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> NetworkInterface.getByInetAddress(addr));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            NetworkInterface value = (NetworkInterface)success.value();
            bl = value != null;
        } else if (try_ instanceof Failure) {
            bl = false;
        } else {
            throw new MatchError((Object)try_);
        }
        return bl;
    }

    public MasterClusterInfo apply(MasterNode localNode, List<MasterNode> peerNodes) {
        return new MasterClusterInfo(localNode, peerNodes);
    }

    public Option<Tuple2<MasterNode, List<MasterNode>>> unapply(MasterClusterInfo x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.localNode(), x$0.peerNodes()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$loadHAConfig$2(String localNodeId$1, MasterNode x$1) {
        String string = localNodeId$1;
        String string2 = x$1.nodeId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$loadHAConfig$3(MasterNode node) {
        return !node.isRatisHostUnresolved() && MODULE$.isLocalAddress(node.ratisIpAddr());
    }

    private MasterClusterInfo$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

