/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.batchee.servlet.util;

import javax.batch.api.BatchProperty;
import javax.batch.api.Batchlet;
import javax.inject.Inject;

public class SimpleBatchlet implements Batchlet {
    @Inject
    @BatchProperty
    private String value;

    @Inject
    @BatchProperty
    private String sleep;

    private volatile boolean stopped = false;

    @Override
    public String process() throws Exception {
        if (value == null) {
            value = "OK";
        }
        if (sleep != null) {
            long done = 0;
            final long max = Long.parseLong(sleep);
            while (done < max && !stopped) {
                Thread.sleep(1000);
                done += 1000;
            }
        }
        return value;
    }

    @Override
    public void stop() throws Exception {
        stopped = true;
    }
}
