/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.math.BigDecimal;
import java.net.URI;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Geometry;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;
import org.opengis.util.TypeName;

final class TypeNames {
    private static final Map<String, Class<?>> MAPPING = new LinkedHashMap(16);
    private final NameSpace ogcNS;
    private final NameSpace classNS;

    TypeNames(NameFactory factory) {
        this.ogcNS = factory.createNameSpace((GenericName)factory.createLocalName(null, (CharSequence)"OGC"), null);
        this.classNS = factory.createNameSpace((GenericName)factory.createLocalName(null, (CharSequence)"class"), null);
    }

    final TypeName toTypeName(NameFactory factory, Class<?> valueClass) {
        String name;
        NameSpace ns;
        block7: {
            ns = this.ogcNS;
            if (CharSequence.class.isAssignableFrom(valueClass)) {
                name = InternationalString.class.isAssignableFrom(valueClass) ? "FreeText" : "CharacterString";
            } else if (Numbers.isNumber(valueClass)) {
                name = Numbers.isInteger(valueClass) ? "Integer" : "Real";
            } else {
                Class<?> base;
                Iterator<Map.Entry<String, Class<?>>> it = MAPPING.entrySet().iterator();
                do {
                    Map.Entry<String, Class<?>> entry;
                    if (!(base = (entry = it.next()).getValue()).isAssignableFrom(valueClass)) continue;
                    name = entry.getKey();
                    break block7;
                } while (base != Boolean.class);
                name = Types.getStandardName(valueClass);
                if (name == null) {
                    ns = this.classNS;
                    name = valueClass.getName();
                }
            }
        }
        if (factory instanceof DefaultNameFactory) {
            return ((DefaultNameFactory)factory).createTypeName(ns, name, valueClass);
        }
        return factory.createTypeName(ns, (CharSequence)name);
    }

    static Class<?> toClass(String namespace, String name) throws ClassNotFoundException {
        Class<Object> c;
        if (namespace == null || namespace.equalsIgnoreCase("OGC")) {
            c = MAPPING.get(name);
            if (c == null && (c = Types.forStandardName(name)) == null && namespace != null) {
                c = Void.TYPE;
            }
        } else {
            c = namespace.equalsIgnoreCase("class") ? Class.forName(name) : null;
        }
        return c;
    }

    static boolean isValid(Class<?> valueClass) {
        if (valueClass == Void.TYPE) {
            throw new IllegalArgumentException(Errors.format((short)45, (Object)"valueClass", (Object)"void"));
        }
        return valueClass != null;
    }

    static String namespace(NameSpace ns) {
        GenericName name;
        if (ns != null && !ns.isGlobal() && (name = ns.name()) != null) {
            return name.toString();
        }
        return null;
    }

    static String unknown(GenericName name) {
        return Errors.format((short)149, (Object)name.toFullyQualifiedName());
    }

    static {
        Map<String, Class<?>> m = MAPPING;
        m.put("URI", URI.class);
        m.put("DateTime", Date.class);
        m.put("PT_Locale", Locale.class);
        m.put("Geometry", Geometry.class);
        m.put("Decimal", BigDecimal.class);
        m.put("Boolean", Boolean.class);
        m.put("FreeText", InternationalString.class);
        m.put("CharacterString", String.class);
        m.put("Real", Double.class);
        m.put("Decimal", Double.class);
        m.put("Integer", Integer.class);
    }
}

