/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.metadata.internal.ReferencingServices;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.NilReason;
import org.apache.sis.xml.bind.gco.GO_Real;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

@XmlType(name="EX_VerticalExtent_Type", propOrder={"minimumValue", "maximumValue", "verticalCRS"})
@XmlRootElement(name="EX_VerticalExtent")
public class DefaultVerticalExtent
extends ISOMetadata
implements VerticalExtent {
    private static final long serialVersionUID = -1963873471175296153L;
    private Double minimumValue;
    private Double maximumValue;
    private VerticalCRS verticalCRS;

    public DefaultVerticalExtent() {
    }

    public DefaultVerticalExtent(double minimumValue, double maximumValue, VerticalCRS verticalCRS) {
        if (!Double.isNaN(minimumValue)) {
            this.minimumValue = minimumValue;
        }
        if (!Double.isNaN(maximumValue)) {
            this.maximumValue = maximumValue;
        }
        this.verticalCRS = verticalCRS;
    }

    public DefaultVerticalExtent(VerticalExtent object) {
        super(object);
        if (object != null) {
            this.minimumValue = object.getMinimumValue();
            this.maximumValue = object.getMaximumValue();
            this.verticalCRS = object.getVerticalCRS();
        }
    }

    public static DefaultVerticalExtent castOrCopy(VerticalExtent object) {
        if (object == null || object instanceof DefaultVerticalExtent) {
            return (DefaultVerticalExtent)object;
        }
        return new DefaultVerticalExtent(object);
    }

    @XmlElement(name="minimumValue", required=true)
    @XmlJavaTypeAdapter(value=GO_Real.class)
    public Double getMinimumValue() {
        return this.minimumValue;
    }

    public void setMinimumValue(Double newValue) {
        this.checkWritePermission(this.minimumValue);
        this.minimumValue = newValue;
    }

    @XmlElement(name="maximumValue", required=true)
    @XmlJavaTypeAdapter(value=GO_Real.class)
    public Double getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(Double newValue) {
        this.checkWritePermission(this.maximumValue);
        this.maximumValue = newValue;
    }

    @XmlElement(name="verticalCRS")
    public VerticalCRS getVerticalCRS() {
        return this.verticalCRS;
    }

    public void setVerticalCRS(VerticalCRS newValue) {
        this.checkWritePermission(this.verticalCRS);
        this.verticalCRS = newValue;
    }

    private Double value() {
        return this.minimumValue != null ? this.minimumValue : this.maximumValue;
    }

    public void setBounds(Envelope envelope) throws TransformException {
        this.checkWritePermission(this.value());
        ReferencingServices.getInstance().setBounds(envelope, this);
    }

    public void intersect(VerticalExtent other) throws IllegalArgumentException {
        block10: {
            this.checkWritePermission(this.value());
            ArgumentChecks.ensureNonNull((String)"other", (Object)other);
            Double min = other.getMinimumValue();
            Double max = other.getMaximumValue();
            try {
                MathTransform1D cv;
                block11: {
                    block12: {
                        Double d;
                        cv = this.getConversionFrom(other.getVerticalCRS());
                        if (DefaultVerticalExtent.isReversing(cv, min, max)) {
                            Double tmp = min;
                            min = max;
                            max = tmp;
                        }
                        if (min == null) break block11;
                        if (this.minimumValue == null || min.isNaN()) break block12;
                        min = DefaultVerticalExtent.convert(cv, min);
                        if (!(d > this.minimumValue)) break block11;
                    }
                    this.minimumValue = min;
                }
                if (max == null) break block10;
                if (this.maximumValue != null && !max.isNaN()) {
                    Double d;
                    max = DefaultVerticalExtent.convert(cv, max);
                    if (!(d < this.maximumValue)) break block10;
                }
                this.maximumValue = max;
            }
            catch (ClassCastException | UnsupportedOperationException | TransformException | FactoryException e) {
                throw new IllegalArgumentException(Errors.format((short)63, (Object)"verticalCRS"), e);
            }
        }
        if (this.minimumValue != null && this.maximumValue != null && this.minimumValue > this.maximumValue) {
            this.minimumValue = this.maximumValue = NilReason.MISSING.createNilObject(Double.class);
        }
    }

    private MathTransform1D getConversionFrom(VerticalCRS source) throws FactoryException {
        MathTransform1D cv;
        if (!Utilities.equalsIgnoreMetadata((Object)this.verticalCRS, (Object)source) && this.verticalCRS != null && source != null && !(cv = (MathTransform1D)ReferencingServices.getInstance().getCoordinateOperationFactory().createOperation((CoordinateReferenceSystem)source, (CoordinateReferenceSystem)this.verticalCRS).getMathTransform()).isIdentity()) {
            return cv;
        }
        return null;
    }

    private static boolean isReversing(MathTransform1D cv, Double sample, Double other) throws TransformException {
        if (cv == null) {
            return false;
        }
        if (sample == null || sample.isNaN()) {
            sample = other;
        } else if (other != null && !other.isNaN()) {
            sample = (sample + other) / 2.0;
        }
        return MathFunctions.isNegative((double)cv.derivative(sample != null ? sample : Double.NaN));
    }

    private static Double convert(MathTransform1D tr, Double value) throws TransformException {
        return tr != null ? tr.transform(value.doubleValue()) : value.doubleValue();
    }
}

