/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.related;

import java.util.List;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.extension.related.UserMappingRow;
import mil.nga.geopackage.extension.related.UserMappingTable;
import mil.nga.geopackage.user.custom.UserCustomDao;
import mil.nga.geopackage.user.custom.UserCustomResultSet;
import mil.nga.geopackage.user.custom.UserCustomRow;
import mil.nga.geopackage.user.custom.UserCustomTable;

public class UserMappingDao
extends UserCustomDao {
    public UserMappingDao(UserCustomDao dao) {
        super(dao, (UserCustomTable)new UserMappingTable((UserCustomTable)dao.getTable()));
    }

    protected UserMappingDao(UserCustomDao dao, UserMappingTable userMappingTable) {
        super(dao, (UserCustomTable)userMappingTable);
    }

    public UserMappingTable getTable() {
        return (UserMappingTable)super.getTable();
    }

    @Override
    public UserMappingRow newRow() {
        return new UserMappingRow(this.getTable());
    }

    public UserMappingRow getRow(UserCustomResultSet resultSet) {
        return this.getRow((UserCustomRow)resultSet.getRow());
    }

    public UserMappingRow getRow(UserCustomRow row) {
        return new UserMappingRow(row);
    }

    public UserCustomResultSet queryByBaseId(UserMappingRow userMappingRow) {
        return this.queryByBaseId(userMappingRow.getBaseId());
    }

    public UserCustomResultSet queryByBaseId(long baseId) {
        return (UserCustomResultSet)this.queryForEq("base_id", baseId);
    }

    public int countByBaseId(UserMappingRow userMappingRow) {
        return this.countByBaseId(userMappingRow.getBaseId());
    }

    public int countByBaseId(long baseId) {
        return this.count(this.queryByBaseId(baseId));
    }

    public UserCustomResultSet queryByRelatedId(UserMappingRow userMappingRow) {
        return this.queryByRelatedId(userMappingRow.getRelatedId());
    }

    public UserCustomResultSet queryByRelatedId(long relatedId) {
        return (UserCustomResultSet)this.queryForEq("related_id", relatedId);
    }

    public int countByRelatedId(UserMappingRow userMappingRow) {
        return this.countByRelatedId(userMappingRow.getRelatedId());
    }

    public int countByRelatedId(long relatedId) {
        return this.count(this.queryByRelatedId(relatedId));
    }

    public UserCustomResultSet queryByIds(UserMappingRow userMappingRow) {
        return this.queryByIds(userMappingRow.getBaseId(), userMappingRow.getRelatedId());
    }

    public UserCustomResultSet queryByIds(long baseId, long relatedId) {
        return (UserCustomResultSet)this.query(this.buildWhereIds(baseId, relatedId), this.buildWhereIdsArgs(baseId, relatedId));
    }

    public List<Long> uniqueBaseIds() {
        return this.querySingleColumnTypedResults("SELECT DISTINCT " + CoreSQLUtils.quoteWrap((String)"base_id") + " FROM " + CoreSQLUtils.quoteWrap((String)this.getTableName()), null, GeoPackageDataType.INTEGER);
    }

    public List<Long> uniqueRelatedIds() {
        return this.querySingleColumnTypedResults("SELECT DISTINCT " + CoreSQLUtils.quoteWrap((String)"related_id") + " FROM " + CoreSQLUtils.quoteWrap((String)this.getTableName()), null, GeoPackageDataType.INTEGER);
    }

    public int countByIds(UserMappingRow userMappingRow) {
        return this.countByIds(userMappingRow.getBaseId(), userMappingRow.getRelatedId());
    }

    public int countByIds(long baseId, long relatedId) {
        return this.count(this.queryByIds(baseId, relatedId));
    }

    public int deleteByBaseId(UserMappingRow userMappingRow) {
        return this.deleteByBaseId(userMappingRow.getBaseId());
    }

    public int deleteByBaseId(long baseId) {
        StringBuilder where = new StringBuilder();
        where.append(this.buildWhere("base_id", baseId));
        String[] whereArgs = this.buildWhereArgs(new Object[]{baseId});
        int deleted = this.delete(where.toString(), whereArgs);
        return deleted;
    }

    public int deleteByRelatedId(UserMappingRow userMappingRow) {
        return this.deleteByRelatedId(userMappingRow.getRelatedId());
    }

    public int deleteByRelatedId(long relatedId) {
        StringBuilder where = new StringBuilder();
        where.append(this.buildWhere("related_id", relatedId));
        String[] whereArgs = this.buildWhereArgs(new Object[]{relatedId});
        int deleted = this.delete(where.toString(), whereArgs);
        return deleted;
    }

    public int deleteByIds(UserMappingRow userMappingRow) {
        return this.deleteByIds(userMappingRow.getBaseId(), userMappingRow.getRelatedId());
    }

    public int deleteByIds(long baseId, long relatedId) {
        return this.delete(this.buildWhereIds(baseId, relatedId), this.buildWhereIdsArgs(baseId, relatedId));
    }

    private String buildWhereIds(long baseId, long relatedId) {
        StringBuilder where = new StringBuilder();
        where.append(this.buildWhere("base_id", baseId));
        where.append(" AND ");
        where.append(this.buildWhere("related_id", relatedId));
        return where.toString();
    }

    private String[] buildWhereIdsArgs(long baseId, long relatedId) {
        return this.buildWhereArgs(new Object[]{baseId, relatedId});
    }
}

