/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tilestore.raster;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.function.IntToDoubleFunction;
import org.apache.baremaps.dem.ElevationUtils;
import org.apache.baremaps.dem.HillshadeCalculator;
import org.apache.baremaps.tilestore.TileCoord;
import org.apache.baremaps.tilestore.TileStore;
import org.apache.baremaps.tilestore.TileStoreException;
import org.apache.baremaps.tilestore.raster.GeoTiffReader;

public class RasterHillshadeTileStore
implements TileStore<BufferedImage> {
    private final GeoTiffReader geoTiffReader;
    private final IntToDoubleFunction pixelToElevation;

    public RasterHillshadeTileStore(GeoTiffReader geoTiffReader, IntToDoubleFunction pixelToElevation) {
        this.geoTiffReader = geoTiffReader;
        this.pixelToElevation = pixelToElevation;
    }

    @Override
    public BufferedImage read(TileCoord tileCoord) throws TileStoreException {
        try {
            int tileSize = 256;
            int tileBuffer = 1;
            int imageSize = tileSize + tileBuffer + tileBuffer;
            double[] grid = this.geoTiffReader.read(tileCoord, tileSize, tileBuffer);
            grid = ElevationUtils.clampGrid((double[])grid, (double)0.0, (double)10000.0);
            grid = new HillshadeCalculator(grid, imageSize, imageSize, HillshadeCalculator.getResolution((int)tileCoord.z()) / 2.0).calculate(45.0, 315.0);
            BufferedImage hillshadeImage = new BufferedImage(imageSize, imageSize, 10);
            for (int y = 0; y < imageSize; ++y) {
                for (int x = 0; x < imageSize; ++x) {
                    int value = (int)grid[y * imageSize + x];
                    hillshadeImage.setRGB(x, y, new Color(value, value, value).getRGB());
                }
            }
            return hillshadeImage.getSubimage(1, 1, tileSize, tileSize);
        }
        catch (Exception e) {
            throw new TileStoreException(e);
        }
    }

    @Override
    public void write(TileCoord tileCoord, BufferedImage blob) throws TileStoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(TileCoord tileCoord) throws TileStoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws Exception {
    }
}

