/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Stream;
import org.apache.baremaps.geocoder.GeocoderConstants;
import org.apache.baremaps.geocoder.openstreetmap.OpenStreetMapEntityConsumer;
import org.apache.baremaps.openstreetmap.pbf.PbfEntityReader;
import org.apache.baremaps.openstreetmap.stream.StreamUtils;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.locationtech.jts.geom.Coordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateGeocoderOpenStreetMap
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(CreateGeocoderOpenStreetMap.class);
    private Path file;
    private Path indexDirectory;

    public CreateGeocoderOpenStreetMap() {
    }

    public CreateGeocoderOpenStreetMap(Path file, Path indexDirectory) {
        this.file = file;
        this.indexDirectory = indexDirectory;
    }

    @Override
    public void execute(WorkflowContext context) throws Exception {
        Path path = this.file.toAbsolutePath();
        Map<Long, Coordinate> coordinateMap = context.getCoordinateMap();
        Map<Long, List<Long>> referenceMap = context.getReferenceMap();
        FSDirectory directory = FSDirectory.open((Path)this.indexDirectory);
        IndexWriterConfig config = new IndexWriterConfig(GeocoderConstants.ANALYZER);
        try (IndexWriter indexWriter = new IndexWriter((Directory)directory, config);){
            OpenStreetMapEntityConsumer importer = new OpenStreetMapEntityConsumer(indexWriter);
            CreateGeocoderOpenStreetMap.execute(path, coordinateMap, referenceMap, importer);
        }
    }

    public static void execute(Path path, Map<Long, Coordinate> coordinateMap, Map<Long, List<Long>> referenceMap, OpenStreetMapEntityConsumer importer) throws IOException {
        PbfEntityReader reader = new PbfEntityReader().setGeometries(true).setSrid(4326).setCoordinateMap(coordinateMap).setReferenceMap(referenceMap);
        try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
            StreamUtils.batch((Stream)reader.read(input)).forEach(importer);
        }
    }

    public String toString() {
        return new StringJoiner(", ", CreateGeocoderOpenStreetMap.class.getSimpleName() + "[", "]").add("file=" + this.file).add("indexDirectory=" + this.indexDirectory).toString();
    }
}

